/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.lang.MutableString;
import java.util.LinkedList;
import java.util.List;

public class SamSequenceVariation {
    private MutableString fromString;
    private MutableString toString;
    private ByteList qual;
    private boolean hasQual;
    private int readIndex;
    private int refPosition;
    private int lastRefPosition;

    public SamSequenceVariation(int refPosition, char refChar, int readIndex, char readChar, boolean hasQual, byte qualChar) {
        this.refPosition = refPosition;
        this.lastRefPosition = refPosition;
        this.fromString = new MutableString();
        this.fromString.append(refChar);
        this.readIndex = readIndex;
        this.toString = new MutableString();
        this.toString.append(readChar);
        this.hasQual = hasQual;
        if (hasQual) {
            this.qual = new ByteArrayList();
            this.qual.add(qualChar);
        }
    }

    public MutableString getFromString() {
        return this.fromString;
    }

    public MutableString getToString() {
        return this.toString;
    }

    public ByteList getQual() {
        return this.qual;
    }

    public byte[] getQualByteArray() {
        if (this.qual == null) {
            return null;
        }
        return this.qual.toByteArray();
    }

    public boolean isHasQual() {
        return this.hasQual;
    }

    public int getReadIndex() {
        return this.readIndex;
    }

    public int getRefPosition() {
        return this.refPosition;
    }

    public String toString() {
        MutableString output = new MutableString();
        output.append(String.format("%s[%d]->%s[%d] / qual=", this.fromString.toString(), this.refPosition, this.toString.toString(), this.readIndex));
        if (this.hasQual) {
            for (int i = 0; i < this.qual.size(); ++i) {
                if (i > 0) {
                    output.append(":");
                }
                output.append(String.format("%d", (Byte)this.qual.get(i)));
            }
        } else {
            output.append("none");
        }
        return output.toString();
    }

    public static void merge(List<SamSequenceVariation> vars) {
        LinkedList<SamSequenceVariation> toRemoves = new LinkedList<SamSequenceVariation>();
        SamSequenceVariation current = null;
        for (SamSequenceVariation var : vars) {
            if (var.fromString.length() <= 1) continue;
            return;
        }
        for (SamSequenceVariation var : vars) {
            if (current == null) {
                current = var;
                continue;
            }
            if (var.refPosition == current.lastRefPosition || var.refPosition == current.lastRefPosition + 1) {
                char currentFromChar = current.fromString.charAt(current.fromString.length() - 1);
                char currentToChar = current.toString.charAt(current.toString.length() - 1);
                char varFromChar = var.fromString.charAt(0);
                char varToChar = var.toString.charAt(0);
                if (varFromChar == '-' && currentFromChar != '-' || varToChar == '-' && currentToChar != '-' || var.hasQual != current.hasQual) {
                    current = var;
                    continue;
                }
                current.fromString.append(var.fromString);
                current.toString.append(var.toString);
                if (current.hasQual) {
                    current.qual.add(var.qual.get(0));
                }
                toRemoves.add(var);
                current.lastRefPosition = var.refPosition;
                continue;
            }
            current = var;
        }
        for (SamSequenceVariation toRemove : toRemoves) {
            vars.remove(toRemove);
        }
    }

    public boolean equals(int refPosition, CharSequence refChars, int readIndex, CharSequence readChars, byte[] qualChars) {
        if (refPosition != this.refPosition || readIndex != this.readIndex) {
            return false;
        }
        if (!this.fromString.equals(refChars) || !this.toString.equals(readChars)) {
            return false;
        }
        if (this.hasQual) {
            if (qualChars == null || this.qual.size() != qualChars.length) {
                return false;
            }
            for (int i = 0; i < this.qual.size(); ++i) {
                if ((Byte)this.qual.get(i) == qualChars[i]) continue;
                return false;
            }
        } else if (qualChars != null && qualChars.length > 0) {
            return false;
        }
        return true;
    }

    public static boolean contains(List<SamSequenceVariation> vars, int refPosition, CharSequence refChars, int readIndex, CharSequence readChars, byte[] qualChars) {
        for (SamSequenceVariation var : vars) {
            if (!var.equals(refPosition, refChars, readIndex, readChars, qualChars)) continue;
            return true;
        }
        return false;
    }
}

