/*
 * Decompiled with CFR 0.152.
 */
package estraier;

import estraier.Condition;
import estraier.Database;
import estraier.DatabaseInformerImpl;
import estraier.Document;
import estraier.Result;
import estraier.Utility;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Cmd {
    private static final String PROTVER = "1.0";
    private static final int SEARCHMAX = 10;
    private static final int SEARCHAUX = 32;
    private static final int SNIPWWIDTH = 480;
    private static final int SNIPHWIDTH = 96;
    private static final int SNIPAWIDTH = 96;
    private static final int VM_ID = 0;
    private static final int VM_URI = 1;
    private static final int VM_ATTR = 2;
    private static final int VM_FULL = 3;
    private static final int VM_SNIP = 4;
    private static final PrintStream stdout = System.out;
    private static final PrintStream stderr = System.err;
    static /* synthetic */ Class class$estraier$Cmd;

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            Cmd.usage();
        }
        if (stringArray[0].equals("put")) {
            n = Cmd.runput(stringArray);
        } else if (stringArray[0].equals("out")) {
            n = Cmd.runout(stringArray);
        } else if (stringArray[0].equals("edit")) {
            n = Cmd.runedit(stringArray);
        } else if (stringArray[0].equals("get")) {
            n = Cmd.runget(stringArray);
        } else if (stringArray[0].equals("uriid")) {
            n = Cmd.runuriid(stringArray);
        } else if (stringArray[0].equals("inform")) {
            n = Cmd.runinform(stringArray);
        } else if (stringArray[0].equals("optimize")) {
            n = Cmd.runoptimize(stringArray);
        } else if (stringArray[0].equals("merge")) {
            n = Cmd.runmerge(stringArray);
        } else if (stringArray[0].equals("search")) {
            n = Cmd.runsearch(stringArray);
        } else {
            Cmd.usage();
        }
        System.exit(n);
    }

    private static final void usage() {
        stderr.println("command line utility for the core API of Hyper Estraier");
        stderr.println("");
        stderr.println("synopsis:");
        StringBuffer stringBuffer = new StringBuffer("  java ");
        Class clazz = class$estraier$Cmd;
        if (clazz == null) {
            clazz = class$estraier$Cmd = Cmd.class("[Lestraier.Cmd;", false);
        }
        stderr.println(stringBuffer.append(clazz.getName()).append(" arguments...").toString());
        stderr.println("");
        stderr.println("arguments:");
        stderr.println("  put [-cl] [-ws] db [file]");
        stderr.println("  out [-cl] db expr");
        stderr.println("  edit db expr name [value]");
        stderr.println("  get db expr [attr]");
        stderr.println("  uriid db uri");
        stderr.println("  inform db");
        stderr.println("  optimize [-onp] [-ond] db");
        stderr.println("  merge [-cl] db target");
        stderr.println("  search [-vu|-va|-vf|-vs] [-gs|-gf|-ga] [-cd] [-ni] [-sf|-sfr|-sfu|-sfi] [-attr expr] [-ord expr] [-max num] [-sk num] [-aux num] [-dis name] db [phrase]");
        stderr.println("");
        System.exit(1);
    }

    private static final void printerror(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$estraier$Cmd;
        if (clazz == null) {
            clazz = class$estraier$Cmd = Cmd.class("[Lestraier.Cmd;", false);
        }
        stderr.println(stringBuffer.append(clazz.getName()).append(": ").append(string).toString());
        stderr.flush();
    }

    private static final int runput(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-cl")) {
                    n |= 1;
                } else if (string3.equals("-ws")) {
                    n |= 2;
                } else {
                    Cmd.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                Cmd.usage();
            }
            ++n2;
        }
        if (string == null) {
            Cmd.usage();
        }
        return Cmd.procput(string, string2, n);
    }

    private static final int runout(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-cl")) {
                    n |= 1;
                } else {
                    Cmd.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                Cmd.usage();
            }
            ++n2;
        }
        if (string == null || string2 == null) {
            Cmd.usage();
        }
        return Cmd.procout(string, string2, n);
    }

    private static final int runedit(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string5 = stringArray[n];
            if (string == null && string5.startsWith("-")) {
                Cmd.usage();
            } else if (string == null) {
                string = string5;
            } else if (string2 == null) {
                string2 = string5;
            } else if (string3 == null) {
                string3 = string5;
            } else if (string4 == null) {
                string4 = string5;
            } else {
                Cmd.usage();
            }
            ++n;
        }
        if (string == null || string2 == null || string3 == null) {
            Cmd.usage();
        }
        return Cmd.procedit(string, string2, string3, string4);
    }

    private static final int runget(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            if (string == null && string4.startsWith("-")) {
                Cmd.usage();
            } else if (string == null) {
                string = string4;
            } else if (string2 == null) {
                string2 = string4;
            } else if (string3 == null) {
                string3 = string4;
            } else {
                Cmd.usage();
            }
            ++n;
        }
        if (string == null || string2 == null) {
            Cmd.usage();
        }
        return Cmd.procget(string, string2, string3);
    }

    private static final int runuriid(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                Cmd.usage();
            } else if (string == null) {
                string = string3;
            } else if (string2 == string2) {
                string2 = string3;
            } else {
                Cmd.usage();
            }
            ++n;
        }
        if (string == null || string2 == null) {
            Cmd.usage();
        }
        return Cmd.procuriid(string, string2);
    }

    private static final int runinform(String[] stringArray) {
        String string = null;
        int n = 1;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                Cmd.usage();
            } else if (string == null) {
                string = string2;
            } else {
                Cmd.usage();
            }
            ++n;
        }
        if (string == null) {
            Cmd.usage();
        }
        return Cmd.procinform(string);
    }

    private static final int runoptimize(String[] stringArray) {
        String string = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-onp")) {
                    n |= 1;
                } else if (string2.equals("-ond")) {
                    n |= 2;
                } else {
                    Cmd.usage();
                }
            } else if (string == null) {
                string = string2;
            } else {
                Cmd.usage();
            }
            ++n2;
        }
        if (string == null) {
            Cmd.usage();
        }
        return Cmd.procoptimize(string, n);
    }

    private static final int runmerge(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-cl")) {
                    n |= 1;
                } else {
                    Cmd.usage();
                }
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                Cmd.usage();
            }
            ++n2;
        }
        if (string == null || string2 == null) {
            Cmd.usage();
        }
        return Cmd.procmerge(string, string2, n);
    }

    private static final int runsearch(String[] stringArray) {
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>(3);
        String string3 = null;
        int n = 10;
        int n2 = 0;
        int n3 = 0;
        int n4 = 32;
        String string4 = null;
        boolean bl = false;
        int n5 = 0;
        int n6 = 1;
        while (n6 < stringArray.length) {
            String string5 = stringArray[n6];
            if (string == null && string5.startsWith("-")) {
                if (string5.equals("-vu")) {
                    n5 = 1;
                } else if (string5.equals("-va")) {
                    n5 = 2;
                } else if (string5.equals("-vf")) {
                    n5 = 3;
                } else if (string5.equals("-vs")) {
                    n5 = 4;
                } else if (string5.equals("-gs")) {
                    n3 |= 1;
                } else if (string5.equals("-gf")) {
                    n3 |= 4;
                } else if (string5.equals("-ga")) {
                    n3 |= 8;
                } else if (string5.equals("-cd")) {
                    bl = true;
                } else if (string5.equals("-ni")) {
                    n3 |= 0x10;
                } else if (string5.equals("-sf")) {
                    n3 |= 0x400;
                } else if (string5.equals("-sfr")) {
                    n3 |= 0x800;
                } else if (string5.equals("-sfu")) {
                    n3 |= 0x8000;
                } else if (string5.equals("-sfi")) {
                    n3 |= 0x10000;
                } else if (string5.equals("-attr")) {
                    if (++n6 >= stringArray.length) {
                        Cmd.usage();
                    }
                    arrayList.add(stringArray[n6]);
                } else if (string5.equals("-ord")) {
                    if (++n6 >= stringArray.length) {
                        Cmd.usage();
                    }
                    string3 = stringArray[n6];
                } else if (string5.equals("-max")) {
                    if (++n6 >= stringArray.length) {
                        Cmd.usage();
                    }
                    n = Integer.parseInt(stringArray[n6]);
                } else if (string5.equals("-sk")) {
                    if (++n6 >= stringArray.length) {
                        Cmd.usage();
                    }
                    n2 = Integer.parseInt(stringArray[n6]);
                } else if (string5.equals("-aux")) {
                    if (++n6 >= stringArray.length) {
                        Cmd.usage();
                    }
                    n4 = Integer.parseInt(stringArray[n6]);
                } else if (string5.equals("-dis")) {
                    if (++n6 >= stringArray.length) {
                        Cmd.usage();
                    }
                    string4 = stringArray[n6];
                } else {
                    Cmd.usage();
                }
            } else if (string == null) {
                string = string5;
            } else {
                string2 = string2 == null ? string5 : string2 + ' ' + string5;
            }
            ++n6;
        }
        if (string == null) {
            Cmd.usage();
        }
        return Cmd.procsearch(string, string2, arrayList, string3, n, n2, n3, n4, string4, bl, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int procput(String string, String string2, int n) {
        Database database;
        Object object;
        byte[] byArray;
        block16: {
            block17: {
                byArray = null;
                if (string2 == null) break block17;
                object = null;
                try {
                    try {
                        object = new FileInputStream(string2);
                        byArray = Utility.read_all((InputStream)object);
                    }
                    catch (IOException iOException) {
                        Cmd.printerror(iOException.toString());
                        int n2 = 1;
                        Object var6_8 = null;
                        try {
                            if (object == null) return n2;
                            ((FileInputStream)object).close();
                            return n2;
                        }
                        catch (IOException iOException2) {}
                        return n2;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    try {}
                    catch (IOException iOException) {}
                    if (object == null) throw throwable;
                    ((FileInputStream)object).close();
                    throw throwable;
                    throw throwable;
                }
                {
                    database = null;
                    try {}
                    catch (IOException iOException) {}
                    if (object != null) {
                        ((FileInputStream)object).close();
                    }
                    break block16;
                }
                break block16;
            }
            try {
                byArray = Utility.read_all(System.in);
            }
            catch (IOException iOException) {
                Cmd.printerror(iOException.toString());
                return 1;
            }
        }
        object = null;
        try {
            object = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Cmd.printerror(unsupportedEncodingException.toString());
            return 1;
        }
        Document document = new Document((String)object);
        database = new Database();
        if (!database.open(string, 6)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        database.set_informer(new DatabaseInformerImpl());
        if (!database.put_doc(document, n)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        if (database.close()) return 0;
        Cmd.printerror(string + ": " + database.err_msg(database.error()));
        return 1;
    }

    private static final int procout(String string, String string2, int n) {
        Database database = new Database();
        if (!database.open(string, 2)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        database.set_informer(new DatabaseInformerImpl());
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (n2 < 1 && (n2 = database.uri_to_id(string2)) < 1) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        if (!database.out_doc(n2, n)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        if (!database.close()) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        return 0;
    }

    private static final int procedit(String string, String string2, String string3, String string4) {
        Database database = new Database();
        if (!database.open(string, 2)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        database.set_informer(new DatabaseInformerImpl());
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 1 && (n = database.uri_to_id(string2)) < 1) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        Document document = database.get_doc(n, 2);
        if (document == null) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        document.add_attr(string3, string4);
        if (!database.edit_doc(document)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        if (!database.close()) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        return 0;
    }

    private static final int procget(String string, String string2, String string3) {
        Database database = new Database();
        if (!database.open(string, 1)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 1 && (n = database.uri_to_id(string2)) < 1) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        if (string3 != null) {
            String string4 = database.get_doc_attr(n, string3);
            if (string4 == null) {
                Cmd.printerror(string + ": " + database.err_msg(database.error()));
                database.close();
                return 1;
            }
            stdout.println(string4);
        } else {
            Document document = database.get_doc(n, 0);
            if (document == null) {
                Cmd.printerror(string + ": " + database.err_msg(database.error()));
                database.close();
                return 1;
            }
            stdout.print(document.dump_draft());
        }
        if (!database.close()) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        return 0;
    }

    private static final int procuriid(String string, String string2) {
        Database database = new Database();
        if (!database.open(string, 1)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        int n = database.uri_to_id(string2);
        if (n < 1) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        stdout.println(n);
        if (!database.close()) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        return 0;
    }

    private static final int procinform(String string) {
        Database database = new Database();
        if (!database.open(string, 1)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        stdout.println("number of documents: " + database.doc_num());
        stdout.println("number of words: " + database.word_num());
        stdout.println("file size: " + (long)database.size());
        if (!database.close()) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        return 0;
    }

    private static final int procoptimize(String string, int n) {
        Database database = new Database();
        if (!database.open(string, 2)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        database.set_informer(new DatabaseInformerImpl());
        if (!database.optimize(n)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        if (!database.close()) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        return 0;
    }

    private static final int procmerge(String string, String string2, int n) {
        Database database = new Database();
        if (!database.open(string, 2)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        database.set_informer(new DatabaseInformerImpl());
        if (!database.merge(string2, n)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            database.close();
            return 1;
        }
        if (!database.close()) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        return 0;
    }

    private static final int procsearch(String string, String string2, List list, String string3, int n, int n2, int n3, int n4, String string4, boolean bl, int n5) {
        int n6;
        Database database = new Database();
        if (!database.open(string, 1)) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        Condition condition = new Condition();
        if (string2 != null) {
            condition.set_phrase(string2);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            condition.add_attr((String)iterator.next());
        }
        if (string3 != null) {
            condition.set_order(string3);
        }
        if (n >= 0) {
            condition.set_max(n);
        }
        if (n2 >= 0) {
            condition.set_skip(n2);
        }
        condition.set_options(n3);
        condition.set_auxiliary(n4);
        if (string4 != null) {
            condition.set_distinct(string4);
        }
        long l = new GregorianCalendar().getTimeInMillis();
        Result result = database.search(condition);
        long l2 = new GregorianCalendar().getTimeInMillis();
        String string5 = "--------[" + l + "]--------";
        stdout.println(string5);
        stdout.println("VERSION\t1.0");
        stdout.println("NODE\tlocal");
        stdout.println("HIT\t" + result.hint(""));
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator2 = result.hint_words().iterator();
        int n7 = 1;
        while (iterator2.hasNext()) {
            String string6 = (String)iterator2.next();
            n6 = result.hint(string6);
            if (n6 > 0) {
                arrayList.add(string6);
            }
            stdout.println("HINT#" + n7 + '\t' + string6 + '\t' + n6);
            ++n7;
        }
        stdout.println("TIME\t" + (double)(l2 - l) / 1000.0);
        stdout.println("DOCNUM\t" + database.doc_num());
        stdout.println("WORDNUM\t" + database.word_num());
        if (n5 == 1) {
            stdout.println("VIEW\tURI");
        } else if (n5 == 2) {
            stdout.println("VIEW\tATTRIBUTE");
        } else if (n5 == 3) {
            stdout.println("VIEW\tFULL");
        } else if (n5 == 4) {
            stdout.println("VIEW\tSNIPPET");
        } else {
            stdout.println("VIEW\tID");
        }
        stdout.println("");
        if (n5 != 2 && n5 != 3 && n5 != 4) {
            stdout.println(string5);
        }
        n7 = result.doc_num();
        int n8 = 0;
        while (n8 < n7) {
            String string7;
            Iterator iterator3;
            Document document;
            n6 = result.get_doc_id(n8);
            if (n5 == 1) {
                document = database.get_doc(n6, bl ? 0 : 2);
                if (document != null && (!bl || database.scan_doc(document, condition))) {
                    stdout.println("" + n6 + '\t' + document.attr("@uri"));
                }
            } else if (n5 == 2) {
                document = database.get_doc(n6, bl ? 0 : 2);
                if (document != null && (!bl || database.scan_doc(document, condition))) {
                    stdout.println(string5);
                    iterator3 = document.attr_names().iterator();
                    while (iterator3.hasNext()) {
                        string7 = (String)iterator3.next();
                        stdout.println(string7 + '=' + document.attr(string7));
                    }
                    stdout.println("");
                }
            } else if (n5 == 3) {
                document = database.get_doc(n6, 0);
                if (document != null && (!bl || database.scan_doc(document, condition))) {
                    stdout.println(string5);
                    stdout.print(document.dump_draft());
                }
            } else if (n5 == 4) {
                document = database.get_doc(n6, 0);
                if (document != null && (!bl || database.scan_doc(document, condition))) {
                    stdout.println(string5);
                    iterator3 = document.attr_names().iterator();
                    while (iterator3.hasNext()) {
                        string7 = (String)iterator3.next();
                        stdout.println(string7 + '=' + document.attr(string7));
                    }
                    stdout.println("");
                    stdout.print(document.make_snippet(arrayList, 480, 96, 96));
                }
            } else {
                stdout.println(n6);
            }
            ++n8;
        }
        stdout.println(string5 + ":END");
        if (!database.close()) {
            Cmd.printerror(string + ": " + database.err_msg(database.error()));
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private Cmd() {
    }
}

