/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.SafeRunnable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public abstract class Connection {
    private final String requestedUsername;
    private final String password;
    private Thread readerThread = null;
    private Socket socket;
    private String username = null;

    public Connection(String string, String string2) {
        this.requestedUsername = string;
        this.password = string2;
    }

    public Connection() {
        this(null, null);
    }

    protected String getRequestedUsername() {
        return this.requestedUsername;
    }

    protected String getPassword() {
        return this.password;
    }

    public synchronized void initiateConnect(final String string, final int n) {
        this.readerThread = new Thread("ReaderThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (Connection.this.connect(string, n)) {
                        Connection.this.readerLoop();
                    }
                }
                finally {
                    Connection connection = Connection.this;
                    synchronized (connection) {
                        if (Connection.this.readerThread == Thread.currentThread()) {
                            Connection.this.readerThread = null;
                        }
                    }
                }
            }
        };
        this.readerThread.setPriority(10);
        this.readerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(String string, int n) {
        try {
            Socket socket = this.connectImpl(string, n);
            Connection connection = this;
            synchronized (connection) {
                this.socket = socket;
            }
            this.execRunnable(new SafeRunnable(){

                public void safeRun() {
                    Connection.this.handleConnected();
                }
            });
            return true;
        }
        catch (IOException iOException) {
            if (this.readerThread == Thread.currentThread()) {
                this.handleConnectingFailed(iOException);
            }
            return false;
        }
    }

    protected Socket connectImpl(String string, int n) throws IOException {
        return new Socket(string, n);
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        return this.socket.getOutputStream();
    }

    public synchronized InetAddress getHost() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        return this.socket.getInetAddress();
    }

    public synchronized int getPort() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        return this.socket.getPort();
    }

    private void readerLoop() {
        try {
            Object object;
            InputStream inputStream = this.createInputStream(this.socket.getInputStream());
            while ((object = this.readMessage(inputStream)) != null) {
                this.execRunnable(new MessageDispatcher(object));
            }
            this.connectionInterrupted(null);
        }
        catch (IOException iOException) {
            this.connectionInterrupted(iOException);
        }
    }

    protected InputStream createInputStream(InputStream inputStream) {
        return inputStream;
    }

    protected abstract Object readMessage(InputStream var1) throws IOException;

    protected final synchronized void connectionInterrupted(final IOException iOException) {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.socket.close();
            this.socket = null;
            this.username = null;
            this.execRunnable(new SafeRunnable(){

                public void safeRun() {
                    Connection.this.handleDisconnection(iOException);
                }
            });
        }
        catch (IOException iOException2) {
            iOException2.printStackTrace();
        }
    }

    public final synchronized boolean isConnecting() {
        return this.readerThread != null && !this.isConnected();
    }

    public final synchronized boolean isConnected() {
        return this.socket != null;
    }

    public final synchronized boolean isLoggedIn() {
        return this.username != null;
    }

    public final synchronized String getUsername() {
        if (!this.isLoggedIn()) {
            throw new IllegalStateException("Not yet logged in");
        }
        return this.username;
    }

    public final synchronized void initiateLogin() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        if (this.isLoggedIn()) {
            throw new IllegalStateException("Already logged in");
        }
        this.sendLoginSequence();
    }

    protected abstract void sendLoginSequence();

    public synchronized void close() {
        if (this.isConnected()) {
            this.connectionInterrupted(null);
        } else if (this.isConnecting()) {
            this.readerThread.interrupt();
            this.readerThread = null;
        }
    }

    protected final synchronized void loginSucceeded(String string) {
        if (string == null) {
            throw new IllegalArgumentException("username may not be null");
        }
        if (this.isLoggedIn()) {
            throw new IllegalStateException("Already logged in");
        }
        this.username = string;
        this.handleLoginSucceeded();
    }

    protected final synchronized void loginFailed(String string) {
        if (this.isLoggedIn()) {
            throw new IllegalStateException("Already logged in");
        }
        this.handleLoginFailed(string);
        this.close();
    }

    protected void execRunnable(Runnable runnable) {
        runnable.run();
    }

    protected void handleConnected() {
        this.initiateLogin();
    }

    protected void handleConnectingFailed(IOException iOException) {
    }

    protected abstract void handleMessage(Object var1);

    protected void handleLoginSucceeded() {
    }

    protected void handleLoginFailed(String string) {
    }

    protected void handleDisconnection(IOException iOException) {
    }

    private class MessageDispatcher
    extends SafeRunnable {
        private final Object message;

        public MessageDispatcher(Object object) {
            this.message = object;
        }

        public void safeRun() {
            Connection.this.handleMessage(this.message);
        }
    }
}

