/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import free.util.WindowDisposingListener;
import free.util.swing.Mnemonicable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SwingUtils {
    private static final KeyStroke CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(27, 0);

    public static void registerEscapeCloser(RootPaneContainer rootPaneContainer) {
        JRootPane jRootPane = rootPaneContainer.getRootPane();
        Window window = SwingUtilities.windowForComponent(jRootPane);
        WindowDisposingListener windowDisposingListener = new WindowDisposingListener(window);
        jRootPane.registerKeyboardAction(windowDisposingListener, CLOSE_KEYSTROKE, 2);
    }

    public static Frame frameForComponent(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
                continue;
            }
            component = component.getParent();
        }
        return null;
    }

    public static JPanel createHorizontalBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        return jPanel;
    }

    public static JPanel createVerticalBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        return jPanel;
    }

    public static void makeIconButton(AbstractButton abstractButton, Icon icon, Icon icon2, Icon icon3) {
        abstractButton.setIcon(icon);
        abstractButton.setRolloverIcon(icon2);
        abstractButton.setPressedIcon(icon3);
        abstractButton.setBorderPainted(false);
        abstractButton.setContentAreaFilled(false);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
    }

    public static int getLabelMnemonicIndex(String string) {
        return string.indexOf(38);
    }

    public static String getLabelText(String string) {
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + string.substring(n + 1);
    }

    public static void applyLabelSpec(AbstractButton abstractButton, String string) {
        abstractButton.setText(SwingUtils.getLabelText(string));
        if (!SwingUtils.isMacLnF()) {
            abstractButton.setDisplayedMnemonicIndex(SwingUtils.getLabelMnemonicIndex(string));
        }
    }

    public static void applyLabelSpec(JLabel jLabel, String string) {
        jLabel.setText(SwingUtils.getLabelText(string));
        if (!SwingUtils.isMacLnF()) {
            jLabel.setDisplayedMnemonicIndex(SwingUtils.getLabelMnemonicIndex(string));
        }
    }

    public static void applyLabelSpec(Mnemonicable mnemonicable, String string) {
        mnemonicable.setText(SwingUtils.getLabelText(string));
        if (!SwingUtils.isMacLnF()) {
            mnemonicable.setDisplayedMnemonicIndex(SwingUtils.getLabelMnemonicIndex(string));
        }
    }

    public static boolean isMacLnF() {
        String string = UIManager.getLookAndFeel().getID();
        return string.equals("Mac") || string.equals("Aqua");
    }

    public static boolean isMetalLnF() {
        return UIManager.getLookAndFeel().getID().equals("Metal");
    }

    public static boolean isMotiflLnF() {
        return UIManager.getLookAndFeel().getID().equals("Motif");
    }

    public static boolean isWindowsLnF() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }
}

