/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.Registry;
import gnu.javax.crypto.key.srp6.SRPAlgorithm;
import gnu.javax.crypto.key.srp6.SRPKey;
import gnu.javax.crypto.key.srp6.SRPKeyPairRawCodec;
import java.math.BigInteger;
import java.security.PrivateKey;

public class SRPPrivateKey
extends SRPKey
implements PrivateKey {
    private final BigInteger X;
    private final BigInteger v;

    public static SRPPrivateKey valueOf(byte[] byArray) {
        if (byArray[0] == Registry.MAGIC_RAW_SRP_PRIVATE_KEY[0]) {
            SRPKeyPairRawCodec sRPKeyPairRawCodec = new SRPKeyPairRawCodec();
            return (SRPPrivateKey)sRPKeyPairRawCodec.decodePrivateKey(byArray);
        }
        throw new IllegalArgumentException("magic");
    }

    public BigInteger getX() {
        return this.X;
    }

    public BigInteger getV() {
        return this.v;
    }

    public byte[] getEncoded(int n) {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new SRPKeyPairRawCodec().encodePrivateKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("format");
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        if (!(object instanceof SRPPrivateKey)) {
            return false;
        }
        SRPPrivateKey sRPPrivateKey = (SRPPrivateKey)object;
        boolean bl2 = false;
        if (super.equals(sRPPrivateKey) && this.X.equals(sRPPrivateKey.getX())) {
            bl2 = bl = true;
        }
        if (this.v != null) {
            boolean bl3 = false;
            if (bl && this.v.equals(sRPPrivateKey.getV())) {
                bl3 = true;
            }
            bl = bl3;
        }
        return bl;
    }

    public SRPPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(bigInteger, bigInteger2, bigInteger3, null);
    }

    public SRPPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(bigInteger, bigInteger2);
        SRPAlgorithm.checkParams(bigInteger, bigInteger2);
        this.X = bigInteger3;
        this.v = bigInteger4;
    }

    SRPPrivateKey(BigInteger[] bigIntegerArray) {
        super(bigIntegerArray[0], bigIntegerArray[1]);
        if (bigIntegerArray.length == 3) {
            this.X = bigIntegerArray[2];
            this.v = null;
        } else if (bigIntegerArray.length == 4) {
            this.X = bigIntegerArray[2];
            this.v = bigIntegerArray[3];
        } else {
            throw new IllegalArgumentException("invalid number of SRP parameters");
        }
    }
}

