/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.alsa;

import javax.sound.sampled.AudioFormat;
import org.tritonus.share.sampled.AudioFormats;

public class AlsaUtils {
    private static AudioFormat[] sm_aFormatTable = new AudioFormat[32];

    public static AudioFormat getAlsaFormat(int n) {
        return sm_aFormatTable[n];
    }

    public static int getAlsaFormat(AudioFormat audioFormat) {
        int n = audioFormat.getChannels();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int n2 = audioFormat.getSampleSizeInBits();
        int n3 = 0;
        while (n3 < sm_aFormatTable.length) {
            if (sm_aFormatTable[n3] != null && AudioFormats.matches(sm_aFormatTable[n3], audioFormat)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    static {
        AlsaUtils.sm_aFormatTable[0] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[1] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[2] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false);
        AlsaUtils.sm_aFormatTable[3] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[4] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 16, -1, -1, -1.0f, false);
        AlsaUtils.sm_aFormatTable[5] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 16, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[6] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, false);
        AlsaUtils.sm_aFormatTable[7] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[8] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 24, -1, -1, -1.0f, false);
        AlsaUtils.sm_aFormatTable[9] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 24, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[10] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, false);
        AlsaUtils.sm_aFormatTable[11] = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[12] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 32, -1, -1, -1.0f, false);
        AlsaUtils.sm_aFormatTable[13] = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 32, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[20] = new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, 8, -1, -1, -1.0f, true);
        AlsaUtils.sm_aFormatTable[21] = new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, 8, -1, -1, -1.0f, true);
    }
}

