/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import lts.CompactState;
import lts.DrawMachine;

public class LTSCanvas
extends JPanel
implements Scrollable {
    public static boolean fontFlag = false;
    public static boolean displayName = false;
    public static boolean newLabelFormat = true;
    Dimension initial = new Dimension(10, 10);
    Font nameFont;
    Font labelFont;
    static final int SEPARATION = 80;
    static final int ARCINC = 30;
    protected boolean singleMode = false;
    DrawMachine[] drawing;
    DrawMachine focus;
    protected MouseInputListener mouse;
    private Rectangle rr = new Rectangle();
    private int maxUnitIncrement = 1;

    public LTSCanvas(boolean bl) {
        this.setBigFont(fontFlag);
        this.setBackground(Color.white);
        this.singleMode = bl;
        if (!this.singleMode) {
            this.mouse = new MyMouse();
            this.addMouseListener(this.mouse);
            this.addMouseMotionListener(this.mouse);
        }
    }

    public void setMode(boolean bl) {
        if (bl == this.singleMode) {
            return;
        }
        this.focus = null;
        if (this.drawing != null) {
            int n = this.drawing.length;
            this.drawing = new DrawMachine[n];
        }
        this.singleMode = bl;
        if (!this.singleMode) {
            this.mouse = new MyMouse();
            this.addMouseListener(this.mouse);
            this.addMouseMotionListener(this.mouse);
        } else if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.removeMouseMotionListener(this.mouse);
            this.mouse = null;
        }
        this.setPreferredSize(this.initial);
        this.revalidate();
        this.repaint();
    }

    public void setBigFont(boolean bl) {
        if (bl) {
            this.labelFont = new Font("Serif", 1, 14);
            this.nameFont = new Font("SansSerif", 1, 18);
        } else {
            this.labelFont = new Font("Serif", 0, 12);
            this.nameFont = new Font("SansSerif", 1, 14);
        }
        if (this.drawing != null) {
            int n = 0;
            while (n < this.drawing.length) {
                if (this.drawing[n] != null) {
                    this.drawing[n].setFonts(this.nameFont, this.labelFont);
                }
                ++n;
            }
        }
        this.repaint();
    }

    public void setDrawName(boolean bl) {
        displayName = bl;
        if (this.drawing != null) {
            int n = 0;
            while (n < this.drawing.length) {
                if (this.drawing[n] != null) {
                    this.drawing[n].setDrawName(displayName);
                }
                ++n;
            }
        }
        this.repaint();
    }

    public void setNewLabelFormat(boolean bl) {
        newLabelFormat = bl;
        if (this.drawing != null) {
            int n = 0;
            while (n < this.drawing.length) {
                if (this.drawing[n] != null) {
                    this.drawing[n].setNewLabelFormat(newLabelFormat);
                }
                ++n;
            }
        }
        this.repaint();
    }

    public void setMachines(int n) {
        this.focus = null;
        this.drawing = n > 0 ? new DrawMachine[n] : null;
        this.setPreferredSize(this.initial);
        this.revalidate();
        this.repaint();
    }

    public void draw(int n, CompactState compactState, int n2, int n3, String string) {
        if (compactState == null || n >= this.drawing.length) {
            this.drawing = null;
            this.repaint();
            return;
        }
        if (this.drawing[n] == null) {
            this.drawing[n] = new DrawMachine(compactState, this, this.nameFont, this.labelFont, displayName, newLabelFormat, 80, 30);
        }
        if (this.singleMode) {
            this.focus = this.drawing[n];
        }
        this.drawing[n].select(n2, n3, string);
        Dimension dimension = this.drawing[n].getSize();
        Dimension dimension2 = this.getPreferredSize();
        this.setPreferredSize(new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height)));
        this.revalidate();
        this.repaint();
    }

    public void clear(int n) {
        this.drawing[n] = null;
        this.repaint();
    }

    public int clearSelected() {
        if (this.focus == null || this.singleMode || this.drawing == null) {
            return -1;
        }
        int n = 0;
        while (this.drawing[n] != this.focus) {
            ++n;
        }
        this.focus = null;
        this.drawing[n] = null;
        this.repaint();
        return n;
    }

    public void stretchHorizontal(int n) {
        if (this.focus != null) {
            this.focus.setStretch(false, n, 0);
            this.focus.getRect(this.rr);
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(new Dimension(Math.max(dimension.width, this.rr.x + this.rr.width), Math.max(dimension.height, this.rr.y + this.rr.height)));
            this.revalidate();
            this.repaint();
        }
    }

    public void stretchVertical(int n) {
        if (this.focus != null) {
            this.focus.setStretch(false, 0, n);
            this.focus.getRect(this.rr);
            Dimension dimension = this.getPreferredSize();
            this.setPreferredSize(new Dimension(Math.max(dimension.width, this.rr.x + this.rr.width), Math.max(dimension.height, this.rr.y + this.rr.height)));
            this.revalidate();
            this.repaint();
        }
    }

    public void select(int n, int[] nArray, int[] nArray2, String string) {
        if (this.drawing == null) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.drawing[n2] != null) {
                int n3 = nArray != null ? nArray[n2] : 0;
                int n4 = nArray2 != null ? nArray2[n2] : 0;
                this.drawing[n2].select(n3, n4, string);
            }
            ++n2;
        }
        this.repaint();
    }

    public DrawMachine getDrawing() {
        return this.focus;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        if (this.drawing != null && !this.singleMode) {
            int n = 0;
            while (n < this.drawing.length) {
                if (this.drawing[n] != null && (this.drawing[n] != this.focus || this.focus == null)) {
                    this.drawing[n].draw(graphics);
                }
                ++n;
            }
        }
        if (this.focus != null) {
            this.focus.draw(graphics);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.maxUnitIncrement;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return rectangle.width - 80;
        }
        return rectangle.height - 30;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int n) {
        this.maxUnitIncrement = n;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    class MyMouse
    extends MouseInputAdapter {
        Point start = null;
        Rectangle r = new Rectangle();

        MyMouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (LTSCanvas.this.drawing != null) {
                if (LTSCanvas.this.focus != null) {
                    LTSCanvas.this.focus.setSelected(false);
                    LTSCanvas.this.focus = null;
                    LTSCanvas.this.repaint();
                }
                int n = 0;
                while (n < LTSCanvas.this.drawing.length) {
                    if (LTSCanvas.this.drawing[n] != null) {
                        LTSCanvas.this.drawing[n].getRect(this.r);
                        if (this.r.contains(mouseEvent.getPoint())) {
                            LTSCanvas.this.focus = LTSCanvas.this.drawing[n];
                            LTSCanvas.this.focus.setSelected(true);
                            this.start = mouseEvent.getPoint();
                            LTSCanvas.this.repaint();
                            return;
                        }
                    }
                    ++n;
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (LTSCanvas.this.focus != null) {
                LTSCanvas.this.focus.getRect(this.r);
                Point point = mouseEvent.getPoint();
                if (this.start != null) {
                    double d = point.getX() - this.start.getX();
                    int n = (int)((double)this.r.x + d);
                    double d2 = point.getY() - this.start.getY();
                    int n2 = (int)((double)this.r.y + d2);
                    LTSCanvas.this.focus.setPos(n > 0 ? n : 0, n2 > 0 ? n2 : 0);
                    this.start = point;
                    LTSCanvas.this.repaint();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.start = null;
            if (LTSCanvas.this.focus != null) {
                LTSCanvas.this.focus.getRect(this.r);
                if (!this.r.contains(mouseEvent.getPoint())) {
                    LTSCanvas.this.focus.setSelected(false);
                    LTSCanvas.this.focus = null;
                    LTSCanvas.this.repaint();
                } else {
                    Dimension dimension = LTSCanvas.this.getPreferredSize();
                    LTSCanvas.this.setPreferredSize(new Dimension(Math.max(dimension.width, this.r.x + this.r.width), Math.max(dimension.height, this.r.y + this.r.height)));
                    LTSCanvas.this.revalidate();
                }
            }
        }
    }
}

