/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.DoubleBehaviour;
import uk.ac.ic.doc.scenebeans.Input;
import uk.ac.ic.doc.scenebeans.InputBase;
import uk.ac.ic.doc.scenebeans.PointBehaviour;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.Transform;
import uk.ac.ic.doc.scenebeans.behaviour.DoubleBehaviourBase;
import uk.ac.ic.doc.scenebeans.behaviour.PointBehaviourBase;

public class MouseMotion
extends InputBase {
    private boolean _is_active = true;
    private boolean _is_dragged = true;
    private PositionFacet _pos = new PositionFacet();
    private DoubleFacet _x = new DoubleFacet();
    private DoubleFacet _y = new DoubleFacet();
    private DoubleFacet _angle = new DoubleFacet();

    public boolean isActive() {
        return this._is_active;
    }

    public void setActive(boolean bl) {
        this._is_active = bl;
    }

    public boolean isDragged() {
        return this._is_dragged;
    }

    public void setDragged(boolean bl) {
        this._is_dragged = bl;
    }

    public PointBehaviour getPositionFacet() {
        return this._pos;
    }

    public DoubleBehaviour getxFacet() {
        return this._x;
    }

    public DoubleBehaviour getyFacet() {
        return this._y;
    }

    public DoubleBehaviour getAngleFacet() {
        return this._angle;
    }

    public void updatePosition(double d, double d2) {
        double d3 = Math.atan(d2 / d);
        d3 = d >= 0.0 ? Math.atan(d2 / d) - 1.5707963267948966 : Math.atan(d2 / d) + 1.5707963267948966;
        this._pos.postUpdate(new Point2D.Double(d, d2));
        this._x.postUpdate(d);
        this._y.postUpdate(d2);
        this._angle.postUpdate(d3);
    }

    public static void mouseMoved(SceneGraph sceneGraph, double d, double d2) throws NoninvertibleTransformException {
        Processor processor = new Processor(d, d2, false);
        MouseMotion.dispatchMouseMotion(sceneGraph, processor);
    }

    public static void mouseDragged(SceneGraph sceneGraph, double d, double d2) throws NoninvertibleTransformException {
        Processor processor = new Processor(d, d2, true);
        MouseMotion.dispatchMouseMotion(sceneGraph, processor);
    }

    private static void dispatchMouseMotion(SceneGraph sceneGraph, Processor processor) throws NoninvertibleTransformException {
        try {
            sceneGraph.accept(processor);
        }
        catch (TransformFailure transformFailure) {
            throw transformFailure.cause;
        }
    }

    private static class Processor
    implements SceneGraphProcessor {
        private AffineTransform _transform = new AffineTransform();
        private Point2D _point;
        private boolean _dragged;

        Processor(double d, double d2, boolean bl) {
            this._point = new Point2D.Double(d, d2);
            this._dragged = bl;
        }

        public void process(Primitive primitive) {
        }

        public void process(CompositeNode compositeNode) {
            int n = 0;
            while (n < compositeNode.getVisibleSubgraphCount()) {
                compositeNode.getVisibleSubgraph(n).accept(this);
                ++n;
            }
        }

        public void process(Transform transform) {
            Point2D point2D = this._point;
            try {
                this._point = transform.getTransform().inverseTransform(this._point, null);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new TransformFailure(noninvertibleTransformException);
            }
            transform.getTransformedGraph().accept(this);
            this._point = point2D;
        }

        public void process(Style style) {
            style.getStyledGraph().accept(this);
        }

        public void process(Input input) {
            MouseMotion mouseMotion;
            if (input instanceof MouseMotion && (mouseMotion = (MouseMotion)input).isActive() && (mouseMotion.isDragged() && this._dragged || !mouseMotion.isDragged())) {
                Point2D point2D = this._transform.transform(this._point, null);
                mouseMotion.updatePosition(point2D.getX(), point2D.getY());
            }
            input.getSensitiveGraph().accept(this);
        }
    }

    private static class TransformFailure
    extends RuntimeException {
        NoninvertibleTransformException cause;

        TransformFailure(NoninvertibleTransformException noninvertibleTransformException) {
            this.cause = noninvertibleTransformException;
        }
    }

    private static class DoubleFacet
    extends DoubleBehaviourBase {
        private DoubleFacet() {
        }

        public void postUpdate(double d) {
            super.postUpdate(d);
        }
    }

    private static class PositionFacet
    extends PointBehaviourBase {
        private PositionFacet() {
        }

        public void postUpdate(Point2D point2D) {
            super.postUpdate(point2D);
        }
    }
}

