;;;; $Id: mell-string.el,v 1.1.1.1 2003/06/01 03:04:44 komatsu Exp $

(defun mell-string-delete-regexp (string regexp)
  "Delete characters in STRING according as REGEXP"
  ;; replace-in-string $B$O(B Emacs $B$K$O$J$$(B.
  (apply 'concat (split-string string regexp))
  )

(defun mell-string-transpose-chars (string position)
  "Interchange characters around POSITION in STRING."
  (and (= position (length string)) (setq position (1- position)))
  (if (and (> position 0) (< position (length string)))
      (concat
       (substring string 0 (1- position))
       (substring string position (1+ position))
       (substring string (1- position) position)
       (substring string (1+ position))
       )
    string
    ))

(defun mell-string-split (string regexp)
  "Divide STRING from REGEXP."
  (let ((start 0) match-list splited-list)
    (while (string-match regexp string start)
      (setq match-list
	    (append match-list (list (match-beginning 0) (match-end 0))))
      (setq start (match-end 0))
      )
    (setq match-list (append '(0) match-list (list (length string))))
    (while match-list
      (setq splited-list 
	    (cons (substring string (nth 0 match-list) (nth 1 match-list))
		  splited-list))
      (setq match-list (nthcdr 2 match-list))
      )
    (reverse splited-list)))

(defun mell-string-replace (target-string from-regexp to-string)
  "Replace TARGET-STRING from FROM-REGEXP to TO-STRING."
  (if (string-match from-regexp target-string)
      (setq target-string
	    (mapconcat '(lambda (x) x)
		       (mell-string-split target-string from-regexp)
		       to-string))
    )
  target-string)


(defun mell-string-append-to-file (string filename)
  (save-excursion
    (or (bufferp mell-working-buffer)
	(setq mell-working-buffer
	      (get-buffer-create mell-working-buffer-name)))
    (set-buffer mell-working-buffer)
    (erase-buffer)
    (insert string)
    (append-to-file (point-min) (point-max) (expand-file-name filename))
    ))

(provide 'mell-string)
