type token =
  | WHSP
  | LPAREN
  | RPAREN
  | AND
  | OR
  | NOT
  | EOF
  | ATTREQUAL of (string * string)
  | ATTREQUALSUB of (string * Ldap_types.substring_component)
  | ATTRGTE of (string * string)
  | ATTRLTE of (string * string)
  | ATTRAPPROX of (string * string)
  | ATTRPRESENT of (string)
  | ATTREXTENDEDMATCH of (string * string * string)
  | ATTREXTENDEDDN of (string * string option * string)

open Parsing;;
let _ = parse_error;;
# 23 "src/ldap/ldap_filterparser.mly"
  open Ldap_types

  let star_escape_rex = Pcre.regexp ~study:true ("\\" ^ "\\2a")
  let lparen_escape_rex = Pcre.regexp ~study:true ("\\" ^ "\\28")
  let rparen_escape_rex = Pcre.regexp ~study:true ("\\" ^ "\\29")
  let backslash_escape_rex = Pcre.regexp ~study:true ("\\" ^ "\\5c")
  let null_escape_rex = Pcre.regexp ~study:true ("\\" ^ "\\00")
  let unescape s =
    (Pcre.qreplace ~rex:star_escape_rex ~templ:"*"
       (Pcre.qreplace ~rex:lparen_escape_rex ~templ:"("
          (Pcre.qreplace ~rex:rparen_escape_rex ~templ:")"
             (Pcre.qreplace ~rex:null_escape_rex ~templ:"\000"
                (Pcre.qreplace ~rex:backslash_escape_rex ~templ:"\\" s)))))
# 35 "src/ldap/ldap_filterparser.ml"
let yytransl_const = [|
  257 (* WHSP *);
  258 (* LPAREN *);
  259 (* RPAREN *);
  260 (* AND *);
  261 (* OR *);
  262 (* NOT *);
    0 (* EOF *);
    0|]

let yytransl_block = [|
  263 (* ATTREQUAL *);
  264 (* ATTREQUALSUB *);
  265 (* ATTRGTE *);
  266 (* ATTRLTE *);
  267 (* ATTRAPPROX *);
  268 (* ATTRPRESENT *);
  269 (* ATTREXTENDEDMATCH *);
  270 (* ATTREXTENDEDDN *);
    0|]

let yylhs = "\255\255\
\002\000\002\000\003\000\003\000\003\000\003\000\003\000\003\000\
\003\000\003\000\003\000\003\000\003\000\003\000\001\000\000\000"

let yylen = "\002\000\
\002\000\001\000\004\000\004\000\004\000\003\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\008\000\007\000\009\000\010\000\012\000\
\011\000\013\000\014\000\016\000\000\000\000\000\000\000\000\000\
\000\000\015\000\000\000\002\000\000\000\000\000\006\000\003\000\
\001\000\004\000\005\000"

let yydgoto = "\002\000\
\012\000\019\000\020\000"

let yysindex = "\013\000\
\040\255\000\000\255\254\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\019\000\040\255\040\255\040\255\
\028\255\000\000\014\255\000\000\027\255\029\255\000\000\000\000\
\000\000\000\000\000\000"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000"

let yygindex = "\000\000\
\000\000\018\000\255\255"

let yytablesize = 54
let yytable = "\013\000\
\003\000\017\000\014\000\015\000\016\000\004\000\005\000\006\000\
\007\000\008\000\009\000\010\000\011\000\001\000\022\000\003\000\
\024\000\025\000\018\000\025\000\004\000\005\000\006\000\007\000\
\008\000\009\000\010\000\011\000\003\000\026\000\023\000\027\000\
\021\000\004\000\005\000\006\000\007\000\008\000\009\000\010\000\
\011\000\003\000\000\000\000\000\000\000\000\000\004\000\005\000\
\006\000\007\000\008\000\009\000\010\000\011\000"

let yycheck = "\001\000\
\002\001\003\000\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\012\001\013\001\014\001\001\000\016\000\002\001\
\003\001\019\000\000\000\021\000\007\001\008\001\009\001\010\001\
\011\001\012\001\013\001\014\001\002\001\003\001\003\001\003\001\
\015\000\007\001\008\001\009\001\010\001\011\001\012\001\013\001\
\014\001\002\001\255\255\255\255\255\255\255\255\007\001\008\001\
\009\001\010\001\011\001\012\001\013\001\014\001"

let yynames_const = "\
  WHSP\000\
  LPAREN\000\
  RPAREN\000\
  AND\000\
  OR\000\
  NOT\000\
  EOF\000\
  "

let yynames_block = "\
  ATTREQUAL\000\
  ATTREQUALSUB\000\
  ATTRGTE\000\
  ATTRLTE\000\
  ATTRAPPROX\000\
  ATTRPRESENT\000\
  ATTREXTENDEDMATCH\000\
  ATTREXTENDEDDN\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'filterlist) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'filter) in
    Obj.repr(
# 52 "src/ldap/ldap_filterparser.mly"
                    (_2 :: _1)
# 137 "src/ldap/ldap_filterparser.ml"
               : 'filterlist))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'filter) in
    Obj.repr(
# 53 "src/ldap/ldap_filterparser.mly"
         ([_1])
# 144 "src/ldap/ldap_filterparser.ml"
               : 'filterlist))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'filterlist) in
    Obj.repr(
# 57 "src/ldap/ldap_filterparser.mly"
                               (`And _3)
# 151 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'filterlist) in
    Obj.repr(
# 58 "src/ldap/ldap_filterparser.mly"
                              (`Or _3)
# 158 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'filter) in
    Obj.repr(
# 59 "src/ldap/ldap_filterparser.mly"
                           (`Not _3)
# 165 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'filter) in
    Obj.repr(
# 60 "src/ldap/ldap_filterparser.mly"
                       (_2)
# 172 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * Ldap_types.substring_component) in
    Obj.repr(
# 61 "src/ldap/ldap_filterparser.mly"
               (`Substrings {attrtype=(fst _1);substrings=(snd _1)})
# 179 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * string) in
    Obj.repr(
# 62 "src/ldap/ldap_filterparser.mly"
            (`EqualityMatch {attributeDesc=(fst _1);assertionValue=(unescape (snd _1))})
# 186 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * string) in
    Obj.repr(
# 63 "src/ldap/ldap_filterparser.mly"
          (`GreaterOrEqual {attributeDesc=(fst _1);assertionValue=(unescape (snd _1))})
# 193 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * string) in
    Obj.repr(
# 64 "src/ldap/ldap_filterparser.mly"
          (`LessOrEqual {attributeDesc=(fst _1);assertionValue=(unescape (snd _1))})
# 200 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 65 "src/ldap/ldap_filterparser.mly"
              (`Present _1)
# 207 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * string) in
    Obj.repr(
# 66 "src/ldap/ldap_filterparser.mly"
             (`ApproxMatch {attributeDesc=(fst _1);assertionValue=(unescape (snd _1))})
# 214 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * string * string) in
    Obj.repr(
# 67 "src/ldap/ldap_filterparser.mly"
                    (let (a, oid, v) = _1 in
                       `ExtensibleMatch
                         {matchingRule=(Some (unescape oid));
                          ruletype=(Some (unescape a));
                          matchValue=(unescape v);
                          dnAttributes=false})
# 226 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string * string option * string) in
    Obj.repr(
# 73 "src/ldap/ldap_filterparser.mly"
                 (let (a, oid, v) = _1 in
                    `ExtensibleMatch
                      {matchingRule=(match oid with
                                         Some s -> Some (unescape s)
                                       | None -> None);
                       ruletype=(Some (unescape a));
                       matchValue=(unescape v);
                       dnAttributes=true})
# 240 "src/ldap/ldap_filterparser.ml"
               : 'filter))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'filter) in
    Obj.repr(
# 85 "src/ldap/ldap_filterparser.mly"
             (_1)
# 247 "src/ldap/ldap_filterparser.ml"
               : Ldap_types.filter))
(* Entry filter_and_eof *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let filter_and_eof (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : Ldap_types.filter)
