//mysql用なのでVARCHARのサイズ指定
CREATE TABLE Site (
  id INTEGER primary key AUTO_INCREMENT,
  site_id VARCHAR(255) unique,
  site_name VARCHAR(255),
  isDomainRoot INTEGER default 0,
  url VARCHAR(255),
  path VARCHAR(255),
  data_source_name VARCHAR(255)
) TYPE = InnoDB;

CREATE TABLE ASPUser (
  id INTEGER primary key AUTO_INCREMENT,
  first_name VARCHAR(255),
  last_name VARCHAR(255),
  first_name_reading VARCHAR(255),
  last_name_reading VARCHAR(255),
  nickname VARCHAR(255),
  birth_date VARCHAR(255),
  email VARCHAR(255) not null unique,
  password VARCHAR(255),
  last_login_date INTEGER
) TYPE = InnoDB;

CREATE TABLE User_Site(
	user_id INTEGER,
	site_id INTEGER,
	unique ( user_id, site_id )
) TYPE = InnoDB;

CREATE TABLE CertificationQueue(
	id INTEGER primary key AUTO_INCREMENT,
	user_id INTEGER,
	site_id VARCHAR(255),
	time_limit INTEGER,
	register_code VARCHAR(255) not null
) TYPE = InnoDB;

create table cmsfile(
	id INTEGER primary key AUTO_INCREMENT,
	name VARCHAR(255),
	path VARCHAR(255),
	url VARCHAR(255),
	parent_file_id integer,
	extension VARCHAR(255),
	is_dir integer,
	is_image integer,
	file_size integer,
	create_date integer,
	update_date integer
);

create table download_log(
	id INTEGER primary key AUTO_INCREMENT,
	download_date integer,
	download_file varchar(255),
	ip_address varchar(255),
	user_agent varchar(255),
	mail_address varchar(255),
	analyzed integer default 0
);
-- alter table download_log add column analyzed integer default 0 ;

create table download_count(
	id INTEGER primary key AUTO_INCREMENT,
	name varchar(255),
	date integer,
	count integer,
	unique (name, date)
);