<?php

###############################################################################
# persian_utf-8.php
#
# This is the Persian language file for Geeklog
# Special thanks to Mahdi Montazeri for his work on this project
#
# Copyright (C) 2018 geeklog.ir
# info AT mahdimontazeri DOT com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

$LANG_ISO639_1 = 'fa';
$LANG_DIRECTION = 'rtl';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'ارائه شده توسط:',
    2 => 'بیشتر بخوانید',
    3 => 'نظرات',
    4 => 'ویرایش',
    5 => 'Contributed by: %s on %s',
    6 => 'Last modified on %s',
    7 => '',
    8 => '',
    9 => 'وظایف مدیریت:',
    10 => 'ارسال مقالات',
    11 => 'مقالات',
    12 => 'بلوک ها',
    13 => 'موضوعات',
    14 => 'دستور و کنترل',
    15 => '',
    16 => '',
    17 => 'کاربران',
    18 => 'SQL Query',
    19 => 'خروج',
    20 => 'اطلاعات کاربر:',
    21 => 'نام کاربری',
    22 => 'شناسه کاربر',
    23 => 'سطح امنیتی',
    24 => 'ناشناس',
    25 => 'پاسخ',
    26 => 'نظرات زیر متعلق به اشخاصی می باشند که آنها را ارسال کرده اند. این سایت مسئول آنچه که می گویند نمی باشد.',
    27 => 'آخرین پست ها',
    28 => 'حذف',
    29 => 'بدون نظر کاربر',
    30 => 'مقالات قدیمی تر',
    31 => 'برچسب های مجاز HTML:',
    32 => 'خطا، نام کاربری نامعتبر است',
    33 => 'خطا، قادر به نوشتن در پرونده log نمی باشد',
    34 => 'خطا',
    35 => 'خروج',
    36 => 'روشن',
    37 => 'بدون مقالات کاربر',
    38 => 'سندیکای محتوا',
    39 => 'تازه کردن',
    40 => 'خطا در درخواست رمز عبور، نام کاربری نامعتبر است',
    41 => 'کاربران مهمان',
    42 => 'نوشته توسط:',
    43 => 'پاسخ به این',
    44 => 'اصلی',
    45 => 'شماره خطا MySQL',
    46 => 'پیام خطای MySQL',
    47 => 'وظایف کاربر',
    48 => 'حساب من',
    49 => 'ترجیحات',
    50 => 'خطا با بیانیه SQL',
    51 => 'راهنما',
    52 => 'جدید',
    53 => 'صفحه اصلی مدیر',
    54 => 'پرونده را نمی توان باز کرد.',
    55 => 'خطا در',
    56 => 'رای',
    57 => 'رمز عبور',
    58 => 'ورود',
    59 => "حساب کاربری ندارید؟ ثبت نام به عنوان یک <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">کاربر جدید</a>!",
    60 => 'ارسال نظر',
    61 => 'ایجاد حساب کاربری جدید',
    62 => 'کلمات',
    63 => 'ترجیحات نظر',
    64 => 'ارسال مقاله به یک دوست توسط ایمیل',
    65 => 'دیدن نسخه قابل چاپ',
    66 => '',
    67 => 'خوش آمدید به ',
    68 => 'خانه',
    69 => 'تماس',
    70 => 'جستجو',
    71 => 'مشارکت',
    72 => 'منابع اینترنتی',
    73 => '',
    74 => '',
    75 => 'جستجوی پیشرفته',
    76 => 'آمار سایت',
    77 => 'افزونه ها',
    78 => '',
    79 => 'چه خبر',
    80 => 'مقالات در آخرین',
    81 => 'مقاله در آخرین',
    82 => 'ساعت ها',
    83 => 'نظرات',
    84 => '',
    85 => '۴۸ ساعت گذشته',
    86 => 'بدون نظرات جدید',
    87 => '۲ هفته گذشته',
    88 => '',
    89 => '',
    90 => 'خانه',
    91 => 'ایجاد شده این صفحه در',
    92 => 'ثانیه ها',
    93 => 'حق نسخه برداری',
    94 => 'همه علائم تجاری و حق نسخه برداری در این صفحه متعلق به صاحبان مربوطه می باشند.',
    95 => 'قدرت گرفته توسط',
    96 => 'گروه ها',
    97 => 'فهرست لغت',
    98 => 'افزونه ها',
    99 => 'مقالات',
    100 => 'بدون مقالات جدید',
    101 => 'مقالات قدیمی تر وجود ندارد',
    102 => '',
    103 => 'مدیریت پایگاه داده',
    104 => 'توسط',
    105 => 'نامه به کاربران',
    106 => 'مشاهدات:',
    107 => 'آزمایش نسخه GL',
    108 => 'پاکسازی حافظه نهان',
    109 => 'گزارش سوءاستفاده',
    110 => 'گزارش این پست به مدیر سایت',
    111 => '',
    112 => 'کاربران ثبت نام شده',
    113 => 'مستندات',
    114 => 'دنبالک ها',
    115 => 'بدون نظرات جدید دنبالک',
    116 => 'دنبالک',
    117 => 'پوشه',
    118 => 'لطفا ادامه مطلب را در صفحه بعدی ادامه دهید:',
    119 => "Lost your <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">رمز عبور</a>?",
    120 => 'پیوند دائمی به این نظر',
    121 => 'نظرات (%d)',
    122 => 'دنبالک ها (%d)',
    123 => 'همه HTML مجاز است',
    124 => 'برای حذف همه موارد علامت گذاری شده کلیک کنید',
    125 => 'آیا مطمئن هستید که می خواهید همه موارد علامت گذاری شده را حذف کنید؟',
    126 => 'همه موارد را انتخاب یا حذف کنید',
    127 => 'پیوند دائمی',
    128 => 'ورود با OpenID',
    129 => 'پیکربندی',
    130 => 'خدمات اینترنتی',
    131 => 'HTML مجاز نمی باشد',
    132 => 'اطلاعات',
    133 => 'بحرانی',
    134 => 'راهنما',
    135 => 'هشدار',
    136 => 'هشدار: جاوا اسکریپت برای عملکرد بهتر توصیه می شود',
    137 => 'هشدار: برای فعال کردن قابلیت جاوا اسکریپت نیاز است',
    138 => "برای غیرفعال کردن ویرایشگر پیشرفته و استفاده از ویرایشگر پیشفرض که جاوا اسکریپت نیاز نمی باشد <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">اینجا</a> کلیک کنید",
    139 => "برای بازگشت به صفحه اصلی <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">اینجا</a> کلیک کنید",
    140 => 'برچسب های خودکار مجاز:',
    141 => 'یک خطا رخ داد',
    142 => 'متأسفانه، در بارگذاری این صفحه خطایی رخ داده است. لطفا بعدا مجدد امتحان کنید.',
    143 => 'اظهار نظر (%d)',
    144 => 'Parse Error.  An error occurred while parsing PHP code.',
    'loginform' => "<a href=\"{$_CONF['site_url']}/users.php\">Login Here</a>",
    'remoteloginoptions' => 'Remote Login Options',
    'facebook' => 'برای ورود با فیسبوک',
    'twitter' => 'ورود با توییتر',
    'linkedin' => 'ورود با لینکداین',
    'google' => 'ورود با گوگل',
    'microsoft' => 'Login with Microsoft',
    'yahoo' => 'ورود با یاهو',
    'github' => 'ورود با گیتهاب',
    'ctl' => 'پاکسازی حافظه نهان',
    'ok' => 'تصویب',
    'filemanager' => 'مدیریت پرونده',
    'error_invalid_password' => 'خطا، رمز عبور نامعتبر برای نام کاربری',
    'error_filemanager_disabled' => 'Filemanager is disabled',
    'terms_of_use' => 'Terms of Use',
    'terms_of_service' => 'Terms of Service',
    'privacy_policy' => 'Privacy Policy',
    'about_cookies' => 'About Cookies',
    'parse_php_error' => 'There was an error parsing your PHP code: %s',
    'error_title' => 'An Error Occurred'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'ارسال نظر',
    2 => 'حالت پست',
    3 => 'خروج',
    4 => 'ایجاد حساب کاربری',
    5 => 'نام کاربری',
    6 => 'این سایت به شما نیاز دارد که برای ارسال نظر وارد سیستم شوید، لطفا وارد شوید. اگر حساب کاربری ندارید می توانید از فرم زیر برای ایجاد یک حساب استفاده کنید.',
    7 => 'آخرین نظر شما بود ',
    8 => " چند ثانیه قبل. این سایت حداقل نیاز دارد {$_CONF['commentspeedlimit']} ثانیه بین نظرات",
    9 => 'اظهار نظر',
    10 => 'ارسال گزارش',
    11 => 'ثبت کردن نظر',
    12 => 'لطفا رشته های عنوان و نظر را پر کنید، همانطور که برای ارسال یک نظر نیاز است.',
    13 => 'اطلاعات شما',
    14 => 'پیش نمایش',
    15 => 'گزارش این پست',
    16 => 'عنوان',
    17 => 'خطا',
    18 => 'چیز های مهم',
    19 => 'لطفا تلاش کنید پست ها را درباره موضوع نگه دارید.',
    20 => 'بجای شروع موضوعات جدید تلاش کنید به نظرات دیگران پاسخ دهید.',
    21 => 'قبل از ارسال خود، پیام های دیگران را بخوانید تا آنچه که از قبل گفته شد، از تکثیر مجدد آن جلوگیری شود.',
    22 => 'از یک موضوع واضح استفاده کنید که درباره پیام شما توضیح می دهد.',
    23 => 'نشانی ایمیل شما به صورت عمومی منتشر نخواهد شد.',
    'instr_line6' => 'When logged in as a user your comments will be linked to your account and you can specify if you would like notifications of any replies.',
    24 => 'کاربر ناشناس',
    25 => 'آیا مطمئن هستید که میخواهید این پست را به مدیر سایت گزارش دهید؟',
    26 => '%s :گزارش پست های خشونت آمیز زیر را گزارش کرد',
    27 => 'گزارش سوء استفاده',
    28 => 'تغییرات پیش نمایش',
    29 => 'ثبت تغییرات',
    30 => 'ویرایش شده',
    31 => 'توسط',
    32 => 'ویرایش یک نظر',
    33 => 'ویرایش نظر ارسال',
    34 => 'تغییرات ارسال پیش نمایش',
    35 => 'ذخیره تغییرات در صف',
    36 => 'پاسخ های جدید را به من اعلام کن',
    37 => 'پاسخ نظر جدید',
    38 => 'یک پاسخ به نظر شما داده شده \'%s\'.',
    39 => 'می توانید متن نظر را در نشانی زیر ببینید:',
    40 => 'اگر مایل به دریافت هیچگونه اطلاعیه دیگری از پاسخ ها نباشید، به پیوند زیر مراجعه کنید:',
    41 => 'درود %s,',
    42 => 'لغو اشتراک',
    43 => 'لغو اشتراک از اطلاعیه های پاسخ',
    44 => 'اسم شما',
    45 => "سپاس از نظر شما. باید صبر کنید {$_CONF['commentspeedlimit']} ثانیه برای ارسال نظر جدید.",
    100 => 'مدیریت نظر',
    101 => 'نظرات موجود',
    102 => 'اقدام حجمی',
    103 => 'این کاربر را ممنوع کنید',
    104 => 'این نشانی آیپی را توسط افزونه ضد هرزنامه ممنوع کنید',
    105 => 'نشانی آیپی',
    106 => 'انجام اعمال حجمی در نظرات و ارسالی های نظر از جمله تصویب و حذف. همچنین می توانید کاربران و نشانی های آیپی را به صورت حجمی ممنوع کنید. <span style="color: red;">نشانی های آیپی در قرمز</span> کسانی که توسط افزونه ضد هرزنامه ممنوع شده اند (فقط از ارسالی ها ممنوع شده) and/or افزونه ممنوعیت (از بازدید سایت ممنوع شده). <span style="color: red;">نام های کاربری در قرمز</span> کاربرانی که ممنوع شده اند.',
    'record_edit' => 'کاربر و زمان ویرایش ضبط شود؟',
    'ban_plugin_ban_ip' => 'این نشانی آیپی را توسط افزونه ممنوعیت ممنوع کنید',
    'num_comments' => '%s Comment(s)',
    'anon_user_name' => '%s (Anonymous User)',
    'comments_closed_msg' => 'Comments are closed and no new posts are allowed.',
    'read_comment' => 'Read the full comment at',
    'comment_for' => 'The above comment is for the following item',
    'comment_page_title' => 'Comments for %s',
    'comments' => 'Comments'
);

###############################################################################
# usersettings.php

$LANG04 = array(
    1 => 'مشخصات کاربر برای',
    2 => 'نام کاربری',
    3 => 'نام و نام خانوادگی',
    4 => 'رمز عبور جدید',
    5 => 'ایمیل',
    6 => 'صفحه نخست',
    7 => 'زندگینامه',
    8 => 'کلید پی جی پی',
    9 => 'ذخیره اطلاعات',
    10 => 'آخرین 10 نظر برای کاربر',
    11 => 'بدون نظرات کاربر',
    12 => 'ترجیحات کاربر برای',
    13 => 'خلاصه ایمیل روزانه',
    14 => 'این رمز عبور توسط یک رندومایزر تولید شده است. توصیه می شود که این رمز را بلافاصله تغییر دهید. برای تغییر رمز عبور خود، وارد شوید و سپس از منوی وظایف کاربر بر حساب کاربری من کلیک کنید.',
    15 => "حساب کاربری شما {$_CONF['site_name']} با موفقیت ایجاد شده است. برای استفاده از آن، باید با بکارگیری از اطلاعات زیر وارد شوید. لطفا این ایمیل را برای ارجاع بیشتر ذخیره کنید.",
    'email_convert_remote' => "Your {$_CONF['site_name']} remote account has been converted to a local account. To continue to use your account, you must login using the information below. Please save this mail for further reference.",
    16 => 'اطلاعات حساب کاربری شما',
    17 => 'حساب کاربری وجود ندارد',
    18 => 'نشانی ایمیل ارائه شده به نظر نمی رسد یک نشانی ایمیل معتبر باشد',
    19 => 'نام کاربری یا نشانی ایمیل ارائه شده از قبل موجود است',
    20 => 'نشانی ایمیل ارائه شده به نظر نمی رسد یک نشانی ایمیل معتبر باشد',
    21 => 'خطا',
    22 => "ثبت نام با {$_CONF['site_name']}!",
    23 => "ایجاد یک حساب کاربری به شما همه مزایای {$_CONF['site_name']} عضویت را می دهد و به شما اجازه می دهد تا نظرات خود را ارسال و موارد را به عنوان خودتان ارسال کنید. اگر حساب کاربری ندارید، فقط قادر به ارسال ناشناسانه خواهید بود. لطفا توجه داشته باشید که نشانی ایمیل شما </i></b>هرگز<b><i> به صورت عمومی در این سایت نمایش داده نخواهد شد.",
    24 => 'رمز عبور شما به نشانی ایمیلی که وارد می کنید ارسال خواهد شد.',
    25 => 'آیا رمز عبور خود را فراموش کرده اید؟',
    26 => '<em>یکی از</em> نام کاربری <em>یا</em> نشانی ایمیل را که برای ثبت نام استفاده کردید را وارد کنید و روی ایمیل رمز عبور کلیک کنید. دستورالعمل ها درباره چگونگی تنظیم یک رمز عبور جدید به نشانی ایمیل ضبط شده ارسال خواهد شد.',
    27 => 'ثبت نام کن!',
    28 => 'رمز ایمیل',
    29 => 'خارج شدن از',
    30 => 'وارد شده از',
    31 => 'قابلیتی که انتخاب کرده اید نیاز به ورود شما به سیستم دارد',
    32 => 'امضا',
    33 => 'هرگز به صورت عمومی نمایش داده نشود',
    34 => 'این اسم واقعی شماست',
    35 => 'رمز عبور را وارد کنید تا آن را تغییر دهید',
    36 => 'شروع با http://',
    37 => 'به نظرات شما اعمال شد',
    38 => 'همه چیز درباره شماست! هر کس می تواند این را بخواند',
    39 => 'کلید عمومی پی جی پی شما برای اشتراک گذاشتن',
    42 => 'قالب تاریخ',
    43 => 'حداکثر مقالات',
    48 => 'موضوعات',
    52 => 'پیشفرض هست',
    53 => 'دریافت مقالات روز ها هرشب',
    56 => 'نویسندگان',
    57 => 'حالت نمایش',
    58 => 'سفارش مرتب سازی',
    59 => 'محدودیت نظر',
    60 => 'چگونه نظرات شما نمایش داده شود؟',
    61 => 'ابتدا جدیدترین یا قدیمی ترین؟',
    62 => 'پیشفرض 100 است',
    63 => "رمز عبور شما به شما ایمیل شده است و باید در مدت کوتاهی برسد. لطفا دستورالعمل ها را در پیام دنبال کنید و از شما برای استفاده {$_CONF['site_name']} سپاسگزاریم.",
    64 => 'ترجیحات نظر برای',
    65 => 'تلاش کنید مجدد وارد شوید',
    66 => 'ممکن است اعتبارات ورود خود را اشتباه وارد کرده اید. لطفا تلاش کنید مجدد وارد شوید.',
    67 => 'عضو از',
    68 => 'مرا به خاطر داشته باش برای',
    69 => 'چه مدت باید پس از ورود به سیستم به شما یادآوری کنیم؟',
    'cookietimeout_tooltip' => 'This site will remember you are logged in from the device you are currently using regardless of if your account has been logged out automatically due to no activity. Accounts are logged out after being inactive for %s seconds (this is called the "User Session Timeout"). When "Remember Me For" is set for your account it will include the time you select here PLUS the "User Session timeout".',
    70 => "سفارشی کردن طرح بندی و محتوای {$_CONF['site_name']}!",
    71 => "یکی از ویژگی های عالی {$_CONF['site_name']} این است که می توانید سفارشی سازید محتوایی را که دریافت می کنید و می توانید طرح کلی این سایت را تغییر دهید. برای استفاده از مزیت این ویژگی های عالی ابتدا باید <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">ثبت نام کنید</a> with {$_CONF['site_name']}. آیا از قبل عضو می باشید؟ سپس از فرم ورود در سمت چپ برای ورود استفاده کنید!",
    72 => 'زمینه',
    73 => 'زبان',
    74 => 'تغییر آنچه این سایت به نظر می رسد!',
    75 => 'موضوعات ایمیل شده برای',
    76 => 'اگر یک موضوع را از فهرست زیر انتخاب کنید هر مقاله جدید پست شده به همان موضوع را در پایان هر روز دریافت خواهید کرد. فقط موضوعاتی را که علاقه دارید انتخاب کنید!',
    77 => 'عکس',
    78 => 'یک تصویر از خودتان بیافزایید!',
    79 => 'برای حذف این تصویر اینجا را بررسی کنید',
    80 => 'ورود',
    81 => 'ارسال ایمیل',
    82 => 'آخرین ۱۰ مقاله برای کاربر',
    83 => 'ارسال آمار برای کاربر',
    84 => 'تعداد کل مقالات:',
    85 => 'تعداد کل نظرات:',
    86 => 'یافتن همه ارسال ها توسط',
    87 => 'نام ورود شما',
    88 => "کسی (احتمالا شما) یک رمز جدید برای حساب شما \"%s\" در {$_CONF['site_name']} درخواست کرده است، <{$_CONF['site_url']}> \n\nاگر واقعا می‌خواهید این اقدام عملی شود، لطفا روی پیوند زیر کلیک کنید:\n\n",
    'user_password_action_msg' => 'If you really want this action to be taken, please click on the following link:',
    89 => "اگر نمی خواهید این اقدام عملی شود، بسادگی این پیام را نادیده بگیرید و درخواست چشم پوشی خواهد شد (رمز عبور شما بدون تغییر باقی خواهد ماند).\n\n",
    90 => 'می توانید یک رمز عبور جدید برای حساب کاربری خود وارد کنید. لطفا توجه داشته باشید که رمز عبور قدیمی شما هنوز تا هنگامی که این فرم را ارسال می کنید معتبر است.',
    91 => 'رمز عبور جدید را تنظیم کنید',
    92 => 'رمز عبور جدید را وارد کنید',
    93 => 'آخرین درخواست شما برای رمز عبور جدید %d ثانیه قبل بود. این سایت حداقل %d ثانیه بین درخواست های رمز عبور نیاز دارد.',
    94 => 'حذف حساب کاربری "%s"',
    96 => 'حذف حساب کاربری',
    97 => 'تأیید حذف حساب کاربری',
    98 => 'آیا مطمئن هستید که می خواهید حساب کاربری خود را حذف کنید؟ با انجام این کار، قادر به ورود مجدد به این سایت نخواهید بود (مگر اینکه یک حساب جدید ایجاد کنید). اگر مطمئن می باشید، روی فرم زیر مجدد روی "حذف حساب" کلیک کنید.',
    99 => 'گزینه های حریم خصوصی برای',
    100 => 'ایمیل از مدیر',
    101 => 'اجازه ایمیل از مدیران سایت',
    102 => 'ایمیل از کاربران',
    103 => 'اجازه ایمیل از کاربران دیگر',
    104 => 'نمایش وضعیت آنلاین',
    105 => 'نمایش در بلوک چه کسی آنلاین است',
    106 => 'موقعیت',
    107 => 'نمایش داده شده در مشخصات عمومی شما',
    108 => 'رمز عبور جدید را تأیید کنید',
    109 => 'رمز عبور جدید را مجدد اینجا وارد کنید',
    110 => 'رمز عبور فعلی',
    111 => 'لطفا رمز عبور فعلی خود را وارد کنید',
    112 => 'فراتر از تعداد تلاش های ورود مجاز رفته اید. لطفا بعدا مجدد امتحان کنید.',
    113 => 'تلاش برای ورود انجام نشد',
    114 => 'حساب کاربری غیرفعال شد',
    115 => 'حساب کاربری شما غیرفعال شده است، ممکن است نتوانید وارد شوید. لطفا با یک مدیر تماس بگیرید.',
    116 => 'حساب کاربری در انتظار فعالسازی',
    117 => 'حساب کاربری شما در حال حاضر در انتظار فعال شدن توسط یک مدیر است. تا هنگامی که حساب کاربری شما تأیید نشده باشد قادر به ورود نخواهید بود.',
    118 => '',
    119 => '',
    120 => 'حساب کاربری فعال شده',
    121 => 'سرویس',
    122 => 'با عرض پوزش، ثبت نام کاربر جدید غیرفعال است',
    123 => "آیا شما یک <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">کاربر جدید می باشید</a>?",
    124 => 'تأیید ایمیل',
    125 => 'باید نشانی ایمیل یکسان در هر دو رشته وارد کنید!',
    126 => 'لطفا برای تایید تکرار کنید. هنگامی که نشانی ایمیل خود را بروز می کنید، یک ایمیل با یک پیوند تأیید به نشانی جدید ارسال خواهد شد که نیاز خواهد داشت قبل از تغییر نشانی ایمیل این حساب کاربری که تغییر خواهد کرد، روی آن کلیک شود.',
    127 => 'برای تغییر هر یک از این تنظیمات، باید رمز عبور فعلی خود را وارد کنید. (فقط حساب های غیر از راه دور)',
    128 => 'اسم شما',
    129 => 'رمز عبور و ایمیل',
    130 => 'درباره شما',
    131 => 'گزینه های خلاصه روزانه',
    132 => 'ویژگی خلاصه روزانه',
    133 => 'نمایش نظر',
    134 => 'گزینه های نظر',
    135 => '<li>حالت پیشفرض برای چگونه نظرات نمایش داده خواهد شد</li><li>ترتیب پیشفرض برای نمایش نظرات</li><li>حداکثر تعداد نظرات را برای نشان دادن تنظیم کنید - پیشفرض ۱۰۰ است</li>',
    138 => 'تنظیمات متفرقه',
    139 => 'طرح بندی و زبان',
    140 => '<li>بدون نقشک های موضوع اگر علامت زده شود نقشک های موضوع مقاله را نمایش نخواهد داد</li><li>بدون جعبه ها اگر علامت زده شود فقط فهرست مدیر، فهرست کاربر و موضوعات را نمایش خواهد داد</li><li>تنظیم حداکثر تعداد مقالات برای نمایش در هر صفحه</li><li>تنظیم زمینه، منطقه زمانی و قالب تاریخ مورد نظر خود</li>',
    141 => 'تنظیمات حریم خصوصی',
    142 => 'تنظیم پیشفرض این است که به کاربران و مدیران اجازه می دهد تا ایمیل به اعضای دیگر سایت ارسال کنند و وضعیت شما را به صورت آنلاین نشان می دهد. برای محافظت از حریم شخصی خود علامت این گزینه ها را بردارید.',
    145 => 'مشخصات عمومی شما',
    146 => 'رمز عبور و ایمیل',
    147 => 'رشته های رمز عبور فقط برای حساب های غیر از راه دور. رمز عبور حساب کاربری، ایمیل و ویژگی ورود خودکارتان را ویرایش کنید. شما نیاز خواهید داشت رمز عبور یکسان یا نشانی ایمیل را دو بار بعنوان یک تاییدیه وارد کنید.',
    148 => 'اطلاعات کاربر',
    149 => 'اطلاعات کاربری خود را تغییر دهید که به سایر کاربران نشان داده می شود.<ul><li>امضا به هر نظر یا پست انجمن که ایجاد کردید افزوده خواهد شد</li><li>BIO یک ارائه ای مختصر از خودتان برای به اشتراک گذاشتن است</li><li>اشتراک کلید پی جی پی خود</li></ul>',
    150 => '',
    156 => 'حذف حساب کاربری',
    157 => 'گزینه حذف',
    158 => 'منطقه زمانی',
    160 => '(حداکثر. %d x %d پیکسل, %d بایت; %s)',
    161 => 'مقیاس کاهش خواهد یافت',
    162 => 'مقیاس نخواهد شد',
    163 => 'تأیید اعتبار مجدد ناموفق بود',
    164 => 'فراتر از تعداد تلاش های مجاز برای تأیید هویت مجدد رفته اید. عملیات قطع شده و تغییرات اخیر شما گم شده است، متاسفم.',
    165 => 'استفاده از ویرایشگر پیشرفته',
    166 => 'همگام سازی مجدد حساب از راه دور',
    167 => 'ورود از راه دور',
    168 => 'همچنین می توانید با یکی از خدمات تأیید اعتبار از راه دور در زیر وارد شوید.',
    169 => 'کاربر مشخصات خود را به روز کرده است',
    170 => "مدیر در {$_CONF['site_name']} رمز عبور حساب کاربری شما را به صورت زیر تغییر داد. لطفا این ایمیل را برای مرجع بیشتر ذخیره کنید.",
    171 => 'Post mode for the "Signature" and "Bio" below',
    'user_login' => 'ورود کاربر',
    'user_login_message' => 'لطفا وارد شوید. شما باید نام کاربری و رمز عبور را وارد کنید.',
    'user_remote_login_desc_long' => 'Click on one of the button(s) below to login and/or register via an account you have on another supported remote service. Please note, you must have an account on the remote service. If you are creating a new account on this website, then the remote service may ask you to give this website permissions to access information like your name, email address, and profile photo.',
    'remote_register_instructions' => "<strong>Please note:</strong> To register and create an account via Remote Login, please visit the <a href=\"{$_CONF['site_url']}/users.php\" rel=\"nofollow\">User Login</a>.",
    'user_logged_in_message' => "شما از قبل وارد سیستم شدید. آیا مایلید به <a href=\"{$_CONF['site_url']}/users.php?mode=logout\" rel=\"nofollow\">خروج</a>?",
    'user_max_login_attempts' => 'حداکثر تلاش های ورود و محدودیت سرعت رسیده',
    'tfa_two_factor_auth' => 'دو عامل تأیید هویت',
    'tfa_help1' => 'قبل از اینکه دو عامل تأیید هویت را فعال کنید، مطمئن شوید که برنامه "Google Authenticator" را روی دستگاه تلفن همراه خود نصب می کنید.',
    'tfa_help2' => '.فعال کردن دو عامل تأیید هویت',
    'tfa_help3' => '"Google Authenticator" را اجرا کنید، روی نقشک plus کلیک کنید و کد QR را اسکن کنید.',
    'tfa_help4' => 'کد های پشتیبان را در زیر چاپ یا بارگیری کنید در صورتی که نمی توانید از دستگاه تلفن همراه خود که Google Authenticator را نصب کردید استفاده کنید. هر کد پشتیبان فقط یکبار معتبر است. اگر یک مجموعه جدید از کد های پشتیبان را تولید می کنید، سپس مجموعه فعلی نامعتبر خواهد بود.',
    'tfa_help5' => 'دکمه ذخیره را در پایین صفحه فشار دهید.',
    'tfa_enter_code' => 'کد %d-digit که برنامه Google Authenticator شما نشان می دهد یا یکی از کد پشتیبان در صفحه ترجیحات خود که در اختیار دارید را وارد کنید.',
    'tfa_backup_code_desc' => 'توجه: شما فقط یکبار می‌توانید کد پشتیبان را استفاده کنید، سپس نامعتبر می شود. به خاطر داشته باشید کد های پشتیبان بیشتر را از صفحه ترجیحات کاربر تولید کنید اگر در حال کمبود می باشید.',
    'tfa_code' => 'کد تصدیق کننده گوگل',
    'tfa_authenticate' => 'تصدیق کردن',
    'tfa_qrcode' => 'QR کد',
    'tfa_show_hide' => 'نمایش/پنهان',
    'tfa_backup_code' => 'کد های پشتیبان',
    'tfa_download' => 'بارگیری کد های پشتیبان',
    'tfa_new_backup_code' => 'ایجاد مجموعه ای جدید از کد های پشتیبان',
    'tfa_generate_confirm' => 'شروع؟',
    'lang_tfa_user_edit_desc' => 'شما فقط در صورت نیاز مجاز به غیرفعال کردن دو عامل تأیید هویت (2FA) از این فرم می باشید (مانند کاربر کد های پشتیبان خود را ندارد). این نباید توسط مدیران فعال شود زیرا کاربر برای فعال کردن و راه اندازی 2FA از حساب خود، از جمله برنامه Google Authenticator برای تلفن خود و نسخه برداری از کد های پشتیبان، نیاز دارد.',
    'desc_new_pwd_status' => 'شما نیاز دارید یک رمز عبور جدید برای حساب کاربری خود وارد کنید. شما می توانید یک رمز عبور جدید برای حساب کاربری خود وارد کنید. <em>لطفا توجه داشته باشید شما قادر نخواهید بود هیچ کاری با حساب کاربری خود انجام دهید تا هنگامی که رمز عبور شما بروزرسانی شده باشد.</em>',
    'new_email' => 'ایمیل جدید',
    'set_new_email' => 'تنظیم ایمیل جدید',
    'confirm_new_email' => 'تأیید ایمیل جدید',
    'enter_new_email' => 'وارد کردن ایمیل جدید',
    'desc_new_email_status' => 'شما نیاز دارید یک نشانی ایمیل جدید برای حساب کاربری خود وارد کنید. شما می توانید یک ایمیل جدید برای حساب کاربری خود وارد کنید. <em>لطفا توجه داشته باشید شما قادر نخواهید بود هیچ کاری با حساب کاربری خود انجام دهید تا هنگامی که ایمیل شما بروزرسانی و تأیید شده باشد.</em>',
    'email_msg_email_status_1' => "شما نشانی ایمیل خود را برای حساب کاربری خود بروز کرده اید \"%s\" در {$_CONF['site_name']}، <{$_CONF['site_url']}>.\n\nبرای تأیید این نشانی ایمیل، لطفا روی پیوند زیر کلیک کنید:\n\n",
    'email_msg_verify' => 'Please click on the following link to verify this email address:',
    'email_msg_email_status_2' => "اگر این نشانی ایمیل را تأیید نکنید و به حساب کاربری خود وارد شوید نیاز خواهید داشت یک نشانی ایمیل جدید وارد کنید و مجدد از طریق این روند تأیید ایمیل بروید.\n\n",
    'email_verify' => 'ایمیل جدید برای تأیید',
    'email_verify_delete' => 'حذف ایمیل برای تأیید',
    'email_verify_msg' => "شما از قبل نشانی ایمیل خود را برای حساب کاربری خود بروزرسانی کرده اید اما هنوز نیاز دارد تأیید شود. لطفا ایمیل حساب خود را برای یک ایمیل از {$_CONF['site_name']} که شامل یک پیوند تأیید است را بررسی کنید. یکبار که روی آن پیوند کلیک می کنید نشانی ایمیل جدید شما تأیید خواهد شد و حساب کاربری شما برای استفاده از آن بروزرسانی خواهد شد.<br" . XHTML . "><br" . XHTML . ">اگر مایلید می توانید ایمیل جدید را بروزرسانی کنید تا با رشته‌ های ایمیل بالا تایید شود یا می توانید آن را حذف کنید.",
    'remove_account_msg' => 'برای برداشتن حساب خود از پایگاه داده ما، رمز عبور فعلی خود را در "رمز عبور فعلی" بالا وارد کنید، جعبه کنار "گزینه حذف" را در زیر بررسی کنید و روی "ذخیره" کلیک کنید. لطفا توجه داشته باشید که هر گونه مقالات و نظراتی که تحت این حساب کاربری ارسال کردید حذف <strong>نخواهند</strong> شد، اما نشان می دهد که توسط "ناشناس" پست شده است.',
    'remove_remote_account_msg' => 'برای برداشتن حساب از راه دور خود از پایگاه داده ما، جعبه کنار "گزینه حذف" را در زیر بررسی کنید و روی "ذخیره" کلیک کنید. لطفا توجه داشته باشید که هر گونه مقالات و نظراتی که تحت این حساب کاربری ارسال کردید حذف <strong>نخواهند</strong> شد، اما نشان می دهد که توسط "ناشناس" پست شده است.',
    'theme_info' => '%1$s %2$s (requires Geeklog %3$s)'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'پیش نمایش',
    'pe_namepass' => 'نام کاربری و رمز عبور',
    'pe_userinfo' => 'درباره شما',
    'pe_layout' => 'طرح بندی و زبان',
    'pe_content' => 'محتوا',
    'pe_privacy' => 'حریم خصوصی'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'بدون مقالات برای نمایش',
    2 => 'هیچ مقالاتی برای نمایش در این موضوع وجود ندارد.',
    3 => '',
    4 => 'مقاله ویژه امروز',
    5 => 'بعدی',
    6 => 'قبلی',
    7 => 'اولین',
    8 => 'آخرین',
    9 => 'Page navigation'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'در هنگام فرستادن پیام شما خطایی پیش آمد. لطفا مجدد تلاش کنید.',
    2 => 'پیام با موفقیت ارسال شد.',
    3 => 'لطفا مطمئن شوید که در رشته نشانی ایمیل شما از یک نشانی ایمیل معتبر استفاده می کنید.',
    4 => 'لطفا رشته های نام شما, نشانی ایمیل شما, موضوع و پیام را پر کنید',
    5 => 'خطا: بدون چنین کاربر.',
    6 => 'یک خطا وجود داشت.',
    7 => 'مشخصات کاربر برای',
    8 => 'نام کاربری',
    9 => 'نشانی اینترنتی کاربر',
    10 => 'ارسال نامه به',
    11 => 'اسم شما:',
    12 => 'نشانی ایمیل شما',
    13 => 'موضوع:',
    14 => 'پیام:',
    15 => 'HTML ترجمه نخواهد شد.',
    16 => 'فرستادن پیام',
    17 => 'ارسال مقاله به یک دوست توسط ایمیل',
    18 => 'به نام',
    19 => 'به نشانی ایمیل',
    20 => 'از نام',
    21 => 'از نشانی ایمیل',
    22 => 'همه رشته ها نیاز است',
    23 => "این ایمیل به شما فرستاده شد توسط %s در %s زیرا فکر کردند ممکن است در این مقاله علاقه مند باشید از جانب {$_CONF['site_url']}. این هرزنامه نمی باشد و نشانی های ایمیل مربوط به این تراکنش در یک فهرست و اندوخته شده برای استفاده بعدی ذخیره نشده است.",
    24 => 'نظر برای این مقاله در',
    25 => 'برای استفاده از این ویژگی باید وارد شوید. با ورود به سیستم، به ما کمک می کند تا از سوء استفاده از سیستم جلوگیری کنیم',
    26 => 'این فرم به شما اجازه می دهد تا یک ایمیل به کاربر انتخابی ارسال کنید. همه رشته ها نیاز است.',
    27 => 'پیام کوتاه',
    28 => '%s :نوشت ',
    29 => "این خلاصه روزانه از {$_CONF['site_name']} برای ",
    30 => ' خبرنامه روزانه برای ',
    31 => 'عنوان',
    32 => 'تاریخ',
    33 => 'مقاله کامل را بخوانید در',
    34 => 'پایان پیام',
    35 => 'با عرض پوزش، این کاربر ترجیح می دهد که هیچ ایمیلی دریافت نکند.',
    36 => 'نسخه:',
    37 => 'یک نسخه از این ایمیل برایم ارسال کن',
    38 => "این یک نسخه از ایمیل است که ارسال کردید به %s از جانب <{$_CONF['site_url']}>:",
    39 => 'آخرین پیام شما بود ',
    40 => " چند ثانیه قبل. این سایت حداقل نیاز دارد {$_CONF['speedlimit']} ثانیه بین ارسال پیام ها",
    41 => 'این کاربر وجود ندارد.',
    42 => 'این نشانی ایمیل کاربر موجود نمی باشد. این به احتمال زیاد به این معنی است که یک حساب کاربری OAuth است.',
    43 => 'این نشانی ایمیل کاربر نامعتبر است.',
    44 => 'این وضعیت کاربران به چیزی غیر از فعال یا رمز عبور جدید تنظیم شده و بنابراین نشانی ایمیل بد فرض شده.',
    45 => "This is a message sent from {$_CONF['site_name']} by %s. Any replies will need to be sent to the email address: %s",
    46 => "To unsubscribe from the Daily Digest, login to {$_CONF['site_name']} at {$_CONF['site_url']}. Then visit the user settings page at {$_CONF['site_url']}/usersettings.php and view the Content Tab. You can then unsubscribe to the Daily Digest by deselecting all topics and saving your profile."
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'جستجوی پیشرفته',
    2 => 'کلید واژه ها',
    3 => 'موضوع',
    4 => 'همه',
    5 => 'نوع',
    6 => 'مقالات',
    7 => 'نظرات',
    8 => 'نویسندگان',
    9 => 'همه',
    10 => 'جستجو',
    11 => 'نتایج جستجو',
    12 => 'تطابقات',
    13 => 'نتایج جستجو: حاصل نشد',
    14 => 'رای جستجوی شما هیچ تطابقی وجود نداشت',
    15 => 'لطفا مجدد تلاش کنید.',
    16 => 'عنوان',
    17 => 'تاریخ',
    18 => 'نویسنده',
    19 => "جستجو {$_CONF['site_name']} از جمله مقالات، نظرات و سایر صفحات اطلاعاتی",
    20 => 'تاریخ',
    21 => 'به',
    22 => '(قالب تاریخ YYYY-MM-DD)',
    23 => 'مشاهدات',
    24 => 'مورد %d یافت شد',
    25 => 'جستجو شد برای',
    26 => 'موارد ',
    27 => 'ثانیه',
    28 => 'هیچ مقاله یا نظر برای جستجوی شما مطابقت ندارد',
    29 => 'نتایج مقاله و نظر',
    30 => '',
    31 => 'این افزونه هیچ تطابقی بازگشت نداد',
    32 => '',
    33 => 'نشانی اینترنتی',
    34 => 'موقعیت',
    35 => 'تمام روز',
    36 => 'نوع کلمه کلیدی',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'رشته جستار شما باید حداقل ۳ حرف داشته باشد.',
    42 => 'لطفا از یک تاریخ قالب بندی شده استفاده کنید به صورت YYYY-MM-DD (سال-ماه-روز).',
    43 => 'عبارت دقیق',
    44 => 'همه این کلمات',
    45 => 'هر یک از این کلمات',
    46 => 'بعدی',
    47 => 'قبلی',
    48 => 'نویسنده',
    49 => 'تاریخ',
    50 => 'بازدید',
    51 => '',
    52 => 'موقعیت',
    53 => 'نتایج مقاله',
    54 => 'نتایج نظر',
    55 => 'عبارت',
    56 => 'و',
    57 => 'یا',
    58 => 'نتایج بیشتر &gt;&gt;',
    59 => 'نتایج',
    60 => 'هر صفحه',
    61 => 'محدود کردن جستجو',
    62 => '#',
    63 => 'شرح',
    64 => 'نمایش %1$d - %2$d از %3$d نتایج',
    65 => 'مقاله',
    66 => 'اظهار نظر',
    67 => 'نمایش %d نتایج',
    68 => 'مرتب سازی بر اساس',
    69 => 'فقط عناوین',
    70 => 'در دسترس نمی باشد ...',
    71 => 'صعودی',
    72 => 'نزولی',
    73 => 'ارسال',
    74 => 'محدود کردن نتایج'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'آمار سایت',
    2 => 'مجموع بازدید به سیستم',
    3 => 'مقالات (نظرات) در سیستم',
    4 => 'Site Statistic',
    5 => "Overall Site Statistics for {$_CONF['site_name']}",
    6 => '',
    7 => 'ده مقاله برتر دیده شده',
    8 => 'عنوان مقاله',
    9 => 'مشاهدات',
    10 => 'به نظر می رسد که هیچ مقاله ای در این سایت وجود ندارد یا هیچکس آنها را همواره ندیده است.',
    11 => 'ده مقاله برتر نظر داده شده',
    12 => 'نظرات',
    13 => 'به نظر می رسد که هیچ مقاله ای در این سایت وجود ندارد یا هیچکس همواره یک نظر هم درباره آنها نداشته است.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'ده مقاله برتر ایمیل زده شده',
    23 => 'ایمیل ها',
    24 => 'به نظر می رسد که هیچکس یک مقاله در این سایت ایمیل نکرده است',
    25 => 'ده مقاله برتر نظر داده شده دنبالک',
    26 => 'هیچ نظر دنبالک یافت نشد.',
    27 => 'تعداد کاربران فعال',
    28 => '',
    29 => '',
    30 => 'بازدید',
    31 => '',
    32 => 'Top Ten Liked Articles',
    33 => 'No liked articles found.'
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'آنچه مرتبط است',
    2 => 'ارسال مقاله به یک دوست توسط ایمیل',
    3 => 'قالب مقاله چاپی',
    4 => 'گزینه های مقاله',
    5 => '',
    6 => 'اشتراک در \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'برای ارسال یک %s نیاز است که به عنوان یک کاربر وارد سیستم شوید.',
    2 => 'ورود',
    3 => 'کاربر جدید',
    4 => '',
    5 => '',
    6 => 'ارسال یک مقاله',
    7 => 'ورود نیاز است',
    8 => 'ارسال',
    9 => 'هنگام ارسال اطلاعات برای استفاده در این سایت از شما خواهش می کنیم از پیشنهادات زیر پیروی کنید...<ul><li>همه رشته ها را پر کنید، آنها نیاز می باشند</li><li>اطلاعات کامل و دقیق ارائه دهید</li><li>دو بار این نشانی های اینترنتی را بررسی کنید</li></ul>',
    10 => 'عنوان',
    11 => '',
    12 => 'تاریخ شروع',
    13 => 'تاریخ پایان',
    14 => 'موقعیت',
    15 => 'شرح',
    16 => '',
    17 => '',
    18 => '',
    19 => 'اول خواندن',
    20 => '',
    21 => '',
    22 => 'خطا: رشته های گم شده',
    23 => 'لطفا همه رشته های فرم را پر کنید. همه رشته ها نیاز است.',
    24 => 'ارسالی ذخیره شد',
    25 => 'شما %s ارسال با موفقیت ذخیره شد.',
    26 => 'محدودیت سرعت',
    27 => 'نام کاربری',
    28 => 'موضوع',
    29 => 'مقاله',
    30 => 'آخرین ارسال شما بود ',
    31 => " چند ثانیه قبل. این سایت حداقل نیاز دارد {$_CONF['speedlimit']} ثانیه بین ارسال ها",
    32 => 'پیش نمایش',
    33 => 'پیش نمایش مقاله',
    34 => 'خروج',
    35 => 'برچسب های HTML مجاز نمی باشند',
    36 => 'حالت پست',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'خط نشانی ۱',
    45 => 'خط نشانی ۲',
    46 => 'شهر/شهرک',
    47 => 'استان',
    48 => 'کد پستی',
    49 => '',
    50 => '',
    51 => 'موقعیت',
    52 => 'حذف',
    53 => 'ایجاد حساب کاربری',
    54 => 'مقدمه مقاله',
    55 => 'بدنه مقاله'
);

###############################################################################
# LIKES feature since Geeklog 2.2.1

$LANG_LIKES = array(
    'like' => 'Like',
    'unlike' => 'Unlike',
    'dislike' => 'Dislike',
    'undislike' => 'Undislike',
    'likes' => 'Likes',
    'unlikes' => 'Unlikes',
    'dislikes' => 'Dislikes',
    'undislikes' => 'Undislikes',
    'i_like_this' => 'I like this',
    'i_dislike_this' => 'I dislike this',
    'thanks_for_action' => 'Thanks for voting!',
    'likes_speedlimit' => 'You last used the Likes system on an item %s seconds ago. This site requires at least %s seconds between using the Likes system',
    'likes_ip_error' => 'Your IP address has already performed this Likes action.',
    'likes_uid_error' => 'Your User account has already performed this Likes action.',
    'own_item_error' => 'Either you own the item or do not have permission to Like/Dislike it.',
    'liked_by' => 'Liked by:',
    'disliked_by' => 'Disliked by:',
    'num_anon_users' => '<br' . XHTML . '>%s Anonymous Users',
    'one_anon_users' => '<br' . XHTML . '>1 Anonymous User',
    'num_more_users' => '<br' . XHTML . '>+%s more Users',
    'username_in_likes_list' => '<br' . XHTML . '>%s',
    'autotag_desc_likes_block' => "[likes_block:aid action:aid wrapper:wid class:likes-autotag type: subtype: time:604800 max:10 cache:3600 line:1 length:20]
\n	- Displays the Likes block. No attributes are required. If attribute not specified then default in configuration used. 
\n	- action = 1 (likes only), 2 (dislikes only), or 3 (both) 
\n	- wrapper = 0 (no wrapper), 1 (block wrapper with title), div wrapper with css class), or both
\n	- class = Specifies the css class used by the div wrapper if enabled else default likes-autotag will be used 
\n	- type = Either empty (for all types) or include 1 supported like type. For example 'article' or 'comment'
\n	- subtype = Specify a sub type of type if needed
\n	- time = Display items that are this many seconds old. 0 will display all items
\n	- max = Maximum number of items to display
\n	- cache = Cached for no longer than this many seconds. If 0 caching is disabled
\n	- line = Display likes icons on new line
\n	- length = Trim item title length to this many characters",
    'num_likes_in_time_limit' => 'The last number of Likes this item received within the time specified.',
    'num_dislikes_in_time_limit' => 'The last number of Dislikes this item received within the time specified.',
    'num_likes_total' => 'The total number of Likes this item has received.',
    'num_dislikes_total' => 'The total number of Dislikes this item has received.',
    'likes_time_span' => 'Most Likes in the last %t %s',
    'dislikes_time_span' => 'Most Dislikes in the last %t %s',
    'all_time_span' => 'Most engaging in the last %t %s',
    'whats_liked' => 'Whats Liked',
    'whats_recently_liked' => 'Whats Recently Liked',
    'whats_disliked' => 'Whats Disliked',
    'whats_recently_disliked' => 'Whats Recently Disliked',
    'whats_popular' => 'Whats Popular',
    'whats_recently_popular' => 'Whats Recently Popular',
    'whats_liked_type' => 'Liked %s',
    'whats_recently_liked_type' => 'Recently Liked %s',
    'whats_disliked_type' => 'Disliked %s',
    'whats_recently_disliked_type' => 'Recently Disliked %s',
    'whats_popular_type' => 'Popular %s',
    'whats_recently_popular_type' => 'Recently Popular %s',
    'no_liked_items_in_time_limit' => 'There have been no Likes during the time specified.',
    'no_disliked_items_in_time_limit' => 'There have been no Dislikes during the time specified.',
    'no_action_items_in_time_limit' => 'There have been no Likes or Dislikes during the time specified.',
    'no_liked_items' => 'There are no Liked items.',
    'no_disliked_items' => 'There are no Disliked items.',
    'no_action_items' => 'There are no Liked or Disliked items.',
    'last_num_likes_by' => 'Last %s Likes and Dislikes by %s',
    'msg_no_likes' => 'No likes or dislikes found by user.',
    'total_num_likes' => 'Total number of likes and dislikes:',
    'title_liked' => '%s Liked on ',
    'title_disliked' => '%s Disliked on ',
    'articles' => 'Articles',
    'comments' => 'Comments'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/logviewer.php

$LANG_LOGVIEW = array(
    'log_viewer' => 'نمایشگر لاگ',
    'info' => 'مدیریت پرونده لاگ گیکلاگ.',
    'logs' => 'لاگ ها',
    'view' => 'دیدن پرونده لاگ',
    'clear' => 'پاکسازی پرونده لاگ',
    'log_file' => 'پرونده لاگ'
);

###############################################################################
# admin/envcheck.php - distribution integrity checker

$LANG_ENVCHECK = array(
    'correct_perms' => 'لطفا مسائل شناسایی شده در زیر را اصلاح کنید. یکبار پس از آنکه اصلاح شده اند، از دکمه <b>بازرسی</b> برای تأیید صحت محیط استفاده کنید.',
    'current' => 'فعلی',
    'current_php_settings' => 'تنظیمات فعلی پی اچ پی',
    'directory_permissions' => 'مجوز های پوشه',
    'enabled' => 'فعال شده',
    'env_check' => 'بررسی محیط',
    'file_permissions' => 'مجوز های پرونده',
    'file_uploads' => 'بسیاری از ویژگی های گیکلاگ نیاز به بارگذاری پرونده ها دارند، این باید فعال شود.',
    'filesystem_check' => 'پوشه / مجوز های پرونده',
    'gd_lib' => 'GD کتابخانه های',
    'gd_not_found' => 'ناتوان در یافت توابع کتابخانه GD. لطفا مطمئن شوید که کتابخانه های GD در پی اچ پی کامپایل شدند یا یک کتابخانه گرافیکی جایگزین را انتخاب کنید.',
    'gd_ok' => 'GD Libraries v2 نصب شده است.',
    'gd_v1' => 'GD Libraries v1 نصب شده است - این نسخه به صورت کامل از پردازش تصویر JPG پشتیبانی نمی کند، بنابراین ممکن است برخی از مسائل کیفیت وجود داشته باشد.',
    'graphics' => 'کتابخانه گرافیک',
    'libraries' => 'کتابخانه ها',
    'hosting_env' => 'بررسی محیط میزبانی',
    'imagemagick' => 'ImageMagick برنامه های',
    'im_not_found' => 'قادر به یافت اجرایی <strong>تبدیل</strong> برای ImageMagick نمی باشد.',
    'im_ok' => 'اجرایی <strong>تبدیل</strong> معتبر به نظر می رسد.',
    'memory_limit' => 'توصیه می شود حداقل ۴۸ مگابایت حافظه فعال شده در سایت خود داشته باشید.',
    'not_writable' => 'نوشتنی نمی باشد',
    'notes' => 'یادداشت ها',
    'not_found' => 'یافت نشد',
    'netpbm' => 'NetPBM کتابخانه',
    'np_ok' => 'کتابخانه NetPBM نصب شده',
    'np_not_found' => 'اجرایی های NetPBM یافت نشدند.',
    'fileinfo_library' => 'Fileinfo کتابخانه',
    'fileinfo_ok' => 'کتابخانه Fileinfo بارکنش شده است. این کتابخانه هنگام بارگذاری تصاویر برای مقالات نیاز است. برای دریافت نوع MIME پرونده در حال بارگذاری شدن در هنگام ایجاد یک ریز عکس از تصویر استفاده شده است.',
    'fileinfo_not_found' => 'کتابخانه Fileinfo بارکنش نشده است. این <strong>فقط</strong> در هنگام بارگذاری تصاویر در ویرایشگر مقاله نیاز است.',
    'openssl_library' => 'OpenSSL کتابخانه',
    'openssl_ok' => 'کتابخانه OpenSSL بارکنش شده است. این کتابخانه نیاز است اگر مایل به استفاده از روش ورود کاربر OAuth یا پروتکل SMTPS گیکلاگ برای ارسال ایمیل می باشید.',
    'openssl_not_found' => 'کتابخانه OpenSSL بارکنش نشده است. این نیاز است <strong>فقط</strong> اگر مایل به استفاده از روش ورود کاربر OAuth یا ارسال ایمیل از طریق پروتکل SMTPS با گیکلاگ می باشید.',
    'off' => 'خاموش',
    'ok' => 'باشه',
    'on' => 'روشن',
    'open_basedir' => 'اگر محدودیت های <strong>open_basedir</strong> در سایت شما فعال باشند، ممکن است هنگام نصب موجب مشکلات مجوز شود. بررسی سیستم پرونده زیر باید هر گونه مسائل را بیان کند.',
    'database_settings' => 'تنظیمات پایگاه داده',
    'database_mysql_version' => 'MySQL نسخه',
    'database_mysql_req_version' => 'گیکلاگ به MySQL نسخه ۴.۱.۲ یا جدیدتر نیاز دارد (MySQL ۵ توصیه می شود).',
    'database_pgsql_version' => 'Postgresql نسخه',
    'database_pgsql_req_version' => 'گیکلاگ نیاز به Postgresql نسخه ۹.۱.۷ یا جدیدتر دارد.',
    'database_dms' => 'سیستم مدیریت پایگاه داده',
    'database_dms_notes' => 'ناتوان در تعیین سیستم مدیریت پایگاه داده. گیکلاگ نیاز به MySQL یا Postgresql دارد.',
    'php_req_version' => 'گیکلاگ نیاز به نسخه پی اچ پی ۵.۳.۳ یا جدیدتر دارد.',
    'php_settings' => 'تنظیمات پی اچ پی',
    'php_version' => 'نسخه پی اچ پی',
    'php_warning' => 'اگر هر یک از موارد زیر در رنگ <span class="no">قرمز</span> علامت زده شده باشند، ممکن است با سایت گیکلاگ خود با مشکلاتی مواجه شوید. برای اطلاعات مربوط به تغییر هر کدام از این تنظیمات پی اچ پی را با ارائه دهنده میزبانی اینترنت خود بررسی کنید.',
    'post_max_size' => 'گیکلاگ به شما اجازه می دهد افزونه ها، تصاویر و پرونده ها را بارگذاری کنید. باید حداکثر ۸ مگابایت را برای اندازه پست اجازه دهید.',
    'recheck' => 'بازرسی محیط',
    'recommended' => 'توصیه شده',
    'setting' => 'تنظیمات',
    'unable_mkdir' => 'ناموفق در ایجاد پوشه',
    'upload_max_filesize' => 'گیکلاگ به شما اجازه می دهد افزونه ها، تصاویر و پرونده ها را بارگذاری کنید. باید حداقل ۸ مگابایت را برای اندازه بارگذاری اجازه دهید.',
    'not_checked' => 'پریده',
    'bypass_note' => 'از وقتی که محدودیت های هر یک Safe Mode یا open_basedir شناسایی شدند، بررسی برای کتابخانه های گرافیکی پریدند.',
    'not_used_note' => 'هیچ کتابخانه گرافیکی استفاده شده توسط گیکلاگ تنظیم نشده است.',
    'location' => 'موقعیت',
    'status' => 'وضعیت',
    'item' => 'مورد',
    'jhead' => 'jhead برنامه',
    'jhead_not_found' => 'قادر به یافتن اجرایی jhead نمی باشد.',
    'jhead_ok' => 'اجرایی jhead نصب شده است.',
    'jpegtran' => 'jpegtran برنامه',
    'jpegtran_not_found' => 'قادر به یافتن اجرایی jpegtran نمی باشد.',
    'jpegtran_ok' => 'اجرایی jpegtran نصب شده است.',
    'showhide_phpinfo' => 'نمایش/پنهان کامل اطلاعات پی اچ پی',
    'view_online' => 'اینجا %s برای دیدن آنلاین اینجا کلیک کنید',
    'no_new_items' => 'بدون موارد جدید',
    'max_execution_time' => 'گیکلاگ مقدار پیشفرض پی اچ پی را ۳۰ ثانیه به عنوان حداقلی توصیه می کند اما بارگذاری های افزونه و سایر عملیات ممکن است طولانی تر از این بسته به محیط میزبانی اینترنت شما باشد. اگر safe_mode (در بالا) خاموش است، شما ممکن است قادر به افزایش این با تغییر مقدار <b>max_execution_time</b> در پرونده php.ini خود باشید.',
    'phpinfo_disabled' => 'In order to view the current php settings, you will have to contact your host and enable access to the phpinfo() function.'
);

###############################################################################
# For Demo Mode (since v2.2.1)

$LANG_DEMO = array(
    'header' => 'Header',
    'subject' => 'Subject:',
    'to' => 'To:',
    'from' => 'From:',
    'priority' => 'Priority:',
    'body' => 'Body',
    'notice' => 'Notice',
    'emails_disabled_msg' => 'Please note sending emails is disabled in Demo mode. An email which would have been sent was:'
);

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'تأیید هویت نیاز است',
    2 => 'اطلاعات نادرست ورود، لطفا مجدد امتحان کنید.',
    3 => 'رمز عبور نامعتبر برای کاربر',
    4 => 'نام کاربری:',
    5 => 'رمز عبور:',
    6 => 'تمام دسترسی به بخش های اداری این سایت اینترنتی ضبط و بررسی می شود.<br' . XHTML . '>این صفحه فقط برای استفاده پرسنل مجاز است.',
    7 => 'ورود',
    8 => 'ورود',
    9 => 'This page is for the use of authorized personnel only. Please note all access to administrative portions of this web site are logged and reviewed.'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'کافی نبودن حقوق مدیر',
    2 => 'حقوق لازم برای ویرایش این بلوک را ندارید.',
    3 => 'ویرایشگر بلوک',
    4 => 'یک مشکل در خواندن این خوراک وجود داشت (برای جزئیات error.log را ببینید).',
    5 => 'بله',
    6 => 'خیر',
    7 => 'همه',
    8 => 'سطح امنیتی بلوک',
    9 => 'ترتیب بلوک',
    10 => '',
    11 => 'بلوک درگاه',
    12 => 'بلوک معمولی',
    13 => 'گزینه های بلوک درگاه',
    14 => 'نشانی اینترنتی خوراک',
    15 => 'آخرین بروزرسانی خوراک',
    16 => 'گزینه های بلوک معمولی',
    17 => 'محتوای بلوک',
    18 => 'لطفا رشته های عنوان بلوک و محتوا را وارد کنید',
    19 => 'مدیریت بلوک',
    20 => 'بلوک های منظم',
    21 => 'Block SecLev',
    22 => 'بلوک های پویا',
    23 => 'ترتیب بلوک',
    24 => 'پویا',
    25 => 'برای تغییر یا حذف یک بلوک عادی، روی نقشک ویرایش آن بلوک در زیر کلیک کنید. برای ایجاد یک بلوک عادی جدید، روی "ایجاد جدید" در بالا کلیک کنید. برای حرکت یک بلوک عادی، روی پیکان ها یا جعبه های [R] و [L] کلیک کنید. برای ویرایش بلوک های پویا پیکربندی افزونه که بلوک مربوط به آن است را بررسی کنید.',
    26 => 'بلوک طرح',
    27 => 'بلوک پی اچ پی',
    28 => 'گزینه های بلوک پی اچ پی',
    29 => 'عملکرد بلوک',
    30 => 'اگر مایلید یکی از بلوک های شما از کد پی اچ پی استفاده کند، نام تابع را در بالا وارد کنید. نام تابع شما باید با پیشوند "phpblock_" (e.g. phpblock_getweather) شروع شود. اگر این پیشوند را نداشته باشد، تابع شما فراخوانده نخواهد شد. ما این کار را برای نگه داشتن افرادی که ممکن است نصب گیکلاگ شما را بواسطه قرار دادن فراخوان های تابع خودسرانه که ممکن است برای سیستم شما مضر باشد هک کرده اند. اگر پس از نام تابع شما پرانتز "()" قرار دهید، تابع با دو پارامتر فراخوانده خواهد شد. پارامتر 1 یک آرایه شامل ردیف داده برای این بلوک در جدول gl_blocks خواهد بود. پارامتر 2 یک رشته شامل هر قدر متن است که بین دو پرانتز قرار می دهید. در نهایت، توصیه می‌شود که همه کد بلوک پی اچ پی خود را در /path/to/geeklog/system/lib-custom.php قرار دهید. این اجازه خواهد داد کد با شما باقی بماند حتی هنگامی که به یک نسخه جدیدتر گیکلاگ ارتقا می دهید.',
    31 => 'خطا در بلوک پی اچ پی. تابع، %s، وجود ندارد.',
    32 => 'خطای رشته(های) مفقود',
    33 => 'باید نشانی اینترنتی را به پرونده خوراک سندیکا برای بلوک های درگاه وارد کنید',
    34 => 'باید عنوان و کارکرد را برای بلوک های پی اچ پی وارد کنید',
    35 => 'باید عنوان و محتوا را برای بلوک های عادی وارد کنید',
    36 => 'باید محتوا را برای بلوک های طرح وارد کنید',
    37 => 'نام بد کارکرد بلوک پی اچ پی',
    38 => 'توابع برای بلوک های پی اچ پی باید پیشوند \'phpblock_\' (e.g. phpblock_getweather) داشته باشند. پیشوند \'phpblock_\' به دلایل امنیتی برای جلوگیری از اجرای کد خودسرانه نیاز است.',
    39 => 'پهلو',
    40 => 'چپ',
    41 => 'راست',
    42 => 'باید عنوان بلوک و ترتیب بلوک را برای بلوک های پیشفرض گیکلاگ را وارد کنید.',
    43 => 'فقط صفحه اصلی',
    44 => 'چندگانه',
    45 => "شما در حال تلاش برای دسترسی به یک بلوک می باشید که حق آن را ندارید. این تلاش ضبط شده است. لطفا <a href=\"{$_CONF['site_admin_url']}/block.php\">به صفحه مدیریت بلوک بازگردید</a>.",
    46 => 'حرکت',
    47 => 'هیچ یک',
    48 => 'نام بلوک',
    49 => '(بدون فاصله)',
    50 => 'نام بلوک نمی تواند خالی باشد',
    51 => 'شامل http:// یا https:// اگر پرونده کمک شامل یک نشانی اینترنتی باشد',
    52 => 'اگر این قطعه را خالی بگذارید نقشک کمک برای این بلوک نمایش داده نخواهد شد. اگر فقط یک پرونده HTML را فهرست می کنید (بنابراین پنجره بالاپر می تواند استفاده شود) لطفا مطمئن شوید که پرونده در پوشه public_html/help گیکلاگ تحت زبان صحیح واقع شده است (این ویژگی چندین زبان را پشتیبانی می کند).',
    53 => 'فعال شده',
    54 => 'ذخیره',
    55 => 'لغو',
    56 => 'حذف',
    57 => 'حرکت بلوک به پایین',
    58 => 'حرکت بلوک به بالا',
    59 => 'حرکت بلوک به راست',
    60 => 'حرکت بلوک به چپ',
    61 => 'بدون عنوان',
    62 => 'محدودیت مقاله',
    63 => 'عنوان بد بلوک',
    64 => 'عنوان شما نباید خالی باشد و نمی تواند شامل HTML باشد. همچنین باید یک انتخاب موضوع بسازید.',
    65 => 'ترتیب',
    66 => 'برچسب های خودکار',
    67 => 'بررسی برای اجازه برچسب های خودکار',
    68 => 'خوراک برای این بلوک درگاه برای نمایش بسیار طولانی است. لطفا یک حداکثر تعداد مقالات را برای وارد کردن برای بلوک در صفحه برپایی بلوک یا یک حداکثر سراسری در پیکربندی گیکلاگ تنظیم کنید.',
    69 => 'نام افزونه',
    70 => 'شناسه سی اس اس',
    71 => 'این رشته اختیاری است',
    72 => 'کلاس های سی اس اس',
    73 => 'این رشته اختیاری است. شما می توانید کلاس های مجزا چندگانه را با فاصله مشخص کنید',
    'autotag_desc_block' => '[block:name class:block-autotag] - یک بلوک را نمایش می دهد. کلاس نیاز نمی باشد. کلاس مشخص می کند کلاس سی اس اس را و بلوک را در یک div بسته بندی می کند. کلاس برچسب خودکار بلوک همیشه با div شامل خواهد بود.',
    'newlines' => 'خطوط جدید',
    'convert_newlines' => 'برای تبدیل خطوط جدید (EOL) به عنصر HTML شکست خط علامت بزنید',
    'position' => 'موقعیت',
    'cache_time' => 'زمان حافظه نهان',
    'cache_time_desc' => 'این بلوک برای طولانی تر از این چند ثانیه ذخیره نخواهد شد. اگر 0 باشد ذخیره سازی غیرفعال است اگر -1 باشد ذخیره شده است تا هنگامی که بلوک مجدد ویرایش شود. (۳۶۰۰ = ۱ ساعت، ۸۶۴۰۰ = ۱ روز)',
    'block_type_gldefault' => 'سیستم',
    'block_type_normal' => 'عادی',
    'block_type_phpblock' => 'پی اچ پی',
    'block_type_portal' => 'درگاه',
    'block_type_dynamic' => 'پویا'
);

###############################################################################
# Block Locations

$LANG23 = array(
    'blocks_article_footer_name' => 'پاورقی مقاله',
    'blocks_article_footer_desc' => 'نمایش بلوک ها در پاورقی مقاله',
    'blocks_article_topic_list_name' => 'فهرست موضوع مقاله',
    'blocks_article_topic_list_desc' => 'نمایش بلوک ها بلافاصله پس از هر تعداد X مقالات در موضوعات را نمایش می دهد'
);

###############################################################################
# admin/article.php

$LANG24 = array(
    1 => 'مقالات قبلی',
    2 => 'مقالات بعدی',
    3 => 'حالت',
    4 => 'حالت پست',
    5 => 'ویرایشگر مقاله',
    6 => 'هیچ مقاله ای در سیستم وجود ندارد',
    7 => 'نویسنده',
    8 => 'ذخیره',
    9 => 'پیش نمایش',
    10 => 'لغو',
    11 => 'حذف',
    12 => 'شناسه',
    13 => '',
    14 => '',
    15 => 'تاریخ',
    16 => 'متن معرفی',
    17 => 'متن بدنه',
    18 => 'بازدید',
    19 => 'نظرات',
    20 => 'پینگ',
    21 => 'ارسال پینگ',
    22 => 'فهرست مقالات',
    23 => 'برای تغییر یا حذف یک مقاله، روی نقشک ویرایش آن مقاله در زیر کلیک کنید. برای دیدن یک مقاله، روی عنوان مقاله ای که مایل به دیدن می باشید کلیک کنید. برای ایجاد یک مقاله جدید، روی "ایجاد جدید" در بالا کلیک کنید.',
    24 => 'شناسه ای که برای این مقاله انتخاب کرده اید از قبل در حال استفاده است. لطفا شناسه دیگری استفاده کنید.',
    25 => 'خطا هنگام ذخیره مقاله',
    26 => 'پیش نمایش مقاله',
    27 => '<p>اگر از [unscaledX] بجای [imageX] استفاده کنید، تصویر در ابعاد اصلی آن قرار خواهد گرفت.</p>',
    28 => '<p><b>پیش نمایش:</b> پیش نمایش یک مقاله با تصاویر پیوست شده توسط ذخیره سازی در مقاله به عنوان پیش نویس بجای ضربه زدن به دکمه پیش نمایش بهتر است انجام شود. فقط هنگامی که تصاویر پیوست نشده اند از دکمه پیش نمایش استفاده کنید.</p>',
    29 => 'دنبالک ها',
    30 => 'خطا های بارگذاری پرونده',
    31 => 'لطفا رشته های عنوان و متن معرفی را پر کنید و مطمئن شوید که حداقل یک موضوع انتخاب شده است',
    32 => 'ویژه',
    33 => 'فقط یک مقاله ویژه می تواند وجود داشته باشد',
    34 => 'پیش نویس',
    35 => 'بله',
    36 => 'خیر',
    37 => 'بیشتر توسط',
    38 => 'بیشتر از',
    39 => 'ایمیل ها',
    40 => '',
    41 => "شما در حال تلاش برای دسترسی به یک مقاله می باشید که حق آن را ندارید. این تلاش ضبط شده است. شما می توانید مقاله را به صورت فقط خواندنی در زیر ببینید. لطفا <a href=\"{$_CONF['site_admin_url']}/article.php\">به صفحه مدیریت مقاله بازگردید</a> وقتی کارتان انجام شد.",
    42 => "شما در حال تلاش برای دسترسی به یک مقاله می باشید که حق آن را ندارید. این تلاش ضبط شده است. لطفا <a href=\"{$_CONF['site_admin_url']}/article.php\">به صفحه مدیریت مقاله بازگردید</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>توجه:</b> اگر این تاریخ را به آینده تغییر دهید، این مقاله تا آن تاریخ منتشر نخواهد شد. همچنین به این معنی است که مقاله در عنوان خوراک شما گنجانده نخواهد شد و توسط صفحات جستجو و آمار چشم پوشی خواهد شد.',
    47 => 'تصاویر',
    48 => 'تصویر',
    49 => 'راست',
    50 => 'چپ',
    51 => '<p>برای افزودن یکی از تصاویری که به این مقاله در حال پیوست دادنید نیاز دارید متن قالب بندی شده خاصی را قرار دهید. متن قالب بندی شده خاص [imageX]، [imageX_right] یا [imageX_left] می‌باشد جایی که X تعداد تصاویری است که پیوست کرده اید. توجه: شما باید تصاویری که پیوست می کنید استفاده کنید. در غیر اینصورت قادر به ذخیره مقاله خود نخواهید بود.</p>',
    52 => '',
    53 => 'مورد استفاده قرار نگرفت. قبل از اینکه بتوانید تغییرات خود را ذخیره کنید باید این تصویر را در مقدمه یا بدنه بگنجانید',
    54 => 'تصاویر پیوست شده استفاده نشدند',
    55 => 'خطا های زیر هنگام تلاش برای ذخیره مقاله شما رخ داده اند. لطفا قبل از ذخیره این خطا ها را اصلاح کنید',
    56 => 'نمایش نقشک موضوع',
    57 => 'دیدن تصویر اصلی',
    58 => 'گزینه های بایگانی',
    59 => 'گزینه',
    60 => '',
    61 => 'بایگانی خودکار',
    62 => 'حذف خودکار',
    63 => 'غیرفعال کردن نظرات',
    64 => '',
    65 => '',
    66 => '',
    67 => 'افزایش اندازه ناحیه ویرایش محتوا',
    68 => 'کاهش اندازه ناحیه ویرایش محتوا',
    69 => 'انتشار تاریخ مقاله',
    70 => 'انتخاب نوار پایه ای',
    71 => 'نوار ابزار اصلی',
    72 => 'نوار ابزار متداول',
    73 => 'نوار ابزار پیشرفته',
    74 => 'نوار ابزار پیشرفته ۲',
    75 => 'ویژه کامل',
    76 => 'گزینه های انتشار',
    77 => 'جاوا اسکریپت نیاز دارد برای ویرایشگر پیشرفته فعال شود. گزینه را می توان در پانل مدیریت پیکربندی غیرفعال کرد.',
    78 => 'برای استفاده از ویرایشگر پیشفرض روی <a href="%s/article.php?mode=edit&amp;sid=%s&amp;editopt=default">here</a> اینجا </a> کلیک کنید',
    79 => 'پیش نمایش',
    80 => 'ویرایشگر',
    81 => 'گزینه های انتشار',
    82 => 'تصاویر',
    83 => 'گزینه های بایگانی',
    84 => 'مجوز ها',
    85 => 'نمایش همه',
    86 => 'ویرایشگر پیشرفته',
    87 => 'آمار مقاله',
    88 => 'قالب سبک ویکی',
    89 => 'شرح متا',
    90 => 'کلمه های کلیدی متا',
    91 => 'همیشه می توانید "پیش نمایش" را برای تمدید زمان انقضا ضربه بزنید.',
    92 => 'همچنین ممکن است دوست داشته باشید',
    93 => '#',
    94 => 'تغییر اندازه داده شده',
    95 => 'اصلی',
    96 => 'بارگذاری | جایگزین',
    97 => 'بدون تصویر',
    'autotag_desc_story' => '[story: id alternate title] - یک پیوند به یک مقاله را نمایش می دهد. مانند برچسب خودکار مقاله عمل می کند. لطفا بجای آن از برچسب خودکار مقاله استفاده کنید.',
    'autotag_desc_article' => '[article: id alternate title] - یک پیوند به یک مقاله با استفاده از عنوان مقاله مانند عنوان را نمایش می دهد. عنوان جایگزین ممکن است مشخص شود اما نیاز نمی باشد.',
    'cache_time' => 'زمان حافظه نهان',
    'cache_time_desc' => 'این مقاله برای طولانی تر از این چند ثانیه ذخیره نخواهد شد. اگر 0 باشد ذخیره سازی غیرفعال است اگر -1 باشد ذخیره شده است تا هنگامی که مقاله مجدد ویرایش شود. (۳۶۰۰ = ۱ ساعت، ۸۶۴۰۰ = ۱ روز)'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'ویرایشگر موضوع',
    2 => 'شناسه موضوع',
    3 => 'نام موضوع',
    4 => 'تصویر موضوع',
    5 => '(از فضا استفاده نکنید)',
    6 => 'حذف یک موضوع همه مقالات را حذف می کند، ارسالات و بلوک های مرتبط با آن (تا هنگامی که آنها فقط با آن موضوع حذف شده مرتبط می باشند).',
    7 => 'لطفا رشته های شناسه موضوع و نام موضوع را پر کنید',
    8 => 'مدیریت موضوع',
    9 => 'برای تغییر یا حذف یک موضوع، روی نقشک ویرایش آن موضوع در زیر کلیک کنید. برای ایجاد یک موضوع جدید، روی "ایجاد جدید" در بالا کلیک کنید. ستاره(*) موضوع پیشفرض را نشان می دهد.',
    10 => 'سفارش مرتب سازی',
    11 => 'مقالات/صفحه',
    12 => 'دسترسی ممنوع است',
    13 => "شما در حال تلاش برای دسترسی به یک موضوع می باشید که حق آن را ندارید. این تلاش ضبط شده است. لطفا <a href=\"{$_CONF['site_admin_url']}/topic.php\">به صفحه مدیریت موضوع بازگردید</a>.",
    14 => 'روش مرتب سازی',
    15 => 'الفبایی',
    16 => 'پیشفرض هست',
    17 => 'موضوع جدید',
    18 => 'خانه مدیر',
    19 => 'ذخیره',
    20 => 'لغو',
    21 => 'حذف',
    22 => 'پیشفرض',
    23 => 'در صورت لزوم، این موضوع را پیشفرض برای موارد و ارسالات جدید تعیین کنید',
    24 => '(*)',
    25 => 'موضوع بایگانی',
    26 => 'این موضوع را پیشفرض برای مقالات بایگانی تعیین کنید. فقط یک موضوع مجاز است',
    27 => 'یا بارگذاری نقشک موضوع',
    28 => 'حداکثر',
    29 => 'خطا های بارگذاری پرونده',
    30 => 'مقالات در موضوع',
    31 => 'از یک شناسه موضوع محدود استفاده کرده اید. لطفا یکی دیگر را انتخاب کنید.',
    32 => 'موضوع اصلی',
    33 => 'وارث',
    34 => 'موضوع اصلی همه موارد موروثی را به ارث می برد',
    35 => 'پنهان',
    36 => 'موضوع در بلوک موضوع پنهان خواهد شد تا موضوع اصلی آن انتخاب شود',
    37 => 'ریشه',
    38 => 'همه',
    39 => 'فقط صفحه اصلی',
    40 => 'اختصاص یک یا چند موضوع. ',
    41 => 'اگر "همه" انتخاب شده باشد سپس مورد برای همه موضوعات ظاهر خواهد شد. اگر "فقط صفحه اصلی" انتخاب شده باشد سپس مورد فقط در صفحه اصلی ظاهر خواهد شد. دیگر باید حداقل یک موضوع را انتخاب کنید تا مورد را به آن اختصاص دهید.',
    'topic_control_select_topics' => 'Else you must select at least one topic to assign the item to. ',
    'topic_control_select_topics_disabled' => 'Else you must select at least one topic you have edit access for, to assign the item to (text is darker). ',
    'topic_control_no_topics' => 'Unfortunately you do not have edit access to any topics so none can be selected. ',
    42 => 'وارث شامل فهرستی از موضوعات اختصاص داده شده است. اگر موضوع انتخاب شده باشد سپس مورد توسط موضوع اصلی به ارث برده خواهد شد.',
    43 => 'پیشفرض شامل فهرستی از موضوعات اختصاص داده شده است. این موضوع پیشفرض است که هنگام نمایش مورد استفاده خواهد شد اگر موضوع واقعی که کاربر در آن است یافت نشد.',
    44 => 'وارث',
    45 => 'پیشفرض',
    46 => 'موضوع اصلی شما نمی تواند موضوع بایگانی باشد. لطفا یک موضوع اصلی متفاوت را انتخاب کنید.',
    47 => 'یک موضوع بایگانی نمی تواند موضوعات خرد داشته باشد. لطفا قبل از ایجاد یک موضوع موضوع بایگانی هر موضوع خرد را بردارید.',
    48 => 'شناسه موضوع اصلی یافت نشد.',
    49 => 'این شناسه موضوع از قبل مورد استفاده می باشد. لطفا یکی دیگر را انتخاب کنید.',
    50 => 'بله',
    51 => 'خیر',
    52 => 'مقاله',
    53 => 'تصویر',
    54 => 'منتخب',
    55 => 'معین',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'خانه',
    'autotag_desc_topic' => '[topic:id alternate title] - یک پیوند به یک موضوع با استفاده از شناسه مانند عنوان را نمایش می دهد. یک عنوان جایگزین ممکن است مشخص شود اما نیاز نمی باشد.',
    'autotag_desc_related_topics' => '[related_topics:id type:plugin max:max_items_listed] - یک فهرست افقی قابل کلیک از موضوعات مرتبط بر اساس شناسه و نوع مورد را ایجاد می کند.',
    'autotag_desc_related_items' => '[related_items:id type:plugin max:max_items_listed trim:max_length include:plugin] - ایجاد یک فهرست قابل کلیک از موارد مرتبط بر اساس شناسه و نوع مورد.',
    'no_related_items' => 'هیچ موارد مرتبطی یافت نشد.',
    'topics:' => ':موضوعات',
    'filed_under:' => ':ثبت شده تحت',
    'topic_title' => 'عنوان موضوع',
    'topic_title_desc' => 'استفاده شده به صورت عنوان صفحه برای موضوع. اگر خالی باشد نام موضوع استفاده خواهد شد.',
    'move_topic_up' => 'Move topic up the sort order',
    'move_topic_down' => 'Move topic down in the sort order',
    'topics_edit_access_select' => 'You can only select topics you have Edit access to you (text is darker).',
    'topics_edit_access_listed' => 'Only topics with Edit access are listed.'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'ویرایشگر کاربر',
    2 => 'شناسه کاربر',
    3 => 'نام کاربری',
    4 => 'نام و نام خانوادگی',
    5 => 'رمز عبور',
    6 => 'سطح امنیتی',
    7 => 'نشانی ایمیل',
    8 => 'صفحه نخست',
    9 => '(از فضا استفاده نکنید)',
    10 => 'لطفا نام کاربری و نشانی ایمیل را وارد کنید',
    11 => 'مدیریت کاربر',
    12 => 'برای تغییر یا حذف یک کاربر، روی نقشک ویرایش آن کاربر زیر کلیک کنید. برای دیدن یک کاربر، روی نام کاربری که مایل به دیدن می باشید کلیک کنید. برای ایجاد یک کاربر جدید، روی "ایجاد جدید" در بالا کلیک کنید.',
    13 => 'SecLev',
    14 => 'Reg. Date',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'ذخیره',
    21 => 'نام کاربری که تلاش کردید ذخیره کنید از قبل وجود داشته است.',
    22 => 'خطا',
    23 => 'افزودن دسته ای',
    24 => 'واردات دسته ای از کاربران',
    25 => 'می توانید دسته ای از کاربران را به گیکلاگ وارد کنید. پرونده وارداتی باید یک پرونده متنی tab-delimited باشد و باید رشته های به ترتیب زیر را داشته باشد: نام کامل، نام کاربری، نشانی ایمیل. هر کاربری که وارد می کنید با یک رمز عبور تصادفی ایمیل خواهد شد. شما باید یک کاربر وارد شده در هر خط داشته باشید. عدم پیروی از این دستورالعمل ها موجب مشکلاتی خواهد شد که ممکن است به کار دستی نیاز باشد بنابراین ورودی های خود را دوبار بررسی کنید!',
    26 => '',
    27 => '',
    28 => 'برای حذف این تصویر اینجا کلیک کنید',
    29 => 'مسیر',
    30 => 'وارد كردن',
    31 => 'کاربران جدید',
    32 => 'پردازش انجام شده. وارد شده %d و مواجه با %d شکست',
    33 => 'ارسال',
    34 => 'خطا: باید یک پرونده را برای بارگذاری مشخص کنید.',
    35 => 'آخرین ورود',
    36 => 'هرگز',
    37 => 'شناسه منحصر بفرد',
    38 => 'فهرست نویسی گروه',
    39 => 'رمز عبور (مجدد)',
    40 => 'تاریخ ثبت نام',
    41 => 'تاریخ آخرین ورود',
    42 => 'ممنوع شده',
    43 => 'در انتظار فعال سازی',
    44 => 'در انتظار مجوز',
    45 => 'فعال',
    46 => 'وضعیت کاربر',
    'user_status_desc' => "An explanation of all possible user statuses: <ul>
\n        <li><strong>Awaiting Activation</strong> - New account awaiting user to login. Email has been sent but not verified. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>
\n        <li><strong>Awaiting Authorization</strong> - New account awaiting moderator approval in the User Submission Queue. When User Submission approved, user will be sent email with password. This is only set for a new account and is an automated status (Admins cannot set accounts to this status manually)</li>
\n        <li><strong>Active</strong> - This is an Active account.</li>
\n        <li><strong>Banned</strong> -  This Account is banned/disabled. Username is crossed out on the site for any content they have submitted, User cannot login, emails to account is disabled, and profile cannot be viewed by any user except Admins.</li>
\n        <li><strong>Locked</strong> - This Account is locked. User cannot login, emails to account is disabled, but profile can still be viewed by all.</li>
\n        <li><strong>New Email Required</strong> - Emails to account is disabled. When user logs in again they must submit new email address and verify before access to rest of the website (under this user account). Status stays the same until email is verified. If \"Require User Email\" config option true then any users who login (includes remote accounts) that do not have an email address will automatically switch to this status.</li>
\n        <li><strong>New Password Required</strong> -  When the user logs in they must submit a new password before access to rest of website (under this user account). This is only for regular accounts and not remote accounts.</li>
\n        </ul>
\n    ",
    47 => 'ویرایش',
    48 => 'نمایش گروه های مدیر',
    49 => 'گروه مدیر',
    50 => 'برای اجازه دادن به تصفیه کردن این گروه به عنوان یک گروه استفاده مدیر علامت بزنید',
    51 => 'روز های آنلاین',
    52 => '<br' . XHTML . '>توجه: "روز های آنلاین" تعداد روز های بین اولین ثبت نام و آخرین ورود می باشد.',
    53 => 'ثبت نام شده',
    54 => 'مدیر دسته',
    55 => 'این فقط در صورتی کار می کند اگر گزینه \'ضبط آخرین ورود\' را در پانل مدیریت پیکربندی فعال کرده باشید.',
    56 => 'لطفا نوع کاربری را که میخواهید حذف کنید انتخاب کنید و "بروزرسانی فهرست" را فشار دهید. سپس آنهایی را از فهرستی که نمی خواهید حذف کنید را علامت بردارید و "حذف" را فشار دهید. لطفا توجه داشته باشید که فقط آنهایی را که در حال حاضر نمایان می باشند در صورتی که محدوده های فهرست بالای چندین صفحه است حذف خواهید کرد.',
    57 => 'کاربران فانتوم',
    58 => 'کاربران کوتاه مدت',
    59 => 'کاربران قدیمی',
    60 => 'کاربرانی که ثبت نام کردند بیشتر از ',
    61 => ' ماه قبل اما هرگز وارد نشدند.',
    62 => 'کاربرانی که ثبت نام کردند بیشتر از ',
    63 => ' ماه قبل سپس در مدت ۲۴ ساعت وارد سیستم شدند اما از آن پس هرگز به سایت شما برنگشتند.',
    64 => 'کاربران عادی کسانی که به سادگی از سایت شما بازدید نکردند پس از ',
    65 => ' ماه ها.',
    66 => 'بروزرسانی فهرست',
    67 => 'ماه ها از زمان ثبت نام',
    68 => 'ساعت های آنلاین',
    69 => 'ماه های آفلاین',
    70 => 'نمی توان حذف کرد',
    71 => 'با موفقیت حذف شد',
    72 => 'هیچ کاربری برای حذف انتخاب نشده است',
    73 => 'آیا مطمئن هستید که می خواهید همه کاربران انتخابی را به صورت دائمی حذف کنید؟',
    74 => 'کاربران اخیر',
    75 => 'کاربرانی که ثبت نام کرده اند در آخرین ',
    76 => ' ماه ها',
    77 => 'ایمیل یادآوری ورود به سایت برای کاربران انتخاب شده',
    78 => 'ارسال یادآوری',
    79 => 'هیچ کاربری برای یادآوری ها انتخاب نشده',
    80 => 'ارسال موفق یادآوری ها',
    81 => 'یادآوری تأیید اعتبار حساب کاربری برای %s',
    82 => "حساب کاربری شما در {$_CONF['site_name']} از %s در دسترس نبوده است و در صورت عدم دسترسی در ۳۰ روز آینده غیرفعال خواهد شد.",
    83 => "حساب کاربری شما در {$_CONF['site_name']} از زمان ایجاد آن استفاده نشده است و در صورت عدم دسترسی به زودی حذف خواهد شد.",
    84 => "نام ورود شما هست: %s برای سایت ما: {$_CONF['site_url']}",
    85 => 'اگر رمز عبور را فراموش کرده اید از پیوند زیر استفاده کنید: %s',
    86 => 'شامل',
    87 => 'یادآوری ها',
    88 => 'گروه پیشفرض',
    89 => 'برای تعیین این به عنوان یک گروه پیشفرض برای کاربران جدید علامت بزنید',
    90 => 'Apply "Default Group" change to existing user accounts',
    91 => 'ارسال رمز عبور به کاربر',
    92 => 'فقط برای کاربران جدید و یا هنگام تغییر رمز عبور برای کاربر موجود.',
    'convert_remote' => 'Check here to convert from remote to a local account',
    'convert_remote_desc' => 'When a remote account is converted to a local account, a password will be automatically generated. If the account does not have a confirmed email address, the account will be locked after it is converted since the user will have no way of retrieving the password. Once converted and if the account is active and has an email address the user will be emailed the password or they can request the password by using the forget password link from the Login page. For user accounts that do not have an active status and valid email you will have to manually notify the user of the account change and how to login.',
    'contributed' => 'Contributed',
    'na' => 'NA',
    'nothing' => 'Nothing',
    'autotag_desc_user' => '[user: name alternate title] - یک پیوند به یک کاربر با استفاده از نام کاربری مانند عنوان را نمایش می دهد. یک عنوان جایگزین ممکن است مشخص شود اما نیاز نمی باشد.',
    'USER_ACCOUNT_LOCKED' => 'قفل شده',
    'USER_ACCOUNT_NEW_EMAIL' => 'ایمیل جدید نیاز است',
    'USER_ACCOUNT_NEW_PASSWORD' => 'رمز عبور جدید نیاز است'
);

###############################################################################
# admin/moderation.php
# admin/index.php

$LANG29 = array(
    1 => 'تصویب',
    2 => 'حذف',
    3 => 'ویرایش',
    4 => 'مشخصات',
    10 => 'عنوان',
    11 => 'تاریخ شروع',
    12 => 'نشانی اینترنتی',
    13 => 'ارسالی ها',
    14 => 'تاریخ',
    15 => 'موضوع',
    16 => 'نام کاربری',
    17 => 'نام و نام خانوادگی',
    18 => 'ایمیل',
    34 => 'دستور و کنترل',
    35 => 'ارسالی های مقاله',
    36 => 'اصلی یا نظر',
    37 => 'نویسنده',
    38 => 'ارسال',
    39 => 'در حال حاضر هیچ ارسالی برای اداره کردن وجود ندارد',
    40 => 'ارسالی های کاربر',
    41 => 'ارسالی های نظر',
    42 => 'نام کاربری',
    43 => 'انتشار خودکار نظرات؟',
    44 => 'نتایج نظارت شما',
    45 => '%1$d مورد تایید شده و %2$d مورد حذف شده از ارسالات کاربر.',
    46 => 'مشخصات کاربر بروزرسانی شد',
    'core' => 'هسته',
    'plugins' => 'افزونه ها',
    'tools' => 'ابزار ها',
    'users' => 'کاربران',
    'submissions_desc' => 'برای تغییر و یا حذف ارسالات یک کاربر، روی نقشک ویرایش آن مورد در زیر کلیک کنید. برای تأیید و حذف چندین ارسال از گزینه های رادیویی در فهرست ها استفاده کنید و سپس روی ارسال کلیک کنید. اقلام در بیشتر موارد از جدیدترین به قدیمی ترین ترتیب داده شده اند.',
    'max_invalid_login' => 'حداکثر ورود های نامعتبر به سر رسیده برای کاربر',
    'max_invalid_login_msg' => "این کاربر به حداکثر تعداد تلاش های ورود نامعتبر رسیده است ({$_CONF['invalidloginattempts']}) در مدت زمان مشخص شده ({$_CONF['invalidloginmaxtime']} ثانیه). آخرین آیپی برای ایجاد یک تلاش ناموفق %s است. کاربر واقعی رمز عبور را برای حساب کاربری خود فراموش کرده است یا شخص دیگری تلاش در حدس زدن رمز عبور برای این حساب کاربری دارد."
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} ابزار ایمیل",
    2 => 'از نام',
    3 => 'از نشانی ایمیل',
    4 => 'موضوع',
    5 => 'پیام',
    6 => 'فرستادن به:',
    7 => 'همه کاربران',
    8 => 'مدیر',
    9 => 'گزینه ها',
    10 => 'HTML',
    11 => 'پیام فوری!',
    12 => 'ارسال',
    13 => 'بازنشانی',
    14 => 'چشم پوشی تنظیمات کاربر',
    15 => 'خطا هنگام ارسال به: ',
    16 => 'پیام ها با موفقیت ارسال شدند به: ',
    17 => "<a href=\"{$_CONF['site_admin_url']}/mail.php\">ارسال پیام دیگری</a>",
    18 => 'به',
    19 => 'توجه: اگر می خواهید یک پیام را به همه اعضای سایت ارسال کنید، گروه کاربران وارد شده را از فهرست کشویی انتخاب کنید.',
    20 => "Successfully sent <successcount> messages and unsuccessfully sent <failcount> messages.  If you need them, the details of each message attempts is below.  Otherwise you can <a href=\"{$_CONF['site_admin_url']}/mail.php\">Send another message</a> or you can <a href=\"{$_CONF['site_admin_url']}/moderation.php\">go back to the administration page</a>.",
    21 => 'عدم موفقیت ها',
    22 => 'موفقیت ها',
    23 => 'بدون شکست ها',
    24 => 'بدون موفقیت ها',
    25 => '-- انتخاب گروه --',
    26 => 'لطفا همه فیلد های فرم را پر کنید و یک گروه از کاربران را از فهرست کشویی انتخاب کنید.',
    27 => 'متغیر های زیر در </strong>موضوع<strong> و </strong>پیام<strong> موجود می باشند: {uid}, {username}, {fullname}, {email}, {homepage}, {theme}, {language}, {location}, {lastgranted}, {lastlogin}, {site_url}, {site_name}, {site_slogan}, {owner_name}, {copyrightyear}, {site_mail}, {noreply_mail}',
    'email_divider' => '------------------------------------------------------------',
    'email_divider_html' => '<hr' . XHTML . '>',
    'sig_divider' => '---',
    'sig_divider_html' => '---<br' . XHTML . '>',
    'email_footer_msg_noreply' => 'The address used to send this email is not monitored. Please do not reply to this email.',
    'email_footer_msg_content' => 'If content from the website is displayed in this email, there may be layout changes which result in formatting issues.',
    'ip_address_email' => 'IP address that initiated email:'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'نصب افزونه ها احتمالا باعث آسیب به نصب گیکلاگ شما و احتمالا به سیستم شما می شود. مهم است افزونه هایی را که فقط از <a href="https://www.geeklog.net">Geeklog Homepage</a> بارگیری شده اند نصب کنید زیرا ما همه افزونه هایی را که به سایت ما ارسال شدند روی سیستم عامل های مختلف به صورت کامل آزمایش می کنیم. مهم این است که متوجه شوید که روند نصب افزونه نیاز به اجرای چند فرمان سیستم پرونده دارد که می تواند به مشکلات امنیتی منجر شود، به ویژه اگر افزونه هایی از سایت های شخص ثالث استفاده کنید. حتی با این هشدار که شما دریافت می کنید، ما موفقیت هر گونه نصب را تضمین نمی دهیم و ما مسئول آسیب ناشی از نصب افزونه گیکلاگ نمی باشیم. به عبارت دیگر، با ریسک شخصی نصب کنید. برای احتیاط، دستورالعمل هایی درباره نحوه نصب دستی یک افزونه شامل بسته هر افزونه می باشد.',
    2 => 'سلب مسئولیت نصب افزونه',
    3 => 'فرم نصب افزونه',
    4 => 'پرونده افزونه',
    5 => 'فهرست افزونه',
    6 => 'هشدار: افزونه از قبل نصب شده!',
    7 => 'افزونه ای را که در حال تلاش برای نصب آن می باشید وجود دارد. لطفا قبل از نصب مجدد آن افزونه را حذف کنید',
    8 => 'شکست بررسی سازگاری افزونه',
    9 => 'این افزونه نیاز به یک نسخه جدید از گیکلاگ دارد. لطفا نسخه گیکلاگ خود را <a href="https://www.geeklog.net"> Geeklog </a> ارتقا دهید.',
    10 => '<br' . XHTML . '><b>هیچ افزونه ای در حال حاضر نصب نشده است.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'برای تغییر یا حذف یک افزونه، روی نقشک ویرایشگر افزونه کلیک کنید. این جزئیات افزونه از جمله سایت اینترنتی نویسندگان را نشان می دهد. هر دو نسخه نصب و نسخه بازگشتی از کد افزونه نشان داده شدند. این به شما کمک خواهد کرد تا بدانید که اگر افزونه نیاز به ارتقا دارد. برای نصب یا ارتقا یک افزونه لطفا مستندات آن را کنکاش کنید.',
    12 => 'نام افزونه برای plugineditor() تهیه نشده',
    13 => 'مرکز اطلاعات افزونه',
    14 => 'افزونه های پاک شده',
    'installed_plugins' => 'Installed Plugins',
    15 => 'خانه مدیر',
    16 => 'نام افزونه',
    17 => 'نسخه افزونه',
    18 => 'نسخه گیکلاگ',
    19 => 'فعال شده',
    20 => 'بله',
    21 => 'خیر',
    22 => 'نصب',
    23 => 'ذخیره',
    24 => 'لغو',
    25 => 'حذف',
    26 => 'نام افزونه',
    27 => 'صفحه اصلی افزونه',
    28 => 'نسخه نصب شده',
    29 => 'نسخه گیکلاگ',
    30 => 'حذف افزونه؟',
    31 => 'آیا مطمئن هستید که می خواهید این افزونه را حذف کنید؟ با انجام این کار همه داده ها و ساختار های داده ای که این افزونه از آن استفاده می کند را بر خواهید داشت. اگر مطمئن می باشید، مجدد روی حذف در فرم زیر کلیک کنید.',
    32 => '<p><b>خطا برچسب خودکار در فالب صحیح نمی باشد</b></p>',
    33 => 'نسخه کد',
    34 => 'بروزرسانی',
    35 => 'ویرایش',
    36 => 'کد',
    37 => 'داده',
    38 => 'بروزرسانی!',
    39 => 'بارگذاری یک افزونه',
    40 => 'می توانید یک بایگانی افزونه (.tar.gz، .tgz، .zip) را به صورت مستقیم در اینجا بارگذاری کنید:',
    41 => 'بارگذاری',
    42 => 'کلیک برای بروزرسانی',
    43 => 'ترتیب بارکنش',
    44 => 'حرکت افزونه به بالای ترتیب بارکنش',
    45 => 'حرکت افزونه به پایین ترتیب بارکنش',
    46 => 'کلیک برای حذف سازی این افزونه',
    47 => 'واقعا تصمیم به حذف %s افزونه؟',
    48 => 'کلیک برای فعال سازی این افزونه',
    49 => 'کلیک برای غیرفعال سازی این افزونه',
    50 => 'وابستگی ها',
    51 => 'باشه',
    52 => 'حل نشده',
    53 => 'غیرفعال شده',
    54 => 'موجود نمی باشد',
    55 => 'نصب نشده',
    56 => 'نسخه اشتباه',
    57 => 'ناشناخته',
    58 => 'ترتیب بارکنش یک یا چند افزونه به منظور حل وابستگی ها تغییر کرده است',
    59 => 'اطلاعات',
    60 => 'بستن',
    61 => 'وضعیت',
    62 => 'کلیک برای نصب این افزونه',
    63 => 'این افزونه را نمی توان نصب کرد',
    64 => 'این افزونه را نمی توان فعال کرد',
    65 => 'قابلیت بارگذاری افزونه به علت خطا های زیر غیرفعال شده است:',
    66 => 'بارگذاری های پرونده در پیکربندی پی اچ پی شما غیرفعال است.',
    67 => 'پوشه "%s" قابل نوشتن نمی باشد.',
    68 => 'مجوز های لازم برای نصب افزونه ها ندارید.',
    69 => 'مجوز های لازم برای بارگذاری افزونه ها ندارید.',
    'delete' => 'Delete',
    'delete_plugin' => 'Delete Plugin and all of its files?',
    'click_to_delete_msg' => 'Click to Delete this Plugin files',
    'really_delete_msg' => 'Really Delete %s Plugin files?',
    99 => 'یک خطای ناشناخته رخ داده است',
    100 => 'باشه.',
    101 => 'پرونده بارگذاری شده فراتر از رهنمود upload_max_filesize در php.ini است.',
    102 => 'پرونده بارگذاری شده فراتر از رهنمود MAX_FILE_SIZE است که در فرم HTML مشخص شده است.',
    103 => 'پرونده بارگذاری شده فقط تا حدی بارگذاری شد.',
    104 => 'هیچ پرونده ای بارگذاری نشد.',
    105 => '(خطای تعریف نشده)',
    106 => 'فقدان یک پوشه موقت.',
    107 => 'شکست نوشتن پرونده روی دیسک.',
    108 => 'بارگذاری پرونده توسط مد متوقف شد.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'ایجاد خوراک',
    2 => 'ذخیره',
    3 => 'حذف',
    4 => 'لغو',
    10 => 'سندیکای محتوا',
    11 => 'خوراک جدید',
    12 => 'خانه مدیر',
    13 => 'برای تغییر یا حذف خوراک، روی نقشک ویرایش خوراک در زیر کلیک کنید. برای ایجاد یک خوراک جدید، روی "ایجاد جدید" در بالا کلیک کنید.',
    14 => 'عنوان',
    15 => 'نوع',
    16 => 'نام پرونده',
    17 => 'قالب',
    18 => 'آخرین بروزرسانی',
    19 => 'فعال شده',
    20 => 'بله',
    21 => 'خیر',
    22 => '<i>(بدون خوراک ها)</i>',
    23 => 'همه موضوعات',
    24 => 'ویرایشگر خوراک',
    25 => 'عنوان خوراک',
    26 => 'حد',
    27 => 'طول ورودی ها',
    28 => '(0 = no text, 1 = full text, other = limit to that number of chars.)',
    29 => 'شرح',
    30 => 'آخرین بروزرسانی',
    31 => 'مجموعه کاراکتر',
    32 => 'زبان',
    33 => 'مطالب',
    34 => 'ورودی ها',
    35 => 'ساعت ها',
    36 => 'نوع خوراک را انتخاب کنید',
    37 => '',
    38 => 'خطا: رشته های گم شده',
    39 => 'لطفا عنوان خوراک، شرح و نام پرونده را پر کنید.',
    40 => 'لطفا یک تعداد از ورودی ها یا تعداد ساعت ها را وارد کنید.',
    41 => 'ارسال',
    42 => '',
    43 => 'همه',
    44 => 'هیچ یک',
    45 => 'سرآیند پیوند در موضوع',
    46 => 'محدود کردن نتایج',
    47 => 'جستجو',
    48 => 'ویرایش',
    49 => 'آرم خوراک',
    50 => "نسبت به نشانی اینترنتی سایت ({$_CONF['site_url']})",
    51 => 'نام پرونده ای که انتخاب کرده اید از قبل توسط خوراک دیگری استفاده شده است. لطفا یک مورد متفاوت را انتخاب کنید.',
    52 => 'خطا: نام پرونده موجود',
    53 => 'همه مقالات صفحه اول',
    54 => 'لطفا نوع خوراک را برای ایجاد انتخاب کنید.',
    55 => 'مقالات',
    'num_articles' => '%s Article(s)'
);

###############################################################################
# admin/language.php (since v2.1.2)

$LANG_LANG = array(
    'language_admin_title' => 'حکم های زبان',
    'language_manager' => 'مدیریت حکم زبان',
    'new_language_msg' => 'برای تغییر یا حذف یک مورد حکم زبان، روی نقشک ویرایش آن مورد در زیر کلیک کنید. برای ایجاد یک حکم جدید، روی "ایجاد جدید" در بالا کلیک کنید. حکم های زبان برای هر دو خود گیکلاگ و هر پلاگین نصب شده کار می کند.',
    'language_editor' => 'ویرایشگر حکم زبان',
    'id' => 'شناسه',
    'language' => 'زبان',
    'name' => 'عنصر متغیر',
    'var_name' => 'نام متغیر',
    'name_tip' => 'Required just for language arrays.',
    'var_name_tip' => 'Can be a regular variable or array. Do not include the dollar sign at the beginning of the variable/array name.',
    'value' => 'مقدار جدید'
);

###############################################################################
# admin/router.php

$LANG_ROUTER = array(
    1 => 'مسیریابی نشانی اینترنتی',
    2 => 'مدیریت مسیریابی',
    3 => 'شناسه',
    4 => 'روش',
    5 => 'قاعده',
    6 => 'مسیر',
    7 => 'اولویت',
    8 => 'افزایش اولویت',
    9 => 'کاهش اولویت',
    10 => 'ویرایش مسیریابی',
    11 => 'برای تغییر یا حذف یک مسیر، روی نقشک ویرایش مسیر در زیر کلیک کنید. برای ایجاد یک مسیر جدید، روی "ایجاد جدید" در بالا کلیک کنید. هنگامی که از جایبان ها (@) استفاده می کنید، باید جایبان های یکسان در یک قاعده و مسیر آن تعریف کنید. به خاطر داشته باشید نشانی اینترنتی مسیریابی در حال حاضر فقط از مقالات، موضوعات، صفحات ایستا، پوشه مقاله و افزونه پیوند ها پشتیبانی می کند.',
    12 => 'روش درخواست بد',
    13 => 'قاعده یک مورد اجباری است.',
    14 => 'مسیر یک مورد اجباری است.',
    15 => 'جایبان ها (@) در یک قاعده و آنهایی که در یک مسیر باید یکسان باشند.',
    16 => 'مسیر نباید با "/index.php/" شروع شود.',
    17 => 'خطای پایگاه داده رخ داده.',
    18 => '<strong>برای فعال کردن مسیریابی نشانی اینترنتی، باید بازنویسی نشانی اینترنتی را در پیکربندی فعال کنید.</strong>',
    19 => '<strong>برای فعال کردن مسیریابی نشانی اینترنتی، باید مسیریابی نشانی اینترنتی را در پیکربندی فعال کنید.</strong>',
    20 => '<ul><li>جایبان ها (@) باید هردو در یک قانون و مسیر آن یکسان باشند.</li><li>یک جایبان با "@" شروع می شود، به دنبال آن یک الفبای است، اختیاری توسط هر طول الفبایی یا رقمی دنبال شده است.</li><li>جایبان ها به حروف کوچک و بزرگ حساس می باشند.</li><li>کد وضعیت در حال حاضر باید در ۲۰۰ باقی بماند. تغییر این ممکن است منجر به مسائل غیر قابل پیش بینی شود زیرا این ویژگی آزمایشی است.</li></ul>',
    21 => 'کد وضعیت',
    22 => 'فعال شده',
    23 => 'بله',
    24 => 'خیر'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "رمز عبور شما به شما ایمیل شده است و باید در مدت کوتاهی برسد. لطفا دستورالعمل ها را در پیام دنبال کنید و از شما برای استفاده {$_CONF['site_name']} سپاسگزاریم.",
    2 => "سپاس از شما برای ارسال مقاله خود به {$_CONF['site_name']}. برای تأیید به کارکنان ما ارسال شده است. اگر تایید شده باشد، مقاله شما برای دیگران جهت خواندن روی سایت در دسترس خواهد بود.",
    3 => '',
    4 => '',
    5 => 'اطلاعات حساب کاربری شما با موفقیت ذخیره شده است.',
    6 => 'ترجیحات شما با موفقیت ذخیره شده اند.',
    7 => 'ترجیحات نظر شما با موفقیت ذخیره شده است.',
    8 => 'شما با موفقیت خارج شده اید.',
    9 => 'مقاله شما با موفقیت ذخیره شده است.',
    10 => 'مقاله با موفقیت حذف شده است.',
    11 => 'بلوک شما با موفقیت ذخیره شده است.',
    12 => 'بلوک با موفقیت حذف شده است.',
    13 => 'موضوع شما با موفقیت ذخیره شده است.',
    14 => 'موضوع و همه مقالات و بلوک های آن با موفقیت حذف شده است.',
    15 => 'نظر شما برای بازدید ارسال شده است و هنگامی که توسط یک ناظر تایید شد منتشر خواهد شد.',
    16 => 'لغو اشتراک شده اید. دیگر از پاسخ های جدید مطلع نخواهید شد.',
    17 => 'حساب کاربر شما قفل شده است و دسترسی به آن غیرفعال شده است. برای اطلاعات بیشتر با مدیر تماس بگیرید.',
    18 => '',
    19 => '',
    20 => '',
    21 => 'کاربر با موفقیت ذخیره شده است.',
    22 => 'کاربر با موفقیت حذف شده است.',
    23 => 'رمز عبور شما باید مطابقت داشته باشد، لطفا مجدد امتحان کنید. رمز های عبور به حروف کوچک و بزرگ حساس می باشند.',
    24 => 'ایمیل شما باید مطابقت داشته باشد، لطفا مجدد امتحان کنید.',
    25 => 'یک نشانی ایمیل معتبر وارد نکرده اید، لطفا مجدد امتحان کنید.',
    26 => 'این نشانی ایمیل از قبل توسط یک حساب کاربری استفاده می شود، لطفا مجدد امتحان کنید.',
    27 => 'پیام با موفقیت ارسال شد.',
    28 => 'افزونه با موفقیت ذخیره شده است.',
    29 => 'با عرض پوزش، به این صفحه مدیریت دسترسی ندارید. لطفا توجه داشته باشید که همه تلاش ها برای دسترسی به ویژگی های غیر مجاز ضبط شده اند.',
    30 => 'دسترسی ممنوع است',
    31 => 'Sorry, This feature is not supported by the  database server this website is using.  Please note that all attempts to access unsupported features are logged.',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'پیام سیستم',
    41 => '',
    42 => '',
    43 => 'حساب کاربری وجود ندارد.',
    44 => 'افزونه با موفقیت نصب شد!',
    45 => 'افزونه با موفقیت حذف شد.',
    46 => 'نام کاربری یا نشانی ایمیل شما یافت نشد، لطفا مجدد امتحان کنید.',
    47 => 'با عرض پوزش در حال حاضر نمی توانید رمز عبور حساب کاربری خود را درخواست کنید. برای اطلاعات بیشتر با مدیر تماس بگیرید.',
    48 => "سپاس از شما برای درخواست عضویت با {$_CONF['site_name']}. تیم ما درخواست شما را بررسی خواهد کرد. اگر تأیید شده باشد، رمز عبور شما به نشانی ایمیلی که تازه وارد کردید به شما ارسال خواهد شد.",
    49 => 'گروه شما با موفقیت ذخیره شده است.',
    50 => 'گروه با موفقیت حذف شده است.',
    51 => 'این نام کاربری از قبل در حال استفاده است. لطفا یکی دیگر را انتخاب کنید.',
    52 => 'نشانی ایمیل ارائه شده به نظر نمی رسد یک نشانی ایمیل معتبر باشد.',
    53 => 'رمز عبور جدید شما پذیرفته شده است. لطفا از رمز عبور جدید خود برای ورود به سیستم استفاده کنید.',
    54 => 'درخواست شما برای یک رمز عبور جدید منقضی شده است. لطفا مجدد امتحان کنید.',
    55 => 'یک ایمیل به شما ارسال شده است و باید لحظه ای برسید. لطفا دستور این پیام را برای تنظیم یک رمز جدید برای حساب کاربری خود دنبال کنید.',
    56 => 'نشانی ایمیل ارائه شده برای حساب دیگری از قبل در حال استفاده است.',
    57 => 'حساب کاربری شما با موفقیت حذف شده است.',
    58 => 'خوراک شما با موفقیت ذخیره شده است.',
    59 => 'خوراک با موفقیت حذف شده است.',
    60 => 'افزونه با موفقیت به روز شد.',
    61 => 'Plugin %s: Unknown message placeholder',
    62 => 'نظر دنبالک حذف شده است.',
    63 => 'یک خطا هنگام حذف نظر دنبالک رخ داد.',
    64 => 'نظر دنبالک شما با موفقیت ارسال شده است.',
    65 => 'سرویس فهرست وبلاگ با موفقیت ذخیره شد.',
    66 => 'سرویس فهرست وبلاگ حذف شده است.',
    67 => 'رمز عبور جدید با رمز عبور تایید مطابقت ندارد! رمز های عبور به حروف کوچک و بزرگ حساس می باشند.',
    68 => 'باید رمز عبور فعلی درست را وارد کنید.',
    69 => 'حساب کاربری شما مسدود شده است!',
    70 => 'حساب کاربری شما در انتظار تأیید مدیر است',
    71 => 'حساب کاربری شما اکنون تایید شده است و منتظر تأیید مدیر است.',
    72 => 'هنگام تلاش برای نصب افزونه یک خطا رخ داد. برای جزئیات error.log را ببینید.',
    73 => 'هنگام تلاش برای پاکسازی افزونه یک خطا رخ داد. برای جزئیات error.log را ببینید.',
    74 => 'پینگبک با موفقیت ارسال شده است.',
    75 => 'دنبالک ها باید با استفاده از یک درخواست پست ارسال شوند.',
    76 => 'آیا واقعا می خواهید این مورد را حذف کنید؟',
    77 => 'هشدار:<br' . XHTML . '>شما رمزگذاری پیشفرض خود را به UTF-8 تنظیم کرده اید. با این حال، سرور شما از رمزگذاری های چند بایتی پشتیبانی نمی کند. لطفا توابع mbstring را برای پی اچ پی نصب کنید یا یک مجموعه کاراکتر/زبان متفاوت را انتخاب کنید.',
    78 => 'لطفا مطمئن شوید که نشانی ایمیل و نشانی ایمیل تأیید یکسان می باشند.',
    79 => 'صفحه ای که تلاش در باز کردن آن دارید اشاره دارد به یک قابلیت که دیگر در این سایت وجود ندارد.',
    80 => 'افزونه ای که این خوراک ایجاد کرد در حال حاضر غیرفعال است. شما قادر نخواهید بود این خوراک را ویرایش کنید تا هنگامی که افزونه اصلی را مجدد فعال کنید.',
    81 => 'ممکن است اعتبارات ورود خود را اشتباه وارد کرده اید. لطفا تلاش کنید مجدد وارد شوید.',
    82 => 'فراتر از تعداد تلاش های ورود مجاز رفته اید. لطفا بعدا مجدد امتحان کنید.',
    83 => 'برای تغییر رمز عبور خود، نشانی ایمیل، یا برای اینکه تا چه مدت شما را به خاطر داشته باشد، لطفا رمز عبور فعلی خود را وارد کنید.',
    84 => 'برای حذف حساب کاربری خود، لطفا رمز عبور فعلی خود را وارد کنید.',
    85 => 'یک مشکل در فرستادن ایمیل وجود داشت.',
    86 => 'سرور OpenID قصد ورود شما را باطل کرد.',
    87 => 'عملیات ورود به OpenID توسط کاربر لغو شد.',
    88 => 'سرور OpenID یک خطا را بازگرداند.',
    89 => 'ناتوان در یافتن یک سرور OpenID برای هویت داده شده نشانی اینترنتی.',
    90 => 'شناسایی OpenID لغو شد.',
    91 => 'یک نشانی اینترنتی با هویت نامعتبر را مشخص کردید.',
    92 => "لطفا <a href=\"{$_CONF['site_admin_url']}/sectest.php\">امنیت سایت خود را بررسی کنید</a> قبل از استفاده آن!",
    93 => 'پشتیبان پایگاه داده موفق بود.',
    94 => 'پشتیبان ناموفق: اندازه پرونده کمتر از ۱ کیلوبایت',
    95 => 'یک خطا وجود داشت.',
    96 => '',
    97 => '',
    98 => 'افزونه با موفقیت بارگذاری شد.',
    99 => 'افزونه در حال حاضر وجود دارد.',
    100 => 'پرونده افزونه ای که بارگذاری کردید بایگانی فشرده GZip یا Zip نبود.',
    101 => 'هیچ موضوعی وجود ندارد (که به آن دسترسی دارید). حداقل یک موضوع نیاز دارید تا قادر به ارسال مقالات باشد.',
    110 => 'بدست نیاوردن نشانی اینترنتی برای تأیید هویت.',
    111 => 'خطای تأیید هویت.',
    112 => 'صدور گواهینامه لغو شده است.',
    113 => 'حساب کاربری شما با موفقیت ایجاد شده است. {site_url}',
    114 => 'همگام سازی مجدد شما با حساب راه دور شما ناموفق بوده است اما اطلاعات حساب دیگر شما با موفقیت ذخیره شده است.',
    115 => 'سرویس از راه دور غیرفعال شده است.',
    116 => 'بارکنش...',
    117 => 'صفحه راهنما یافت نشد.',
    118 => 'برای انتخاب یک تاریخ کلیک کنید',
    119 => 'بیشتر..',
    120 => 'این را بفرستید؟',
    121 => 'یک مورد مسیر یابی نشانی اینترنتی ذخیره شد.',
    122 => 'یک مورد مسیر یابی نشانی اینترنتی ذخیره نشد.',
    123 => 'یک مورد مسیر یابی نشانی اینترنتی حذف شد.',
    130 => 'مورد زبان شما با موفقیت حذف شده است.',
    131 => 'مورد زبان شما با موفقیت ذخیره شده است.',
    140 => 'نظر(های) حذف شده.',
    141 => 'حذف ناموفق یک نظر.',
    142 => 'نظر(های) تایید شده.',
    143 => 'کاربر(های) ممنوع شده.',
    144 => 'نشانی آیپی های ممنوع شده با افزونه اسپم-اکس.',
    145 => 'نشانی آیپی های ممنوع شده با افزونه منع.',
    150 => 'همه پرونده ها و پوشه هایی که در هنگام نصب استفاده می شد با موفقیت حذف شدند.',
    151 => 'حذف ناموفق برخی از پرونده ها و پوشه های مورد استفاده در هنگام نصب. لطفا آنها را به صورت دستی بردارید.',
    152 => 'همه پرونده ها و پوشه هایی که در هنگام نصب استفاده شدند همانطور که می باشند رها شدند. حفظ آنها روی سرور خطرناک است، پس لطفا فراموش نکنید که آنها را به صورت دستی بردارید.',
    153 => 'آخرین مقاله را %1$d ثانیه قبل ایمیل کردید. این سایت حداقل %2$d ثانیه بین ایمیل کردن مقالات نیاز دارد.',
    160 => 'The plugin files was successfully deleted.',
    161 => 'The archive includes a file whose name includes an unsafe character.',
    400 => 'همه رشته های مورد نیاز اعتبار داده نشده اند',
    401 => 'لطفا نام کامل را وارد کنید',
    500 => 'حافظه نهان قالب با موفقیت پاک شده است.',
    501 => 'یک پیام تأیید به نشانی ایمیل شما ارسال شده است. لطفا برای تأیید نشانی ایمیل خود و بروزرسانی حساب کاربری خود روی پیوند در ایمیل کلیک کنید. اگر قبل از تأیید نشانی ایمیل خود مجدد به حساب کاربری خود وارد شوید مجدد از شما برای یک نشانی ایمیل پرسش خواهد شد.<br' . XHTML . '><br' . XHTML . '>لطفا توجه داشته باشید که در حال حاضر با موفقیت خارج شده اید بنابراین می توانید این تأیید را تکمیل کنید.',
    502 => 'درخواست شما برای یک ایمیل جدید منقضی شده است. لطفا مجدد تلاش کنید.',
    503 => 'ایمیل شما با موفقیت تأیید شده است.',
    504 => 'رمز های عبور باید حداقل ۸ حرف داشته باشد و شامل حداقل ۱ عدد و ۱ حرف باشد. رمز های عبور به حروف کوچک و بزرگ حساس می باشند.',
    505 => "<em>Current set Site Default theme \"{$_CONF['theme_site_default']}\" is not valid.</em> Using Geeklog Default theme \"{$_CONF['theme']}\" for now. <br" . XHTML . "><br" . XHTML . ">This version of Geeklog you are running (v2.2.2) supports Themes with Geeklog v{$_CONF['min_theme_gl_version']} support.<br" . XHTML . "><br" . XHTML . ">Please update by reselecting a valid theme for the sites Config Theme setting in the Geeklog Configuration and resave.",
    506 => "<em>Current set Site Default theme \"{$_CONF['theme_site_default']}\" is not valid.</em> Using Geeklog theme \"{$_CONF['theme']}\" for now.<br" . XHTML . "><br" . XHTML . ">This version of Geeklog you are running (v2.2.2) supports Themes with Geeklog v{$_CONF['min_theme_gl_version']} support.<br" . XHTML . "><br" . XHTML . ">Please update by reselecting a valid theme for the sites Config Theme setting in the Geeklog Configuration and resave."
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'دسترسی',
    'ownerroot' => 'مالک/ریشه',
    'group' => 'گروه',
    'readonly' => 'فقط خواندنی',
    'accessrights' => 'حقوق دسترسی',
    'owner' => 'مالک',
    'grantgrouplabel' => 'اعطای حقوق ویرایش به گروه بالا',
    'permmsg' => 'توجه: اعضا همه اعضای سایت که وارد شده اند می باشد و ناشناس همه کاربرانی سایت را جستجو می کنند که وارد نشده اند می باشد.',
    'securitygroups' => 'گروه های امنیتی',
    'editrootmsg' => "حتی اگر شما یک کاربر مدیر می باشید، نمی توانید یک کاربر ریشه را بدون اینکه خود نخست یک کاربر ریشه باشید ویرایش کنید. شما می توانید همه کاربران دیگر را ویرایش کنید به غیر از کاربران ریشه. لطفا توجه داشته باشید که همه تلاش ها برای ویرایش غیر قانونی کاربران ریشه ضبط شده اند. لطفا به <a href=\"{$_CONF['site_admin_url']}/user.php\">صفحه مدیریت کاربر</a> بازگردید.",
    'securitygroupsmsg' => 'جعبه ها را برای گروه هایی که می خواهید کاربر نیز متعلق به آن باشد را انتخاب کنید. گروه هایی که چک شده اند اما غیرفعالند گروه های هسته می باشند که نیاز می باشند یا گروه های به ارث برده از گروه های دیگر که کاربر به صورت مستقیم متعلق به آنها است.',
    'groupeditor' => 'ویرایشگر گروه',
    'description' => 'شرح',
    'name' => 'نام',
    'rights' => 'حقوق',
    'missingfields' => 'رشته های مفقود',
    'missingfieldsmsg' => 'باید نام و شرح برای یک گروه تهیه کنید',
    'groupmanager' => 'مدیریت گروه',
    'newgroupmsg' => 'برای تغییر یا حذف یک گروه، روی نقشک ویرایش آن گروه در زیر کلیک کنید. برای ایجاد یک گروه جدید، روی "ایجاد جدید" در بالا کلیک کنید. لطفا توجه داشته باشید که گروه های هسته نمی توانند حذف شوند زیرا آنها توسط سیستم استفاده شدند.',
    'groupname' => 'نام گروه',
    'coregroup' => 'گروه هسته',
    'yes' => 'بله',
    'no' => 'خیر',
    'corerightsdescr' => "این گروه یک گروه هسته {$_CONF['site_name']} است. بنابراین حقوق این گروه را نمی توان ویرایش کرد. در زیر یک فهرست فقط خواندنی از حقوق است که این گروه به آن دسترسی دارد.",
    'groupmsg' => 'گروه های امنیتی در این سایت سلسله مراتبی می باشند. با افزودن این گروه به هر یک از گروه های زیر شما به این گروه همان حقوقی را خواهید داد که آن گروه‌ ها دارند. جایی که امکان دارد تشویق می شود که از گروه های زیر برای دادن حقوق به یک گروه استفاده کنید. اگر به این گروه نیاز دارید که حقوق سفارشی داشته باشید سپس می توانید حقوق مربوط به ویژگی های مختلف سایت را در قسمت زیر به نام \'Rights\' انتخاب کنید. برای افزودن این گروه به هر یک از موارد زیر بسادگی فقط کادر کنار گروه(های) مورد نظر را علامت بزنید. گروه هایی که علامت زده شده اند اما غیرفعال می باشند گروه های وارث از گروه های دیگر که مستقیما به این گروه تعلق دارند می باشند.',
    'coregroupmsg' => "این گروه یک گروه هسته {$_CONF['site_name']} است. بنابراین گروه هایی که این گروه به آنها تعلق دارد نمی توانند ویرایش شوند. در زیر یک فهرست فقط خواندنی از گروه هایی است که این گروه متعلق به آن است.",
    'rightsdescr' => 'یک دسترسی گروه به یک حق مشخص در زیر می تواند به صورت مستقیم به گروه یا به یک گروه متفاوت که این گروه بخشی از آن است داده شود. مواردی که در زیر با یک جعبه غیرفعال شده (که علامت زده شده است) را می بینید حقوقی می باشند که به این گروه داده شده است زیرا به گروه دیگری با این حق تعلق دارد. حقوق با جعبه های در زیر حقوقی می باشند که می توانند به صورت مستقیم به این گروه داده شوند.',
    'lock' => 'قفل',
    'members' => 'اعضا',
    'anonymous' => 'ناشناس',
    'permissions' => 'مجوز ها',
    'permissionskey' => 'R = read, E = edit, edit rights assume read rights',
    'edit' => 'ویرایش',
    'none' => 'هیچ یک',
    'accessdenied' => 'دسترسی ممنوع است',
    'storydenialmsg' => "شما برای دیدن این مقاله دسترسی ندارید. این می‌تواند به این دلیل باشد که شما یک عضو {$_CONF['site_name']} نمی باشید. لطفا <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">یک عضو شوید</a> از {$_CONF['site_name']} برای دریافت دسترسی کامل عضویت!",
    'nogroupsforcoregroup' => 'این گروه به هیچ یک از گروه های دیگر متعلق نمی باشد',
    'grouphasnorights' => 'این گروه به هیچ یک از امکانات اداری این سایت دسترسی ندارد',
    'newgroup' => 'گروه جدید',
    'adminhome' => 'خانه مدیر',
    'save' => 'ذخیره',
    'cancel' => 'لغو',
    'delete' => 'حذف',
    'canteditroot' => 'تلاش کرده اید گروه ریشه را ویرایش کنید اما خودتان در گروه ریشه نمی باشید، بنابراین دسترسی شما به این گروه ممنوع است. اگر احساس می کنید این یک خطا است لطفا با مدیر سیستم تماس بگیرید.',
    'listusers' => 'اعضا',
    'listthem' => 'فهرست',
    'usersingroup' => 'کاربران در گروه "%s"',
    'usersingroupmsg' => 'یک فهرستی از کاربران که متعلق به گروه می باشند. فهرست های کاربران اینجا ممکن است مستقیما متعلق به گروه باشند یا از گروه دیگری که به این گروه افزوده شده است به ارث برده شدند.',
    'usergroupadmin' => 'مدیریت گروه کاربر',
    'add' => 'افزودن',
    'remove' => 'برداشتن',
    'availmembers' => 'اعضای موجود',
    'groupmembers' => 'اعضای گروه',
    'inheritmembers' => 'اعضای گروه به ارث رسیده',
    'canteditgroup' => 'برای ویرایش این گروه، باید عضو این گروه باشید. اگر احساس می کنید این یک خطا است لطفا با مدیر سیستم تماس بگیرید.',
    'cantlistgroup' => 'برای دیدن اعضای این گروه، باید خود یک عضو باشید. اگر احساس می کنید این یک خطا است لطفا با مدیر سیستم تماس بگیرید.',
    'editgroupmsg' => 'برای تغییر عضویت گروه، روی نام اعضا کلیک کنید و از دکمه های افزودن یا برداشتن استفاده کنید. اگر عضو یک جزء از گروه باشد، نام آنها فقط در سمت راست ظاهر خواهد شد. یکبار که کامل کردید - <b>ذخیره</b> را برای بروزرسانی گروه و بازگشت به صفحه مدیریت گروه اصلی فشار دهید.<br' . XHTML . '><br' . XHTML . '>اعضای گروه وارث فقط می توانند بواسطه ویرایش گروه که در واقع متعلق به آنها نیز می باشند برداشته شوند و فقط در اینجا برای اهداف اطلاعاتی نشان داده شده اند. به خاطر داشته باشید که یک کاربر می تواند هر دو حالت یک عضو گروه فعلی باشد و هنوز از گروه دیگری نیز به ارث برده شود.',
    'listgroupmsg' => 'فهرست نویسی همه اعضای فعلی در گروه: <b>%s</b>',
    'search' => 'جستجو',
    'submit' => 'ارسال',
    'limitresults' => 'محدود کردن نتایج',
    'group_id' => 'شناسه گروه',
    'plugin_access_denied_msg' => 'شما به صورت غیرقانونی تلاش در دسترسی به یک صفحه مدیریت افزونه دارید. لطفا توجه داشته باشید که همه تلاش ها برای دسترسی غیرقانونی به این صفحه ضبط شدند.',
    'groupexists' => 'نام گروه در حال حاضر وجود دارد',
    'groupexistsmsg' => '.گروهی با این نام از قبل وجود دارد. نام های گروه باید منحصر به فرد باشد',
    'demo_mode_denied_msg' => '.این ویژگی در حال حاضر غیرفعال است در حالی که سایت در حالت نمایشی است'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'database_admin' => 'مدیریت پایگاه داده',
    'last_ten_backups' => 'پشتیبان های پایگاه داده',
    'site_db_backup' => "{$_CONF['site_name']} Database Backup",
    'create_backup' => 'پایگاه داده پشتیبان',
    'do_backup' => 'انجام پشتیبان گیری',
    'backup_successful' => 'پشتیبان پایگاه داده موفق بود.',
    'backup_error' => 'Error performing database backup.',
    'db_explanation' => 'برای ایجاد یک پشتیبان جدید از پایگاه داده سایت خود، گزینه "پایگاه داده پشتیبان" را در بالا انتخاب کنید. برای بارگیری یک پشتیبان، روی نام پرونده از فهرست زیر کلیک کنید.',
    'backup_instructions' => 'برای ایجاد یک پشتیبان جدید از پایگاه داده سایت خود، دکمه "انجام پشتیبان گیری" را در زیر انتخاب کنید. این همه جداول فعلی گیکلاگ را پشتیبان می گیرد. شما می توانید نسخه پشتیبان را از صفحه اصلی مدیریت پایگاه داده بارگیری کنید.',
    'zero_size' => 'پشتیبان ناموفق: حجم پرونده 0 بایت بود',
    'path_not_found' => "{$_CONF['backup_path']} وجود ندارد و یا یک پوشه نمی باشد",
    'no_access' => "خطا: پوشه {$_CONF['backup_path']} در دسترس نمی باشد.",
    'backup_file' => 'پرونده پشتیبان',
    'size' => 'اندازه',
    'bytes' => 'بایت ها',
    'total_number' => 'تعداد کل پشتیبان ها: %d',
    'download' => 'کلیک برای بارگیری این پرونده',
    'convert_menu' => 'تبدیل به InnoDB',
    'convert_title' => 'تبدیل به جداول InnoDB',
    'convert_myisam_menu' => 'تبدیل به MyISAM',
    'convert_myisam_title' => 'تبدیل به جداول MyISAM',
    'convert_button' => 'تبدیل',
    'converting' => 'تبدیل کردن',
    'no_innodb' => 'نسخه MySQL شما از جداول InnoDB پشتیبانی نمی کند.',
    'no_myisam' => 'نسخه MySQL شما از جداول MyISAM پشتیبانی نمی کند.',
    'innodb_instructions' => 'جداول InnoDB می توانند کارکرد بهتر در پایگاه های داده بزرگ فراهم کنند. لطفا <a href="http://dev.mysql.com/doc/refman/5.7/en/converting-tables-to-innodb.html" target="_blank">بخوانید</a> درباره مزایا و اشکالات جداول InnoDB قبل از اینکه یک تبدیل انجام دهید.',
    'myisam_instructions' => 'جداول MyISAM می توانند کارایی بهتر در پایگاه های داده کوچکتر را فراهم کنند.',
    'already_converted' => 'به نظر می رسد که همه جداول از قبل به InnoDB تبدیل شده اند.',
    'already_converted_myisam' => 'به نظر می رسد که همه جداول از قبل به MyISAM تبدیل شده اند.',
    'conversion_message' => 'توجه: تبدیل ممکن است کمی زمان ببرد - لطفا صبور باشید.',
    'innodb_success' => 'جداول با موفقیت به InnoDB تبدیل شدند.',
    'myisam_success' => 'جداول با موفقیت به MyISAM تبدیل شدند.',
    'table_issues' => 'با این وجود، برخی از جداول ممکن است مشکلی داشته باشند. برای جزئیات بیشتر لطفا error.log را بررسی کنید.',
    'optimize_menu' => 'بهینه سازی جداول',
    'optimize_title' => 'بهینه سازی جداول',
    'optimize_button' => 'بهینه',
    'optimizing' => 'بهینه سازی',
    'optimize_explain' => 'بهینه سازی جداول ممکن است به بهبود کارکرد سایت شما کمک کند. تاثیر واقعی بستگی به استفاده از جدول دارد و برخی از جداول ممکن است بیشتر از دیگران سودمند باشد. انتظار نداشته باشید یک تفاوت کلان در کارکرد وجود داشته باشد. <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html" target="_blank">راهنمای MySQL</a> بیان می کند: <q>این احتمالا نیازی به انجام این کار بیشتر از یک بار در هفته یا ماه نمی باشد</q>.',
    'last_optimization' => 'آخرین بهینه سازی',
    'optimization_message' => 'بهینه سازی ممکن است کمی زمان ببرد - لطفا صبور باشید.',
    'optimize_success' => 'جداول پایگاه داده با موفقیت بهینه سازی شدند.',
    'conversion_status' => 'وضعیت تبدیل',
    'optimization_status' => 'وضعیت بهینه سازی',
    'backup_status' => 'وضعیت پشتیبان',
    'backingup' => 'اجرای پشتیبان گیری',
    'backup_title' => 'پشتیبان گیری از پایگاه داده گیکلاگ',
    'backup_warning' => 'توجه: پیکربندی فقط به ساختار های پایگاه داده پشتیبان تنظیم شده است. هیچ داده ای پشتیبان گیری نخواهد شد.',
    'latest_backup' => 'آخرین پشتیبان',
    'tables_to_backup' => 'جداول پشتیبان',
    'include' => 'شامل',
    'exclude' => 'مستثنی',
    'options' => 'گزینه ها',
    'struct_only' => 'فقط ساختار جدول پشتیبان (بدون داده)',
    'max_files' => 'حداکثر پرونده های پشتیبان برای نگهداری',
    'disable_purge' => '("0" برای غیرفعال کردن پاکسازی.)',
    'use_gzip' => ' GZip در صورت موجود بودن استفاده از',
    'configure' => 'پیکربندی',
    'config_instructions' => 'هر جدولی را که می خواهید از پشتیبان مستثنی شود را انتخاب کنید. گزینه های دیگر را می توان در پیکربندی گیکلاگ زیر برگ پایگاه داده یافت.',
    'config_successful' => 'Tables to Backup list was saved successfully.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'خانه',
    2 => 'تماس',
    3 => 'انتشار',
    4 => '',
    5 => '',
    6 => '',
    7 => 'آمار سایت',
    8 => 'شخصی سازی',
    9 => 'جستجو',
    10 => 'جستجوی پیشرفته',
    11 => 'پوشه'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'خطای ۴۰۴',
    2 => '<p>هی، من در همه جا نگاه کردم اما نمی توانم پیدا کنم:</p><p><b>%s</b></p>',
    3 => "<p>متاسفیم اما صفحه ای که درخواست کرده اید وجود ندارد. لطفا راحت باشید به بررسی <a href=\"{$_CONF['site_url']}/\">صفحه اصلی</a> یا <a href=\"{$_CONF['site_url']}/search.php\">صفحه جستجو</a> برای دیدن اینکه اگر می توانید آنچه را که از دست دادید پیدا کنید.",
    4 => "<p>متاسفیم اما صفحه ای که درخواست کرده اید وجود ندارد. توصیه می کنیم برای بازگشت به <a href=\"%s\">صفحه مرتبط</a> یا ممکن است بخواهید بررسی کنید <a href=\"{$_CONF['site_url']}/\">صفحه اصلی</a> یا <a href=\"{$_CONF['site_url']}/search.php\">صفحه جستجو</a> را برای دیدن اینکه اگر می توانید آنچه را که از دست دادید پیدا کنید."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'ورود به سیستم نیاز است',
    2 => 'با عرض پوزش، برای دسترسی به این منطقه، باید به عنوان یک کاربر وارد سیستم شوید.',
    3 => 'ورود',
    4 => 'کاربر جدید'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'دنبالک',
    'from' => 'از جانب',
    'tracked_on' => 'دنبال شده',
    'read_more' => '[بیشتر بخوانید]',
    'intro_text' => 'در اینجا چیزی است که دیگران باید درباره آن بگویند \'%s\':',
    'no_comments' => 'بدون نظرات دنبالک برای این ورودی.',
    'this_trackback_url' => 'نشانی اینترنتی دنبالک برای این ورودی:',
    'num_comments' => '%d نظرات دنبالک',
    'send_trackback' => 'ارسال پینگ ها',
    'preview' => 'پیش نمایش',
    'editor_title' => 'ارسال نظر دنبالک',
    'trackback_url' => 'نشانی اینترنتی دنبالک',
    'entry_url' => 'نشانی اینترنتی ورودی',
    'entry_title' => 'عنوان ورودی',
    'blog_name' => 'نام سایت',
    'excerpt' => 'گزیده',
    'truncate_warning' => 'توجه: سایت دریافت کننده ممکن است قطعه شما را کوتاه کند',
    'button_send' => 'ارسال',
    'button_preview' => 'پیش نمایش',
    'send_error' => 'خطا',
    'send_error_details' => 'خطا هنگام ارسال نظر دنبالک:',
    'url_missing' => 'بدون نشانی اینترنتی ورودی',
    'url_required' => 'لطفا حداقل یک نشانی اینترنتی برای ورودی را وارد کنید.',
    'target_missing' => 'بدون نشانی اینترنتی دنبالک',
    'target_required' => 'لطفا یک نشانی اینترنتی دنبالک وارد کنید',
    'error_socket' => 'پریز باز نشد.',
    'error_response' => 'پاسخ درک نشد.',
    'error_unspecified' => 'خطای نامشخص.',
    'select_url' => 'انتخاب نشانی اینترنتی دنبالک',
    'not_found' => 'نشانی اینترنتی دنبالک یافت نشد',
    'autodetect_failed' => 'گیکلاگ نمی تواند نشانی اینترنتی دنبالک را برای پستی که می خواهید نظرتان را به آن ارسال کنید شناسایی کند. لطفا آن را به صورت دستی در زیر وارد کنید.',
    'trackback_explain' => 'از پیوند زیر، لطفا نشانی اینترنتی که می خواهید نظر دنبالک خود را ارسال کنید انتخاب کنید. سپس گیکلاگ تلاش خواهد کرد نشانی اینترنتی دنبالک درستی برای آن پست مشخص کند یا می توانید <a href="%s">آن را به صورت دستی وارد کنید</a> اگر از قبل آن را می دانید.',
    'no_links_trackback' => 'هیچ پیوند هایی یافت نشد. شما نمی توانید یک نظر دنبالک برای این ورودی ارسال کنید.',
    'pingback' => 'پینگبک',
    'pingback_results' => 'نتایج پینگبک',
    'send_pings' => 'ارسال پینگ ها',
    'send_pings_for' => 'ارسال پینگ ها برای "%s"',
    'no_links_pingback' => 'هیچ پیوند هایی یافت نشد. هیچ پینگبک هایی برای این ورودی ارسال نشده اند.',
    'pingback_success' => 'پینگبک ارسال شد.',
    'no_pingback_url' => 'نشانی اینترنتی پینگبک یافت نشد.',
    'resend' => 'ارسال مجدد',
    'ping_all_explain' => 'هم اکنون می توانید سایت هایی را که به (<a href="http://en.wikipedia.org/wiki/Pingback">پینگبک</a>) پیوند دادید آگاه سازید، تبلیغ کنید که سایت شما توسط پینگ کردن خدمات پوشه وبلاگ به روز شده است و یا ارسال یک نظر <a href="http://en.wikipedia.org/wiki/Trackback">دنبالک</a> در صورت اینکه شما درباره یک پست در سایت شخص دیگری نوشتید.',
    'pingback_button' => 'ارسال پینگبک',
    'pingback_short' => 'ارسال پینگبک ها به همه سایت های پیوند خورده به این ورودی.',
    'pingback_disabled' => '(پینگبک غیرفعال شده)',
    'ping_button' => 'ارسال پینگ',
    'ping_short' => 'پینگ خدمات فهرست وبلاگ.',
    'ping_disabled' => '(پینگ غیرفعال شده)',
    'trackback_button' => 'ارسال دنبالک',
    'trackback_short' => 'ارسال یک نظر دنبالک.',
    'trackback_disabled' => '(دنبالک غیرفعال شده)',
    'may_take_a_while' => 'لطفا توجه داشته باشید که ارسال پینگبک ها و پینگ ها ممکن است کمی زمان ببرد.',
    'ping_results' => 'نتایج پینگ',
    'unknown_method' => 'روش پینگ ناشناخته',
    'ping_success' => 'پینگ ارسال شد.',
    'error_site_name' => 'لطفا نام سایت را وارد کنید.',
    'error_site_url' => 'لطفا نشانی اینترنتی سایت را وارد کنید.',
    'error_ping_url' => 'لطفا یک نشانی اینترنتی پینگ معتبر وارد کنید.',
    'no_services' => 'هیچ خدمات فهرست وبلاگ پیکربندی نشده.',
    'services_headline' => 'خدمات فهرست وبلاگ',
    'service_explain' => 'برای تغییر یا حذف یک سرویس پوشه وبلاگ، روی نقشک ویرایش آن سرویس در زیر کلیک کنید. برای افزودن یک سرویس پوشه وبلاگ جدید، روی "ایجاد جدید" در بالا کلیک کنید.',
    'service' => 'سرویس',
    'ping_method' => 'روش پینگ',
    'service_website' => 'سایت اینترنتی',
    'service_ping_url' => 'نشانی اینترنتی برای پینگ',
    'ping_standard' => 'پینگ استاندارد',
    'ping_extended' => 'پینگ مضاعف',
    'ping_unknown' => '(روش ناشناخته)',
    'edit_service' => 'ویرایش سرویس فهرست وبلاگ',
    'trackbacks' => 'دنبالک ها',
    'editor_intro' => 'نظر دنبالک خود را آماده کنید برای <a href="%s">%s</a>.',
    'editor_intro_none' => 'نظر دنبالک خود را آماده کنید.',
    'trackback_note' => 'برای ارسال یک نظر دنبالک برای یک مقاله، به فهرست مقالات بروید و روی آن کلیک کنید "ارسال پینگ" برای مقاله. برای ارسال یک دنبالک که به یک مقاله مرتبط نمی باشد، <a href="%s">اینجا را کلیک کنید</a>.',
    'pingback_explain' => 'ارسال یک نشانی اینترنتی برای دنبالک. دنبالک به صفحه اصلی سایت شما اشاره خواهد کرد.',
    'pingback_url' => 'نشانی اینترنتی پینگبک',
    'site_url' => 'نشانی اینترنتی این سایت',
    'pingback_note' => 'برای ارسال یک پینگبک برای یک مقاله، به فهرست مقالات بروید و روی آن کلیک کنید "ارسال پینگ" برای مقاله. برای ارسال یک پینگبک که به یک مقاله مرتبط نمی باشد، <a href="%s">اینجا را کلیک کنید</a>.',
    'pbtarget_missing' => 'بدون نشانی اینترنتی پینگبک',
    'pbtarget_required' => 'لطفا یک نشانی اینترنتی پینگبک وارد کنید',
    'pb_error_details' => 'خطا هنگام ارسال پینگبک:',
    'delete_trackback' => 'کلیک برای حذف این دنبالک: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'فهرست مقاله',
    'title_year' => 'فهرست مقاله برای %d',
    'title_month_year' => 'فهرست مقاله برای %s %d',
    'nav_top' => 'برگشت به فهرست مقاله',
    'no_articles' => '.بدون مقالات'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'بررسی امنیتی گیکلاگ',
    'results' => 'نتایج بررسی امنیتی',
    'okay' => 'همه چیز در نظم و ترتیب به نظر می رسد.',
    'please_fix' => '!لطفا قبل از استفاده از سایت خود مسائل بالا را رفع کنید',
    'please_note' => 'لطفا توجه داشته باشید که هیچ سایت 100٪ امن نمی باشد. این اسکریپت فقط می تواند برای مسائل امنیتی واضح آزمايش شود.',
    'stay_informed' => 'برای مطلع ماندن درباره نسخه های جدید گیکلاگ و مسائل امنیتی احتمالی، ما پیشنهاد می کنیم که به فهرست پستی %s (کم ترافیک) مشترک شوید و یا از گزینه %s در منوی مدیریت خود به صورت مرتب برای بررسی بروزرسانی های موجود استفاده کنید.',
    'public_html' => '"public_html" هرگز نباید بخشی از نشانی سایت شما باشد. لطفا بخش درباره public_html در %s را مجدد بخوانید و برپایی خود را نتیجتا قبل از اقدام تغییر دهید.',
    'installation' => 'دستورالعمل های نصب',
    'directory' => 'پوشه',
    'failed_tmp' => 'ناموفق برای ایجاد یک پرونده موقت در %s پوشه شما. مجوز های پوشه خود را بررسی کنید!',
    'fix_it' => '!این یک خطر امنیتی است و باید برطرف شود',
    'reachable' => '%s شما از اینترنت قابل دسترسی است.',
    'not_reachable' => 'خوب! %s شما از اینترنت غیر قابل دسترسی است.',
    'not_sure' => 'هنگام تلاش برای آزمایش %s شما یک کد نتیجه HTTP %s دریافت کردید. مطمئن نمی باشید چه چیزی از آن ساخته شود ...',
    'remove_inst' => 'قبل از اینکه سایت خود را بدون هر گونه خطا هایی جاری کنید، باید پوشه نصب %s را بردارید.',
    'remove_inst2' => 'نگه داشتن آن در اطراف اجازه می دهد به توانایی کاربران مخرب برای نابود کردن نصب فعلی، سایت شما را بگیرند یا اطلاعات حساس را بازیابی کنند.',
    'inst_removed' => 'خوب! به نظر می رسد از قبل پوشه نصب را برداشته اید.',
    'fix_password' => 'هنوز <strong>رمز عبور پیشفرض</strong> را از "رمز عبور" در حساب کاربری پیشفرض مدیر تغییر نداده اید.',
    'password_okay' => 'خوب! به نظر می رسد از قبل رمز عبور پیشفرض حساب کاربری را تغییر داده اید.'
);

###############################################################################
# "What's New" Time Strings
# 
# This here determines the order of the sentence "No new articles in 2 hrs"
# order it so it makes sense in your language:
# %i    item, "Articles"
# %n    amount, "2", "20" etc
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n جدید %i در آخرین %t %s',
    'new_last' => 'آخرین %t %s',
    'minutes' => 'دقایق',
    'hours' => 'ساعات',
    'days' => 'روز ها',
    'weeks' => 'هفته ها',
    'months' => 'ماه ها',
    'years' => 'سال ها',
    'minute' => 'دقیقه',
    'hour' => 'ساعت',
    'day' => 'روز',
    'week' => 'هفته',
    'month' => 'ماه',
    'year' => 'سال'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'ژانویه',
    2 => 'فوریه',
    3 => 'مارس',
    4 => 'آوریل',
    5 => 'مه',
    6 => 'ژوئن',
    7 => 'جولای',
    8 => 'آگوست',
    9 => 'سپتامبر',
    10 => 'اکتبر',
    11 => 'نوامبر',
    12 => 'دسامبر'
);

###############################################################################
# Short Month names

$LANG_MONTH_SHORT = array(
    1 => 'Jan',
    2 => 'Feb',
    3 => 'Mar',
    4 => 'Apr',
    5 => 'May',
    6 => 'Jun',
    7 => 'Jul',
    8 => 'Aug',
    9 => 'Sep',
    10 => 'Oct',
    11 => 'Nov',
    12 => 'Decr'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'یکشنبه',
    2 => 'دوشنبه',
    3 => 'سه شنبه',
    4 => 'چهار شنبه',
    5 => 'پنج شنبه',
    6 => 'جمعه',
    7 => 'شنبه'
);

###############################################################################
# Short Weekday Names

$LANG_WEEK_SHORT = array(
    1 => 'Sun',
    2 => 'Mon',
    3 => 'Tue',
    4 => 'Wed',
    5 => 'Thu',
    6 => 'Fri',
    7 => 'Sat'
);

###############################################################################
# AM/PM

$LANG_AMPM = array(
    'am_pm' => array('am' => 'am', 'pm' => 'pm'),
    'AM_PM' => array('am' => 'AM', 'pm' => 'PM')
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'جستجو',
    'limit_results' => 'محدود کردن نتایج',
    'submit' => 'ارسال',
    'edit' => 'ویرایش',
    'edit_adv' => 'ویرایش پیشرفته',
    'admin_home' => 'خانه مدیر',
    'create_new' => 'ایجاد جدید',
    'create_new_adv' => 'ایجاد جدید (پیشرفته)',
    'enabled' => 'فعال شده',
    'disabled' => 'غیرفعال شده',
    'title' => 'عنوان',
    'page_title' => 'عنوان صفحه',
    'type' => 'نوع',
    'topic' => 'موضوع',
    'info' => 'اطلاعات',
    'help_url' => 'نشانی اینترنتی پرونده راهنما',
    'save' => 'ذخیره',
    'cancel' => 'لغو',
    'install' => 'نصب',
    'delete' => 'حذف',
    'deleteitem' => 'حذف',
    'delete_sel' => 'حذف انتخاب شده',
    'copy' => 'نسخه',
    'no_results' => '- هیچ ورودی یافت نشد -',
    'data_error' => 'خطایی در پردازش داده اشتراک وجود داشت. لطفا منبع داده را بررسی کنید.',
    'preview' => 'پیش نمایش',
    'records_found' => 'سوابق یافت شده',
    'addchild' => 'افزودن فرعی',
    'list' => 'فهرست',
    'list_all' => 'فهرست همه',
    'meta_description' => 'شرح متا',
    'meta_keywords' => 'فراکلیدواژه ها',
    'na' => 'قابل اجرا نمی باشد',
    'unavailable' => 'در دسترس نمی باشد',
    'warning' => '!!!',
    'token_expiry' => 'شما وقت دارید تا %s .برای ایجاد تغییرات. پس از آن، نشانگر امنیتی که در این صفحه جاسازی شده است، منقضی خواهد شد و تغییرات را از دست خواهید داد',
    'token_expired' => 'نشانگر امنیتی این عملیات منقضی شده است. لطفا مجدد تصدیق کنید تا ادامه یابد.',
    'reauth_msg' => 'نشانگر امنیتی این عملیات منقضی شده است. اگر می خواهید این عملیات را ادامه دهید، لطفا مجدد در پایین تصدیق کنید. این مطمئن خواهد شد تغییراتی که انجام داده اید، از بین نمی رود.',
    'token_expired_remote_user' => 'نشانگر امنیتی این عملیات منقضی شده است. از آنجا که یک کاربر از راه دور می باشید، نمی توانید مجدد تصدیق اعتبار کنید، بنابراین تغییرات خود را از دست داده اید.',
    'token_re_authentication_error' => 'There was an error after your account was re-authenticated. It is unclear if the operation you were performing was executed or not.',
    'authenticate' => 'تصدیق',
    'approve' => 'تأیید',
    'device' => 'دستگاه',
    'device_desc' => 'برای چه وسیله ای می خواهید این مورد را نمایش دهید؟',
    'for_all' => 'همه',
    'for_mobile' => 'برای گوشی',
    'for_computer' => 'برای رایانه',
    'all' => 'همه',
    'mobile' => 'گوشی',
    'computer' => 'رایانه',
    'edit_access_only' => 'Edit Access Only'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'نظرات فعال شده',
    -1 => 'نظرات غیرفعال شده',
    1 => 'نظرات بسته شده'
);

$LANG_commentmodes = array(
    'flat' => 'یکدست',
    'nested' => 'تو در تو',
    'threaded' => 'موضوعی',
    'nocomment' => 'بدون نظرات'
);

$LANG_cookiecodes = array(
    0 => '(خیر)',
    3600 => '۱ ساعت',
    7200 => '۲ ساعت',
    10800 => '۳ ساعت',
    28800 => '۸ ساعت',
    86400 => '۱ روز',
    604800 => '۱ هفته',
    2678400 => '۱ ماه'
);

$LANG_dateformats = array(
    0 => 'پیشفرض سیستم'
);

$LANG_featurecodes = array(
    0 => 'ویژه نمی باشد',
    1 => 'ویژه'
);

$LANG_frontpagecodes = array(
    0 => 'نمایش فقط در موضوع',
    1 => 'نمایش در صفحه اول'
);

$LANG_postmodes = array(
    'plaintext' => 'متن قدیمی ساده',
    'html' => 'HTML قالب'
);

$LANG_sortcodes = array(
    'ASC' => 'اول قدیمی ترین ها',
    'DESC' => 'اول جدیدترین ها'
);

$LANG_statuscodes = array(
    0 => 'طبیعی',
    1 => 'بروزرسانی',
    10 => 'بایگانی'
);

$LANG_trackbackcodes = array(
    0 => 'دنبالک فعال شده',
    -1 => 'دنبالک غیرفعال شده'
);

$LANG_structureddatatypes = array(
    'none' => 'None',
    'core-webpage' => 'WebPage',
    'core-article' => 'Article',
    'core-newsarticle' => 'NewsArticle',
    'core-blogposting' => 'BlogPosting'
);

$LANG_STRUCT_DATA = array(
    'lang_structured_data_type' => 'Structured Data Type',
    'autotag_desc_structureddata' => '[structureddata:schema_property]Property Value[/structureddata] - Adds a property to the structured data of the content that the autotag is embedded in.'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'خانه',
    'admin_home' => 'مدیریت سایت',
    'sections' => 'بخش های پیکربندی',
    'restore' => 'بازگرداندن',
    'add_element' => 'افزودن عنصر',
    'save_changes' => 'ذخیره تغییرات',
    'reset_form' => 'بازنشانی فرم',
    'changes_made' => 'تغییرات با موفقیت انجام شد برای',
    'title' => 'مدیریت پیکربندی',
    'disable' => 'برای غیرفعال کردن این گزینه کلیک کنید',
    'enable' => 'فعال کردن',
    'default_tab_name' => 'اصلی',
    'search_configuration_label' => 'پیکربندی جستجو',
    'error_validation_occurs' => 'مقادیر پیکربندی نامعتبر وجود دارد. لطفا این رشته ها را اصلاح کنید (فقط روی متغیر پیکربندی کلیک کنید تا شما را به رشته خطا هدایت کند)'
);

$LANG_configsections['Core'] = array(
    'label' => 'گیکلاگ',
    'title' => 'پیکربندی گیکلاگ'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML مسیر',
    'site_url' => 'نشانی اینترنتی سایت',
    'site_admin_url' => 'نشانی اینترنتی مدیر',
    'site_mail' => 'ایمیل سایت',
    'noreply_mail' => 'ایمیل بدون پاسخ',
    'mail_cc_enabled' => 'اجازه ارسال نسخه های کربن',
    'mail_cc_default' => '"نسخه کربن" توسط پیشفرض',
    'mail_charset' => 'مجموعه کاراکتر ایمیل',
    'site_name' => 'نام سایت',
    'site_slogan' => 'شعار',
    'path_site_logo' => 'Site Logo',
    'owner_name' => 'نام مالک',
    'microsummary_short' => 'خلاصه کوتاه',
    'path_log' => 'لاگ',
    'path_language' => 'زبان',
    'backup_path' => 'پشتیبان',
    'path_data' => 'داده',
    'path_images' => 'تصاویر',
    'path_editors' => 'ویراستاران پیشرفته',
    'mail_settings' => 'تنظیمات ایمیل',
    'dbdump_filename_prefix' => 'پیشوند نام پرونده پشتیبان',
    'dbdump_tables_only' => 'فقط ساختار جدول پشتیبان',
    'dbdump_gzip' => ' GZip در صورت موجود بودن استفاده از',
    'dbdump_max_files' => 'حداکثر پرونده های پشتیبان برای نگهداری',
    'theme' => 'زمینه',
    'doctype' => 'اعلام نوع سند',
    'menu_elements' => 'عناصر منو',
    'path_themes' => 'مسیر زمینه ها',
    'cache_templates' => 'قالب های نهانگاه؟',
    'cache_mobile' => 'نهانگاه دستگاه های تلفن همراه به صورت جداگانه؟',
    'cache_resource' => 'ترکیب، خرد و ذخیره سازی پرونده های سی اس اس و جاوا اسکریپت؟',
    'disable_new_user_registration' => 'غیرفعال کردن ثبت نام جدید',
    'allow_user_themes' => 'اجازه دادن به زمینه های کاربر',
    'allow_user_language' => 'اجازه دادن به زبان کاربر',
    'switchlang_homepage' => 'تغییر مجدد راهنمایی کردن بلوک زبان به صفحه اصلی',
    'new_item_set_current_lang' => 'Add Current Language Id to New Item',
    'allow_user_photo' => 'اجازه دادن به عکس کاربر',
    'allow_username_change' => 'اجازه دادن به تغییر نام کاربری',
    'allow_account_delete' => 'اجازه دادن به حذف حساب کاربری',
    'hide_author_exclusion' => 'اجازه دادن به پنهان کردن نویسنده',
    'show_fullname' => 'نمایش نام کامل',
    'show_servicename' => 'نمایش نام سرویس',
    'require_user_email' => 'نیازمند ایمیل کاربر',
    'custom_registration' => 'فعال کردن ثبت سفارشی',
    'user_login_method' => 'روش ورود کاربر',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'google_login' => 'Enable OAuth Login Method Google',
    'google_consumer_key' => 'Google OAuth Consumer Key',
    'google_consumer_secret' => 'Google OAuth Consumer Secret',
    'microsoft_login' => 'Enable OAuth Login Method Microsoft',
    'microsoft_consumer_key' => 'Microsoft OAuth Consumer Key',
    'microsoft_consumer_secret' => 'Microsoft OAuth Consumer Secret',
    'yahoo_login' => 'Enable OAuth Login Method Yahoo',
    'yahoo_consumer_key' => 'Yahoo OAuth Consumer Key',
    'yahoo_consumer_secret' => 'Yahoo OAuth Consumer Secret',
    'github_login' => 'Enable OAuth Login Method GitHub',
    'github_consumer_key' => 'GitHub OAuth Consumer Key',
    'github_consumer_secret' => 'GitHub OAuth Consumer Secret',
    'spamx' => 'اقدامات ضد هرزنامه',
    'sort_admin' => 'مرتب سازی پیوند ها',
    'language' => 'زبان پیشفرض',
    'locale' => 'محلی',
    'date' => 'قالب تاریخ',
    'daytime' => 'قالب هنگام روز',
    'shortdate' => 'قالب تاریخ کوتاه',
    'dateonly' => 'قالب فقط تاریخ',
    'timeonly' => 'قالب فقط زمان',
    'week_start' => 'شروع هفته',
    'hour_mode' => 'حالت ساعت',
    'thousand_separator' => 'جداساز هزارگان',
    'decimal_separator' => 'جداساز دهگان',
    'decimal_count' => 'تعداد دهگان',
    'language_files' => 'پرونده های زبان',
    'languages' => 'زبان ها',
    'timezone' => 'منطقه زمانی',
    'site_disabled_msg' => 'پیام سایت غیرفعال یا نشانی اینترنتی',
    'rootdebug' => 'اشکال زدایی ریشه',
    'cookie_session' => 'نام کوکی نشست',
    'cookie_name' => 'نام کوکی دائمی',
    'cookie_password' => 'نام کوکی رمز عبور',
    'cookie_theme' => 'نام کوکی زمینه',
    'cookie_language' => 'نام کوکی زبان',
    'cookie_tzid' => 'نام کوکی منطقه زمانی',
    'cookie_anon_name' => 'نام کوکی کاربر ناشناس',
    'cookie_ip' => 'جاسازی آیپی توسط کوکی ها؟',
    'default_perm_cookie_timeout' => 'وقفه دائمی',
    'session_cookie_timeout' => 'وقفه نشست',
    'cookie_path' => 'مسیر کوکی',
    'cookiedomain' => 'دامنه کوکی',
    'cookiesecure' => 'کوکی امن',
    'lastlogin' => 'ضبط آخرین ورود به سیستم؟',
    'num_search_results' => 'تعداد نتایج جستجو',
    'loginrequired' => 'ورود نیاز است؟',
    'submitloginrequired' => 'برای ارسال ورود نیاز است؟',
    'commentsloginrequired' => 'برای نظر ورود نیاز است؟',
    'statsloginrequired' => 'برای آمار ورود نیاز است؟',
    'searchloginrequired' => 'برای جستجو ورود نیاز است؟',
    'profileloginrequired' => 'برای مشخصات ورود نیاز است؟',
    'emailuserloginrequired' => 'برای ایمیل به کاربر ورود نیاز است؟',
    'emailstoryloginrequired' => 'برای ایمیل مقاله ورود نیاز است؟',
    'directoryloginrequired' => 'برای پوشه ورود نیاز است؟',
    'storysubmission' => 'صف ارسالی مقاله؟',
    'usersubmission' => 'صف ارسالی کاربر؟',
    'listdraftstories' => 'فهرست مقالات پیش نویس؟',
    'notification' => 'اطلاعیه ها',
    'postmode' => 'حالت پست پیشفرض',
    'speedlimit' => 'محدودیت سرعت ارسال',
    'skip_preview' => 'جست پیش نمایش در پست ها',
    'advanced_editor' => 'ویرایشگر پیشرفته؟',
    'advanced_editor_name' => 'نام ویرایشگر پیشرفته؟',
    'wikitext_editor' => 'ویرایشگر ویکی تکست؟',
    'remove_4byte_chars' => 'برداشتن کاراکتر های ۴ بایت یو تی اف ۸؟',
    'cron_schedule_interval' => 'فاصله زمانی کرون',
    'sortmethod' => 'مرتب سازی موضوعات',
    'showstorycount' => 'نمایش تعداد مقاله؟',
    'showsubmissioncount' => 'نمایش تعداد ارسالی؟',
    'hide_home_link' => 'پنهان کردن پیوند صفحه اصلی؟',
    'whosonline_threshold' => 'آستانه نشست',
    'whosonline_anonymous' => 'پنهان کردن نام های مهمانان؟',
    'whosonline_photo' => 'نمایش تصویر بند انگشتی عکس؟',
    'emailstories' => 'خلاصه روزانه فعال شده؟',
    'emailstorieslength' => 'طول مقالات',
    'emailstoriesperdefault' => 'برای کاربران جدید فعال شود؟',
    'allow_domains' => 'خودکار دامنه ها را مجاز می سازد',
    'disallow_domains' => 'خودکار دامنه ها را غیر مجاز می سازد',
    'newstoriesinterval' => 'فاصله مقالات جدید',
    'newcommentsinterval' => 'فاصله نظرات جدید',
    'newtrackbackinterval' => 'فاصله دنبالک های جدید',
    'hidenewstories' => 'پنهان کردن مقالات جدید',
    'hidenewcomments' => 'پنهان کردن نظرات جدید',
    'hidenewtrackbacks' => 'پنهان کردن دنبالک های جدید',
    'hidenewplugins' => 'پنهان کردن افزونه های جدید',
    'title_trim_length' => 'عنوان کوتاه کردن طول',
    'whatsnew_cache_time' => 'حداکثر زمان حافظه نهان',
    'trackback_enabled' => 'دنبالک فعال شده؟',
    'pingback_enabled' => 'پینگبک فعال شده؟',
    'ping_enabled' => 'پینگ فعال شده؟',
    'trackback_code' => 'پیشفرض دنبالک',
    'multiple_trackbacks' => 'دنبالک های چندگانه',
    'trackbackspeedlimit' => 'محدودیت سرعت دنبالک',
    'check_trackback_link' => 'بررسی دنبالک ها',
    'pingback_self' => 'خود پینگبک؟',
    'pingback_excerpt' => 'ایجاد برگزیدن پینگبک؟',
    'link_documentation' => 'پیوند به مستندات؟',
    'link_versionchecker' => 'پیوند به نسخه بررسی کننده؟',
    'maximagesperarticle' => 'حداکثر تصاویر در هر مقاله',
    'limitnews' => 'مقالات در هر صفحه',
    'minnews' => 'حداقل مقالات در هر صفحه',
    'contributedbyline' => 'نمایش "اعانه شده توسط"؟"',
    'hideviewscount' => 'پنهان کردن دفعه مشاهدات؟',
    'hideemailicon' => 'پنهان کردن نقشک ایمیل؟',
    'hideprintericon' => 'پنهان کردن نقشک چاپ؟',
    'allow_page_breaks' => 'اجازه شکستن های صفحه؟',
    'page_break_comments' => 'نظرات در مقالات چند صفحه ای',
    'article_image_align' => 'تنظیم نقشک موضوع',
    'show_topic_icon' => 'نمایش نقشک موضوع؟',
    'structured_data_type_default' => 'Structured Data Type Default',
    'structured_data_article_topic' => 'Structured Data of Articles in Topics',
    'draft_flag' => 'پیشفرض پرچم پیش نویس',
    'frontpage' => 'پیشفرض صفحه اصلی',
    'hide_no_news_msg' => 'پنهان کردن پیام "بدون خبر"؟',
    'hide_main_page_navigation' => 'پنهان کردن جهت یابی صفحه اصلی؟',
    'onlyrootfeatures' => 'فقط ریشه می تواند ویژگی باشد؟',
    'aftersave_story' => 'پس از ذخیره سازی مقاله',
    'related_topics' => 'موضوعات مرتبط',
    'related_topics_max' => 'حداکثر موضوعات مرتبط برای نمایش',
    'whats_related' => 'آنچه مرتبط است',
    'whats_related_max' => 'حداکثر آنچه مربوط به نمایش است',
    'whats_related_trim' => 'طول آنچه مربوط به عنوان است',
    'default_cache_time_article' => 'زمان پیشفرض حافظه نهان مقاله',
    'blocks_article_topic_list_repeat_after' => 'مقاله موضوع فهرست بلوک ها موقعیت تکرار',
    'aftersave_user' => 'پس از ذخیره سازی کاربر',
    'show_right_blocks' => 'همیشه نمایش بلوک های راست؟',
    'showfirstasfeatured' => 'نمایش اولین مقاله به صورت ویژه؟',
    'template_comments' => 'نظرات قالب در خروجی؟',
    'backend' => 'فعال کردن خوراک ها؟',
    'rdf_file' => 'پوشه خروجی سندیکا',
    'rdf_limit' => 'محدودیت خوراک',
    'rdf_storytext' => 'طول مقالات در خوراک',
    'rdf_language' => 'زبان خوراک',
    'syndication_max_headlines' => 'حداکثر تعداد سرفصل ها (بلوک های درگاه)',
    'comment_feeds_article_tag' => 'برچسب مقاله',
    'comment_feeds_article_tag_position' => 'موقعیت برچسب مقاله',
    'comment_feeds_article_author_tag' => 'برچسب نویسنده مقاله',
    'comment_feeds_comment_author_tag' => 'برچسب نویسنده نظر',
    'copyrightyear' => 'سال حق نشر',
    'image_lib' => 'کتابخانه تصویر',
    'path_to_mogrify' => 'مسیر Mogrify',
    'path_to_netpbm' => 'مسیر Netpbm',
    'debug_image_upload' => 'اشکال زدایی بارگذاری تصویر؟',
    'keep_unscaled_image' => 'نگهداری تصویر مقیاس نشده؟',
    'allow_user_scaling' => 'اجازه دادن کاربر برای مقیاس؟',
    'jpeg_quality' => 'JPEG کیفیت؟',
    'max_image_width' => 'حداکثر عرض تصویر؟',
    'max_image_height' => 'حداکثر ارتفاع تصویر؟',
    'max_image_size' => 'حداکثر اندازه تصویر؟',
    'max_topicicon_width' => 'حداکثر عرض نقشک موضوع؟',
    'max_topicicon_height' => 'حداکثر ارتفاع نقشک موضوع؟',
    'max_topicicon_size' => 'حداکثر اندازه نقشک موضوع؟',
    'max_photo_width' => 'حداکثر عرض عکس؟',
    'max_photo_height' => 'حداکثر ارتفاع عکس؟',
    'max_photo_size' => 'حداکثر اندازه عکس؟',
    'generate_user_icon' => 'Generate User Icon automatically?',
    'use_gravatar' => 'استفاده از گرآواتار؟',
    'gravatar_rating' => 'رتبه گرآواتار',
    'gravatar_identicon' => 'Gravatar Identicon',
    'force_photo_width' => 'تحمیل عرض عکس',
    'default_photo' => 'عکس پیشفرض',
    'commentspeedlimit' => 'محدودیت سرعت نظر',
    'comment_limit' => 'محدودیت نظر',
    'comment_mode' => 'حالت نظر',
    'comment_order' => 'ترتیب نظر',
    'comment_code' => 'پیشفرض نظر',
    'comment_edit' => 'اجازه ویرایش نظر؟',
    'comment_edittime' => 'زمان ویرایش نظر (ثانیه)',
    'commentsubmission' => 'صف ارسالی های نظر',
    'likes_enabled' => 'Likes Enabled',
    'likes_articles' => 'Article Likes',
    'likes_comments' => 'Comment Likes',
    'likes_speedlimit' => 'Likes Speed Limit',
    'likes_users_listed' => 'User Listed',
    'likes_block_cache_time' => 'Cache Time',
    'likes_block_include_time' => 'Include Time',
    'likes_block_max_items' => 'Max Items Listed',
    'likes_block_displayed_actions' => 'Displayed Actions',
    'likes_block_title_trim_length' => 'Title Trim Length',
    'likes_block_likes_new_line' => 'Likes on New Line',
    'likes_block_type' => 'Type',
    'likes_block_subtype' => 'Sub Type',
    'likes_block_enable' => 'Enabled',
    'likes_block_isleft' => 'Display Block on Left',
    'likes_block_order' => 'Block Order',
    'likes_block_topic_option' => 'Topic Options',
    'likes_block_topic' => 'Topic',
    'likes_block_group_id' => 'Group',
    'likes_block_permissions' => 'Permissions',
    'passwordspeedlimit' => 'محدودیت سرعت رمز عبور',
    'login_attempts' => 'حداکثر تلاش های ورود',
    'login_speedlimit' => 'محدودیت سرعت ورود',
    'invalidloginattempts' => 'حداکثر تلاش های ورود نامعتبر',
    'invalidloginmaxtime' => 'حداکثر زمان ورود نامعتبر',
    'enable_twofactorauth' => 'فعال کردن دو عامل تأیید هویت؟',
    'pass_alg' => 'الگوریتم هش رمز عبور',
    'pass_stretch' => 'تعداد کشش هش',
    'user_html' => 'کاربر HTML',
    'admin_html' => 'مدیر HTML',
    'advanced_html' => 'HTML اضافی برای ویرایشگر پیشرفته',
    'skip_html_filter_for_root' => 'پرش تصفیه HTML برای ریشه؟',
    'allowed_protocols' => 'پروتکل های اجازه داده شده',
    'disable_autolinks' => 'غیرفعال کردن برچسب های خودکار؟',
    'clickable_links' => 'قابلیت کلیک ساختن نشانی های اینترنتی؟',
    'linktext_maxlen' => 'حداکثر طول متن پیوند',
    'compressed_output' => 'ارسال خروجی فشرده؟',
    'frame_options' => 'حفاظت در برابر "جک زدن کلیک"',
    'page_navigation_max_pages' => 'حداکثر صفحات برای جهت یابی',
    'page_navigation_mobile_max_pages' => 'حداکثر صفحات برای جهت یابی با دستگاه های سیار',
    'default_cache_time_block' => 'زمان پیشفرض حافظه نهان بلوک',
    'titletoid' => 'فعال کردن عنوان به شناسه؟',
    '404_log' => 'لاگ گیری خطا های ۴۰۴',
    'censormode' => 'حالت سانسور؟',
    'censorreplace' => 'سانسور جایگزین متن',
    'censorlist' => 'فهرست سانسور',
    'ip_lookup' => 'جستجو آیپی',
    'url_rewrite' => 'فعال کردن بازنویسی نشانی اینترنتی',
    'url_routing' => 'فعال کردن مسیریابی نشانی اینترنتی',
    'cdn_hosted' => 'از نسخه میزبانی شده CDN از jQuery و uikit استفاده کنید',
    'meta_tags' => 'برچسب های متا',
    'meta_description' => 'پیشفرض شرح متا',
    'meta_keywords' => 'پیشفرض فراکلیدواژه ها',
    'default_permissions_block' => 'مجوز های پیشفرض بلوک',
    'default_permissions_story' => 'مجوز های پیشفرض مقاله',
    'default_permissions_topic' => 'مجوز های پیشفرض موضوع',
    'atom_max_stories' => 'حداکثر مقالات در خوراک خدمات اینترنتی',
    'disable_webservices' => 'غیرفعال کردن خدمات اینترنتی؟',
    'restrict_webservices' => 'محدود کردن خدمات اینترنتی؟',
    'article_comment_close_enabled' => 'بستن خودکار نظرات (پیشفرض)',
    'article_comment_close_days' => 'روز ها برای بستن نظرات (پیشفرض)',
    'comment_close_rec_stories' => 'تعداد بیشترین مقالات اخیر فعال شده برای نظرات',
    'allow_reply_notifications' => 'اجازه اطلاعیه های پاسخ نظر؟',
    'comment_on_same_page' => 'نظر در همان صفحه؟',
    'show_comments_at_replying' => 'نمایش نظرات در پاسخ دادن؟',
    'search_style' => 'سبک فهرست نتایج',
    'search_limits' => 'محدودیت های صفحه',
    'search_show_num' => 'نمایش شماره نتیجه؟',
    'search_show_type' => 'نمایش نوع نتیجه؟',
    'search_show_sort' => 'اجازه کاربر به مرتب سازی نتایج؟',
    'search_show_limit' => 'نمایش محدودیت های صفحه؟',
    'search_separator' => 'جداساز گروه',
    'search_def_keytype' => 'روش جستجو پیشفرض',
    'search_def_sort' => 'سفارش مرتب سازی پیشفرض',
    'search_use_topic' => 'استفاده موضوع فعلی',
    'autotag_permissions_story' => '[مقاله: ] مجوز ها',
    'autotag_permissions_user' => '[کاربر: ] مجوز ها',
    'autotag_permissions_topic' => '[موضوع: ] مجوز ها',
    'autotag_permissions_related_topics' => '[موضوعات_مرتبط: ] مجوز ها',
    'autotag_permissions_related_items' => '[موارد_مرتبط: ] مجوز ها',
    'autotag_permissions_block' => '[بلوک: ] مجوز ها',
    'autotag_permissions_structureddata' => '[structureddata: ] Permissions',
    'autotag_permissions_likes_block' => '[likes_block: ] Permissions',
    'multiple_breadcrumbs' => 'بردکرامب های چندگانه',
    'disable_breadcrumbs_topics' => 'غیرفعال کردن بردکرامب های موضوع',
    'disable_breadcrumbs_articles' => 'غیرفعال کردن بردکرامب های مقاله',
    'disable_breadcrumbs_plugins' => 'غیرفعال کردن بردکرامب های افزونه',
    'breadcrumb_root_site_name' => 'نام سایت به صورت ریشه بردکرامب؟',
    'filemanager_disabled' => 'غیرفعال کردن مدیریت پرونده؟',
    'filemanager_browse_only' => 'حالت فقط مرور؟',
    'filemanager_default_view_mode' => 'حالت دیدن پیشفرض',
    'filemanager_show_confirmation' => 'نمایش تأیید؟',
    'filemanager_search_box' => 'نمایش جعبه جستجو؟',
    'filemanager_file_sorting' => 'مرتب سازی پرونده',
    'filemanager_chars_only_latin' => 'اجازه کاراکتر های لاتین فقط؟',
    'filemanager_date_format' => 'قالب زمان تاریخ',
    'filemanager_logger' => 'فعال کردن لاگر؟',
    'filemanager_show_thumbs' => 'نمایش ریز عکس ها؟',
    'filemanager_generate_thumbnails' => 'ایجاد ریز عکس ها؟',
    'filemanager_upload_overwrite' => 'بازنویسی پرونده موجود؟',
    'filemanager_upload_file_size_limit' => 'محدودیت حجم بارگذاری پرونده (مگابایت)',
    'filemanager_images_ext' => 'پسوند های پرونده تصویری',
    'filemanager_show_video_player' => 'نمایش پخش کننده ویدئو؟',
    'filemanager_videos_ext' => 'پسوند های پرونده ویدیویی',
    'filemanager_videos_player_width' => 'عرض پخش کننده ویدئو (پیکسل)',
    'filemanager_videos_player_height' => 'ارتفاع پخش کننده ویدئو (پیکسل)',
    'filemanager_show_audio_player' => 'نمایش پخش کننده صوتی؟',
    'filemanager_audios_ext' => 'پسوند های پرونده صوتی',
    'cookie_consent' => 'Enable Cookie Consent',
    'terms_of_use_link' => 'Terms of Use Link',
    'privacy_policy_link' => 'Privacy Policy Link',
    'about_cookies_link' => 'About Cookies Consent Link',
    'ip_anonymization' => 'IP Anonymization'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'سایت',
    'sg_stories' => 'مقالات و دنبالک',
    'sg_theme' => 'زمینه',
    'sg_blocks' => 'بلوک ها',
    'sg_users' => 'کاربران و ارسالی ها',
    'sg_images' => 'تصاویر',
    'sg_locale' => 'زبان ها و محلی',
    'sg_misc' => 'متفرقه',
    'sg_filemanager' => 'مدیریت پرونده'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'سایت',
    'fs_paths' => 'مسیر ها',
    'fs_theme' => 'زمینه',
    'fs_mail' => 'ایمیل',
    'fs_database_backup' => 'پشتیبان پایگاه داده',
    'fs_users' => 'کاربران',
    'fs_misc' => 'متفرقه',
    'fs_spamx' => 'ضد هرزنامه',
    'fs_admin_block' => 'بلوک مدیر',
    'fs_locale' => 'محلی',
    'fs_language' => 'زبان',
    'fs_multilanguage' => 'محتوای چند زبانه',
    'fs_debug' => 'اشکال زدایی',
    'fs_cookies' => 'کوکی ها',
    'fs_login' => 'تنظیمات ورود',
    'fs_search' => 'جستجو',
    'fs_user_submission' => 'ارسالی کاربر',
    'fs_submission' => 'تنظیمات ارسال',
    'fs_topics_block' => 'بلوک موضوعات',
    'fs_whosonline_block' => 'بلوک کاربران آنلاین',
    'fs_daily_digest' => 'خلاصه روزانه',
    'fs_whatsnew_block' => 'بلوک موارد جدید',
    'fs_trackback' => 'دنبالک',
    'fs_pingback' => 'بازگشت پینگ',
    'fs_story' => 'مقاله',
    'fs_theme_advanced' => 'تنظیمات پیشرفته',
    'fs_syndication' => 'سندیکا',
    'fs_syndication_comment' => 'سندیکا نظر',
    'fs_imagelib' => 'کتابخانه تصویر',
    'fs_upload' => 'بارگذاری',
    'fs_articleimg' => 'تصاویر در مقالات',
    'fs_topicicon' => 'نقشک های موضوع',
    'fs_userphoto' => 'عکس ها',
    'fs_gravatar' => 'گرآواتار',
    'fs_comments' => 'نظرات',
    'fs_likes' => 'Likes',
    'fs_likes_block_settings' => 'Block Settings',
    'fs_likes_block_permissions' => 'Block Permissions',
    'fs_htmlfilter' => 'HTML تصفیه کردن',
    'fs_censoring' => 'سانسور کردن',
    'fs_iplookup' => 'جستجو آیپی',
    'fs_perm_story' => 'مجوز پیشفرض مقاله',
    'fs_perm_topic' => 'مجوز پیشفرض موضوع',
    'fs_perm_block' => 'مجوز پیشفرض بلوک',
    'fs_webservices' => 'خدمات اینترنتی',
    'fs_autotag_permissions' => 'مجوز های استفاده از برچسب خودکار',
    'fs_breadcrumbs' => 'بردکرامب ها',
    'fs_pass' => 'تنظیمات رمز عبور',
    'fs_filemanager_general' => 'تنظیمات عمومی',
    'fs_filemanager_upload' => 'بارگذاری',
    'fs_filemanager_images' => 'تصاویر',
    'fs_filemanager_videos' => 'فیلم ها',
    'fs_filemanager_audios' => 'صدا ها'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'سایت',
    'tab_paths' => 'مسیر ها',
    'tab_theme' => 'زمینه',
    'tab_mail' => 'ایمیل',
    'tab_database' => 'پایگاه داده',
    'tab_users' => 'کاربران',
    'tab_misc' => 'متفرقه',
    'tab_spamx' => 'ضد هرزنامه',
    'tab_admin_block' => 'بلوک مدیر',
    'tab_locale' => 'محلی',
    'tab_language' => 'زبان',
    'tab_debug' => 'اشکال زدایی',
    'tab_cookies' => 'کوکی ها',
    'tab_login' => 'تنظیمات ورود',
    'tab_search' => 'جستجو',
    'tab_user_submission' => 'ارسالی کاربر',
    'tab_submission' => 'تنظیمات ارسال',
    'tab_topics_block' => 'بلوک موضوعات',
    'tab_whosonline_block' => 'بلوک کاربران آنلاین',
    'tab_daily_digest' => 'خلاصه روزانه',
    'tab_whatsnew_block' => 'بلوک موارد جدید',
    'tab_trackback' => 'دنبالک',
    'tab_pingback' => 'بازگشت پینگ',
    'tab_story' => 'مقاله',
    'tab_theme_advanced' => 'تنظیمات پیشرفته',
    'tab_syndication' => 'سندیکا',
    'tab_imagelib' => 'کتابخانه تصویر',
    'tab_upload' => 'بارگذاری',
    'tab_articleimg' => 'تصاویر در مقالات',
    'tab_topicicon' => 'نقشک های موضوع',
    'tab_userphoto' => 'عکس ها',
    'tab_gravatar' => 'گرآواتار',
    'tab_comments' => 'نظرات',
    'tab_likes' => 'Likes',
    'tab_htmlfilter' => 'HTML تصفیه کردن',
    'tab_censoring' => 'سانسور کردن',
    'tab_iplookup' => 'جستجو آیپی',
    'tab_permissions' => 'مجوز ها',
    'tab_webservices' => 'خدمات اینترنتی',
    'tab_topics' => 'موضوعات',
    'tab_filemanager_general' => 'تنظیمات عمومی',
    'tab_filemanager_upload' => 'بارگذاری',
    'tab_filemanager_images' => 'تصاویر',
    'tab_filemanager_videos' => 'فیلم ها',
    'tab_filemanager_audios' => 'صدا ها'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html', 'Wiki-style Format' => 'wikitext'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'Login' => 'login', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Articles' => 'article', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user', 'User Updates' => 'user_update'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none'),
    31 => array('Newest First' => 'DESC', 'Oldest First' => 'ASC'),
    32 => array('Disabled' => 0, 'Just Article Pages' => 1, 'Articles and Topics' => 2),
    33 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (No Links)' => 2, 'Enabled (No Outbound Links)' => 3),
    34 => array('grid' => 'grid', 'list' => 'list'),
    35 => array('default' => 'default', 'Name (asc)' => 'NAME_ASC', 'Name (desc)' => 'NAME_DESC', 'Type (asc)' => 'TYPE_ASC', 'Type (desc)' => 'TYPE_DESC', 'Modified (asc)' => 'MODIFIED_ASC', 'Modified (desc)' => 'MODIFIED_DESC'),
    36 => array('False' => 'false', 'Frontpage only' => 'frontpage', 'Frontpage and Topics' => 'frontpage_topics'),
    37 => array('Disabled' => 0, 'Enabled (with "index.php")' => 1, 'Enabled (without "index.php")' => 2),
    38 => array('Mystery Man' => 'mm', 'Identicon' => 'identicon', 'MonsterId' => 'monsterid', 'WAvatar' => 'wavatar', 'Retro' => 'retro'),
    39 => array('None' => '', 'WebPage' => 'core-webpage', 'Article' => 'core-article', 'NewsArticle' => 'core-newsarticle', 'BlogPosting' => 'core-blogposting'),
    40 => array('False' => 0, 'Users and Anonymous' => 1, 'Users Only' => 2),
    41 => array('False' => 0, 'Likes and Dislikes' => 1, 'Likes Only' => 2),
    42 => array('None' => 0, 'Use individual Article Settings' => 1),
    43 => array('All' => 'all', 'Homepage Only' => 'homeonly', 'Select Topics' => 'selectedtopics'),
    44 => array('No access' => 0, 'Read-Only' => 2),
    46 => array('Likes and Dislikes' => 3, 'Likes Only' => 1, 'Dislikes Only' => 2)
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'این رشته شامل یک مقدار نامعتبر است',
    'notEmpty' => 'این رشته نباید خالی باشد',
    'alphaNumeric' => 'این رشته باید حرفی عددی باشد',
    'alphaNumericOrEmpty' => 'This field must be alpha numeric or empty',
    'between' => 'این رشته باید در یک محدوده مشخصی باشد',
    'blank' => 'این رشته باید خالی باشد',
    'comparison' => 'این رشته با عمل مقایسه تطابق ندارد',
    'date' => 'این رشته باید در یک قالب تاریخ باشد',
    'year' => 'این رشته باید در یک قالب سال از قبیل ۲۰۱۰ باشد',
    'yearOrRange' => 'این رشته باید در یک قالب سال از قبیل ۲۰۱۰ یا در محدوده ای مانند ۲۰۱۰ تا ۲۰۱۲ باشد',
    'time' => 'این رشته باید در یک قالب زمان باشد',
    'datetime' => 'این رشته باید در یک قالب تاریخ زمان باشد',
    'boolean' => 'این رشته باید یک نوع داده بولی باشد',
    'decimal' => 'این رشته باید یک نوع داده ده‌دهی باشد',
    'email' => 'این رشته باید یک نشانی ایمیل معتبر داشته باشد',
    'equalTo' => 'این رشته برابر نمی باشد',
    'extension' => 'این رشته فقط پسوند های پرونده مجاز را می پذیرد',
    'ip' => 'این رشته باید در یک قالب معتبر آیپی باشد',
    'minLength' => 'این رشته خیلی کوتاه است',
    'maxLength' => 'این رشته خیلی طولانی است',
    'numeric' => 'این رشته باید عددی باشد',
    'phone' => 'این رشته باید یک شماره تلفن معتبر داشته باشد',
    'range' => 'این رشته باید در یک محدوده مشخصی باشد',
    'url' => 'این رشته باید یک نشانی اینترنتی معتبر داشته باشد',
    'inList' => 'این رشته باید شامل یک فهرست مشخص باشد',
    'mail_settings_backend' => 'این رشته باید یکی از \'smtp\', \'smtps\', \'sendmail\', یا \'mail\' باشد',
    'mail_settings_sendmail_path' => 'این رشته باید شامل یک مسیر معتبر برای دودویی sendmail باشد',
    'mail_settings_host' => 'این رشته باید یک نام میزبان معتبر داشته باشد',
    'mail_settings_port' => 'این رشته باید بین ۰ - ۶۵۵۳۵ باشد',
    'rdf_limit' => 'این رشته باید عددی باشد',
    'path' => 'مسیر وجود ندارد',
    'file' => 'پرونده وجود ندارد',
    'fileName' => 'این رشته باید یک نام پرونده مناسب باشد',
    'search_limits' => 'این رشته باید عددی باشد و با یک کاما جدا شود',
    'num_search_results' => 'این رشته باید عددی باشد و از رشته \'search_limits\' در بالا',
    'theme' => 'زمینه پوشه وجود ندارد',
    'path_themes' => 'مسیر زمینه باید یک مسیر مطلق باشد و اطمینان حاصل شود که آخرین کاراکتر شامل جداکننده پوشه است',
    'path_to_mogrify' => 'شما باید کتابخانه تصویر را به imagemagick تنظیم کنید و این رشته را با مسیر کامل به اجرای mogrify پر کنید',
    'path_to_netpbm' => 'شما باید کتابخانه تصویر را به netpbm تنظیم کنید و این رشته را با پوشه ای در جایی که پرونده های دودویی از بسته Netpbm نگهداری می شوند پر کنید',
    'language' => 'پرونده زبان وجود ندارد',
    'timezone' => 'منطقه زمانی نامعتبر',
    'single_char' => 'این رشته باید یک کاراکتر واحد باشد',
    'page_navigation_max_pages' => 'این رشته باید بین ۲ - ۲۱ باشد',
    'hash' => 'این رشته باید یک تابع مخلوط باشد که توسط نسخه پی اچ پی شما پشتیبانی می شود',
    'config_setting_lang_array' => 'Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value',
    'config_setting_lang_array_element_req' => 'Requires at least one element. Each element requires a unique language shortcut (\'en\', \'de\', etc.) and the corresponding field must contain a value'
);

