require "amrita/template"
include Amrita



TEMPLATE = <<END
<table border="1">
  <tr><th>name</th><th>author</th><th>webpage</tr>
  <tr id=table1>
    <td id="name"></td>
    <td id="author"></td>
    <td><a id="webpage"></a></td>
  </tr>
</table>
END
data = {
   :table1=>[ 
    { 
      :name=>"Ruby", 
      :author=>"matz" , 
      :webpage=> a(:href=>"http://www.ruby-lang.org/") { "Ruby Home Page" },
    },
    { 
      :name=>"perl", 
      :author=>"Larry Wall" ,
      :webpage=> a(:href=>"http://www.perl.com/") { "Perl.com" },
    },
    { 
      :name=>"python", 
      :author=>"Guido van Rossum" ,
      :webpage=> a(:href=>"http://www.python.org/") { "Python Language Website" },
    },
   ] 
}

tmpl = TemplateText.new(TEMPLATE)
tmpl.use_compiler = false
tmpl.expand(STDOUT, data)  # without compiling


tmpl = TemplateText.new(TEMPLATE)
tmpl.use_compiler = true
tmpl.debug_compiler = true
tmpl.set_hint_by_sample_data(data)
tmpl.expand(STDOUT, data)  # with compiled code
puts "----code generated by Amrita(debug mode)-----"
puts tmpl.src
puts "----code generated by Amrita end ------------"

puts "----start benchmark -------"

CNT = 100
#data[:table1] = data[:table1] + data[:table1] + data[:table1] + data[:table1] + data[:table1] # 3 * 5 = 15 lines
#data[:table1] = data[:table1] + data[:table1] # 30 lines
#data[:table1] = data[:table1] + data[:table1] # 60 lines

tmpl = TemplateText.new(TEMPLATE)
tmpl.use_compiler = false
File.open("/dev/null", "w") do |f|
  t = Time.now
  CNT.times  do
    tmpl.expand(f, data)  # without compiling
  end
  puts "#{Time.now-t} seconds for #{CNT} times without compiling"
end

tmpl = TemplateText.new(TEMPLATE)
tmpl.pre_format = true
tmpl.use_compiler = false
File.open("/dev/null", "w") do |f|
  t = Time.now
  CNT.times  do
    tmpl.expand(f, data)  # without compiling
  end
  puts "#{Time.now-t} seconds for #{CNT} times with pre_format"
end


tmpl = TemplateText.new(TEMPLATE)
tmpl.pre_format = true
tmpl.use_compiler = true
File.open("/dev/null", "w") do |f|
  tmpl.expand(f, data)  # compile it before benchmark
  t = Time.now
  CNT.times  do
    tmpl.expand(f, data)  
  end
  puts "#{Time.now-t} seconds for #{CNT} times with pre-compiled code"
end

tmpl = TemplateText.new(TEMPLATE)
tmpl.pre_format = true
tmpl.use_compiler = true
tmpl.set_hint_by_sample_data(data)
File.open("/dev/null", "w") do |f|
  tmpl.expand(f, data)  # compile it before benchmark
  t = Time.now
  CNT.times  do
    tmpl.expand(f, data)  
  end
  puts "#{Time.now-t} seconds for #{CNT} times with pre-compiled code(optimized using sample data)"
end


