/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLStreamWriterImpl
implements XMLStreamWriter {
    protected final Writer writer;
    protected final String encoding;
    protected final boolean prefixDefaulting;
    protected NamespaceContext namespaceContext;
    private LinkedList elements;
    private boolean inStartElement;
    private boolean emptyElement;
    private NamespaceSupport namespaces;

    private final void endStartElement() throws IOException {
        if (!this.inStartElement) {
            return;
        }
        if (this.emptyElement) {
            this.writer.write(47);
            this.elements.removeLast();
            this.namespaces.popContext();
            this.emptyElement = false;
        }
        this.writer.write(62);
        this.inStartElement = false;
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        try {
            this.endStartElement();
            this.namespaces.pushContext();
            this.writer.write(60);
            this.writer.write(localName);
            String[] stringArray = new String[2];
            stringArray[1] = localName;
            this.elements.addLast(stringArray);
            this.inStartElement = true;
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        try {
            boolean isDeclared;
            this.endStartElement();
            this.namespaces.pushContext();
            String prefix = this.getPrefix(namespaceURI);
            boolean bl = false;
            if (prefix != null) {
                bl = true;
            }
            if (!(isDeclared = bl)) {
                if (this.prefixDefaulting) {
                    prefix = "";
                } else {
                    throw new XMLStreamException("namespace " + namespaceURI + " has not been declared");
                }
            }
            this.writer.write(60);
            if (!"".equals(prefix)) {
                this.writer.write(prefix);
                this.writer.write(58);
            }
            this.writer.write(localName);
            if (this.prefixDefaulting && !isDeclared) {
                this.writeNamespace(prefix, namespaceURI);
            }
            this.elements.addLast(new String[]{prefix, localName});
            this.inStartElement = true;
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        try {
            this.endStartElement();
            this.namespaces.pushContext();
            String currentPrefix = this.getPrefix(namespaceURI);
            boolean isCurrent = prefix.equals(currentPrefix);
            this.writer.write(60);
            if (!"".equals(prefix)) {
                this.writer.write(prefix);
                this.writer.write(58);
            }
            this.writer.write(localName);
            if (this.prefixDefaulting && !isCurrent) {
                this.writeNamespace(prefix, namespaceURI);
            }
            this.elements.addLast(new String[]{prefix, localName});
            this.inStartElement = true;
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(namespaceURI, localName);
        this.emptyElement = true;
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.emptyElement = true;
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.emptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        try {
            this.endStartElement();
            String[] element = (String[])this.elements.removeLast();
            this.namespaces.popContext();
            this.writer.write(60);
            this.writer.write(47);
            if (element[0] != null && !"".equals(element[0])) {
                this.writer.write(element[0]);
                this.writer.write(58);
            }
            this.writer.write(element[1]);
            this.writer.write(62);
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        while (!this.elements.isEmpty()) {
            this.writeEndElement();
        }
    }

    public void close() throws XMLStreamException {
        this.flush();
    }

    public void flush() throws XMLStreamException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        try {
            this.writer.write(32);
            this.writer.write(localName);
            this.writer.write(61);
            this.writer.write(34);
            this.writeEncoded(value, true);
            this.writer.write(34);
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        try {
            String currentPrefix = this.getPrefix(namespaceURI);
            if (currentPrefix == null) {
                if (!this.prefixDefaulting) throw new XMLStreamException("namespace " + namespaceURI + " is not bound");
                this.writeNamespace(prefix, namespaceURI);
            } else if (!currentPrefix.equals(prefix)) {
                throw new XMLStreamException("namespace " + namespaceURI + " is bound to prefix " + currentPrefix);
            }
            this.writer.write(32);
            if (!"".equals(prefix)) {
                this.writer.write(prefix);
                this.writer.write(58);
            }
            this.writer.write(localName);
            this.writer.write(61);
            this.writer.write(34);
            this.writeEncoded(value, true);
            this.writer.write(34);
            return;
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        try {
            String prefix = this.getPrefix(namespaceURI);
            if (prefix == null) {
                if (this.prefixDefaulting) {
                    prefix = "";
                    this.writeNamespace(prefix, namespaceURI);
                } else {
                    throw new XMLStreamException("namespace " + namespaceURI + " is not bound");
                }
            }
            this.writer.write(32);
            if (!"".equals(prefix)) {
                this.writer.write(prefix);
                this.writer.write(58);
            }
            this.writer.write(localName);
            this.writer.write(61);
            this.writer.write(34);
            this.writeEncoded(value, true);
            this.writer.write(34);
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (!this.inStartElement) {
            throw new IllegalStateException();
        }
        try {
            if (prefix == null) {
                prefix = "";
            }
            this.setPrefix(prefix, namespaceURI);
            this.writer.write(32);
            this.writer.write("xmlns");
            if (!"".equals(prefix)) {
                this.writer.write(58);
                this.writer.write(prefix);
            }
            this.writer.write(61);
            this.writer.write(34);
            this.writer.write(namespaceURI);
            this.writer.write(34);
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writeNamespace("", namespaceURI);
    }

    public void writeComment(String data) throws XMLStreamException {
        try {
            this.endStartElement();
            if (data != null && data.indexOf("--") != -1) {
                throw new IllegalArgumentException(data);
            }
            this.writer.write("<!--");
            if (data != null) {
                this.writer.write(data);
            }
            this.writer.write("-->");
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, null);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        try {
            this.endStartElement();
            this.writer.write(60);
            this.writer.write(63);
            this.writer.write(target);
            if (data != null) {
                this.writer.write(32);
                this.writer.write(data);
            }
            this.writer.write(63);
            this.writer.write(62);
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeCData(String data) throws XMLStreamException {
        try {
            this.endStartElement();
            if (data.indexOf("]]") != -1) {
                throw new IllegalArgumentException(data);
            }
            this.writer.write("<![CDATA[");
            this.writer.write(data);
            this.writer.write("]]>");
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        try {
            this.writer.write("<!DOCTYPE ");
            this.writer.write(dtd);
            this.writer.write(62);
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        try {
            this.endStartElement();
            this.writer.write(38);
            this.writer.write(name);
            this.writer.write(59);
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(null, null);
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(null, version);
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (version == null) {
            version = "1.0";
        }
        if ((encoding = this.encoding) == null) {
            encoding = "UTF-8";
        }
        if (!"1.0".equals(version) && !"1.1".equals(version)) {
            throw new IllegalArgumentException(version);
        }
        try {
            this.writer.write("<?xml version=\"");
            this.writer.write(version);
            this.writer.write("\" encoding=\"");
            this.writer.write(encoding);
            this.writer.write("\"?>");
            this.writer.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        try {
            this.endStartElement();
            if (text != null) {
                this.writeEncoded(text, false);
            }
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        try {
            this.endStartElement();
            int end = start + len;
            len = 0;
            int i = start;
            while (i < end) {
                char c = text[i];
                if (c == '<' || c == '>' || c == '&') {
                    this.writer.write(text, start, len);
                    if (c == '<') {
                        this.writer.write("&lt;");
                    } else if (c == '>') {
                        this.writer.write("&gt;");
                    } else {
                        this.writer.write("&amp;");
                    }
                    start = i + 1;
                    len = 0;
                } else {
                    ++len;
                }
                ++i;
            }
            if (len > 0) {
                this.writer.write(text, start, len);
            }
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    public String getPrefix(String uri) throws XMLStreamException {
        String prefix = this.namespaces.getPrefix(uri);
        if (prefix == null && this.namespaceContext != null) {
            prefix = this.namespaceContext.getPrefix(uri);
        }
        return prefix;
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (!this.namespaces.declarePrefix(prefix, uri)) {
            throw new XMLStreamException("illegal prefix " + prefix);
        }
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        if (!this.namespaces.declarePrefix("", uri)) {
            throw new XMLStreamException("illegal default namespace prefix");
        }
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.namespaceContext = context;
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException(name);
    }

    private final void writeEncoded(String text, boolean inAttr) throws IOException {
        char[] chars = text.toCharArray();
        int start = 0;
        int end = chars.length;
        int len = 0;
        int i = start;
        while (i < end) {
            char c = chars[i];
            if (c == '<' || c == '>' || c == '&') {
                this.writer.write(chars, start, len);
                if (c == '<') {
                    this.writer.write("&lt;");
                } else if (c == '>') {
                    this.writer.write("&gt;");
                } else {
                    this.writer.write("&amp;");
                }
                start = i + 1;
                len = 0;
            } else if (inAttr && (c == '\"' || c == '\'')) {
                this.writer.write(chars, start, len);
                if (c == '\"') {
                    this.writer.write("&quot;");
                } else {
                    this.writer.write("&apos;");
                }
                start = i + 1;
                len = 0;
            } else {
                ++len;
            }
            ++i;
        }
        if (len > 0) {
            this.writer.write(chars, start, len);
        }
    }

    protected XMLStreamWriterImpl(Writer writer, String encoding, boolean prefixDefaulting) {
        this.writer = writer;
        this.encoding = encoding;
        this.prefixDefaulting = prefixDefaulting;
        this.elements = new LinkedList();
        this.namespaces = new NamespaceSupport();
    }
}

