/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class StringSelection
implements Transferable,
ClipboardOwner {
    static final DataFlavor[] supported_flavors = new DataFlavor[]{DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
    private String data;

    public DataFlavor[] getTransferDataFlavors() {
        return supported_flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int i = 0;
        while (i < supported_flavors.length) {
            if (supported_flavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (DataFlavor.plainTextFlavor == flavor) {
            return new StringReader(this.data);
        }
        return this.data;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public StringSelection(String data) {
        this.data = data;
    }
}

