/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private static final int VIRGIN = 0;
    private static final int LIVING = 1;
    private static final int DYING = 2;
    private static final int DEAD = 3;
    private Cipher cipher;
    private byte[] outBuffer;
    private int outOffset;
    private int outLength;
    private byte[][] inBuffer;
    private int inLength;
    private boolean isStream;
    private int state;

    public int available() throws IOException {
        if (this.isStream) {
            return super.available();
        }
        return this.outLength - this.outOffset;
    }

    public void close() throws IOException {
        super.close();
    }

    public int read() throws IOException {
        if (this.isStream) {
            byte[] buf = new byte[1];
            int in = super.read();
            if (in == -1) {
                return -1;
            }
            buf[0] = (byte)in;
            try {
                this.cipher.update(buf, 0, 1, buf, 0);
            }
            catch (ShortBufferException shouldNotHappen) {
                throw new IOException(shouldNotHappen.getMessage());
            }
            return buf[0] & 0xFF;
        }
        if (this.state == 3) {
            return -1;
        }
        if (this.available() == 0) {
            this.nextBlock();
        }
        if (this.state == 3) {
            return -1;
        }
        return this.outBuffer[this.outOffset++] & 0xFF;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.isStream) {
            len = super.read(buf, off, len);
            try {
                this.cipher.update(buf, off, len, buf, off);
            }
            catch (ShortBufferException shouldNotHappen) {
                throw new IOException(shouldNotHappen.getMessage());
            }
            return len;
        }
        int count = 0;
        while (count < len) {
            if (this.available() == 0) {
                this.nextBlock();
            }
            if (this.state == 3) {
                if (count > 0) {
                    return count;
                }
                return -1;
            }
            int l = Math.min(this.available(), len - count);
            System.arraycopy(this.outBuffer, this.outOffset, buf, count + off, l);
            count += l;
            this.outLength = 0;
            this.outOffset = 0;
        }
        return count;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public long skip(long bytes) throws IOException {
        if (this.isStream) {
            return super.skip(bytes);
        }
        long ret = 0L;
        if (bytes > 0L && this.available() > 0) {
            ret = this.available();
            this.outLength = 0;
            this.outOffset = 0;
        }
        return ret;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int mark) {
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    private final void nextBlock() throws IOException {
        byte[] temp = this.inBuffer[0];
        this.inBuffer[0] = this.inBuffer[1];
        this.inBuffer[1] = temp;
        int count = 0;
        boolean eof = false;
        if (this.state == 0 || this.state == 1) {
            int l;
            do {
                if ((l = this.in.read(this.inBuffer[1], count, this.inBuffer[1].length - count)) != -1) continue;
                eof = true;
                break;
            } while ((count += l) < this.inBuffer[1].length);
        }
        try {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    this.nextBlock();
                    break;
                }
                case 1: {
                    if (eof) {
                        if (count > 0) {
                            this.outOffset = this.cipher.update(this.inBuffer[0], 0, this.inLength, this.outBuffer, 0);
                            this.state = 2;
                            break;
                        }
                        this.outOffset = this.cipher.doFinal(this.inBuffer[0], 0, this.inLength, this.outBuffer, 0);
                        this.state = 3;
                        break;
                    }
                    this.outOffset = this.cipher.update(this.inBuffer[0], 0, this.inLength, this.outBuffer, 0);
                    break;
                }
                case 2: {
                    this.outOffset = this.cipher.doFinal(this.inBuffer[0], 0, this.inLength, this.outBuffer, 0);
                    this.state = 3;
                    break;
                }
            }
        }
        catch (ShortBufferException sbe) {
            throw new IOException(sbe.toString());
        }
        catch (BadPaddingException bpe) {
            throw new IOException(bpe.toString());
        }
        catch (IllegalBlockSizeException ibse) {
            throw new IOException(ibse.toString());
        }
        this.inLength = count;
    }

    public CipherInputStream(InputStream in, Cipher cipher) {
        this(in);
        this.cipher = cipher;
        boolean bl = false;
        if (cipher.getBlockSize() == 1) {
            bl = this.isStream = true;
        }
        if (!bl) {
            this.inBuffer = new byte[2][];
            this.inBuffer[0] = new byte[cipher.getBlockSize()];
            this.inBuffer[1] = new byte[cipher.getBlockSize()];
            this.inLength = 0;
            this.outBuffer = new byte[cipher.getBlockSize()];
            this.outLength = 0;
            this.outOffset = 0;
            this.state = 0;
        }
    }

    protected CipherInputStream(InputStream in) {
        super(in);
    }
}

