/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.tool;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.Frame;
import net.bluecow.spectro.SpectroEditSession;
import net.bluecow.spectro.tool.Tool;

public class RegionFlipTool
implements Tool {
    private ClipPanel clipPanel;
    private Clip clip;
    private final Box settingsPanel = Box.createVerticalBox();
    private final JButton vflipButton = new JButton("Flip vertically");
    private final JButton hflipButton;

    public RegionFlipTool() {
        this.vflipButton.setOpaque(false);
        this.settingsPanel.add(this.vflipButton);
        this.vflipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegionFlipTool.this.vflipRegion();
            }
        });
        this.hflipButton = new JButton("Flip horizontally");
        this.hflipButton.setOpaque(false);
        this.settingsPanel.add(this.hflipButton);
        this.hflipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegionFlipTool.this.hflipRegion();
            }
        });
        this.settingsPanel.add(Box.createGlue());
    }

    public String getName() {
        return "Flip";
    }

    public void activate(SpectroEditSession session) {
        this.clipPanel = session.getClipPanel();
        this.clip = this.clipPanel.getClip();
        this.clipPanel.setRegionMode(true);
    }

    public void deactivate() {
        this.clip = null;
        this.clipPanel = null;
    }

    public JComponent getSettingsPanel() {
        return this.settingsPanel;
    }

    private void vflipRegion() {
        Rectangle region = this.clipPanel.getRegion();
        if (region == null || region.width == 0 || region.height == 0) {
            return;
        }
        Rectangle frameRegion = this.clipPanel.toClipCoords(new Rectangle(region));
        this.clip.beginEdit(frameRegion, "Flip Region Vertically");
        for (int i = 0; i < frameRegion.width; ++i) {
            Frame frame = this.clip.getFrame(frameRegion.x + i);
            for (int j = 0; j < frameRegion.height / 2; ++j) {
                int bottom = frameRegion.y + frameRegion.height - 1 - j;
                int top = frameRegion.y + j;
                double tmp = frame.getReal(bottom);
                frame.setReal(bottom, frame.getReal(top));
                frame.setReal(top, tmp);
            }
        }
        this.clip.endEdit();
    }

    private void hflipRegion() {
        Rectangle region = this.clipPanel.getRegion();
        if (region == null || region.width == 0 || region.height == 0) {
            return;
        }
        Rectangle frameRegion = this.clipPanel.toClipCoords(new Rectangle(region));
        this.clip.beginEdit(frameRegion, "Flip Region Horizontally");
        for (int i = 0; i < frameRegion.width / 2; ++i) {
            Frame lframe = this.clip.getFrame(frameRegion.x + i);
            Frame rframe = this.clip.getFrame(frameRegion.x + frameRegion.width - 1 - i);
            for (int j = frameRegion.y; j < frameRegion.y + frameRegion.height; ++j) {
                double tmp = rframe.getReal(j);
                rframe.setReal(j, lframe.getReal(j));
                lframe.setReal(j, tmp);
            }
        }
        this.clip.endEdit();
    }
}

