<?php
    //
    // formatting.php
    // handles the formatting of posts
	//
	// This file is quite large as a few of the functions are almost exact duplicates of each other.  This was done to make
	// it easy to switch from using Google's rel="nofollow" attribute.  eg, use format_post_nofollow to support using the 
	// attribute, or format_post to not use it.  The lines using the _nofollow functions are noted in blog.php (g_comments, g_reply)
    //
     
    //---------------------------------------------------------------------------------------
    // format_blurcode - implements a bulletin board style post syntax
    //
    //---------------------------------------------------------------------------------------
    function format_blurcode($text )
    {
         
        $blurCodeInArray = array ("[link]",
            "[/link]",
            "[desc]",
            "[img]",
            "[/img]",
            "[quote]",
            "[/quote]",
            "[q]",
            "[/q]",
            "[b]",
            "[/b]",
            "[i]",
            "[/i]",
            "[code]",
            "[/code]",
            "[c]",
            "[/c]",
            "[br]",
            "[u]",
            "[/u]",
            "[ul]",
            "[li]",
            "[/ul]" );
         
        $blurCodeOutArray = array ("<a href='",
            "</a>",
            "'>",
            "<img src='",
            "' alt='image' />",
            "<div class='quote'>",
            "</div>",
            "<div class='quote'>",
            "</div>",
            "<b>",
            "</b>",
            "<i>",
            "</i>",
            "<pre class='code'>",
            "</pre>",
            "<pre class='code'>",
            "</div>",
            "<br />",
            "<u>",
            "</u>",
            "<ul>",
            "<li>",
            "</ul>" );
        $text = str_replace($blurCodeInArray, $blurCodeOutArray, $text);
         
        return $text;
         
    }








	//---------------------------------------------------------------------------------------
    // format_blurcode_nofollow - implements a bulletin board style post syntax, use this version
	// to add the rel='nofollow' attribute to URLs.        //---------------------------------------------------------------------------------------
    function format_blurcode_nofollow($text )
    {
         
        $blurCodeInArray = array ("[link]",
            "[/link]",
            "[desc]",
            "[img]",
            "[/img]",
            "[quote]",
            "[/quote]",
            "[q]",
            "[/q]",
            "[b]",
            "[/b]",
            "[i]",
            "[/i]",
            "[code]",
            "[/code]",
            "[c]",
            "[/c]",
            "[br]",
            "[u]",
            "[/u]",
            "[ul]",
            "[li]",
            "[/ul]" );
         
        $blurCodeOutArray = array ("<a href='",
            "</a>",
            "' rel='nofollow' >",
            "<img src='",
            "' alt='image' />",
            "<div class='quote'>",
            "</div>",
            "<div class='quote'>",
            "</div>",
            "<b>",
            "</b>",
            "<i>",
            "</i>",
            "<pre class='code'>",
            "</pre>",
            "<pre class='code'>",
            "</div>",
            "<br />",
            "<u>",
            "</u>",
            "<ul>",
            "<li>",
            "</ul>" );
        $text = str_replace($blurCodeInArray, $blurCodeOutArray, $text);
         
        return $text;
         
    }


















     
    //---------------------------------------------------------------------------------------
    // format_newlines - replace newlines with HTML breaks
    //
    //---------------------------------------------------------------------------------------
    function format_newlines($text )
    {
        $text = str_replace("\r\n" , "<br />" , $text );
        $text = str_replace("\n" , "<br />" , $text );
        return $text;
    }
     
     
     
    //---------------------------------------------------------------------------------------
    // format_urldetect - detect URLs and make them into working links
    //
    //---------------------------------------------------------------------------------------
    function format_urldetect($text )
    {
        //
        // Let's deal with this one line at a time.  We know lines all end
        // with <br> now, since we just replaced them above.
        //
        $lines = explode('<br />' , $text );
         
        //
        // for all of the lines check to see if there is AT LEAST one http:// in them
        //
        for($j = 0 ; $j < count($lines );
        $j++ )
        {
            if ((strpos($lines[$j], "http:" ) !== false || strpos($lines[$j], "www.") !== false ) && (strpos($lines[$j], "a href") == false) )
            {
                //
                // if there is an http:// in the line, break it into words and find which words have the http://
                //
                $words = explode(" " , $lines[$j] );
                 
                for($i = 0 ; $i < count($words );
                $i++ )
                {
                    if (($pos = strpos($words[$i] , "http:" )) !== false )
                    {
                        $nopunct = trim($words[$i] , ".,!?()[]-" );
                        $words[$i] = str_replace($words[$i] , "<a href='" . $nopunct . "'>" . $words[$i] . "</a>", $words[$i] );
                    }
                    else if(($pos = strpos($words[$i] , "www." )) !== false )
                    {
                        $nopunct = trim($words[$i] , ".,!?()[]-" );
                        $words[$i] = str_replace($words[$i] , "<a href='http://" . $nopunct . "'>" . $words[$i] . "</a>", $words[$i] );
                    }
                     
                }
                $lines[$j] = implode(" " , $words );
            }
        }
         
         
        //
        // bring the lines back together into a post body and return it
        //
        $text = implode('<br />' , $lines );
        return $text;
    }
     
     
    //---------------------------------------------------------------------------------------
    // format_post - applied to post body to perform the desired formatting
    //
    //---------------------------------------------------------------------------------------
    function format_post($text )
    {
        // start_benchmark( "format_post" );
         
        $text = format_newlines($text );
        $text = format_blurcode($text );
        $text = format_urldetect($text );
       
        // stop_benchmark( );
         
         
        return $text;
    }
    
	 




    //---------------------------------------------------------------------------------------
    // format_post_nofollow - applied to post body to perform the desired formatting; this
	// version calls the 'nofollow' version of format_urldetect to place the rel="nofollow"
	// attribute in the link.  Google devised this to prevent comment/trackback spam
    //
    //---------------------------------------------------------------------------------------
    function format_post_nofollow($text )
    {
        // start_benchmark( "format_post" );
         
        $text = format_newlines($text );
        $text = format_blurcode_nofollow($text );
        $text = format_urldetect_nofollow($text );
       
        // stop_benchmark( );
         
         
        return $text;
    }



	//---------------------------------------------------------------------------------------
    // format_urldetect - detect URLs and make them into working links
    //
    //---------------------------------------------------------------------------------------
    function format_urldetect_nofollow($text )
    {
        //
        // Let's deal with this one line at a time.  We know lines all end
        // with <br> now, since we just replaced them above.
        //
        $lines = explode('<br />' , $text );
         
        //
        // for all of the lines check to see if there is AT LEAST one http:// in them
        //
        for($j = 0 ; $j < count($lines );
        $j++ )
        {
            if ((strpos($lines[$j], "http:" ) !== false || strpos($lines[$j], "www.") !== false ) && (strpos($lines[$j], "a href") == false) )
            {
                //
                // if there is an http:// in the line, break it into words and find which words have the http://
                //
                $words = explode(" " , $lines[$j] );
                 
                for($i = 0 ; $i < count($words );
                $i++ )
                {
                    if (($pos = strpos($words[$i] , "http:" )) !== false )
                    {
                        $nopunct = trim($words[$i] , ".,!?()[]-" );
                        $words[$i] = str_replace($words[$i] , "<a href='" . $nopunct . "' rel='nofollow' >" . $words[$i] . "</a>", $words[$i] );
                    }
                    else if(($pos = strpos($words[$i] , "www." )) !== false )
                    {
                        $nopunct = trim($words[$i] , ".,!?()[]-" );
                        $words[$i] = str_replace($words[$i] , "<a href='http://" . $nopunct . "' rel='nofollow' >" . $words[$i] . "</a>", $words[$i] );
                    }
                     
                }
                $lines[$j] = implode(" " , $words );
            }
        }
         
         
        //
        // bring the lines back together into a post body and return it
        //
        $text = implode('<br />' , $lines );
        return $text;
    }






     
    //---------------------------------------------------------------------------------------
    // format_quickquote - adds javascript QuickQuote (tm) links to each paragraph
    //      typically called after format_post has processed the text
    //
    //---------------------------------------------------------------------------------------
    function format_quickquote($text, $poster)
    {
        global $siteSettings;
        $text = format_newlines($text );
        //
        // break the string according to any instances of two <br>'s
        // these indicate a new paragraph basically--whitespace between
        // the things being said
        //
        $stringArray = explode("<br /><br />" , $text );
         
        $arrayLength = count($stringArray);
         
        for ($i = 0; $i < $arrayLength; $i++ )
        {
            //
            // depending on how many <br>'s were put in explode() may have broken the string up
            // into sections without any text--ignore those; who wants to quote whitespace?
            //
            if (empty($stringArray[$i] ) != TRUE && $stringArray[$i] != "<br />" )
            {
                 
                $javaSafeString = htmlspecialchars($stringArray[$i]);
                $javaSafeString = str_replace("'", "\'", $javaSafeString);
                $javaSafeString = str_replace("\r", "", $javaSafeString);
                 
                $javaSafeString = "[quote][i]".$poster." said:[/i][br][br][i]&quot;".$javaSafeString."&quot;[/i][/quote]";
                 
                 
                if ($siteSettings['slickurls'] == TRUE )
                {
                    $file = explode("/" , $_SERVER['SCRIPT_NAME'] );
                    array_pop($file );
                    $path = implode("/", $file );
                    $imgpath = $path . '/' . 'engine/grafts/' . $siteSettings['graft'] . '/images/qq.jpg';
                }
                else
                    $imgpath = 'engine/grafts/' . $siteSettings['graft'] . '/images/qq.jpg';
                 
                 
                $linkQQ = "&nbsp;<a href='#' onClick=\"doIt('$javaSafeString'); return false;\"><img alt='[QuickQuote]' title='QuickQuote the passage' src='" . $imgpath . "' width='12' border='0' /></a>";
                $stringQQ = format_post($stringArray[$i] ) . $linkQQ;
                $stringArray[$i] = $stringQQ;
                 
                 
            }
        }
         
        $text = implode("<br /><br />" , $stringArray );
         
         
        return $text;
         
    }
     
     
     //---------------------------------------------------------------------------------------
    // format_quickquote_nofollow - adds javascript QuickQuote (tm) links to each paragraph
    //      typically called after format_post has processed the text.  Adds the rel="nofollow"
	//		attribute to links.
    //---------------------------------------------------------------------------------------
    function format_quickquote_nofollow($text, $poster)
    {
        global $siteSettings;
        $text = format_newlines($text );
        //
        // break the string according to any instances of two <br>'s
        // these indicate a new paragraph basically--whitespace between
        // the things being said
        //
        $stringArray = explode("<br /><br />" , $text );
         
        $arrayLength = count($stringArray);
         
        for ($i = 0; $i < $arrayLength; $i++ )
        {
            //
            // depending on how many <br>'s were put in explode() may have broken the string up
            // into sections without any text--ignore those; who wants to quote whitespace?
            //
            if (empty($stringArray[$i] ) != TRUE && $stringArray[$i] != "<br />" )
            {
                 
                $javaSafeString = htmlspecialchars($stringArray[$i]);
                $javaSafeString = str_replace("'", "\'", $javaSafeString);
                $javaSafeString = str_replace("\r", "", $javaSafeString);
                 
                $javaSafeString = "[quote][i]".$poster." said:[/i][br][br][i]&quot;".$javaSafeString."&quot;[/i][/quote]";
                 
                 
                if ($siteSettings['slickurls'] == TRUE )
                {
                    $file = explode("/" , $_SERVER['SCRIPT_NAME'] );
                    array_pop($file );
                    $path = implode("/", $file );
                    $imgpath = $path . '/' . 'engine/grafts/' . $siteSettings['graft'] . '/images/qq.png';
                }
                else
                    $imgpath = 'engine/grafts/' . $siteSettings['graft'] . '/images/qq.png';
                 
                 
                $linkQQ = "&nbsp;<a href='#' onClick=\"doIt('$javaSafeString'); return false;\"><img alt='[QuickQuote]' title='QuickQuote the passage' src='" . $imgpath . "' width='12' border='0' /></a>";
                $stringQQ = format_post_nofollow($stringArray[$i] ) . $linkQQ;
                $stringArray[$i] = $stringQQ;
                 
                 
            }
        }
         
        $text = implode("<br /><br />" , $stringArray );
         
         
        return $text;
         
    }
     
     
