#  SecretKeyring.pm
#    - manage a secret GnuPG-based keyring
#
#  Copyright (C) 2000 Frank J. Tobin <ftobin@uiuc.edu>
#
#  This file is part of pgpenvelope
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, visit the following URL:
#  http://www.gnu.org/copyleft/gpl.html
#
#  $Id: SecretKeyring.pm,v 1.1 2001/04/30 02:15:11 ftobin Exp $
#

package PGPEnvelope::SecretKeyring;

push @ISA, 'PGPEnvelope::Keyring';

use strict;

use PGPEnvelope::SecretKey;


sub load_keys
{
    my ( $self, @key_ids ) = @_;
    return unless @key_ids;
    
    print "processing secret keyring...\n";

    $self->clear_keys();
    
    my @keys = $self->gnupg->get_secret_keys( @key_ids );
    
    map { PGPEnvelope::SecretKey->new_from_key( $_ ) } @keys;
    
    $self->push_keys( @keys );
    
    $self->set_keys_loaded();
    $self->clear_indexed_key_info_loaded();
}
