/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GYearType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            if (c == '-' && n4 == 0) {
                ++n3;
            } else if (c < '0' || c > '9') {
                throw new DatatypeException(n4, "invalid GYear value");
            }
            ++n4;
        }
        switch (n2) {
            case 0: {
                String string2 = string.substring(n3, n);
                if (string2.length() >= 4 && Integer.parseInt(string2) != 0) break;
                throw new DatatypeException("invalid GYear value");
            }
            default: {
                throw new DatatypeException("invalid GYear value");
            }
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        try {
            GYear gYear = new GYear();
            gYear.year = Integer.parseInt(string);
            return gYear;
        }
        catch (Exception exception) {
            return null;
        }
    }

    GYearType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gYear"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    static class GYear
    implements Comparable {
        int year;

        public int hashCode() {
            return this.year;
        }

        public boolean equals(Object object) {
            if (object instanceof GYear) {
                boolean bl = false;
                if (((GYear)object).year == this.year) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof GYear) {
                GYear gYear = (GYear)object;
                if (gYear.year == this.year) {
                    return 0;
                }
                return this.year < gYear.year ? -1 : 1;
            }
            return 0;
        }

        GYear() {
        }
    }
}

