/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.Map;
import java.util.WeakHashMap;

public class Prime2 {
    private static final String NAME = "prime";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 5;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private static final int DEFAULT_CERTAINTY = 20;
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2);
    private static final int SMALL_PRIME_COUNT = 1000;
    private static final BigInteger[] SMALL_PRIME = new BigInteger[1000];
    private static final Map knownPrimes;

    private static final void debug(String string) {
        err.println(">>> prime: " + string);
    }

    public static boolean hasSmallPrimeDivisor(BigInteger bigInteger) {
        int n = 0;
        while (n < 1000) {
            BigInteger bigInteger2 = SMALL_PRIME[n];
            if (bigInteger.mod(bigInteger2).equals(ZERO)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean passEulerCriterion(BigInteger bigInteger) {
        int n;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4 = bigInteger3 = bigInteger.subtract(ONE);
        int n2 = bigInteger4.and(BigInteger.valueOf(7L)).intValue();
        int n3 = 1;
        if (n2 != 0) {
            bigInteger4 = bigInteger4.shiftRight(1);
            bigInteger2 = TWO.modPow(bigInteger4, bigInteger);
            if (n2 == 6) {
                if (bigInteger2.bitLength() != 1) {
                    Prime2.debugBI("Fails Euler criterion #1", bigInteger);
                    return false;
                }
                n = 1;
            } else {
                if ((bigInteger2 = bigInteger2.add(ONE)).compareTo(bigInteger) != 0) {
                    Prime2.debugBI("Fails Euler criterion #2", bigInteger);
                    return false;
                }
                n = 1;
                if ((n2 & 4) != 0) {
                    bigInteger4 = bigInteger4.shiftRight(1);
                    n = 2;
                }
            }
        } else {
            bigInteger2 = TWO.modPow(bigInteger4 = bigInteger4.shiftRight(2), bigInteger);
            if (bigInteger2.bitLength() == 1) {
                n3 = 0;
            } else if ((bigInteger2 = bigInteger2.add(ONE)).compareTo(bigInteger) != 0) {
                Prime2.debugBI("Fails Euler criterion #3", bigInteger);
                return false;
            }
            n = bigInteger4.getLowestSetBit();
            bigInteger4 = bigInteger4.shiftRight(n);
            n += 2;
        }
        int n4 = n3;
        while (n4 < 7) {
            bigInteger2 = SMALL_PRIME[n4];
            if ((bigInteger2 = bigInteger2.modPow(bigInteger4, bigInteger)).bitLength() != 1) {
                n2 = n;
                while (bigInteger2.compareTo(bigInteger3) != 0) {
                    if (--n2 == 0) {
                        Prime2.debugBI("Fails Euler criterion #4", bigInteger);
                        return false;
                    }
                    if ((bigInteger2 = bigInteger2.modPow(TWO, bigInteger)).bitLength() != 1) continue;
                    Prime2.debugBI("Fails Euler criterion #5", bigInteger);
                    return false;
                }
            }
            ++n4;
        }
        Prime2.debugBI("Passes Euler criterion", bigInteger);
        return true;
    }

    public static boolean isProbablePrime(BigInteger bigInteger) {
        return Prime2.isProbablePrime(bigInteger, 20);
    }

    public static boolean isProbablePrime(BigInteger bigInteger, int n) {
        if (bigInteger == null) {
            return false;
        }
        if (bigInteger.equals(ZERO) || bigInteger.equals(ONE)) {
            return false;
        }
        int n2 = 0;
        while (n2 < 1000) {
            if (bigInteger.equals(SMALL_PRIME[n2])) {
                return true;
            }
            ++n2;
        }
        WeakReference weakReference = (WeakReference)knownPrimes.get(bigInteger);
        if (weakReference != null && bigInteger.equals(weakReference.get())) {
            return true;
        }
        if (Prime2.hasSmallPrimeDivisor(bigInteger)) {
            return false;
        }
        boolean bl = bigInteger.isProbablePrime(n);
        if (bl && n > 0) {
            knownPrimes.put(bigInteger, new WeakReference(bigInteger));
        }
        return bl;
    }

    private static final void debugBI(String string, BigInteger bigInteger) {
    }

    private Prime2() {
    }

    static {
        long l = -System.currentTimeMillis();
        Prime2.SMALL_PRIME[0] = TWO;
        int n = 3;
        int n2 = 0;
        block0: while (true) {
            Prime2.SMALL_PRIME[++n2] = BigInteger.valueOf(n);
            if (n2 >= 999) break;
            block1: while (true) {
                n += 2;
                int n3 = 1;
                while (true) {
                    int n4;
                    if (n % (n4 = SMALL_PRIME[n3].intValue()) == 0) continue block1;
                    if (n / n4 <= n4) continue block0;
                    ++n3;
                }
                break;
            }
            break;
        }
        l += System.currentTimeMillis();
        knownPrimes = new WeakHashMap();
    }
}

