/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.plain;

import gnu.classpath.SystemProperties;
import gnu.javax.crypto.sasl.NoSuchUserException;
import gnu.javax.crypto.sasl.UserAlreadyExistsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PasswordFile {
    private static String DEFAULT_FILE = SystemProperties.getProperty("gnu.crypto.sasl.plain.password.file", "/etc/tpasswd");
    private Hashtable entries;
    private File passwdFile;
    private long lastmod;

    public synchronized void add(String string, String string2, String[] stringArray) throws IOException {
        this.checkCurrent();
        if (this.entries.containsKey(string)) {
            throw new UserAlreadyExistsException(string);
        }
        if (stringArray.length != 5) {
            throw new IllegalArgumentException("Wrong number of attributes");
        }
        String[] stringArray2 = new String[7];
        stringArray2[0] = string;
        stringArray2[1] = string2;
        System.arraycopy(stringArray, 0, stringArray2, 2, 5);
        this.entries.put(string, stringArray2);
        this.savePasswd();
    }

    public synchronized void changePasswd(String string, String string2) throws IOException {
        this.checkCurrent();
        if (!this.entries.containsKey(string)) {
            throw new NoSuchUserException(string);
        }
        String[] stringArray = (String[])this.entries.get(string);
        stringArray[1] = string2;
        this.entries.remove(string);
        this.entries.put(string, stringArray);
        this.savePasswd();
    }

    public synchronized String[] lookup(String string) throws IOException {
        this.checkCurrent();
        if (!this.entries.containsKey(string)) {
            throw new NoSuchUserException(string);
        }
        return (String[])this.entries.get(string);
    }

    public synchronized boolean contains(String string) throws IOException {
        this.checkCurrent();
        return this.entries.containsKey(string);
    }

    private final synchronized void update() throws IOException {
        this.lastmod = this.passwdFile.lastModified();
        this.readPasswd(new FileInputStream(this.passwdFile));
    }

    private final void checkCurrent() throws IOException {
        if (this.passwdFile.lastModified() > this.lastmod) {
            this.update();
        }
    }

    private final synchronized void readPasswd(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.entries = new Hashtable();
        String[] stringArray = new String[7];
        while ((string = bufferedReader.readLine()) != null) {
            block13: {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
                try {
                    stringArray[0] = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringArray[1] = stringTokenizer.nextToken();
                    if (stringArray[1].equals(":")) {
                        stringArray[1] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[2] = stringTokenizer.nextToken();
                    if (stringArray[2].equals(":")) {
                        stringArray[2] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[3] = stringTokenizer.nextToken();
                    if (stringArray[3].equals(":")) {
                        stringArray[3] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[4] = stringTokenizer.nextToken();
                    if (stringArray[4].equals(":")) {
                        stringArray[4] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[5] = stringTokenizer.nextToken();
                    if (stringArray[5].equals(":")) {
                        stringArray[5] = "";
                    } else {
                        stringTokenizer.nextToken();
                    }
                    stringArray[6] = stringTokenizer.nextToken();
                    if (!stringArray[6].equals(":")) break block13;
                    stringArray[6] = "";
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
            }
            this.entries.put(stringArray[0], stringArray);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void savePasswd() throws IOException {
        block14: {
            if (this.passwdFile == null) return;
            var1_1 = new FileOutputStream(this.passwdFile);
            var2_2 = null;
            try {
                var2_2 = new PrintWriter(var1_1);
                var10_3 = this.entries.keys();
                while (var10_3.hasMoreElements()) {
                    var7_4 = (String)var10_3.nextElement();
                    var8_5 = (String[])this.entries.get(var7_4);
                    var9_6 = new StringBuffer(var8_5[0]);
                    var11_7 = 1;
                    while (var11_7 < var8_5.length) {
                        var9_6.append(":" + var8_5[var11_7]);
                        ++var11_7;
                    }
                    var2_2.println(var9_6.toString());
                }
                var4_10 = null;
                if (var2_2 == null) break block14;
            }
            catch (Throwable var3_8) {
                block17: {
                    var4_9 = null;
                    if (var2_2 == null) break block17;
                    try {
                        var2_2.flush();
                        v0 = null;
                    }
                    catch (Throwable var5_11) {
                        v0 = null;
                    }
                    var6_13 = v0;
                    var2_2.close();
                    throw var3_8;
                }
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (IOException v1) {}
                }
                this.lastmod = this.passwdFile.lastModified();
                throw var3_8;
            }
            try {}
            catch (Throwable var5_12) {
                v2 = null;
lbl48:
                // 2 sources

                var6_14 = v2;
                var2_2.close();
                return;
            }
            var2_2.flush();
            v2 = null;
            ** GOTO lbl48
        }
        if (var1_1 != null) {
            try {}
            catch (IOException v3) {}
            var1_1.close();
        }
        this.lastmod = this.passwdFile.lastModified();
    }

    public PasswordFile() throws IOException {
        this(DEFAULT_FILE);
    }

    public PasswordFile(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public PasswordFile(String string) throws IOException {
        this.passwdFile = new File(string);
        this.update();
    }
}

