/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support.low;

import gnu.javax.swing.text.html.parser.support.low.Buffer;
import gnu.javax.swing.text.html.parser.support.low.Constants;
import gnu.javax.swing.text.html.parser.support.low.Location;
import gnu.javax.swing.text.html.parser.support.low.ParseException;
import gnu.javax.swing.text.html.parser.support.low.Queue;
import gnu.javax.swing.text.html.parser.support.low.Token;
import java.io.IOException;
import java.io.Reader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReaderTokenizer
extends Constants {
    protected boolean advanced;
    protected boolean backupMode;
    Buffer buffer;
    Queue backup;
    Queue queue;
    Reader reader;
    char[] charTokens;
    String[] stringTokens;
    int readerPosition;

    public String getEndOfLineSequence() {
        return this.buffer.getEndOfLineSequence();
    }

    public Token getNextToken() {
        Token token;
        this.advanced = true;
        try {
            if (this.queue.isEmpty()) {
                this.read(1);
            }
            token = !this.queue.isEmpty() ? this.queue.next() : new Token(3, new Location(this.readerPosition));
        }
        catch (IOException iOException) {
            throw new ParseException("IO Exception", iOException);
        }
        if (this.backupMode) {
            this.backup.add(token);
        }
        return token;
    }

    public Token getTokenAhead(int n) {
        try {
            this.read(n - this.queue.size() + 1);
            return this.queue.size() >= n ? this.queue.get(n) : this.eofToken();
        }
        catch (IOException iOException) {
            throw new ParseException("IO Exception", iOException);
        }
    }

    public Token getTokenAhead() {
        try {
            if (this.queue.isEmpty()) {
                this.read(1);
            }
            if (!this.queue.isEmpty()) {
                return this.queue.get(0);
            }
            return this.eofToken();
        }
        catch (IOException iOException) {
            throw new ParseException("IO Exception", iOException);
        }
    }

    public void error(String string, Token token) {
        System.out.println(string);
    }

    public void mark(boolean bl) {
        this.backup.clear();
        this.backupMode = bl;
    }

    public void reset(Reader reader) {
        this.reader = reader;
        this.readerPosition = -1;
        this.buffer.reset();
        this.queue.clear();
    }

    public void reset() {
        if (!this.backupMode) {
            throw new AssertionError((Object)"Call mark(true) before using reset()!");
        }
        this.backupMode = false;
        while (!this.queue.isEmpty()) {
            this.backup.add(this.queue.next());
        }
        Queue queue = this.queue;
        this.queue = this.backup;
        this.backup = queue;
        this.backup.clear();
    }

    void read(int n) throws IOException {
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.readToken();
            ++n2;
        }
    }

    void readToken() throws IOException {
        Token token;
        while ((token = this.tokenMatches()) == null) {
            int n = this.reader.read();
            ++this.readerPosition;
            if (n == 3) {
                n = 32;
            }
            if (n < 0) {
                if (this.buffer.length() == 0) {
                    this.queue.add(this.eofToken());
                    return;
                }
                if (this.buffer.charAt(this.buffer.length() - 1) != '\u0003') {
                    this.buffer.append('\u0003', this.readerPosition++);
                    continue;
                }
                this.buffer.setLength(this.buffer.length() - 1);
                if (this.buffer.length() > 0) {
                    token = new Token(1999, this.buffer.toString(), this.buffer.getLocation(0, this.buffer.length()));
                    this.queue.add(token);
                    this.buffer.setLength(0);
                }
                return;
            }
            this.buffer.append((char)n, this.readerPosition);
        }
    }

    Token tokenMatches() {
        Token token = this.endMatches(this.buffer);
        if (token != null) {
            if (token.kind == 1004) {
                if (this.buffer.charAt(this.buffer.length() - 1) == ';') {
                    this.buffer.setLength(this.buffer.length() - token.getImage().length() - 1);
                } else {
                    this.error("Missing closing semicolon for entity '" + token.getImage() + '\'', token);
                    this.consumeBuffer(token);
                }
            } else {
                this.consumeBuffer(token);
            }
        }
        if (token != null) {
            if (this.buffer.length() > 1) {
                String string = this.buffer.toString();
                string = string.substring(0, string.length() - 1);
                Token token2 = new Token(1999, string, this.buffer.getLocation(0, this.buffer.length));
                this.queue.add(token2);
                this.consumeBuffer(token2);
            }
            this.queue.add(token);
        }
        return token;
    }

    private final void consumeBuffer(Token token) {
        this.buffer.delete(this.buffer.length() - token.getImage().length() - 1, this.buffer.length() - 1);
    }

    private final Token eofToken() {
        return new Token(3, "#", new Location(this.readerPosition));
    }

    private final /* synthetic */ void this() {
        this.buffer = new Buffer();
        this.backup = new Queue();
        this.queue = new Queue();
        this.readerPosition = -1;
    }

    public ReaderTokenizer() {
        this.this();
    }
}

