require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ALTIVEC_H)) {
    eval 'sub _ALTIVEC_H () {1;}' unless defined(&_ALTIVEC_H);
    if(!defined(&__VEC__) || !defined(&__ALTIVEC__)) {
	die("Use\ the\ \"\-maltivec\"\ flag\ to\ enable\ PowerPC\ AltiVec\ support");
    }
    if(!defined(&__APPLE_ALTIVEC__)  && (!defined(&__STRICT_ANSI__) || !defined(&__cplusplus))) {
	eval 'sub vector () { &__vector;}' unless defined(&vector);
	eval 'sub pixel () { &__pixel;}' unless defined(&pixel);
	eval 'sub bool () { &__bool;}' unless defined(&bool);
    }
    eval 'sub __CR6_EQ () {0;}' unless defined(&__CR6_EQ);
    eval 'sub __CR6_EQ_REV () {1;}' unless defined(&__CR6_EQ_REV);
    eval 'sub __CR6_LT () {2;}' unless defined(&__CR6_LT);
    eval 'sub __CR6_LT_REV () {3;}' unless defined(&__CR6_LT_REV);
    require './gcc-12/rs6000-vecdefines.ph';
    eval 'sub vec_lvx () { &vec_ld;}' unless defined(&vec_lvx);
    eval 'sub vec_lvxl () { &vec_ldl;}' unless defined(&vec_lvxl);
    eval 'sub vec_stvx () { &vec_st;}' unless defined(&vec_stvx);
    eval 'sub vec_stvxl () { &vec_stl;}' unless defined(&vec_stvxl);
    eval 'sub vec_vaddcuw () { &vec_addc;}' unless defined(&vec_vaddcuw);
    eval 'sub vec_vand () { &vec_and;}' unless defined(&vec_vand);
    eval 'sub vec_vandc () { &vec_andc;}' unless defined(&vec_vandc);
    eval 'sub vec_vcmpbfp () { &vec_cmpb;}' unless defined(&vec_vcmpbfp);
    eval 'sub vec_vcmpgefp () { &vec_cmpge;}' unless defined(&vec_vcmpgefp);
    eval 'sub vec_vctsxs () { &vec_cts;}' unless defined(&vec_vctsxs);
    eval 'sub vec_vctuxs () { &vec_ctu;}' unless defined(&vec_vctuxs);
    eval 'sub vec_vexptefp () { &vec_expte;}' unless defined(&vec_vexptefp);
    eval 'sub vec_vlogefp () { &vec_loge;}' unless defined(&vec_vlogefp);
    eval 'sub vec_vmaddfp () { &vec_madd;}' unless defined(&vec_vmaddfp);
    eval 'sub vec_vmhaddshs () { &vec_madds;}' unless defined(&vec_vmhaddshs);
    eval 'sub vec_vmhraddshs () { &vec_mradds;}' unless defined(&vec_vmhraddshs);
    eval 'sub vec_vmladduhm () { &vec_mladd;}' unless defined(&vec_vmladduhm);
    eval 'sub vec_vnmsubfp () { &vec_nmsub;}' unless defined(&vec_vnmsubfp);
    eval 'sub vec_vnor () { &vec_nor;}' unless defined(&vec_vnor);
    eval 'sub vec_vor () { &vec_or;}' unless defined(&vec_vor);
    eval 'sub vec_vperm () { &vec_perm;}' unless defined(&vec_vperm);
    eval 'sub vec_vpkpx () { &vec_packpx;}' unless defined(&vec_vpkpx);
    eval 'sub vec_vrefp () { &vec_re;}' unless defined(&vec_vrefp);
    eval 'sub vec_vrfim () { &vec_floor;}' unless defined(&vec_vrfim);
    eval 'sub vec_vrfin () { &vec_round;}' unless defined(&vec_vrfin);
    eval 'sub vec_vrfip () { &vec_ceil;}' unless defined(&vec_vrfip);
    eval 'sub vec_vrfiz () { &vec_trunc;}' unless defined(&vec_vrfiz);
    eval 'sub vec_vrsqrtefp () { &vec_rsqrte;}' unless defined(&vec_vrsqrtefp);
    eval 'sub vec_vsel () { &vec_sel;}' unless defined(&vec_vsel);
    eval 'sub vec_vsldoi () { &vec_sld;}' unless defined(&vec_vsldoi);
    eval 'sub vec_vsl () { &vec_sll;}' unless defined(&vec_vsl);
    eval 'sub vec_vslo () { &vec_slo;}' unless defined(&vec_vslo);
    eval 'sub vec_vspltisb () { &vec_splat_s8;}' unless defined(&vec_vspltisb);
    eval 'sub vec_vspltish () { &vec_splat_s16;}' unless defined(&vec_vspltish);
    eval 'sub vec_vspltisw () { &vec_splat_s32;}' unless defined(&vec_vspltisw);
    eval 'sub vec_vsr () { &vec_srl;}' unless defined(&vec_vsr);
    eval 'sub vec_vsro () { &vec_sro;}' unless defined(&vec_vsro);
    eval 'sub vec_vsubcuw () { &vec_subc;}' unless defined(&vec_vsubcuw);
    eval 'sub vec_vsum2sws () { &vec_sum2s;}' unless defined(&vec_vsum2sws);
    eval 'sub vec_vsumsws () { &vec_sums;}' unless defined(&vec_vsumsws);
    eval 'sub vec_vxor () { &vec_xor;}' unless defined(&vec_vxor);
    eval 'sub vec_vclz () { &vec_cntlz;}' unless defined(&vec_vclz);
    eval 'sub vec_vgbbd () { &vec_gb;}' unless defined(&vec_vgbbd);
    eval 'sub vec_vmrgew () { &vec_mergee;}' unless defined(&vec_vmrgew);
    eval 'sub vec_vmrgow () { &vec_mergeo;}' unless defined(&vec_vmrgow);
    eval 'sub vec_vpopcntu () { &vec_popcnt;}' unless defined(&vec_vpopcntu);
    eval 'sub vec_vrld () { &vec_rl;}' unless defined(&vec_vrld);
    eval 'sub vec_vsld () { &vec_sl;}' unless defined(&vec_vsld);
    eval 'sub vec_vsrd () { &vec_sr;}' unless defined(&vec_vsrd);
    eval 'sub vec_vsrad () { &vec_sra;}' unless defined(&vec_vsrad);
    eval 'sub vec_extract_fp_from_shorth () { &vec_extract_fp32_from_shorth;}' unless defined(&vec_extract_fp_from_shorth);
    eval 'sub vec_extract_fp_from_shortl () { &vec_extract_fp32_from_shortl;}' unless defined(&vec_extract_fp_from_shortl);
    eval 'sub vec_vctz () { &vec_cnttz;}' unless defined(&vec_vctz);
    eval 'sub vec_cpsgn {
        my($x,$y) = @_;
	    eval q( &__builtin_vec_copysign($y,$x));
    }' unless defined(&vec_cpsgn);
    eval 'sub vec_rlnm {
        my($a,$b,$c) = @_;
	    eval q(( &__builtin_vec_rlnm(($a),(($c)<<8)|($b))));
    }' unless defined(&vec_rlnm);
    if(defined(&__VSX__)) {
	eval 'sub vec_vsx_ld () { &__builtin_vec_vsx_ld;}' unless defined(&vec_vsx_ld);
	eval 'sub vec_vsx_st () { &__builtin_vec_vsx_st;}' unless defined(&vec_vsx_st);
	eval 'sub __builtin_vec_xl () { &__builtin_vec_vsx_ld;}' unless defined(&__builtin_vec_xl);
	eval 'sub __builtin_vec_xst () { &__builtin_vec_vsx_st;}' unless defined(&__builtin_vec_xst);
	eval 'sub __builtin_bcdadd_ofl () { &__builtin_vec_bcdadd_ov;}' unless defined(&__builtin_bcdadd_ofl);
	eval 'sub __builtin_bcdsub_ofl () { &__builtin_vec_bcdsub_ov;}' unless defined(&__builtin_bcdsub_ofl);
	eval 'sub __builtin_bcdcmpeq {
	    my($a,$b) = @_;
    	    eval q( &__builtin_vec_bcdsub_eq($a,$b,0));
	}' unless defined(&__builtin_bcdcmpeq);
	eval 'sub __builtin_bcdcmpgt {
	    my($a,$b) = @_;
    	    eval q( &__builtin_vec_bcdsub_gt($a,$b,0));
	}' unless defined(&__builtin_bcdcmpgt);
	eval 'sub __builtin_bcdcmplt {
	    my($a,$b) = @_;
    	    eval q( &__builtin_vec_bcdsub_lt($a,$b,0));
	}' unless defined(&__builtin_bcdcmplt);
	eval 'sub __builtin_bcdcmpge {
	    my($a,$b) = @_;
    	    eval q( &__builtin_vec_bcdsub_ge($a,$b,0));
	}' unless defined(&__builtin_bcdcmpge);
	eval 'sub __builtin_bcdcmple {
	    my($a,$b) = @_;
    	    eval q( &__builtin_vec_bcdsub_le($a,$b,0));
	}' unless defined(&__builtin_bcdcmple);
    }
    eval 'sub __builtin_vec_se_lxvrx () { &__builtin_vec_xl_sext;}' unless defined(&__builtin_vec_se_lxvrx);
    eval 'sub __builtin_vec_tr_stxvrx () { &__builtin_vec_xst_trunc;}' unless defined(&__builtin_vec_tr_stxvrx);
    eval 'sub __builtin_vec_ze_lxvrx () { &__builtin_vec_xl_zext;}' unless defined(&__builtin_vec_ze_lxvrx);
    eval 'sub __builtin_vsx_xxpermx () { &__builtin_vec_xxpermx;}' unless defined(&__builtin_vsx_xxpermx);
    if(defined(&__cplusplus__)) {
	eval 'sub __altivec_unary_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T> \'int\' $NAME ( &T  &a1) {  &return $CALL; });
	}' unless defined(&__altivec_unary_pred);
	eval 'sub __altivec_scalar_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T,  &class  &U> \'int\' $NAME ( &T  &a1,  &U  &a2) {  &return $CALL; });
	}' unless defined(&__altivec_scalar_pred);
	eval 'sub __altivec_binary_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T,  &class  &U>  &typename  &__altivec_bool_ret < &vec_step ( &T)>:: &__ret $NAME ( &T  &a1,  &U  &a2) {  &return $CALL; });
	}' unless defined(&__altivec_binary_pred);
	unless(defined(&__POWER9_VECTOR__)) {
	} else {
	}
	undef(&__altivec_scalar_pred) if defined(&__altivec_scalar_pred);
	undef(&__altivec_unary_pred) if defined(&__altivec_unary_pred);
	undef(&__altivec_binary_pred) if defined(&__altivec_binary_pred);
    } else {
	eval 'sub vec_cmplt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_cmpgt (($a2), ($a1)));
	}' unless defined(&vec_cmplt);
	eval 'sub vec_cmple {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_cmpge (($a2), ($a1)));
	}' unless defined(&vec_cmple);
	eval 'sub vec_all_in {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpbfp_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_in);
	eval 'sub vec_any_out {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpbfp_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_out);
	eval 'sub vec_all_nan {
	    my($a1) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ, ($a1), ($a1)));
	}' unless defined(&vec_all_nan);
	eval 'sub vec_any_nan {
	    my($a1) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT_REV, ($a1), ($a1)));
	}' unless defined(&vec_any_nan);
	eval 'sub vec_all_numeric {
	    my($a1) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT, ($a1), ($a1)));
	}' unless defined(&vec_all_numeric);
	eval 'sub vec_any_numeric {
	    my($a1) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ_REV, ($a1), ($a1)));
	}' unless defined(&vec_any_numeric);
	eval 'sub vec_all_eq {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_eq);
	if(defined(&__POWER9_VECTOR__)) {
	    eval 'sub vec_all_nez {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpnez_p ( &__CR6_LT, ($a1), ($a2)));
	    }' unless defined(&vec_all_nez);
	    eval 'sub vec_any_eqz {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpnez_p ( &__CR6_LT_REV, ($a1), ($a2)));
	    }' unless defined(&vec_any_eqz);
	    eval 'sub vec_all_ne {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpne_p (($a1), ($a2)));
	    }' unless defined(&vec_all_ne);
	    eval 'sub vec_any_eq {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpae_p (($a1), ($a2)));
	    }' unless defined(&vec_any_eq);
	} else {
	    eval 'sub vec_all_ne {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ, ($a1), ($a2)));
	    }' unless defined(&vec_all_ne);
	    eval 'sub vec_any_eq {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	    }' unless defined(&vec_any_eq);
	}
	eval 'sub vec_any_ne {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ne);
	eval 'sub vec_all_gt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_gt);
	eval 'sub vec_all_lt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT, ($a2), ($a1)));
	}' unless defined(&vec_all_lt);
	eval 'sub vec_any_gt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_gt);
	eval 'sub vec_any_lt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_lt);
	eval 'sub vec_all_ngt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_ngt);
	eval 'sub vec_all_nlt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ, ($a2), ($a1)));
	}' unless defined(&vec_all_nlt);
	eval 'sub vec_any_ngt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ngt);
	eval 'sub vec_any_nlt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_nlt);
	eval 'sub vec_all_le {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT, ($a2), ($a1)));
	}' unless defined(&vec_all_le);
	eval 'sub vec_all_ge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_ge);
	eval 'sub vec_any_le {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_le);
	eval 'sub vec_any_ge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ge);
	eval 'sub vec_all_nge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_nge);
	eval 'sub vec_all_nle {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ, ($a2), ($a1)));
	}' unless defined(&vec_all_nle);
	eval 'sub vec_any_nge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_nge);
	eval 'sub vec_any_nle {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_nle);
    }
    eval 'sub vec_dss {
        my($x) = @_;
	    eval q( &__builtin_altivec_dss(($x)));
    }' unless defined(&vec_dss);
    eval 'sub vec_dssall () {
        eval q( &__builtin_altivec_dssall ());
    }' unless defined(&vec_dssall);
    eval 'sub vec_splat_u8 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned char\')  &vec_splat_s8 (($x))));
    }' unless defined(&vec_splat_u8);
    eval 'sub vec_splat_u16 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned short\')  &vec_splat_s16 (($x))));
    }' unless defined(&vec_splat_u16);
    eval 'sub vec_splat_u32 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned int\')  &vec_splat_s32 (($x))));
    }' unless defined(&vec_splat_u32);
    eval 'sub vec_step {
        my($x) = @_;
	    eval q( &__builtin_vec_step (* ( &__typeof__ ($x) *) 0));
    }' unless defined(&vec_step);
}
1;
