require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&NO_WARN_X86_INTRINSICS)) {
    die("Please read comment above.  Use -DNO_WARN_X86_INTRINSICS to disable this error.");
}
unless(defined(&EMMINTRIN_H_)) {
    eval 'sub EMMINTRIN_H_ () {1;}' unless defined(&EMMINTRIN_H_);
    require 'altivec.ph';
    require 'assert.ph';
    require 'xmmintrin.ph';
    eval 'sub _MM_SHUFFLE2 {
        my($x,$y) = @_;
	    eval q(((($x) << 1) | ($y)));
    }' unless defined(&_MM_SHUFFLE2);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set_pd1 (\'double\'  &__F) {  &_mm_set1_pd ( &__F); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_load_pd1 (\'double\'  &const * &__P) {  &_mm_load1_pd ( &__P); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtsd_f64 ( &__m128d  &__A) { (( &__v2df) &__A)[0]; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_storel_pd (\'double\' * &__P,  &__m128d  &__A) {  &_mm_store_sd ( &__P,  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_store_pd1 (\'double\' * &__P,  &__m128d  &__A) {  &_mm_store1_pd ( &__P,  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_add_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &__m128d) (( &__v2df) &__A + ( &__v2df) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sub_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &__m128d) (( &__v2df) &__A - ( &__v2df) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sub_sd ( &__m128d  &__A,  &__m128d  &__B) {  $__A[0] =  $__A[0] -  $__B[0]; ( &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_mul_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &__m128d) (( &__v2df) &__A * ( &__v2df) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_mul_sd ( &__m128d  &__A,  &__m128d  &__B) {  $__A[0] =  $__A[0] *  $__B[0]; ( &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_div_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &__m128d) (( &__v2df) &__A / ( &__v2df) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_div_sd ( &__m128d  &__A,  &__m128d  &__B) {  $__A[0] =  $__A[0] /  $__B[0]; ( &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sqrt_pd ( &__m128d  &__A) { ( &vec_sqrt ( &__A)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_min_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &vec_min ( &__A,  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_min_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c =  &vec_min ( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_max_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &vec_max ( &__A,  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_max_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c =  &vec_max ( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpeq_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmpeq (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmplt_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmplt (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmple_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmple (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpgt_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmpgt (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpge_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmpge (( &__v2df)  &__A,( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpneq_pd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__temp = ( &__v2df)  &vec_cmpeq (( &__v2df)  &__A, ( &__v2df) &__B); (( &__m128d) &vec_nor ( &__temp,  &__temp)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpnlt_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmpge (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpnle_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmpgt (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpngt_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmple (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpnge_pd ( &__m128d  &__A,  &__m128d  &__B) { (( &__m128d) &vec_cmplt (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpord_pd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2du  &__c,  &__d;  &__c = ( &__v2du) &vec_cmpeq ( &__A,  &__A);  &__d = ( &__v2du) &vec_cmpeq ( &__B,  &__B); (( &__m128d) &vec_and( &__c,  &__d)); });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpunord_pd ( &__m128d  &__A,  &__m128d  &__B) { });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpeq_sd( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmpeq( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmplt_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmplt( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmple_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmple( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpgt_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmpgt( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpge_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmpge( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpneq_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmpeq( &__a,  &__b);  &__c =  &vec_nor ( &__c,  &__c); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpnlt_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmpge( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpnle_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmpge( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpngt_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmple( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpnge_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__a,  &__b,  &__c;  &__a =  &vec_splats ( $__A[0]);  &__b =  &vec_splats ( $__B[0]);  &__c = ( &__v2df)  &vec_cmplt( &__a,  &__b); ( &__m128d)  &_mm_setr_pd ( $__c[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpord_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__r;  &__r = ( &__v2df) &_mm_cmpord_pd ( &vec_splats ( $__A[0]),  &vec_splats ( $__B[0])); ( &__m128d)  &_mm_setr_pd ( $__r[0], (( &__v2df) &__A)[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpunord_sd ( &__m128d  &__A,  &__m128d  &__B) {  &__v2df  &__r;  &__r =  &_mm_cmpunord_pd ( &vec_splats ( $__A[0]),  &vec_splats ( $__B[0])); ( &__m128d)  &_mm_setr_pd ( $__r[0],  $__A[1]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_comilt_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] <  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_comile_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] <=  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_comigt_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] >  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_comige_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] >=  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_comineq_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] !=  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_ucomieq_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] ==  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_ucomilt_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] <  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_ucomile_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] <=  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_ucomigt_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] >  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_ucomige_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] >=  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_ucomineq_sd ( &__m128d  &__A,  &__m128d  &__B) { ( $__A[0] !=  $__B[0]); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set_epi64 ( &__m64  &__q1,  &__m64  &__q0) {  &_mm_set_epi64x ( &__q1,  &__q0); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set_epi32 (\'int\'  &__q3, \'int\'  &__q2, \'int\'  &__q1, \'int\'  &__q0) { ( &__m128i)( &__v4si){  &__q0,  &__q1,  &__q2,  &__q3 }; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set_epi16 (my $__q7, my $__q6, my $__q5, my $__q4, my $__q3, my $__q2, my $__q1, my $__q0) { ( &__m128i)( &__v8hi){  $__q0,  $__q1,  $__q2,  $__q3,  $__q4,  $__q5,  $__q6,  $__q7 }; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set_epi8 (\'char\'  &__q15, \'char\'  &__q14, \'char\'  &__q13, \'char\'  &__q12, \'char\'  &__q11, \'char\'  &__q10, \'char\'  &__q09, \'char\'  &__q08, \'char\'  &__q07, \'char\'  &__q06, \'char\'  &__q05, \'char\'  &__q04, \'char\'  &__q03, \'char\'  &__q02, \'char\'  &__q01, \'char\'  &__q00) { ( &__m128i)( &__v16qi){  &__q00,  &__q01,  &__q02,  &__q03,  &__q04,  &__q05,  &__q06,  &__q07,  &__q08,  &__q09,  &__q10,  &__q11,  &__q12,  &__q13,  &__q14,  &__q15 }; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set1_epi64 ( &__m64  &__A) {  &_mm_set_epi64 ( &__A,  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set1_epi32 (\'int\'  &__A) {  &_mm_set_epi32 ( &__A,  &__A,  &__A,  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set1_epi16  {  &_mm_set_epi16 ( &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_set1_epi8 (\'char\'  &__A) {  &_mm_set_epi8 ( &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A,  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_setr_epi32 (\'int\'  &__q0, \'int\'  &__q1, \'int\'  &__q2, \'int\'  &__q3) {  &_mm_set_epi32 ( &__q3,  &__q2,  &__q1,  &__q0); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_setr_epi16 (my $__q0, my $__q1, my $__q2, my $__q3, my $__q4, my $__q5, my $__q6, my $__q7) {  &_mm_set_epi16 ( $__q7,  $__q6,  $__q5,  $__q4,  $__q3,  $__q2,  $__q1,  $__q0); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_setr_epi8 (\'char\'  &__q00, \'char\'  &__q01, \'char\'  &__q02, \'char\'  &__q03, \'char\'  &__q04, \'char\'  &__q05, \'char\'  &__q06, \'char\'  &__q07, \'char\'  &__q08, \'char\'  &__q09, \'char\'  &__q10, \'char\'  &__q11, \'char\'  &__q12, \'char\'  &__q13, \'char\'  &__q14, \'char\'  &__q15) {  &_mm_set_epi8 ( &__q15,  &__q14,  &__q13,  &__q12,  &__q11,  &__q10,  &__q09,  &__q08,  &__q07,  &__q06,  &__q05,  &__q04,  &__q03,  &__q02,  &__q01,  &__q00); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_loadu_si128 ( &__m128i_u  &const * &__P) { ( &__m128i) ( &vec_vsx_ld(0,  &__P)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_loadl_epi64 ( &__m128i_u  &const * &__P) {  &_mm_set_epi64 (( &__m64)0, *( &__m64 *) &__P); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_store_si128 ( &__m128i * &__P,  &__m128i  &__B) {  &assert(( &__P & 0xf) == 0);  &vec_st (( &__v16qu)  &__B, 0, ( &__v16qu*) &__P); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_storeu_si128 ( &__m128i_u * &__P,  &__m128i  &__B) { * &__P =  &__B; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_storel_epi64 ( &__m128i_u * &__P,  &__m128i  &__B) { * &__P = (( &__v2di) &__B)[0]; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_movepi64_pi64 ( &__m128i_u  &__B) { ( &__m64) (( &__v2di) &__B)[0]; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_movpi64_epi64 ( &__m64  &__A) {  &_mm_set_epi64 (( &__m64)0,  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_move_epi64 ( &__m128i  &__A) {  &_mm_set_epi64 (( &__m64)0, ( &__m64) $__A[0]); });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
	eval 'sub __attribute__ () {
	    eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtepi32_pd ( &__m128i  &__A) {  &__v2di  &__val;  &__val = ( &__v2di) &vec_unpackh (( &__v4si) &__A); ( &__m128d) &vec_ctf ( &__val, 0); });
	}' unless defined(&__attribute__);
    }
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtepi32_ps ( &__m128i  &__A) { (( &__m128) &vec_ctf(( &__v4si) &__A, 0)); });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtpd_pi32 ( &__m128d  &__A) {  &__m128i  &__result =  &_mm_cvtpd_epi32( &__A); ( &__m64)  $__result[0]; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvttpd_pi32 ( &__m128d  &__A) {  &__m128i  &__result =  &_mm_cvttpd_epi32 ( &__A); ( &__m64)  $__result[0]; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtsi128_si32 ( &__m128i  &__A) { (( &__v4si) &__A)[0]; });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
	eval 'sub __attribute__ () {
	    eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtpi32_pd ( &__m64  &__A) {  &__v4si  &__temp;  &__v2di  &__tmp2;  &__v2df  &__result;  &__temp = ( &__v4si) &vec_splats ( &__A);  &__tmp2 = ( &__v2di) &vec_unpackl ( &__temp);  &__result =  &vec_ctf (( &__vector my $long)  &__tmp2, 0); ( &__m128d) &__result; });
	}' unless defined(&__attribute__);
    }
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtps_epi32 ( &__m128  &__A) {  &__v4sf  &__rounded;  &__v4si  &__result;  &__rounded =  &vec_rint(( &__v4sf)  &__A);  &__result =  &vec_cts ( &__rounded, 0); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvttps_epi32 ( &__m128  &__A) {  &__v4si  &__result;  &__result =  &vec_cts (( &__v4sf)  &__A, 0); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtsd_si32 ( &__m128d  &__A) {  &__v2df  &__rounded =  &vec_rint(( &__v2df)  &__A); \'int\'  &__result = (( &__v2df) &__rounded)[0];  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvttsd_si32 ( &__m128d  &__A) { \'int\'  &__result = (( &__v2df) &__A)[0];  &__result; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtsd_ss ( &__m128  &__A,  &__m128d  &__B) {  &__v4sf  &__result = ( &__v4sf) &__A; ( &__m128)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtsi32_sd ( &__m128d  &__A, \'int\'  &__B) {  &__v2df  &__result = ( &__v2df) &__A; \'double\'  &__db =  &__B;  &__result [0] =  &__db; ( &__m128d) &__result; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtss_sd ( &__m128d  &__A,  &__m128  &__B) { });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_shuffle_pd( &__m128d  &__A,  &__m128d  &__B,  &const \'int\'  &__mask) {  &__vector \'double\'  &__result;  &const \'int\'  &__litmsk =  &__mask & 0x3;  &if ( &__litmsk == 0)  &__result =  &vec_mergeh ( &__A,  &__B);  &else  &__result =  &vec_mergel ( &__A,  &__B);  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpackhi_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &__m128d)  &vec_mergel (( &__v2df) &__A, ( &__v2df) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpacklo_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &__m128d)  &vec_mergeh (( &__v2df) &__A, ( &__v2df) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_loadh_pd ( &__m128d  &__A, \'double\'  &const * &__B) {  &__v2df  &__result = ( &__v2df) &__A;  &__result [1] = * &__B; ( &__m128d) &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_loadl_pd ( &__m128d  &__A, \'double\'  &const * &__B) {  &__v2df  &__result = ( &__v2df) &__A;  &__result [0] = * &__B; ( &__m128d) &__result; });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
	if(defined(&_ARCH_PWR10)) {
	} else {
	    if(defined(&__LITTLE_ENDIAN__)) {
	    } else {
	    }
	    if(defined(&__LITTLE_ENDIAN__)) {
	    } else {
	    }
	}
    }
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_packs_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_packs (( &__v8hi)  &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_packs_epi32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_packs (( &__v4si) &__A, ( &__v4si) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_packus_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_packsu (( &__v8hi)  &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpackhi_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_mergel (( &__v16qu) &__A, ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpackhi_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_mergel (( &__v8hu) &__A, ( &__v8hu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpackhi_epi32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_mergel (( &__v4su) &__A, ( &__v4su) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpackhi_epi64 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_mergel (( &__vector my $long)  &__A, ( &__vector my $long)  &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpacklo_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_mergeh (( &__v16qu) &__A, ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpacklo_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_mergeh (( &__v8hi) &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpacklo_epi32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_mergeh (( &__v4si) &__A, ( &__v4si) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_unpacklo_epi64 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_mergeh (( &__vector my $long)  &__A, ( &__vector my $long)  &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_add_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v16qu) &__A + ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_add_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v8hu) &__A + ( &__v8hu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_add_epi32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v4su) &__A + ( &__v4su) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_add_epi64 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v2du) &__A + ( &__v2du) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_adds_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_adds (( &__v16qi) &__A, ( &__v16qi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_adds_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_adds (( &__v8hi) &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_adds_epu8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_adds (( &__v16qu) &__A, ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_adds_epu16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_adds (( &__v8hu) &__A, ( &__v8hu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sub_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v16qu) &__A - ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sub_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v8hu) &__A - ( &__v8hu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sub_epi32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v4su) &__A - ( &__v4su) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sub_epi64 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v2du) &__A - ( &__v2du) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_subs_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_subs (( &__v16qi) &__A, ( &__v16qi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_subs_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_subs (( &__v8hi) &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_subs_epu8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_subs (( &__v16qu) &__A, ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_subs_epu16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_subs (( &__v8hu) &__A, ( &__v8hu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_madd_epi16 ( &__m128i  &__A,  &__m128i  &__B) {  &__vector my $__zero = {0, 0, 0, 0}; ( &__m128i)  &vec_vmsumshm (( &__v8hi) &__A, ( &__v8hi) &__B,  $__zero); });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_mulhi_epi16 ( &__m128i  &__A,  &__m128i  &__B) {  &__vector my $__w0,  &__w1;  &__vector my $__xform1 = { };  $__w0 =  &vec_vmulesh (( &__v8hi) &__A, ( &__v8hi) &__B);  &__w1 =  &vec_vmulosh (( &__v8hi) &__A, ( &__v8hi) &__B); ( &__m128i)  &vec_perm ( $__w0,  &__w1,  $__xform1); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_mullo_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) (( &__v8hi) &__A * ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_mul_su32 ( &__m64  &__A,  &__m64  &__B) { my $__a =  &__A; my $__b =  &__B; (( &__m64) $__a * ( &__m64) $__b); });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub __attribute__ () {
	    eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_mul_epu32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &__result;  &else ( &__m128i)  &vec_mule (( &__v4su) &__A, ( &__v4su) &__B);  &endif });
	}' unless defined(&__attribute__);
    }
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_slli_epi16 ( &__m128i  &__A, \'int\'  &__B) {  &__v8hu  &__lshift;  &__v8hi  &__result = { 0, 0, 0, 0, 0, 0, 0, 0};  &if ( &__B >= 0 &&  &__B < 16) {  &if ( &__builtin_constant_p( &__B))  &__lshift = ( &__v8hu)  &vec_splat_s16;  &else  &__lshift =  &vec_splats (  &__B);  &__result =  &vec_sl (( &__v8hi)  &__A,  &__lshift); } ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_slli_epi32 ( &__m128i  &__A, \'int\'  &__B) {  &__v4su  &__lshift;  &__v4si  &__result = { 0, 0, 0, 0};  &if ( &__B >= 0 &&  &__B < 32) {  &if ( &__builtin_constant_p( &__B)  &&  &__B < 16)  &__lshift = ( &__v4su)  &vec_splat_s32;  &else  &__lshift =  &vec_splats (  &__B);  &__result =  &vec_sl (( &__v4si)  &__A,  &__lshift); } ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
	eval 'sub __attribute__ () {
	    eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_slli_epi64 ( &__m128i  &__A, \'int\'  &__B) {  &__v2du  &__lshift;  &__v2di  &__result = { 0, 0};  &if ( &__B >= 0 &&  &__B < 64) {  &if ( &__builtin_constant_p( &__B)  &&  &__B < 16)  &__lshift = ( &__v2du)  &vec_splat_s32( &__B);  &else  &__lshift = ( &__v2du)  &vec_splats (  &__B);  &__result =  &vec_sl (( &__v2di)  &__A,  &__lshift); } ( &__m128i)  &__result; });
	}' unless defined(&__attribute__);
    }
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srai_epi16 ( &__m128i  &__A, \'int\'  &__B) {  &__v8hu  &__rshift = { 15, 15, 15, 15, 15, 15, 15, 15};  &__v8hi  &__result;  &if ( &__B < 16) {  &if ( &__builtin_constant_p( &__B))  &__rshift = ( &__v8hu)  &vec_splat_s16;  &else  &__rshift =  &vec_splats (  &__B); }  &__result =  &vec_sra (( &__v8hi)  &__A,  &__rshift); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srai_epi32 ( &__m128i  &__A, \'int\'  &__B) {  &__v4su  &__rshift = { 31, 31, 31, 31};  &__v4si  &__result;  &if ( &__B < 32) {  &if ( &__builtin_constant_p( &__B)) {  &if ( &__B < 16)  &__rshift = ( &__v4su)  &vec_splat_s32( &__B);  &else  &__rshift = ( &__v4su)  &vec_splats; }  &else  &__rshift =  &vec_splats (  &__B); }  &__result =  &vec_sra (( &__v4si)  &__A,  &__rshift); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_bslli_si128 ( &__m128i  &__A,  &const \'int\'  &__N) {  &__v16qu  &__result;  &const  &__v16qu  &__zeros = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};  &if ( &__N < 16)  &__result =  &vec_sld (( &__v16qu)  &__A,  &__zeros,  &__N);  &else  &__result =  &__zeros; ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_bsrli_si128 ( &__m128i  &__A,  &const \'int\'  &__N) {  &__v16qu  &__result;  &const  &__v16qu  &__zeros = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};  &if ( &__N < 16) {  &__v16qu  &__shift =  &vec_splats(( &__N*8)); }  &else  &__result =  &__zeros; ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srli_si128 ( &__m128i  &__A,  &const \'int\'  &__N) {  &_mm_bsrli_si128 ( &__A,  &__N); });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_slli_si128 ( &__m128i  &__A,  &const \'int\'  &_imm5) {  &__v16qu  &__result;  &const  &__v16qu  &__zeros = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};  &if ( &_imm5 < 16)  &else  &__result =  &__zeros; ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srli_epi16 ( &__m128i  &__A, \'int\'  &__B) {  &__v8hu  &__rshift;  &__v8hi  &__result = { 0, 0, 0, 0, 0, 0, 0, 0};  &if ( &__B < 16) {  &if ( &__builtin_constant_p( &__B))  &__rshift = ( &__v8hu)  &vec_splat_s16;  &else  &__rshift =  &vec_splats (  &__B);  &__result =  &vec_sr (( &__v8hi)  &__A,  &__rshift); } ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srli_epi32 ( &__m128i  &__A, \'int\'  &__B) {  &__v4su  &__rshift;  &__v4si  &__result = { 0, 0, 0, 0};  &if ( &__B < 32) {  &if ( &__builtin_constant_p( &__B)) {  &if ( &__B < 16)  &__rshift = ( &__v4su)  &vec_splat_s32( &__B);  &else  &__rshift = ( &__v4su)  &vec_splats; }  &else  &__rshift =  &vec_splats (  &__B);  &__result =  &vec_sr (( &__v4si)  &__A,  &__rshift); } ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
	eval 'sub __attribute__ () {
	    eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srli_epi64 ( &__m128i  &__A, \'int\'  &__B) {  &__v2du  &__rshift;  &__v2di  &__result = { 0, 0};  &if ( &__B < 64) {  &if ( &__builtin_constant_p( &__B)) {  &if ( &__B < 16)  &__rshift = ( &__v2du)  &vec_splat_s32( &__B);  &else  &__rshift = ( &__v2du)  &vec_splats( &__B); }  &else  &__rshift = ( &__v2du)  &vec_splats (  &__B);  &__result =  &vec_sr (( &__v2di)  &__A,  &__rshift); } ( &__m128i)  &__result; });
	}' unless defined(&__attribute__);
    }
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sll_epi16 ( &__m128i  &__A,  &__m128i  &__B) {  &__v8hu  &__lshift;  &__vector  &__bool my $__shmask;  &const  &__v8hu  &__shmax = { 15, 15, 15, 15, 15, 15, 15, 15};  &__v8hu  &__result;  $__shmask =  &vec_cmple ( &__lshift,  &__shmax);  &__result =  &vec_sl (( &__v8hu)  &__A,  &__lshift);  &__result =  &vec_sel (( &__v8hu)  $__shmask,  &__result,  $__shmask); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sll_epi32 ( &__m128i  &__A,  &__m128i  &__B) {  &__v4su  &__lshift;  &__vector  &__bool \'int\'  &__shmask;  &const  &__v4su  &__shmax = { 32, 32, 32, 32};  &__v4su  &__result;  &__shmask =  &vec_cmplt ( &__lshift,  &__shmax);  &__result =  &vec_sl (( &__v4su)  &__A,  &__lshift);  &__result =  &vec_sel (( &__v4su)  &__shmask,  &__result,  &__shmask); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
	eval 'sub __attribute__ () {
	    eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sll_epi64 ( &__m128i  &__A,  &__m128i  &__B) {  &__v2du  &__lshift;  &__vector  &__bool my $__shmask;  &const  &__v2du  &__shmax = { 64, 64};  &__v2du  &__result;  &__lshift =  &vec_splat (( &__v2du)  &__B, 0);  $__shmask =  &vec_cmplt ( &__lshift,  &__shmax);  &__result =  &vec_sl (( &__v2du)  &__A,  &__lshift);  &__result =  &vec_sel (( &__v2du)  $__shmask,  &__result,  $__shmask); ( &__m128i)  &__result; });
	}' unless defined(&__attribute__);
    }
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sra_epi16 ( &__m128i  &__A,  &__m128i  &__B) {  &const  &__v8hu  &__rshmax = { 15, 15, 15, 15, 15, 15, 15, 15};  &__v8hu  &__rshift;  &__v8hi  &__result;  &__rshift =  &vec_min ( &__rshift,  &__rshmax);  &__result =  &vec_sra (( &__v8hi)  &__A,  &__rshift); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sra_epi32 ( &__m128i  &__A,  &__m128i  &__B) {  &const  &__v4su  &__rshmax = { 31, 31, 31, 31};  &__v4su  &__rshift;  &__v4si  &__result;  &__rshift =  &vec_min ( &__rshift,  &__rshmax);  &__result =  &vec_sra (( &__v4si)  &__A,  &__rshift); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srl_epi16 ( &__m128i  &__A,  &__m128i  &__B) {  &__v8hu  &__rshift;  &__vector  &__bool my $__shmask;  &const  &__v8hu  &__shmax = { 15, 15, 15, 15, 15, 15, 15, 15};  &__v8hu  &__result;  $__shmask =  &vec_cmple ( &__rshift,  &__shmax);  &__result =  &vec_sr (( &__v8hu)  &__A,  &__rshift);  &__result =  &vec_sel (( &__v8hu)  $__shmask,  &__result,  $__shmask); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srl_epi32 ( &__m128i  &__A,  &__m128i  &__B) {  &__v4su  &__rshift;  &__vector  &__bool \'int\'  &__shmask;  &const  &__v4su  &__shmax = { 32, 32, 32, 32};  &__v4su  &__result;  &__shmask =  &vec_cmplt ( &__rshift,  &__shmax);  &__result =  &vec_sr (( &__v4su)  &__A,  &__rshift);  &__result =  &vec_sel (( &__v4su)  &__shmask,  &__result,  &__shmask); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
	eval 'sub __attribute__ () {
	    eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_srl_epi64 ( &__m128i  &__A,  &__m128i  &__B) {  &__v2du  &__rshift;  &__vector  &__bool my $__shmask;  &const  &__v2du  &__shmax = { 64, 64};  &__v2du  &__result;  &__rshift =  &vec_splat (( &__v2du)  &__B, 0);  $__shmask =  &vec_cmplt ( &__rshift,  &__shmax);  &__result =  &vec_sr (( &__v2du)  &__A,  &__rshift);  &__result =  &vec_sel (( &__v2du)  $__shmask,  &__result,  $__shmask); ( &__m128i)  &__result; });
	}' unless defined(&__attribute__);
    }
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_and_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &vec_and (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_andnot_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &vec_andc (( &__v2df)  &__B, ( &__v2df)  &__A)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_or_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &vec_or (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_xor_pd ( &__m128d  &__A,  &__m128d  &__B) { ( &vec_xor (( &__v2df)  &__A, ( &__v2df)  &__B)); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_and_si128 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) &vec_and (( &__v2di)  &__A, ( &__v2di)  &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_andnot_si128 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) &vec_andc (( &__v2di)  &__B, ( &__v2di)  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_or_si128 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) &vec_or (( &__v2di)  &__A, ( &__v2di)  &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_xor_si128 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i) &vec_xor (( &__v2di)  &__A, ( &__v2di)  &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpeq_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmpeq (( &__v16qi)  &__A, ( &__v16qi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpeq_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmpeq (( &__v8hi)  &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpeq_epi32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmpeq (( &__v4si)  &__A, ( &__v4si) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmplt_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmplt (( &__v16qi)  &__A, ( &__v16qi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmplt_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmplt (( &__v8hi)  &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmplt_epi32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmplt (( &__v4si)  &__A, ( &__v4si) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpgt_epi8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmpgt (( &__v16qi)  &__A, ( &__v16qi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpgt_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmpgt (( &__v8hi)  &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cmpgt_epi32 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_cmpgt (( &__v4si)  &__A, ( &__v4si) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_extract_epi16 ( &__m128i  &const  &__A, \'int\'  &const  &__N) { (( &__v8hi) &__A)[ &__N & 7]; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_insert_epi16 ( &__m128i  &const  &__A, \'int\'  &const  &__D, \'int\'  &const  &__N) {  &__v8hi  &__result = ( &__v8hi) &__A;  &__result [( &__N & 7)] =  &__D; ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_max_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_max (( &__v8hi) &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_max_epu8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_max (( &__v16qu)  &__A, ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_min_epi16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_min (( &__v8hi)  &__A, ( &__v8hi) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_min_epu8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_min (( &__v16qu)  &__A, ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    if(defined(&_ARCH_PWR8)) {
	if(defined(&_ARCH_PWR10)) {
	} else {
	    if(defined(&__LITTLE_ENDIAN__)) {
	    } else {
	    }
	}
    }
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_mulhi_epu16 ( &__m128i  &__A,  &__m128i  &__B) {  &__v4su  &__w0,  &__w1;  &__v16qu  &__xform1 = { };  &__w0 =  &vec_vmuleuh (( &__v8hu) &__A, ( &__v8hu) &__B);  &__w1 =  &vec_vmulouh (( &__v8hu) &__A, ( &__v8hu) &__B); ( &__m128i)  &vec_perm ( &__w0,  &__w1,  &__xform1); });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_shufflehi_epi16 ( &__m128i  &__A,  &const \'int\'  &__mask) { my $__element_selector_98 =  &__mask & 0x3; my $__element_selector_BA = ( &__mask >> 2) & 0x3; my $__element_selector_DC = ( &__mask >> 4) & 0x3; my $__element_selector_FE = ( &__mask >> 6) & 0x3;  &const my $__permute_selectors[4] = { };  &__v2du  &__pmask =  &__m64_union  &__t;  &__v2du  &__a,  &__r;  ($__t->{as_short[0]}) =  $__permute_selectors[ $__element_selector_98];  ($__t->{as_short[1]}) =  $__permute_selectors[ $__element_selector_BA];  ($__t->{as_short[2]}) =  $__permute_selectors[ $__element_selector_DC];  ($__t->{as_short[3]}) =  $__permute_selectors[ $__element_selector_FE];  $__pmask[1] =  ($__t->{as_m64});  &__a = ( &__v2du) &__A;  &__r =  &vec_perm ( &__a,  &__a, ( &__vector my $char) &__pmask); ( &__m128i)  &__r; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_shufflelo_epi16 ( &__m128i  &__A,  &const \'int\'  &__mask) { my $__element_selector_10 =  &__mask & 0x3; my $__element_selector_32 = ( &__mask >> 2) & 0x3; my $__element_selector_54 = ( &__mask >> 4) & 0x3; my $__element_selector_76 = ( &__mask >> 6) & 0x3;  &const my $__permute_selectors[4] = { };  &__v2du  &__pmask =  &__m64_union  &__t;  &__v2du  &__a,  &__r;  ($__t->{as_short[0]}) =  $__permute_selectors[ $__element_selector_10];  ($__t->{as_short[1]}) =  $__permute_selectors[ $__element_selector_32];  ($__t->{as_short[2]}) =  $__permute_selectors[ $__element_selector_54];  ($__t->{as_short[3]}) =  $__permute_selectors[ $__element_selector_76];  $__pmask[0] =  ($__t->{as_m64});  &__a = ( &__v2du) &__A;  &__r =  &vec_perm ( &__a,  &__a, ( &__vector my $char) &__pmask); ( &__m128i)  &__r; });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_shuffle_epi32 ( &__m128i  &__A,  &const \'int\'  &__mask) { my $__element_selector_10 =  &__mask & 0x3; my $__element_selector_32 = ( &__mask >> 2) & 0x3; my $__element_selector_54 = ( &__mask >> 4) & 0x3; my $__element_selector_76 = ( &__mask >> 6) & 0x3;  &const my $__permute_selectors[4] = { };  &__v4su  &__t;  $__t[0] =  $__permute_selectors[ $__element_selector_10];  $__t[1] =  $__permute_selectors[ $__element_selector_32];  $__t[2] =  $__permute_selectors[ $__element_selector_54] + 0x10101010;  $__t[3] =  $__permute_selectors[ $__element_selector_76] + 0x10101010; ( &__m128i) &vec_perm (( &__v4si)  &__A, ( &__v4si) &__A, ( &__vector my $char) &__t); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_maskmoveu_si128 ( &__m128i  &__A,  &__m128i  &__B, \'char\' * &__C) {  &__v2du  &__hibit = { 9.18720195043574e+18, 9.18720195043574e+18};  &__v16qu  &__mask,  &__tmp;  &__m128i_u * &__p = ( &__m128i_u*) &__C;  &__tmp = ( &__v16qu) &_mm_loadu_si128( &__p);  &__mask = ( &__v16qu) &vec_cmpgt (( &__v16qu) &__B, ( &__v16qu) &__hibit);  &__tmp =  &vec_sel ( &__tmp, ( &__v16qu) &__A,  &__mask);  &_mm_storeu_si128 ( &__p, ( &__m128i) &__tmp); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_avg_epu8 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_avg (( &__v16qu) &__A, ( &__v16qu) &__B); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_avg_epu16 ( &__m128i  &__A,  &__m128i  &__B) { ( &__m128i)  &vec_avg (( &__v8hu) &__A, ( &__v8hu) &__B); });
    }' unless defined(&__attribute__);
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_sad_epu8 ( &__m128i  &__A,  &__m128i  &__B) {  &__v16qu  &__a,  &__b;  &__v16qu  &__vabsdiff;  &__v4si  &__vsum;  &const  &__v4su  &__zero = { 0, 0, 0, 0};  &__v4si  &__result;  &__a = ( &__v16qu)  &__A;  &__b = ( &__v16qu)  &__B;  &__vsum = ( &__vector \'signed int\')  &vec_sum4s ( &__vabsdiff,  &__zero); ( &__m128i)  &__result; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_lfence ( &void) {  &__atomic_thread_fence ( &__ATOMIC_RELEASE); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_mfence ( &void) {  &__atomic_thread_fence ( &__ATOMIC_SEQ_CST); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtsi32_si128 (\'int\'  &__A) {  &_mm_set_epi32 (0, 0, 0,  &__A); });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_cvtsi64_si128  { ( &__m128i)( &__v2di){  &__A, 0 }; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_castpd_si128( &__m128d  &__A) { ( &__m128i)  &__A; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_castps_pd( &__m128  &__A) { ( &__m128d)  &__A; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_castps_si128( &__m128  &__A) { ( &__m128i)  &__A; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_castsi128_ps( &__m128i  &__A) { ( &__m128)  &__A; });
    }' unless defined(&__attribute__);
    eval 'sub __attribute__ () {
        eval q((( &__gnu_inline__,  &__always_inline__,  &__artificial__))  &_mm_castsi128_pd( &__m128i  &__A) { ( &__m128d)  &__A; });
    }' unless defined(&__attribute__);
}
1;
