/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.jce.sig.KeyPairGeneratorAdapter;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashMap;

public class RSAKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter {
    public void initialize(int n, SecureRandom secureRandom) {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.rsa.L", new Integer(n));
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.rsa.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.rsa.encoding", new Integer(4));
        this.adaptee.setup(hashMap);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        HashMap hashMap = new HashMap();
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params");
            }
            hashMap.put("gnu.crypto.rsa.params", algorithmParameterSpec);
        }
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.rsa.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.rsa.encoding", new Integer(4));
        this.adaptee.setup(hashMap);
    }

    public RSAKeyPairGeneratorSpi() {
        super("rsa");
    }
}

