/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.anonymous;

import gnu.javax.crypto.sasl.ClientMechanism;
import gnu.javax.crypto.sasl.IllegalMechanismStateException;
import gnu.javax.crypto.sasl.anonymous.AnonymousUtil;
import java.io.UnsupportedEncodingException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class AnonymousClient
extends ClientMechanism
implements SaslClient {
    protected void initMechanism() throws SaslException {
    }

    protected void resetMechanism() throws SaslException {
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.complete) {
            throw new IllegalMechanismStateException("evaluateChallenge()");
        }
        return this.response();
    }

    private final byte[] response() throws SaslException {
        byte[] byArray;
        if (!AnonymousUtil.isValidTraceInformation(this.authorizationID)) {
            throw new AuthenticationException("Authorisation ID is not a valid email address");
        }
        this.complete = true;
        try {
            byArray = this.authorizationID.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationException("response()", unsupportedEncodingException);
        }
        return byArray;
    }

    public AnonymousClient() {
        super("ANONYMOUS");
    }
}

