/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public class Generator {
    public long start;
    public long end;
    public long step;
    public final String namePattern;
    public final int type;
    public final int dclass;
    public final long ttl;
    public final String rdataPattern;
    public final Name origin;
    private long current;

    public static boolean supportedType(int n) {
        Type.check(n);
        boolean bl = false;
        if (n == 12 || n == 5 || n == 39 || n == 1 || n == 28 || n == 2) {
            bl = true;
        }
        return bl;
    }

    private final String substitute(String string, long l) throws IOException {
        boolean bl = false;
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            char c = (char)(byArray[n] & 0xFF);
            if (bl) {
                stringBuffer.append(c);
                bl = false;
            } else if (c == '\\') {
                if (n + 1 == byArray.length) {
                    throw new TextParseException("invalid escape character");
                }
                bl = true;
            } else if (c == '$') {
                boolean bl2 = false;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 10L;
                boolean bl3 = false;
                if (n + 1 < byArray.length && byArray[n + 1] == 36) {
                    c = (char)(byArray[++n] & 0xFF);
                    stringBuffer.append(c);
                } else {
                    long l5;
                    if (n + 1 < byArray.length && byArray[n + 1] == 123) {
                        if (++n + 1 < byArray.length && byArray[n + 1] == 45) {
                            bl2 = true;
                            ++n;
                        }
                        while (n + 1 < byArray.length) {
                            if ((c = (char)(byArray[++n] & 0xFF)) == ',' || c == '}') break;
                            if (c < '0' || c > '9') {
                                throw new TextParseException("invalid offset");
                            }
                            c = (char)(c - 48);
                            l2 *= 10L;
                            l2 += (long)c;
                        }
                        if (bl2) {
                            l2 = -l2;
                        }
                        if (c == ',') {
                            while (n + 1 < byArray.length) {
                                if ((c = (char)(byArray[++n] & 0xFF)) == ',' || c == '}') break;
                                if (c < '0' || c > '9') {
                                    throw new TextParseException("invalid width");
                                }
                                c = (char)(c - 48);
                                l3 *= 10L;
                                l3 += (long)c;
                            }
                        }
                        if (c == ',') {
                            if (n + 1 == byArray.length) {
                                throw new TextParseException("invalid base");
                            }
                            if ((c = (char)(byArray[++n] & 0xFF)) == 'o') {
                                l4 = 8L;
                            } else if (c == 'x') {
                                l4 = 16L;
                            } else if (c == 'X') {
                                l4 = 16L;
                                bl3 = true;
                            } else if (c != 'd') {
                                throw new TextParseException("invalid base");
                            }
                        }
                        if (n + 1 == byArray.length || byArray[n + 1] != 125) {
                            throw new TextParseException("invalid modifiers");
                        }
                        ++n;
                    }
                    if ((l5 = l + l2) < 0L) {
                        throw new TextParseException("invalid offset expansion");
                    }
                    String string2 = l4 == 8L ? Long.toOctalString(l5) : (l4 == 16L ? Long.toHexString(l5) : Long.toString(l5));
                    if (bl3) {
                        string2 = string2.toUpperCase();
                    }
                    if (l3 != 0L && l3 > (long)string2.length()) {
                        int n2 = (int)l3 - string2.length();
                        while (n2-- > 0) {
                            stringBuffer.append('0');
                        }
                    }
                    stringBuffer.append(string2);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Record nextRecord() throws IOException {
        if (this.current > this.end) {
            return null;
        }
        String string = this.substitute(this.namePattern, this.current);
        Name name = Name.fromString(string, this.origin);
        String string2 = this.substitute(this.rdataPattern, this.current);
        this.current += this.step;
        return Record.fromString(name, this.type, this.dclass, this.ttl, string2, this.origin);
    }

    public Record[] expand() throws IOException {
        ArrayList arrayList = new ArrayList();
        long l = this.start;
        while (l < this.end) {
            String string = this.substitute(this.namePattern, this.current);
            Name name = Name.fromString(string, this.origin);
            String string2 = this.substitute(this.rdataPattern, this.current);
            arrayList.add(Record.fromString(name, this.type, this.dclass, this.ttl, string2, this.origin));
            l += this.step;
        }
        return (Record[])arrayList.toArray(new Record[arrayList.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("$GENERATE ");
        stringBuffer.append("" + this.start + '-' + this.end);
        if (this.step > 1L) {
            stringBuffer.append("/" + this.step);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.namePattern + ' ');
        stringBuffer.append("" + this.ttl + ' ');
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            stringBuffer.append(DClass.string(this.dclass) + ' ');
        }
        stringBuffer.append(Type.string(this.type) + ' ');
        stringBuffer.append(this.rdataPattern + ' ');
        return stringBuffer.toString();
    }

    public Generator(long l, long l2, long l3, String string, int n, int n2, long l4, String string2, Name name) {
        if (l < 0L || l2 < 0L || l > l2 || l3 <= 0L) {
            throw new IllegalArgumentException("invalid range specification");
        }
        if (!Generator.supportedType(n)) {
            throw new IllegalArgumentException("unsupported type");
        }
        DClass.check(n2);
        this.start = l;
        this.end = l2;
        this.step = l3;
        this.namePattern = string;
        this.type = n;
        this.dclass = n2;
        this.ttl = l4;
        this.rdataPattern = string2;
        this.origin = name;
        this.current = l;
    }
}

