/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.InvalidTypeException;
import org.xbill.DNS.Mnemonic;

public final class Type {
    public static final int A = 1;
    public static final int NS = 2;
    public static final int MD = 3;
    public static final int MF = 4;
    public static final int CNAME = 5;
    public static final int SOA = 6;
    public static final int MB = 7;
    public static final int MG = 8;
    public static final int MR = 9;
    public static final int NULL = 10;
    public static final int WKS = 11;
    public static final int PTR = 12;
    public static final int HINFO = 13;
    public static final int MINFO = 14;
    public static final int MX = 15;
    public static final int TXT = 16;
    public static final int RP = 17;
    public static final int AFSDB = 18;
    public static final int X25 = 19;
    public static final int ISDN = 20;
    public static final int RT = 21;
    public static final int NSAP = 22;
    public static final int NSAP_PTR = 23;
    public static final int SIG = 24;
    public static final int KEY = 25;
    public static final int PX = 26;
    public static final int GPOS = 27;
    public static final int AAAA = 28;
    public static final int LOC = 29;
    public static final int NXT = 30;
    public static final int EID = 31;
    public static final int NIMLOC = 32;
    public static final int SRV = 33;
    public static final int ATMA = 34;
    public static final int NAPTR = 35;
    public static final int KX = 36;
    public static final int CERT = 37;
    public static final int A6 = 38;
    public static final int DNAME = 39;
    public static final int OPT = 41;
    public static final int APL = 42;
    public static final int DS = 43;
    public static final int SSHFP = 44;
    public static final int RRSIG = 46;
    public static final int NSEC = 47;
    public static final int DNSKEY = 48;
    public static final int TKEY = 249;
    public static final int TSIG = 250;
    public static final int IXFR = 251;
    public static final int AXFR = 252;
    public static final int MAILB = 253;
    public static final int MAILA = 254;
    public static final int ANY = 255;
    private static Mnemonic types = new TypeMnemonic();

    static final void check(int n) {
        if (n < 0 || n > (char)-1) {
            throw new InvalidTypeException(n);
        }
    }

    public static final String string(int n) {
        return types.getText(n);
    }

    public static final int value(String string, boolean bl) {
        int n = types.getValue(string);
        if (n == -1 && bl) {
            n = types.getValue("TYPE" + string);
        }
        return n;
    }

    public static final int value(String string) {
        return Type.value(string, false);
    }

    public static final boolean isRR(int n) {
        switch (n) {
            case 41: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return false;
            }
        }
        return true;
    }

    private Type() {
    }

    static {
        types.add(1, "A");
        types.add(2, "NS");
        types.add(3, "MD");
        types.add(4, "MF");
        types.add(5, "CNAME");
        types.add(6, "SOA");
        types.add(7, "MB");
        types.add(8, "MG");
        types.add(9, "MR");
        types.add(10, "NULL");
        types.add(11, "WKS");
        types.add(12, "PTR");
        types.add(13, "HINFO");
        types.add(14, "MINFO");
        types.add(15, "MX");
        types.add(16, "TXT");
        types.add(17, "RP");
        types.add(18, "AFSDB");
        types.add(19, "X25");
        types.add(20, "ISDN");
        types.add(21, "RT");
        types.add(22, "NSAP");
        types.add(23, "NSAP-PTR");
        types.add(24, "SIG");
        types.add(25, "KEY");
        types.add(26, "PX");
        types.add(27, "GPOS");
        types.add(28, "AAAA");
        types.add(29, "LOC");
        types.add(30, "NXT");
        types.add(31, "EID");
        types.add(32, "NIMLOC");
        types.add(33, "SRV");
        types.add(34, "ATMA");
        types.add(35, "NAPTR");
        types.add(36, "KX");
        types.add(37, "CERT");
        types.add(38, "A6");
        types.add(39, "DNAME");
        types.add(41, "OPT");
        types.add(42, "APL");
        types.add(43, "DS");
        types.add(44, "SSHFP");
        types.add(46, "RRSIG");
        types.add(47, "NSEC");
        types.add(48, "DNSKEY");
        types.add(249, "TKEY");
        types.add(250, "TSIG");
        types.add(251, "IXFR");
        types.add(252, "AXFR");
        types.add(253, "MAILB");
        types.add(254, "MAILA");
        types.add(255, "ANY");
    }

    private static class TypeMnemonic
    extends Mnemonic {
        public void check(int n) {
            Type.check(n);
        }

        public TypeMnemonic() {
            super("Type", 2);
            this.setPrefix("TYPE");
        }
    }
}

