/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    protected static final int SCROLL_DOWN = 1;
    protected static final int SCROLL_UP = 0;
    protected Timer autoscrollTimer;
    protected JComboBox comboBox;
    protected boolean hasEntered;
    protected boolean isAutoScrolling;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    protected JList list;
    protected ListDataListener listDataListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected int scrollDirection;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting;

    public void show() {
        Dimension dimension = this.comboBox.getSize();
        dimension.height = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        this.scroller.setMaximumSize(rectangle.getSize());
        this.scroller.setPreferredSize(rectangle.getSize());
        this.scroller.setMinimumSize(rectangle.getSize());
        this.list.invalidate();
        this.syncListSelection();
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.show(this.comboBox, rectangle.x, rectangle.y);
    }

    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        int n = 0;
        while (n < menuElementArray.length) {
            if (menuElementArray[n] == this) {
                menuSelectionManager.clearSelectedPath();
                break;
            }
            ++n;
        }
        this.comboBox.repaint();
    }

    public JList getList() {
        return this.list;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void uninstallingUI() {
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallListeners();
        this.uninstallKeyboardActions();
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        comboBoxModel.removeListDataListener(this.listDataListener);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void firePopupMenuWillBecomeVisible() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        int n = 0;
        while (n < popupMenuListenerArray.length) {
            popupMenuListenerArray[n].popupMenuWillBecomeVisible(new PopupMenuEvent(this.comboBox));
            ++n;
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        int n = 0;
        while (n < popupMenuListenerArray.length) {
            popupMenuListenerArray[n].popupMenuWillBecomeInvisible(new PopupMenuEvent(this.comboBox));
            ++n;
        }
    }

    protected void firePopupMenuCanceled() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        int n = 0;
        while (n < popupMenuListenerArray.length) {
            popupMenuListenerArray[n].popupMenuCanceled(new PopupMenuEvent(this.comboBox));
            ++n;
        }
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler();
    }

    protected KeyListener createKeyListener() {
        return new InvocationKeyHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler();
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ItemListener createItemListener() {
        return new ItemHandler();
    }

    protected JList createList() {
        JList jList = new JList(this.comboBox.getModel());
        return jList;
    }

    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setForeground(this.comboBox.getForeground());
        this.list.setBackground(this.comboBox.getBackground());
        Color color = UIManager.getColor("ComboBox.selectionForeground");
        this.list.setSelectionForeground(color);
        Color color2 = UIManager.getColor("ComboBox.selectionBackground");
        this.list.setSelectionBackground(color2);
        this.list.setBorder(null);
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.syncListSelection();
        this.list.setSelectionMode(1);
        this.installListListeners();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        this.list.addMouseListener(this.listMouseListener);
        this.listMouseMotionListener = this.createListMouseMotionListener();
        this.list.addMouseMotionListener(this.listMouseMotionListener);
        this.listSelectionListener = this.createListSelectionListener();
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 31);
    }

    protected void configureScroller() {
        this.scroller.setBorder(null);
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
    }

    protected void configurePopup() {
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setFocusable(false);
    }

    protected void installComboBoxListeners() {
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.installComboBoxModelListeners(this.comboBox.getModel());
    }

    protected void installComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
    }

    protected void installKeyboardActions() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int n) {
        this.isAutoScrolling = true;
        if (n == 0) {
            this.autoScrollUp();
        } else {
            this.autoScrollDown();
        }
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
    }

    protected void autoScrollUp() {
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        int n = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 0);
        jScrollBar.setValue(jScrollBar.getValue() - n);
        if (this.list.getSelectedIndex() != 0) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
        }
    }

    protected void autoScrollDown() {
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        int n = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 1);
        jScrollBar.setValue(jScrollBar.getValue() + n);
        if (this.list.getSelectedIndex() + 1 != this.comboBox.getItemCount()) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
        }
    }

    protected void delegateFocus(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            this.comboBox.getEditor().getEditorComponent().requestFocus();
        } else {
            this.comboBox.requestFocus();
        }
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.list);
        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getModifiers(), mouseEvent.isPopupTrigger());
        return mouseEvent2;
    }

    protected int getPopupHeightForRowCount(int n) {
        int n2 = 0;
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        if (this.comboBox.getItemCount() < n) {
            n = this.comboBox.getItemCount();
        }
        int n3 = 0;
        while (n3 < n) {
            Component component = listCellRenderer.getListCellRendererComponent(this.list, this.comboBox.getModel().getElementAt(n3), -1, false, false);
            Dimension dimension = component.getPreferredSize();
            n2 += dimension.height;
            ++n3;
        }
        return n2 == 0 ? 100 : n2;
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        return new Rectangle(n, n2, n3, n4);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this.list != null) {
            int n = this.list.locationToIndex(point);
            if (n == -1) {
                n = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
            }
            if (this.list.getSelectedIndex() != n) {
                this.list.setSelectedIndex(n);
                if (bl) {
                    this.list.ensureIndexIsVisible(n);
                }
            }
        }
    }

    private final void uninstallListeners() {
        this.uninstallComboBoxListeners();
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
    }

    private final void uninstallListListeners() {
        this.list.removeMouseListener(this.listMouseListener);
        this.listMouseListener = null;
        this.list.removeMouseMotionListener(this.listMouseMotionListener);
        this.listMouseMotionListener = null;
    }

    private final void uninstallComboBoxListeners() {
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    void syncListSelection() {
        int n = this.comboBox.getSelectedIndex();
        if (n == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
        }
    }

    public BasicComboPopup(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.keyListener = this.createKeyListener();
        this.list = this.createList();
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        this.configurePopup();
        this.installComboBoxListeners();
        this.installKeyboardActions();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class InvocationMouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && BasicComboPopup.this.comboBox.isEnabled()) {
                BasicComboPopup.this.delegateFocus(mouseEvent);
                BasicComboPopup.this.togglePopup();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = BasicComboPopup.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    BasicComboPopup.this.updateListBoxSelectionForEvent(mouseEvent2, false);
                    BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
                }
                BasicComboPopup.this.hide();
            }
            BasicComboPopup.this.hasEntered = false;
            BasicComboPopup.this.stopAutoScrolling();
        }

        protected InvocationMouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicComboPopup.this.isVisible()) {
                MouseEvent mouseEvent2 = BasicComboPopup.this.convertMouseEvent(mouseEvent);
                Rectangle rectangle = new Rectangle();
                BasicComboPopup.this.list.computeVisibleRect(rectangle);
                if (mouseEvent2.getPoint().y >= rectangle.y && mouseEvent2.getPoint().y <= rectangle.y + rectangle.height - 1) {
                    Point point;
                    BasicComboPopup.this.hasEntered = true;
                    if (BasicComboPopup.this.isAutoScrolling) {
                        BasicComboPopup.this.stopAutoScrolling();
                    }
                    if (rectangle.contains(point = mouseEvent2.getPoint())) {
                        BasicComboPopup.this.valueIsAdjusting = true;
                        BasicComboPopup.this.updateListBoxSelectionForEvent(mouseEvent2, false);
                        BasicComboPopup.this.valueIsAdjusting = false;
                    }
                } else if (BasicComboPopup.this.hasEntered) {
                    int n = 0;
                    if (mouseEvent2.getPoint().y < rectangle.y) {
                        n = 1;
                    }
                    int n2 = 1 - n;
                    if (BasicComboPopup.this.isAutoScrolling && BasicComboPopup.this.scrollDirection != n2) {
                        BasicComboPopup.this.stopAutoScrolling();
                        BasicComboPopup.this.startAutoScrolling(n2);
                    } else if (!BasicComboPopup.this.isAutoScrolling) {
                        BasicComboPopup.this.startAutoScrolling(n2);
                    }
                } else if (mouseEvent.getPoint().y < 0) {
                    BasicComboPopup.this.hasEntered = true;
                    BasicComboPopup.this.startAutoScrolling(0);
                }
            }
        }

        protected InvocationMouseMotionHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class InvocationKeyHandler
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }

        protected ListSelectionHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ListMouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicComboPopup.this.comboBox.setSelectedIndex(BasicComboPopup.this.list.getSelectedIndex());
            BasicComboPopup.this.hide();
        }

        protected ListMouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            BasicComboPopup.this.list.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                BasicComboPopup.this.valueIsAdjusting = true;
                BasicComboPopup.this.updateListBoxSelectionForEvent(mouseEvent, false);
                BasicComboPopup.this.valueIsAdjusting = false;
            }
        }

        protected ListMouseMotionHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("renderer")) {
                BasicComboPopup.this.list.setCellRenderer(BasicComboPopup.this.comboBox.getRenderer());
                if (BasicComboPopup.this.isVisible()) {
                    BasicComboPopup.this.hide();
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getOldValue();
                BasicComboPopup.this.uninstallComboBoxModelListeners(comboBoxModel);
                ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getNewValue();
                BasicComboPopup.this.list.setModel(comboBoxModel2);
                BasicComboPopup.this.installComboBoxModelListeners(comboBoxModel2);
                if (BasicComboPopup.this.comboBox.getItemCount() > 0) {
                    BasicComboPopup.this.comboBox.setSelectedIndex(0);
                }
                if (BasicComboPopup.this.isVisible()) {
                    BasicComboPopup.this.hide();
                }
            }
        }

        protected PropertyChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && !BasicComboPopup.this.valueIsAdjusting) {
                BasicComboPopup.this.valueIsAdjusting = true;
                BasicComboPopup.this.syncListSelection();
                BasicComboPopup.this.valueIsAdjusting = false;
                BasicComboPopup.this.list.ensureIndexIsVisible(BasicComboPopup.this.comboBox.getSelectedIndex());
            }
        }

        protected ItemHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }
}

