/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.EventAggregator;
import org.fusesource.hawtdispatch.EventAggregators;
import org.fusesource.hawtdispatch.Retained;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.ServiceBase;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportAware;
import org.fusesource.hawtdispatch.transport.TransportListener;

public class TcpTransport
extends ServiceBase
implements Transport {
    protected URI remoteLocation;
    protected URI localLocation;
    protected TransportListener listener;
    protected ProtocolCodec codec;
    protected SocketChannel channel;
    protected SocketState socketState = new DISCONNECTED();
    protected DispatchQueue dispatchQueue;
    private DispatchSource readSource;
    private DispatchSource writeSource;
    protected CustomDispatchSource<Integer, Integer> drainOutboundSource;
    protected CustomDispatchSource<Integer, Integer> yieldSource;
    protected boolean useLocalHost = true;
    int maxReadRate;
    int maxWriteRate;
    int receiveBufferSize = 65536;
    int sendBufferSize = 65536;
    boolean keepAlive = true;
    public static final int IPTOS_LOWCOST = 2;
    public static final int IPTOS_RELIABILITY = 4;
    public static final int IPTOS_THROUGHPUT = 8;
    public static final int IPTOS_LOWDELAY = 16;
    int trafficClass = 8;
    protected RateLimitingChannel rateLimitingChannel;
    SocketAddress localAddress;
    SocketAddress remoteAddress;
    private final Task CANCEL_HANDLER = new Task(){

        public void run() {
            TcpTransport.this.socketState.onCanceled();
        }
    };
    boolean rejectingOffers;
    boolean writeResumedForCodecFlush = false;

    public void connected(SocketChannel channel) throws IOException, Exception {
        this.channel = channel;
        this.initializeChannel();
        this.socketState = new CONNECTED();
    }

    protected void initializeChannel() throws Exception {
        this.channel.configureBlocking(false);
        Socket socket = this.channel.socket();
        try {
            socket.setReuseAddress(true);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setSoLinger(true, 0);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setTrafficClass(this.trafficClass);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(this.keepAlive);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (this.channel != null && this.codec != null) {
            this.initializeCodec();
        }
    }

    protected void initializeCodec() throws Exception {
        this.codec.setReadableByteChannel(this.readChannel());
        this.codec.setWritableByteChannel(this.writeChannel());
        if (this.codec instanceof TransportAware) {
            ((TransportAware)((Object)this.codec)).setTransport(this);
        }
    }

    public void connecting(URI remoteLocation, URI localLocation) throws IOException, Exception {
        this.channel = SocketChannel.open();
        this.initializeChannel();
        this.remoteLocation = remoteLocation;
        this.localLocation = localLocation;
        if (localLocation != null) {
            InetSocketAddress localAddress = new InetSocketAddress(InetAddress.getByName(localLocation.getHost()), localLocation.getPort());
            this.channel.socket().bind(localAddress);
        }
        String host = this.resolveHostName(remoteLocation.getHost());
        InetSocketAddress remoteAddress = new InetSocketAddress(host, remoteLocation.getPort());
        this.channel.connect(remoteAddress);
        this.socketState = new CONNECTING();
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
        if (this.readSource != null) {
            this.readSource.setTargetQueue(queue);
        }
        if (this.writeSource != null) {
            this.writeSource.setTargetQueue(queue);
        }
        if (this.drainOutboundSource != null) {
            this.drainOutboundSource.setTargetQueue(queue);
        }
        if (this.yieldSource != null) {
            this.yieldSource.setTargetQueue(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _start(Task onCompleted) {
        try {
            if (this.socketState.is(CONNECTING.class)) {
                this.trace("connecting...");
                this.readSource = Dispatch.createSource((SelectableChannel)this.channel, (int)8, (DispatchQueue)this.dispatchQueue);
                this.readSource.setEventHandler(new Task(){

                    public void run() {
                        if (TcpTransport.this.getServiceState() != ServiceBase.STARTED) {
                            return;
                        }
                        try {
                            TcpTransport.this.trace("connected.");
                            TcpTransport.this.channel.finishConnect();
                            TcpTransport.this.readSource.setCancelHandler(null);
                            TcpTransport.this.readSource.cancel();
                            TcpTransport.this.readSource = null;
                            TcpTransport.this.socketState = new CONNECTED();
                            TcpTransport.this.onConnected();
                        }
                        catch (IOException e) {
                            TcpTransport.this.onTransportFailure(e);
                        }
                    }
                });
                this.readSource.setCancelHandler(this.CANCEL_HANDLER);
                this.readSource.resume();
            } else if (this.socketState.is(CONNECTED.class)) {
                this.dispatchQueue.execute(new Task(){

                    public void run() {
                        try {
                            TcpTransport.this.trace("was connected.");
                            TcpTransport.this.onConnected();
                        }
                        catch (IOException e) {
                            TcpTransport.this.onTransportFailure(e);
                        }
                    }
                });
            } else {
                System.err.println("cannot be started.  socket state is: " + this.socketState);
            }
        }
        finally {
            if (onCompleted != null) {
                onCompleted.run();
            }
        }
    }

    public void _stop(Task onCompleted) {
        this.trace("stopping.. at state: " + this.socketState);
        this.socketState.onStop(onCompleted);
    }

    protected String resolveHostName(String host) throws UnknownHostException {
        String localName = InetAddress.getLocalHost().getHostName();
        if (localName != null && this.isUseLocalHost() && localName.equals(host)) {
            return "localhost";
        }
        return host;
    }

    protected void onConnected() throws IOException {
        this.yieldSource = Dispatch.createSource((EventAggregator)EventAggregators.INTEGER_ADD, (DispatchQueue)this.dispatchQueue);
        this.yieldSource.setEventHandler(new Task(){

            public void run() {
                TcpTransport.this.drainInbound();
            }
        });
        this.yieldSource.resume();
        this.drainOutboundSource = Dispatch.createSource((EventAggregator)EventAggregators.INTEGER_ADD, (DispatchQueue)this.dispatchQueue);
        this.drainOutboundSource.setEventHandler(new Task(){

            public void run() {
                TcpTransport.this.flush();
            }
        });
        this.drainOutboundSource.resume();
        this.readSource = Dispatch.createSource((SelectableChannel)this.channel, (int)1, (DispatchQueue)this.dispatchQueue);
        this.writeSource = Dispatch.createSource((SelectableChannel)this.channel, (int)4, (DispatchQueue)this.dispatchQueue);
        this.readSource.setCancelHandler(this.CANCEL_HANDLER);
        this.writeSource.setCancelHandler(this.CANCEL_HANDLER);
        this.readSource.setEventHandler(new Task(){

            public void run() {
                TcpTransport.this.drainInbound();
            }
        });
        this.writeSource.setEventHandler(new Task(){

            public void run() {
                TcpTransport.this.flush();
            }
        });
        if (this.maxReadRate != 0 || this.maxWriteRate != 0) {
            this.rateLimitingChannel = new RateLimitingChannel();
            this.schedualRateAllowanceReset();
        }
        this.listener.onTransportConnected();
    }

    private void schedualRateAllowanceReset() {
        this.dispatchQueue.executeAfter(1L, TimeUnit.SECONDS, new Task(){

            public void run() {
                if (!TcpTransport.this.socketState.is(CONNECTED.class)) {
                    return;
                }
                TcpTransport.this.rateLimitingChannel.resetAllowance();
                TcpTransport.this.schedualRateAllowanceReset();
            }
        });
    }

    private void dispose() {
        if (this.readSource != null) {
            this.readSource.cancel();
            this.readSource = null;
        }
        if (this.writeSource != null) {
            this.writeSource.cancel();
            this.writeSource = null;
        }
        this.codec = null;
    }

    public void onTransportFailure(IOException error) {
        this.listener.onTransportFailure(error);
        this.socketState.onCanceled();
    }

    public boolean full() {
        return this.codec == null || this.codec.full();
    }

    public boolean offer(Object command) {
        this.dispatchQueue.assertExecuting();
        try {
            if (!this.socketState.is(CONNECTED.class)) {
                throw new IOException("Not connected.");
            }
            if (this.getServiceState() != STARTED) {
                throw new IOException("Not running.");
            }
            ProtocolCodec.BufferState rc = this.codec.write(command);
            this.rejectingOffers = this.codec.full();
            switch (rc) {
                case FULL: {
                    return false;
                }
            }
            this.drainOutboundSource.merge((Object)1);
            return true;
        }
        catch (IOException e) {
            this.onTransportFailure(e);
            return false;
        }
    }

    public void flush() {
        this.dispatchQueue.assertExecuting();
        if (this.getServiceState() != STARTED || !this.socketState.is(CONNECTED.class)) {
            return;
        }
        try {
            if (this.codec.flush() == ProtocolCodec.BufferState.EMPTY && this.transportFlush()) {
                if (this.writeResumedForCodecFlush) {
                    this.writeResumedForCodecFlush = false;
                    this.suspendWrite();
                }
                this.rejectingOffers = false;
                this.listener.onRefill();
            } else if (!this.writeResumedForCodecFlush) {
                this.writeResumedForCodecFlush = true;
                this.resumeWrite();
            }
        }
        catch (IOException e) {
            this.onTransportFailure(e);
        }
    }

    protected boolean transportFlush() throws IOException {
        return true;
    }

    protected void drainInbound() {
        if (!this.getServiceState().isStarted() || this.readSource.isSuspended()) {
            return;
        }
        try {
            long initial = this.codec.getReadCounter();
            while (this.codec.getReadCounter() - initial < (long)(this.codec.getReadBufferSize() << 2)) {
                Object command = this.codec.read();
                if (command != null) {
                    try {
                        this.listener.onTransportCommand(command);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.onTransportFailure(new IOException("Transport listener failure."));
                    }
                    if (this.getServiceState() != STOPPED && !this.readSource.isSuspended()) continue;
                    return;
                }
                return;
            }
            this.yieldSource.merge((Object)1);
        }
        catch (IOException e) {
            this.onTransportFailure(e);
        }
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    private boolean assertConnected() {
        try {
            if (!this.isConnected()) {
                throw new IOException("Not connected.");
            }
            return true;
        }
        catch (IOException e) {
            this.onTransportFailure(e);
            return false;
        }
    }

    public void suspendRead() {
        if (this.isConnected() && this.readSource != null) {
            this.readSource.suspend();
        }
    }

    public void resumeRead() {
        if (this.isConnected() && this.readSource != null) {
            if (this.rateLimitingChannel != null) {
                this.rateLimitingChannel.resumeRead();
            } else {
                this._resumeRead();
            }
        }
    }

    private void _resumeRead() {
        this.readSource.resume();
        this.dispatchQueue.execute(new Task(){

            public void run() {
                TcpTransport.this.drainInbound();
            }
        });
    }

    protected void suspendWrite() {
        if (this.isConnected() && this.writeSource != null) {
            this.writeSource.suspend();
        }
    }

    protected void resumeWrite() {
        if (this.isConnected() && this.writeSource != null) {
            this.writeSource.resume();
        }
    }

    public TransportListener getTransportListener() {
        return this.listener;
    }

    public void setTransportListener(TransportListener transportListener) {
        this.listener = transportListener;
    }

    public ProtocolCodec getProtocolCodec() {
        return this.codec;
    }

    public void setProtocolCodec(ProtocolCodec protocolCodec) throws Exception {
        this.codec = protocolCodec;
        if (this.channel != null && this.codec != null) {
            this.initializeCodec();
        }
    }

    public boolean isConnected() {
        return this.socketState.is(CONNECTED.class);
    }

    public boolean isClosed() {
        return this.getServiceState() == STOPPED;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    private void trace(String message) {
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public ReadableByteChannel readChannel() {
        if (this.rateLimitingChannel != null) {
            return this.rateLimitingChannel;
        }
        return this.channel;
    }

    public WritableByteChannel writeChannel() {
        if (this.rateLimitingChannel != null) {
            return this.rateLimitingChannel;
        }
        return this.channel;
    }

    public int getMaxReadRate() {
        return this.maxReadRate;
    }

    public void setMaxReadRate(int maxReadRate) {
        this.maxReadRate = maxReadRate;
    }

    public int getMaxWriteRate() {
        return this.maxWriteRate;
    }

    public void setMaxWriteRate(int maxWriteRate) {
        this.maxWriteRate = maxWriteRate;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    static final class OneWay {
        final Object command;
        final Retained retained;

        public OneWay(Object command, Retained retained) {
            this.command = command;
            this.retained = retained;
        }
    }

    class RateLimitingChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        int read_allowance;
        boolean read_suspended;
        int read_resume_counter;
        int write_allowance;
        boolean write_suspended;

        RateLimitingChannel() {
            this.read_allowance = TcpTransport.this.maxReadRate;
            this.read_suspended = false;
            this.read_resume_counter = 0;
            this.write_allowance = TcpTransport.this.maxWriteRate;
            this.write_suspended = false;
        }

        public void resetAllowance() {
            if (this.read_allowance != TcpTransport.this.maxReadRate || this.write_allowance != TcpTransport.this.maxWriteRate) {
                this.read_allowance = TcpTransport.this.maxReadRate;
                this.write_allowance = TcpTransport.this.maxWriteRate;
                if (this.write_suspended) {
                    this.write_suspended = false;
                    TcpTransport.this.resumeWrite();
                }
                if (this.read_suspended) {
                    this.read_suspended = false;
                    this.resumeRead();
                    for (int i = 0; i < this.read_resume_counter; ++i) {
                        this.resumeRead();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer dst) throws IOException {
            if (TcpTransport.this.maxReadRate == 0) {
                return TcpTransport.this.channel.read(dst);
            }
            int remaining = dst.remaining();
            if (this.read_allowance == 0 || remaining == 0) {
                return 0;
            }
            int reduction = 0;
            if (remaining > this.read_allowance) {
                reduction = remaining - this.read_allowance;
                dst.limit(dst.limit() - reduction);
            }
            int rc = 0;
            try {
                rc = TcpTransport.this.channel.read(dst);
                this.read_allowance -= rc;
            }
            finally {
                if (reduction != 0) {
                    if (dst.remaining() == 0) {
                        TcpTransport.this.readSource.suspend();
                        this.read_suspended = true;
                    }
                    dst.limit(dst.limit() + reduction);
                }
            }
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(ByteBuffer src) throws IOException {
            if (TcpTransport.this.maxWriteRate == 0) {
                return TcpTransport.this.channel.write(src);
            }
            int remaining = src.remaining();
            if (this.write_allowance == 0 || remaining == 0) {
                return 0;
            }
            int reduction = 0;
            if (remaining > this.write_allowance) {
                reduction = remaining - this.write_allowance;
                src.limit(src.limit() - reduction);
            }
            int rc = 0;
            try {
                rc = TcpTransport.this.channel.write(src);
                this.write_allowance -= rc;
            }
            finally {
                if (reduction != 0) {
                    if (src.remaining() == 0) {
                        this.write_suspended = true;
                        TcpTransport.this.suspendWrite();
                    }
                    src.limit(src.limit() + reduction);
                }
            }
            return rc;
        }

        public boolean isOpen() {
            return TcpTransport.this.channel.isOpen();
        }

        public void close() throws IOException {
            TcpTransport.this.channel.close();
        }

        public void resumeRead() {
            if (this.read_suspended) {
                ++this.read_resume_counter;
            } else {
                TcpTransport.this._resumeRead();
            }
        }
    }

    class CANCELED
    extends SocketState {
        private boolean disposed;

        public CANCELED(boolean disposed) {
            this.disposed = disposed;
        }

        void onStop(Task onCompleted) {
            TcpTransport.this.trace("CANCELED.onStop");
            if (!this.disposed) {
                this.disposed = true;
                TcpTransport.this.dispose();
            }
            onCompleted.run();
        }
    }

    class CANCELING
    extends SocketState {
        private LinkedList<Task> runnables = new LinkedList();
        private int remaining;
        private boolean dispose;

        public CANCELING() {
            if (TcpTransport.this.readSource != null) {
                ++this.remaining;
                TcpTransport.this.readSource.cancel();
            }
            if (TcpTransport.this.writeSource != null) {
                ++this.remaining;
                TcpTransport.this.writeSource.cancel();
            }
        }

        void onStop(Task onCompleted) {
            TcpTransport.this.trace("CANCELING.onCompleted");
            this.add(onCompleted);
            this.dispose = true;
        }

        void add(Task onCompleted) {
            if (onCompleted != null) {
                this.runnables.add(onCompleted);
            }
        }

        void onCanceled() {
            TcpTransport.this.trace("CANCELING.onCanceled");
            --this.remaining;
            if (this.remaining != 0) {
                return;
            }
            try {
                TcpTransport.this.channel.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            TcpTransport.this.socketState = new CANCELED(this.dispose);
            for (Task runnable : this.runnables) {
                runnable.run();
            }
            if (this.dispose) {
                TcpTransport.this.dispose();
            }
        }
    }

    class CONNECTED
    extends SocketState {
        public CONNECTED() {
            TcpTransport.this.localAddress = TcpTransport.this.channel.socket().getLocalSocketAddress();
            TcpTransport.this.remoteAddress = TcpTransport.this.channel.socket().getRemoteSocketAddress();
        }

        void onStop(Task onCompleted) {
            TcpTransport.this.trace("CONNECTED.onStop");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.add(this.createDisconnectTask());
            state.onStop(onCompleted);
        }

        void onCanceled() {
            TcpTransport.this.trace("CONNECTED.onCanceled");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.add(this.createDisconnectTask());
            state.onCanceled();
        }

        Task createDisconnectTask() {
            return new Task(){

                public void run() {
                    TcpTransport.this.listener.onTransportDisconnected();
                }
            };
        }
    }

    class CONNECTING
    extends SocketState {
        CONNECTING() {
        }

        void onStop(Task onCompleted) {
            TcpTransport.this.trace("CONNECTING.onStop");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.onStop(onCompleted);
        }

        void onCanceled() {
            TcpTransport.this.trace("CONNECTING.onCanceled");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.onCanceled();
        }
    }

    static class DISCONNECTED
    extends SocketState {
        DISCONNECTED() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class SocketState {
        SocketState() {
        }

        void onStop(Task onCompleted) {
        }

        void onCanceled() {
        }

        boolean is(Class<? extends SocketState> clazz) {
            return this.getClass() == clazz;
        }
    }
}

