/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.sgf;

import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.SgfEvent;
import org.igoweb.go.sgf.Tree;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;

public class ShadowTree
extends Tree
implements EventListener {
    private Tree master;
    private Node masterActiveNode;
    private boolean disableSetActive;

    public ShadowTree(Tree master) {
        super(master);
        this.master = master;
        master.addListener(this);
        this.disableSetActive = true;
    }

    public void setSplit(boolean split) {
        if (split) {
            if (this.masterActiveNode == null) {
                this.masterActiveNode = this.master.getActiveNode();
            }
        } else if (this.masterActiveNode != null) {
            int id = this.masterActiveNode.id;
            this.masterActiveNode = null;
            Node newActiveNode = this.getNode(id);
            if (newActiveNode == null) {
                throw new RuntimeException(Integer.toString(id) + "," + this.master.getActiveNode().id);
            }
            super.setActiveNode(newActiveNode);
        }
    }

    public boolean isSplit() {
        return this.masterActiveNode != null;
    }

    @Override
    public void setActiveNode(Node newNode) {
        if (this.masterActiveNode == null && this.disableSetActive) {
            throw new IllegalStateException();
        }
        super.setActiveNode(newNode);
    }

    public void close() {
        this.master.removeListener(this);
    }

    @Override
    public void handleEvent(Event event) {
        this.disableSetActive = false;
        if (event.type == 7 && this.masterActiveNode != null) {
            this.masterActiveNode = this.master.getActiveNode();
        } else {
            Object arg = event.arg;
            if (arg == null || !(arg instanceof Prop) || this.isPropNeeded((Prop)arg)) {
                this.apply((SgfEvent)event);
            }
        }
        this.disableSetActive = true;
    }

    public void setMaster(Tree tree) {
        this.master.removeListener(this);
        this.master = tree;
        this.master.addListener(this);
    }

    protected boolean isPropNeeded(Prop prop) {
        return true;
    }

    public String toString() {
        return "ShadowTree[" + Integer.toString(System.identityHashCode(this), 16) + ", " + this.master + "]";
    }
}

