/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.examples;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import java.util.Iterator;

public class Manual_HelloWorld_9 {
    public static void main(String[] args) throws Exception {
        JSAP jsap = new JSAP(Manual_HelloWorld_9.class.getResource("Manual_HelloWorld_9.jsap"));
        JSAPResult config = jsap.parse(args);
        if (!config.success()) {
            System.err.println();
            Iterator errs = config.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println();
            System.err.println("Usage: java " + Manual_HelloWorld_9.class.getName());
            System.err.println("                " + jsap.getUsage());
            System.err.println();
            System.err.println(jsap.getHelp());
            System.exit(1);
        }
        String[] names = config.getStringArray("name");
        String[] languages = config.getStringArray("verbose");
        if (languages.length == 0) {
            languages = new String[]{"en"};
        }
        for (int lang = 0; lang < languages.length; ++lang) {
            for (int i = 0; i < config.getInt("count"); ++i) {
                for (int j = 0; j < names.length; ++j) {
                    System.out.println((config.getBoolean("verbose") ? Manual_HelloWorld_9.getVerboseHello(languages[lang]) : "Hi") + ", " + names[j] + "!");
                }
            }
        }
    }

    private static String getVerboseHello(String language) {
        if (language == null || "en".equalsIgnoreCase(language)) {
            return "Hello";
        }
        if ("de".equalsIgnoreCase(language)) {
            return "Guten Tag";
        }
        return "(Barely audible grunt)";
    }
}

