require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_X509V3_H)) {
    eval 'sub OPENSSL_X509V3_H () {1;}' unless defined(&OPENSSL_X509V3_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_X509V3_H () {1;}' unless defined(&HEADER_X509V3_H);
    }
    require 'openssl/bio.ph';
    require 'openssl/x509.ph';
    require 'openssl/conf.ph';
    require 'openssl/x509v3err.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub X509V3_CTX_TEST () {0x1;}' unless defined(&X509V3_CTX_TEST);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub CTX_TEST () { &X509V3_CTX_TEST;}' unless defined(&CTX_TEST);
    }
    eval 'sub X509V3_CTX_REPLACE () {0x2;}' unless defined(&X509V3_CTX_REPLACE);
    eval 'sub sk_X509V3_EXT_METHOD_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509V3_EXT_METHOD_sk_type($sk)));
    }' unless defined(&sk_X509V3_EXT_METHOD_num);
    eval 'sub sk_X509V3_EXT_METHOD_value {
        my($sk, $idx) = @_;
	    eval q((( &X509V3_EXT_METHOD *) &OPENSSL_sk_value( &ossl_check_const_X509V3_EXT_METHOD_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509V3_EXT_METHOD_value);
    eval 'sub sk_X509V3_EXT_METHOD_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509V3_EXT_METHOD) *) &OPENSSL_sk_new( &ossl_check_X509V3_EXT_METHOD_compfunc_type($cmp))));
    }' unless defined(&sk_X509V3_EXT_METHOD_new);
    eval 'sub sk_X509V3_EXT_METHOD_new_null () {
        eval q((( &STACK_OF( &X509V3_EXT_METHOD) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509V3_EXT_METHOD_new_null);
    eval 'sub sk_X509V3_EXT_METHOD_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509V3_EXT_METHOD) *) &OPENSSL_sk_new_reserve( &ossl_check_X509V3_EXT_METHOD_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509V3_EXT_METHOD_new_reserve);
    eval 'sub sk_X509V3_EXT_METHOD_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509V3_EXT_METHOD_sk_type($sk), ($n)));
    }' unless defined(&sk_X509V3_EXT_METHOD_reserve);
    eval 'sub sk_X509V3_EXT_METHOD_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509V3_EXT_METHOD_sk_type($sk)));
    }' unless defined(&sk_X509V3_EXT_METHOD_free);
    eval 'sub sk_X509V3_EXT_METHOD_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509V3_EXT_METHOD_sk_type($sk)));
    }' unless defined(&sk_X509V3_EXT_METHOD_zero);
    eval 'sub sk_X509V3_EXT_METHOD_delete {
        my($sk, $i) = @_;
	    eval q((( &X509V3_EXT_METHOD *) &OPENSSL_sk_delete( &ossl_check_X509V3_EXT_METHOD_sk_type($sk), ($i))));
    }' unless defined(&sk_X509V3_EXT_METHOD_delete);
    eval 'sub sk_X509V3_EXT_METHOD_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509V3_EXT_METHOD *) &OPENSSL_sk_delete_ptr( &ossl_check_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_type($ptr))));
    }' unless defined(&sk_X509V3_EXT_METHOD_delete_ptr);
    eval 'sub sk_X509V3_EXT_METHOD_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_type($ptr)));
    }' unless defined(&sk_X509V3_EXT_METHOD_push);
    eval 'sub sk_X509V3_EXT_METHOD_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_type($ptr)));
    }' unless defined(&sk_X509V3_EXT_METHOD_unshift);
    eval 'sub sk_X509V3_EXT_METHOD_pop {
        my($sk) = @_;
	    eval q((( &X509V3_EXT_METHOD *) &OPENSSL_sk_pop( &ossl_check_X509V3_EXT_METHOD_sk_type($sk))));
    }' unless defined(&sk_X509V3_EXT_METHOD_pop);
    eval 'sub sk_X509V3_EXT_METHOD_shift {
        my($sk) = @_;
	    eval q((( &X509V3_EXT_METHOD *) &OPENSSL_sk_shift( &ossl_check_X509V3_EXT_METHOD_sk_type($sk))));
    }' unless defined(&sk_X509V3_EXT_METHOD_shift);
    eval 'sub sk_X509V3_EXT_METHOD_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509V3_EXT_METHOD_sk_type($sk), &ossl_check_X509V3_EXT_METHOD_freefunc_type($freefunc)));
    }' unless defined(&sk_X509V3_EXT_METHOD_pop_free);
    eval 'sub sk_X509V3_EXT_METHOD_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_type($ptr), ($idx)));
    }' unless defined(&sk_X509V3_EXT_METHOD_insert);
    eval 'sub sk_X509V3_EXT_METHOD_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509V3_EXT_METHOD *) &OPENSSL_sk_set( &ossl_check_X509V3_EXT_METHOD_sk_type($sk), ($idx),  &ossl_check_X509V3_EXT_METHOD_type($ptr))));
    }' unless defined(&sk_X509V3_EXT_METHOD_set);
    eval 'sub sk_X509V3_EXT_METHOD_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_type($ptr)));
    }' unless defined(&sk_X509V3_EXT_METHOD_find);
    eval 'sub sk_X509V3_EXT_METHOD_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_type($ptr)));
    }' unless defined(&sk_X509V3_EXT_METHOD_find_ex);
    eval 'sub sk_X509V3_EXT_METHOD_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_type($ptr), $pnum));
    }' unless defined(&sk_X509V3_EXT_METHOD_find_all);
    eval 'sub sk_X509V3_EXT_METHOD_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509V3_EXT_METHOD_sk_type($sk)));
    }' unless defined(&sk_X509V3_EXT_METHOD_sort);
    eval 'sub sk_X509V3_EXT_METHOD_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509V3_EXT_METHOD_sk_type($sk)));
    }' unless defined(&sk_X509V3_EXT_METHOD_is_sorted);
    eval 'sub sk_X509V3_EXT_METHOD_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509V3_EXT_METHOD) *) &OPENSSL_sk_dup( &ossl_check_const_X509V3_EXT_METHOD_sk_type($sk))));
    }' unless defined(&sk_X509V3_EXT_METHOD_dup);
    eval 'sub sk_X509V3_EXT_METHOD_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509V3_EXT_METHOD) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_copyfunc_type($copyfunc),  &ossl_check_X509V3_EXT_METHOD_freefunc_type($freefunc))));
    }' unless defined(&sk_X509V3_EXT_METHOD_deep_copy);
    eval 'sub sk_X509V3_EXT_METHOD_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509V3_EXT_METHOD_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509V3_EXT_METHOD_sk_type($sk),  &ossl_check_X509V3_EXT_METHOD_compfunc_type($cmp))));
    }' unless defined(&sk_X509V3_EXT_METHOD_set_cmp_func);
    eval 'sub X509V3_EXT_DYNAMIC () {0x1;}' unless defined(&X509V3_EXT_DYNAMIC);
    eval 'sub X509V3_EXT_CTX_DEP () {0x2;}' unless defined(&X509V3_EXT_CTX_DEP);
    eval 'sub X509V3_EXT_MULTILINE () {0x4;}' unless defined(&X509V3_EXT_MULTILINE);
    eval 'sub GEN_OTHERNAME () {0;}' unless defined(&GEN_OTHERNAME);
    eval 'sub GEN_EMAIL () {1;}' unless defined(&GEN_EMAIL);
    eval 'sub GEN_DNS () {2;}' unless defined(&GEN_DNS);
    eval 'sub GEN_X400 () {3;}' unless defined(&GEN_X400);
    eval 'sub GEN_DIRNAME () {4;}' unless defined(&GEN_DIRNAME);
    eval 'sub GEN_EDIPARTY () {5;}' unless defined(&GEN_EDIPARTY);
    eval 'sub GEN_URI () {6;}' unless defined(&GEN_URI);
    eval 'sub GEN_IPADD () {7;}' unless defined(&GEN_IPADD);
    eval 'sub GEN_RID () {8;}' unless defined(&GEN_RID);
    eval 'sub sk_ACCESS_DESCRIPTION_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_ACCESS_DESCRIPTION_sk_type($sk)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_num);
    eval 'sub sk_ACCESS_DESCRIPTION_value {
        my($sk, $idx) = @_;
	    eval q((( &ACCESS_DESCRIPTION *) &OPENSSL_sk_value( &ossl_check_const_ACCESS_DESCRIPTION_sk_type($sk), ($idx))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_value);
    eval 'sub sk_ACCESS_DESCRIPTION_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &ACCESS_DESCRIPTION) *) &OPENSSL_sk_new( &ossl_check_ACCESS_DESCRIPTION_compfunc_type($cmp))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_new);
    eval 'sub sk_ACCESS_DESCRIPTION_new_null () {
        eval q((( &STACK_OF( &ACCESS_DESCRIPTION) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_ACCESS_DESCRIPTION_new_null);
    eval 'sub sk_ACCESS_DESCRIPTION_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &ACCESS_DESCRIPTION) *) &OPENSSL_sk_new_reserve( &ossl_check_ACCESS_DESCRIPTION_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_new_reserve);
    eval 'sub sk_ACCESS_DESCRIPTION_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk), ($n)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_reserve);
    eval 'sub sk_ACCESS_DESCRIPTION_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_free);
    eval 'sub sk_ACCESS_DESCRIPTION_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_zero);
    eval 'sub sk_ACCESS_DESCRIPTION_delete {
        my($sk, $i) = @_;
	    eval q((( &ACCESS_DESCRIPTION *) &OPENSSL_sk_delete( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk), ($i))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_delete);
    eval 'sub sk_ACCESS_DESCRIPTION_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &ACCESS_DESCRIPTION *) &OPENSSL_sk_delete_ptr( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_type($ptr))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_delete_ptr);
    eval 'sub sk_ACCESS_DESCRIPTION_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_type($ptr)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_push);
    eval 'sub sk_ACCESS_DESCRIPTION_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_type($ptr)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_unshift);
    eval 'sub sk_ACCESS_DESCRIPTION_pop {
        my($sk) = @_;
	    eval q((( &ACCESS_DESCRIPTION *) &OPENSSL_sk_pop( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_pop);
    eval 'sub sk_ACCESS_DESCRIPTION_shift {
        my($sk) = @_;
	    eval q((( &ACCESS_DESCRIPTION *) &OPENSSL_sk_shift( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_shift);
    eval 'sub sk_ACCESS_DESCRIPTION_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk), &ossl_check_ACCESS_DESCRIPTION_freefunc_type($freefunc)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_pop_free);
    eval 'sub sk_ACCESS_DESCRIPTION_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_type($ptr), ($idx)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_insert);
    eval 'sub sk_ACCESS_DESCRIPTION_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &ACCESS_DESCRIPTION *) &OPENSSL_sk_set( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk), ($idx),  &ossl_check_ACCESS_DESCRIPTION_type($ptr))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_set);
    eval 'sub sk_ACCESS_DESCRIPTION_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_type($ptr)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_find);
    eval 'sub sk_ACCESS_DESCRIPTION_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_type($ptr)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_find_ex);
    eval 'sub sk_ACCESS_DESCRIPTION_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_type($ptr), $pnum));
    }' unless defined(&sk_ACCESS_DESCRIPTION_find_all);
    eval 'sub sk_ACCESS_DESCRIPTION_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_sort);
    eval 'sub sk_ACCESS_DESCRIPTION_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_ACCESS_DESCRIPTION_sk_type($sk)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_is_sorted);
    eval 'sub sk_ACCESS_DESCRIPTION_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &ACCESS_DESCRIPTION) *) &OPENSSL_sk_dup( &ossl_check_const_ACCESS_DESCRIPTION_sk_type($sk))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_dup);
    eval 'sub sk_ACCESS_DESCRIPTION_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &ACCESS_DESCRIPTION) *) &OPENSSL_sk_deep_copy( &ossl_check_const_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_copyfunc_type($copyfunc),  &ossl_check_ACCESS_DESCRIPTION_freefunc_type($freefunc))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_deep_copy);
    eval 'sub sk_ACCESS_DESCRIPTION_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_ACCESS_DESCRIPTION_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_ACCESS_DESCRIPTION_sk_type($sk),  &ossl_check_ACCESS_DESCRIPTION_compfunc_type($cmp))));
    }' unless defined(&sk_ACCESS_DESCRIPTION_set_cmp_func);
    eval 'sub sk_GENERAL_NAME_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_GENERAL_NAME_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAME_num);
    eval 'sub sk_GENERAL_NAME_value {
        my($sk, $idx) = @_;
	    eval q((( &GENERAL_NAME *) &OPENSSL_sk_value( &ossl_check_const_GENERAL_NAME_sk_type($sk), ($idx))));
    }' unless defined(&sk_GENERAL_NAME_value);
    eval 'sub sk_GENERAL_NAME_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &GENERAL_NAME) *) &OPENSSL_sk_new( &ossl_check_GENERAL_NAME_compfunc_type($cmp))));
    }' unless defined(&sk_GENERAL_NAME_new);
    eval 'sub sk_GENERAL_NAME_new_null () {
        eval q((( &STACK_OF( &GENERAL_NAME) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_GENERAL_NAME_new_null);
    eval 'sub sk_GENERAL_NAME_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &GENERAL_NAME) *) &OPENSSL_sk_new_reserve( &ossl_check_GENERAL_NAME_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_GENERAL_NAME_new_reserve);
    eval 'sub sk_GENERAL_NAME_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_GENERAL_NAME_sk_type($sk), ($n)));
    }' unless defined(&sk_GENERAL_NAME_reserve);
    eval 'sub sk_GENERAL_NAME_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_GENERAL_NAME_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAME_free);
    eval 'sub sk_GENERAL_NAME_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_GENERAL_NAME_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAME_zero);
    eval 'sub sk_GENERAL_NAME_delete {
        my($sk, $i) = @_;
	    eval q((( &GENERAL_NAME *) &OPENSSL_sk_delete( &ossl_check_GENERAL_NAME_sk_type($sk), ($i))));
    }' unless defined(&sk_GENERAL_NAME_delete);
    eval 'sub sk_GENERAL_NAME_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &GENERAL_NAME *) &OPENSSL_sk_delete_ptr( &ossl_check_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_type($ptr))));
    }' unless defined(&sk_GENERAL_NAME_delete_ptr);
    eval 'sub sk_GENERAL_NAME_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_type($ptr)));
    }' unless defined(&sk_GENERAL_NAME_push);
    eval 'sub sk_GENERAL_NAME_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_type($ptr)));
    }' unless defined(&sk_GENERAL_NAME_unshift);
    eval 'sub sk_GENERAL_NAME_pop {
        my($sk) = @_;
	    eval q((( &GENERAL_NAME *) &OPENSSL_sk_pop( &ossl_check_GENERAL_NAME_sk_type($sk))));
    }' unless defined(&sk_GENERAL_NAME_pop);
    eval 'sub sk_GENERAL_NAME_shift {
        my($sk) = @_;
	    eval q((( &GENERAL_NAME *) &OPENSSL_sk_shift( &ossl_check_GENERAL_NAME_sk_type($sk))));
    }' unless defined(&sk_GENERAL_NAME_shift);
    eval 'sub sk_GENERAL_NAME_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_GENERAL_NAME_sk_type($sk), &ossl_check_GENERAL_NAME_freefunc_type($freefunc)));
    }' unless defined(&sk_GENERAL_NAME_pop_free);
    eval 'sub sk_GENERAL_NAME_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_type($ptr), ($idx)));
    }' unless defined(&sk_GENERAL_NAME_insert);
    eval 'sub sk_GENERAL_NAME_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &GENERAL_NAME *) &OPENSSL_sk_set( &ossl_check_GENERAL_NAME_sk_type($sk), ($idx),  &ossl_check_GENERAL_NAME_type($ptr))));
    }' unless defined(&sk_GENERAL_NAME_set);
    eval 'sub sk_GENERAL_NAME_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_type($ptr)));
    }' unless defined(&sk_GENERAL_NAME_find);
    eval 'sub sk_GENERAL_NAME_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_type($ptr)));
    }' unless defined(&sk_GENERAL_NAME_find_ex);
    eval 'sub sk_GENERAL_NAME_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_type($ptr), $pnum));
    }' unless defined(&sk_GENERAL_NAME_find_all);
    eval 'sub sk_GENERAL_NAME_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_GENERAL_NAME_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAME_sort);
    eval 'sub sk_GENERAL_NAME_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_GENERAL_NAME_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAME_is_sorted);
    eval 'sub sk_GENERAL_NAME_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &GENERAL_NAME) *) &OPENSSL_sk_dup( &ossl_check_const_GENERAL_NAME_sk_type($sk))));
    }' unless defined(&sk_GENERAL_NAME_dup);
    eval 'sub sk_GENERAL_NAME_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &GENERAL_NAME) *) &OPENSSL_sk_deep_copy( &ossl_check_const_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_copyfunc_type($copyfunc),  &ossl_check_GENERAL_NAME_freefunc_type($freefunc))));
    }' unless defined(&sk_GENERAL_NAME_deep_copy);
    eval 'sub sk_GENERAL_NAME_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_GENERAL_NAME_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_GENERAL_NAME_sk_type($sk),  &ossl_check_GENERAL_NAME_compfunc_type($cmp))));
    }' unless defined(&sk_GENERAL_NAME_set_cmp_func);
    eval 'sub sk_GENERAL_NAMES_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_GENERAL_NAMES_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAMES_num);
    eval 'sub sk_GENERAL_NAMES_value {
        my($sk, $idx) = @_;
	    eval q((( &GENERAL_NAMES *) &OPENSSL_sk_value( &ossl_check_const_GENERAL_NAMES_sk_type($sk), ($idx))));
    }' unless defined(&sk_GENERAL_NAMES_value);
    eval 'sub sk_GENERAL_NAMES_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &GENERAL_NAMES) *) &OPENSSL_sk_new( &ossl_check_GENERAL_NAMES_compfunc_type($cmp))));
    }' unless defined(&sk_GENERAL_NAMES_new);
    eval 'sub sk_GENERAL_NAMES_new_null () {
        eval q((( &STACK_OF( &GENERAL_NAMES) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_GENERAL_NAMES_new_null);
    eval 'sub sk_GENERAL_NAMES_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &GENERAL_NAMES) *) &OPENSSL_sk_new_reserve( &ossl_check_GENERAL_NAMES_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_GENERAL_NAMES_new_reserve);
    eval 'sub sk_GENERAL_NAMES_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_GENERAL_NAMES_sk_type($sk), ($n)));
    }' unless defined(&sk_GENERAL_NAMES_reserve);
    eval 'sub sk_GENERAL_NAMES_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_GENERAL_NAMES_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAMES_free);
    eval 'sub sk_GENERAL_NAMES_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_GENERAL_NAMES_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAMES_zero);
    eval 'sub sk_GENERAL_NAMES_delete {
        my($sk, $i) = @_;
	    eval q((( &GENERAL_NAMES *) &OPENSSL_sk_delete( &ossl_check_GENERAL_NAMES_sk_type($sk), ($i))));
    }' unless defined(&sk_GENERAL_NAMES_delete);
    eval 'sub sk_GENERAL_NAMES_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &GENERAL_NAMES *) &OPENSSL_sk_delete_ptr( &ossl_check_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_type($ptr))));
    }' unless defined(&sk_GENERAL_NAMES_delete_ptr);
    eval 'sub sk_GENERAL_NAMES_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_type($ptr)));
    }' unless defined(&sk_GENERAL_NAMES_push);
    eval 'sub sk_GENERAL_NAMES_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_type($ptr)));
    }' unless defined(&sk_GENERAL_NAMES_unshift);
    eval 'sub sk_GENERAL_NAMES_pop {
        my($sk) = @_;
	    eval q((( &GENERAL_NAMES *) &OPENSSL_sk_pop( &ossl_check_GENERAL_NAMES_sk_type($sk))));
    }' unless defined(&sk_GENERAL_NAMES_pop);
    eval 'sub sk_GENERAL_NAMES_shift {
        my($sk) = @_;
	    eval q((( &GENERAL_NAMES *) &OPENSSL_sk_shift( &ossl_check_GENERAL_NAMES_sk_type($sk))));
    }' unless defined(&sk_GENERAL_NAMES_shift);
    eval 'sub sk_GENERAL_NAMES_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_GENERAL_NAMES_sk_type($sk), &ossl_check_GENERAL_NAMES_freefunc_type($freefunc)));
    }' unless defined(&sk_GENERAL_NAMES_pop_free);
    eval 'sub sk_GENERAL_NAMES_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_type($ptr), ($idx)));
    }' unless defined(&sk_GENERAL_NAMES_insert);
    eval 'sub sk_GENERAL_NAMES_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &GENERAL_NAMES *) &OPENSSL_sk_set( &ossl_check_GENERAL_NAMES_sk_type($sk), ($idx),  &ossl_check_GENERAL_NAMES_type($ptr))));
    }' unless defined(&sk_GENERAL_NAMES_set);
    eval 'sub sk_GENERAL_NAMES_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_type($ptr)));
    }' unless defined(&sk_GENERAL_NAMES_find);
    eval 'sub sk_GENERAL_NAMES_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_type($ptr)));
    }' unless defined(&sk_GENERAL_NAMES_find_ex);
    eval 'sub sk_GENERAL_NAMES_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_type($ptr), $pnum));
    }' unless defined(&sk_GENERAL_NAMES_find_all);
    eval 'sub sk_GENERAL_NAMES_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_GENERAL_NAMES_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAMES_sort);
    eval 'sub sk_GENERAL_NAMES_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_GENERAL_NAMES_sk_type($sk)));
    }' unless defined(&sk_GENERAL_NAMES_is_sorted);
    eval 'sub sk_GENERAL_NAMES_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &GENERAL_NAMES) *) &OPENSSL_sk_dup( &ossl_check_const_GENERAL_NAMES_sk_type($sk))));
    }' unless defined(&sk_GENERAL_NAMES_dup);
    eval 'sub sk_GENERAL_NAMES_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &GENERAL_NAMES) *) &OPENSSL_sk_deep_copy( &ossl_check_const_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_copyfunc_type($copyfunc),  &ossl_check_GENERAL_NAMES_freefunc_type($freefunc))));
    }' unless defined(&sk_GENERAL_NAMES_deep_copy);
    eval 'sub sk_GENERAL_NAMES_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_GENERAL_NAMES_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_GENERAL_NAMES_sk_type($sk),  &ossl_check_GENERAL_NAMES_compfunc_type($cmp))));
    }' unless defined(&sk_GENERAL_NAMES_set_cmp_func);
    eval 'sub CRLDP_ALL_REASONS () {0x807f;}' unless defined(&CRLDP_ALL_REASONS);
    eval 'sub CRL_REASON_NONE () {-1;}' unless defined(&CRL_REASON_NONE);
    eval 'sub CRL_REASON_UNSPECIFIED () {0;}' unless defined(&CRL_REASON_UNSPECIFIED);
    eval 'sub CRL_REASON_KEY_COMPROMISE () {1;}' unless defined(&CRL_REASON_KEY_COMPROMISE);
    eval 'sub CRL_REASON_CA_COMPROMISE () {2;}' unless defined(&CRL_REASON_CA_COMPROMISE);
    eval 'sub CRL_REASON_AFFILIATION_CHANGED () {3;}' unless defined(&CRL_REASON_AFFILIATION_CHANGED);
    eval 'sub CRL_REASON_SUPERSEDED () {4;}' unless defined(&CRL_REASON_SUPERSEDED);
    eval 'sub CRL_REASON_CESSATION_OF_OPERATION () {5;}' unless defined(&CRL_REASON_CESSATION_OF_OPERATION);
    eval 'sub CRL_REASON_CERTIFICATE_HOLD () {6;}' unless defined(&CRL_REASON_CERTIFICATE_HOLD);
    eval 'sub CRL_REASON_REMOVE_FROM_CRL () {8;}' unless defined(&CRL_REASON_REMOVE_FROM_CRL);
    eval 'sub CRL_REASON_PRIVILEGE_WITHDRAWN () {9;}' unless defined(&CRL_REASON_PRIVILEGE_WITHDRAWN);
    eval 'sub CRL_REASON_AA_COMPROMISE () {10;}' unless defined(&CRL_REASON_AA_COMPROMISE);
    eval 'sub sk_DIST_POINT_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_DIST_POINT_sk_type($sk)));
    }' unless defined(&sk_DIST_POINT_num);
    eval 'sub sk_DIST_POINT_value {
        my($sk, $idx) = @_;
	    eval q((( &DIST_POINT *) &OPENSSL_sk_value( &ossl_check_const_DIST_POINT_sk_type($sk), ($idx))));
    }' unless defined(&sk_DIST_POINT_value);
    eval 'sub sk_DIST_POINT_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &DIST_POINT) *) &OPENSSL_sk_new( &ossl_check_DIST_POINT_compfunc_type($cmp))));
    }' unless defined(&sk_DIST_POINT_new);
    eval 'sub sk_DIST_POINT_new_null () {
        eval q((( &STACK_OF( &DIST_POINT) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_DIST_POINT_new_null);
    eval 'sub sk_DIST_POINT_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &DIST_POINT) *) &OPENSSL_sk_new_reserve( &ossl_check_DIST_POINT_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_DIST_POINT_new_reserve);
    eval 'sub sk_DIST_POINT_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_DIST_POINT_sk_type($sk), ($n)));
    }' unless defined(&sk_DIST_POINT_reserve);
    eval 'sub sk_DIST_POINT_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_DIST_POINT_sk_type($sk)));
    }' unless defined(&sk_DIST_POINT_free);
    eval 'sub sk_DIST_POINT_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_DIST_POINT_sk_type($sk)));
    }' unless defined(&sk_DIST_POINT_zero);
    eval 'sub sk_DIST_POINT_delete {
        my($sk, $i) = @_;
	    eval q((( &DIST_POINT *) &OPENSSL_sk_delete( &ossl_check_DIST_POINT_sk_type($sk), ($i))));
    }' unless defined(&sk_DIST_POINT_delete);
    eval 'sub sk_DIST_POINT_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &DIST_POINT *) &OPENSSL_sk_delete_ptr( &ossl_check_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_type($ptr))));
    }' unless defined(&sk_DIST_POINT_delete_ptr);
    eval 'sub sk_DIST_POINT_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_type($ptr)));
    }' unless defined(&sk_DIST_POINT_push);
    eval 'sub sk_DIST_POINT_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_type($ptr)));
    }' unless defined(&sk_DIST_POINT_unshift);
    eval 'sub sk_DIST_POINT_pop {
        my($sk) = @_;
	    eval q((( &DIST_POINT *) &OPENSSL_sk_pop( &ossl_check_DIST_POINT_sk_type($sk))));
    }' unless defined(&sk_DIST_POINT_pop);
    eval 'sub sk_DIST_POINT_shift {
        my($sk) = @_;
	    eval q((( &DIST_POINT *) &OPENSSL_sk_shift( &ossl_check_DIST_POINT_sk_type($sk))));
    }' unless defined(&sk_DIST_POINT_shift);
    eval 'sub sk_DIST_POINT_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_DIST_POINT_sk_type($sk), &ossl_check_DIST_POINT_freefunc_type($freefunc)));
    }' unless defined(&sk_DIST_POINT_pop_free);
    eval 'sub sk_DIST_POINT_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_type($ptr), ($idx)));
    }' unless defined(&sk_DIST_POINT_insert);
    eval 'sub sk_DIST_POINT_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &DIST_POINT *) &OPENSSL_sk_set( &ossl_check_DIST_POINT_sk_type($sk), ($idx),  &ossl_check_DIST_POINT_type($ptr))));
    }' unless defined(&sk_DIST_POINT_set);
    eval 'sub sk_DIST_POINT_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_type($ptr)));
    }' unless defined(&sk_DIST_POINT_find);
    eval 'sub sk_DIST_POINT_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_type($ptr)));
    }' unless defined(&sk_DIST_POINT_find_ex);
    eval 'sub sk_DIST_POINT_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_type($ptr), $pnum));
    }' unless defined(&sk_DIST_POINT_find_all);
    eval 'sub sk_DIST_POINT_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_DIST_POINT_sk_type($sk)));
    }' unless defined(&sk_DIST_POINT_sort);
    eval 'sub sk_DIST_POINT_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_DIST_POINT_sk_type($sk)));
    }' unless defined(&sk_DIST_POINT_is_sorted);
    eval 'sub sk_DIST_POINT_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &DIST_POINT) *) &OPENSSL_sk_dup( &ossl_check_const_DIST_POINT_sk_type($sk))));
    }' unless defined(&sk_DIST_POINT_dup);
    eval 'sub sk_DIST_POINT_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &DIST_POINT) *) &OPENSSL_sk_deep_copy( &ossl_check_const_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_copyfunc_type($copyfunc),  &ossl_check_DIST_POINT_freefunc_type($freefunc))));
    }' unless defined(&sk_DIST_POINT_deep_copy);
    eval 'sub sk_DIST_POINT_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_DIST_POINT_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_DIST_POINT_sk_type($sk),  &ossl_check_DIST_POINT_compfunc_type($cmp))));
    }' unless defined(&sk_DIST_POINT_set_cmp_func);
    eval 'sub sk_SXNETID_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_SXNETID_sk_type($sk)));
    }' unless defined(&sk_SXNETID_num);
    eval 'sub sk_SXNETID_value {
        my($sk, $idx) = @_;
	    eval q((( &SXNETID *) &OPENSSL_sk_value( &ossl_check_const_SXNETID_sk_type($sk), ($idx))));
    }' unless defined(&sk_SXNETID_value);
    eval 'sub sk_SXNETID_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &SXNETID) *) &OPENSSL_sk_new( &ossl_check_SXNETID_compfunc_type($cmp))));
    }' unless defined(&sk_SXNETID_new);
    eval 'sub sk_SXNETID_new_null () {
        eval q((( &STACK_OF( &SXNETID) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_SXNETID_new_null);
    eval 'sub sk_SXNETID_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &SXNETID) *) &OPENSSL_sk_new_reserve( &ossl_check_SXNETID_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_SXNETID_new_reserve);
    eval 'sub sk_SXNETID_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_SXNETID_sk_type($sk), ($n)));
    }' unless defined(&sk_SXNETID_reserve);
    eval 'sub sk_SXNETID_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_SXNETID_sk_type($sk)));
    }' unless defined(&sk_SXNETID_free);
    eval 'sub sk_SXNETID_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_SXNETID_sk_type($sk)));
    }' unless defined(&sk_SXNETID_zero);
    eval 'sub sk_SXNETID_delete {
        my($sk, $i) = @_;
	    eval q((( &SXNETID *) &OPENSSL_sk_delete( &ossl_check_SXNETID_sk_type($sk), ($i))));
    }' unless defined(&sk_SXNETID_delete);
    eval 'sub sk_SXNETID_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &SXNETID *) &OPENSSL_sk_delete_ptr( &ossl_check_SXNETID_sk_type($sk),  &ossl_check_SXNETID_type($ptr))));
    }' unless defined(&sk_SXNETID_delete_ptr);
    eval 'sub sk_SXNETID_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_SXNETID_sk_type($sk),  &ossl_check_SXNETID_type($ptr)));
    }' unless defined(&sk_SXNETID_push);
    eval 'sub sk_SXNETID_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_SXNETID_sk_type($sk),  &ossl_check_SXNETID_type($ptr)));
    }' unless defined(&sk_SXNETID_unshift);
    eval 'sub sk_SXNETID_pop {
        my($sk) = @_;
	    eval q((( &SXNETID *) &OPENSSL_sk_pop( &ossl_check_SXNETID_sk_type($sk))));
    }' unless defined(&sk_SXNETID_pop);
    eval 'sub sk_SXNETID_shift {
        my($sk) = @_;
	    eval q((( &SXNETID *) &OPENSSL_sk_shift( &ossl_check_SXNETID_sk_type($sk))));
    }' unless defined(&sk_SXNETID_shift);
    eval 'sub sk_SXNETID_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_SXNETID_sk_type($sk), &ossl_check_SXNETID_freefunc_type($freefunc)));
    }' unless defined(&sk_SXNETID_pop_free);
    eval 'sub sk_SXNETID_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_SXNETID_sk_type($sk),  &ossl_check_SXNETID_type($ptr), ($idx)));
    }' unless defined(&sk_SXNETID_insert);
    eval 'sub sk_SXNETID_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &SXNETID *) &OPENSSL_sk_set( &ossl_check_SXNETID_sk_type($sk), ($idx),  &ossl_check_SXNETID_type($ptr))));
    }' unless defined(&sk_SXNETID_set);
    eval 'sub sk_SXNETID_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_SXNETID_sk_type($sk),  &ossl_check_SXNETID_type($ptr)));
    }' unless defined(&sk_SXNETID_find);
    eval 'sub sk_SXNETID_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_SXNETID_sk_type($sk),  &ossl_check_SXNETID_type($ptr)));
    }' unless defined(&sk_SXNETID_find_ex);
    eval 'sub sk_SXNETID_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_SXNETID_sk_type($sk),  &ossl_check_SXNETID_type($ptr), $pnum));
    }' unless defined(&sk_SXNETID_find_all);
    eval 'sub sk_SXNETID_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_SXNETID_sk_type($sk)));
    }' unless defined(&sk_SXNETID_sort);
    eval 'sub sk_SXNETID_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_SXNETID_sk_type($sk)));
    }' unless defined(&sk_SXNETID_is_sorted);
    eval 'sub sk_SXNETID_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &SXNETID) *) &OPENSSL_sk_dup( &ossl_check_const_SXNETID_sk_type($sk))));
    }' unless defined(&sk_SXNETID_dup);
    eval 'sub sk_SXNETID_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &SXNETID) *) &OPENSSL_sk_deep_copy( &ossl_check_const_SXNETID_sk_type($sk),  &ossl_check_SXNETID_copyfunc_type($copyfunc),  &ossl_check_SXNETID_freefunc_type($freefunc))));
    }' unless defined(&sk_SXNETID_deep_copy);
    eval 'sub sk_SXNETID_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_SXNETID_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_SXNETID_sk_type($sk),  &ossl_check_SXNETID_compfunc_type($cmp))));
    }' unless defined(&sk_SXNETID_set_cmp_func);
    eval 'sub sk_POLICYQUALINFO_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_POLICYQUALINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYQUALINFO_num);
    eval 'sub sk_POLICYQUALINFO_value {
        my($sk, $idx) = @_;
	    eval q((( &POLICYQUALINFO *) &OPENSSL_sk_value( &ossl_check_const_POLICYQUALINFO_sk_type($sk), ($idx))));
    }' unless defined(&sk_POLICYQUALINFO_value);
    eval 'sub sk_POLICYQUALINFO_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &POLICYQUALINFO) *) &OPENSSL_sk_new( &ossl_check_POLICYQUALINFO_compfunc_type($cmp))));
    }' unless defined(&sk_POLICYQUALINFO_new);
    eval 'sub sk_POLICYQUALINFO_new_null () {
        eval q((( &STACK_OF( &POLICYQUALINFO) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_POLICYQUALINFO_new_null);
    eval 'sub sk_POLICYQUALINFO_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &POLICYQUALINFO) *) &OPENSSL_sk_new_reserve( &ossl_check_POLICYQUALINFO_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_POLICYQUALINFO_new_reserve);
    eval 'sub sk_POLICYQUALINFO_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_POLICYQUALINFO_sk_type($sk), ($n)));
    }' unless defined(&sk_POLICYQUALINFO_reserve);
    eval 'sub sk_POLICYQUALINFO_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_POLICYQUALINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYQUALINFO_free);
    eval 'sub sk_POLICYQUALINFO_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_POLICYQUALINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYQUALINFO_zero);
    eval 'sub sk_POLICYQUALINFO_delete {
        my($sk, $i) = @_;
	    eval q((( &POLICYQUALINFO *) &OPENSSL_sk_delete( &ossl_check_POLICYQUALINFO_sk_type($sk), ($i))));
    }' unless defined(&sk_POLICYQUALINFO_delete);
    eval 'sub sk_POLICYQUALINFO_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &POLICYQUALINFO *) &OPENSSL_sk_delete_ptr( &ossl_check_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_type($ptr))));
    }' unless defined(&sk_POLICYQUALINFO_delete_ptr);
    eval 'sub sk_POLICYQUALINFO_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_type($ptr)));
    }' unless defined(&sk_POLICYQUALINFO_push);
    eval 'sub sk_POLICYQUALINFO_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_type($ptr)));
    }' unless defined(&sk_POLICYQUALINFO_unshift);
    eval 'sub sk_POLICYQUALINFO_pop {
        my($sk) = @_;
	    eval q((( &POLICYQUALINFO *) &OPENSSL_sk_pop( &ossl_check_POLICYQUALINFO_sk_type($sk))));
    }' unless defined(&sk_POLICYQUALINFO_pop);
    eval 'sub sk_POLICYQUALINFO_shift {
        my($sk) = @_;
	    eval q((( &POLICYQUALINFO *) &OPENSSL_sk_shift( &ossl_check_POLICYQUALINFO_sk_type($sk))));
    }' unless defined(&sk_POLICYQUALINFO_shift);
    eval 'sub sk_POLICYQUALINFO_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_POLICYQUALINFO_sk_type($sk), &ossl_check_POLICYQUALINFO_freefunc_type($freefunc)));
    }' unless defined(&sk_POLICYQUALINFO_pop_free);
    eval 'sub sk_POLICYQUALINFO_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_type($ptr), ($idx)));
    }' unless defined(&sk_POLICYQUALINFO_insert);
    eval 'sub sk_POLICYQUALINFO_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &POLICYQUALINFO *) &OPENSSL_sk_set( &ossl_check_POLICYQUALINFO_sk_type($sk), ($idx),  &ossl_check_POLICYQUALINFO_type($ptr))));
    }' unless defined(&sk_POLICYQUALINFO_set);
    eval 'sub sk_POLICYQUALINFO_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_type($ptr)));
    }' unless defined(&sk_POLICYQUALINFO_find);
    eval 'sub sk_POLICYQUALINFO_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_type($ptr)));
    }' unless defined(&sk_POLICYQUALINFO_find_ex);
    eval 'sub sk_POLICYQUALINFO_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_type($ptr), $pnum));
    }' unless defined(&sk_POLICYQUALINFO_find_all);
    eval 'sub sk_POLICYQUALINFO_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_POLICYQUALINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYQUALINFO_sort);
    eval 'sub sk_POLICYQUALINFO_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_POLICYQUALINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYQUALINFO_is_sorted);
    eval 'sub sk_POLICYQUALINFO_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &POLICYQUALINFO) *) &OPENSSL_sk_dup( &ossl_check_const_POLICYQUALINFO_sk_type($sk))));
    }' unless defined(&sk_POLICYQUALINFO_dup);
    eval 'sub sk_POLICYQUALINFO_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &POLICYQUALINFO) *) &OPENSSL_sk_deep_copy( &ossl_check_const_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_copyfunc_type($copyfunc),  &ossl_check_POLICYQUALINFO_freefunc_type($freefunc))));
    }' unless defined(&sk_POLICYQUALINFO_deep_copy);
    eval 'sub sk_POLICYQUALINFO_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_POLICYQUALINFO_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_POLICYQUALINFO_sk_type($sk),  &ossl_check_POLICYQUALINFO_compfunc_type($cmp))));
    }' unless defined(&sk_POLICYQUALINFO_set_cmp_func);
    eval 'sub sk_POLICYINFO_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_POLICYINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYINFO_num);
    eval 'sub sk_POLICYINFO_value {
        my($sk, $idx) = @_;
	    eval q((( &POLICYINFO *) &OPENSSL_sk_value( &ossl_check_const_POLICYINFO_sk_type($sk), ($idx))));
    }' unless defined(&sk_POLICYINFO_value);
    eval 'sub sk_POLICYINFO_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &POLICYINFO) *) &OPENSSL_sk_new( &ossl_check_POLICYINFO_compfunc_type($cmp))));
    }' unless defined(&sk_POLICYINFO_new);
    eval 'sub sk_POLICYINFO_new_null () {
        eval q((( &STACK_OF( &POLICYINFO) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_POLICYINFO_new_null);
    eval 'sub sk_POLICYINFO_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &POLICYINFO) *) &OPENSSL_sk_new_reserve( &ossl_check_POLICYINFO_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_POLICYINFO_new_reserve);
    eval 'sub sk_POLICYINFO_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_POLICYINFO_sk_type($sk), ($n)));
    }' unless defined(&sk_POLICYINFO_reserve);
    eval 'sub sk_POLICYINFO_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_POLICYINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYINFO_free);
    eval 'sub sk_POLICYINFO_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_POLICYINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYINFO_zero);
    eval 'sub sk_POLICYINFO_delete {
        my($sk, $i) = @_;
	    eval q((( &POLICYINFO *) &OPENSSL_sk_delete( &ossl_check_POLICYINFO_sk_type($sk), ($i))));
    }' unless defined(&sk_POLICYINFO_delete);
    eval 'sub sk_POLICYINFO_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &POLICYINFO *) &OPENSSL_sk_delete_ptr( &ossl_check_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_type($ptr))));
    }' unless defined(&sk_POLICYINFO_delete_ptr);
    eval 'sub sk_POLICYINFO_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_type($ptr)));
    }' unless defined(&sk_POLICYINFO_push);
    eval 'sub sk_POLICYINFO_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_type($ptr)));
    }' unless defined(&sk_POLICYINFO_unshift);
    eval 'sub sk_POLICYINFO_pop {
        my($sk) = @_;
	    eval q((( &POLICYINFO *) &OPENSSL_sk_pop( &ossl_check_POLICYINFO_sk_type($sk))));
    }' unless defined(&sk_POLICYINFO_pop);
    eval 'sub sk_POLICYINFO_shift {
        my($sk) = @_;
	    eval q((( &POLICYINFO *) &OPENSSL_sk_shift( &ossl_check_POLICYINFO_sk_type($sk))));
    }' unless defined(&sk_POLICYINFO_shift);
    eval 'sub sk_POLICYINFO_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_POLICYINFO_sk_type($sk), &ossl_check_POLICYINFO_freefunc_type($freefunc)));
    }' unless defined(&sk_POLICYINFO_pop_free);
    eval 'sub sk_POLICYINFO_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_type($ptr), ($idx)));
    }' unless defined(&sk_POLICYINFO_insert);
    eval 'sub sk_POLICYINFO_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &POLICYINFO *) &OPENSSL_sk_set( &ossl_check_POLICYINFO_sk_type($sk), ($idx),  &ossl_check_POLICYINFO_type($ptr))));
    }' unless defined(&sk_POLICYINFO_set);
    eval 'sub sk_POLICYINFO_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_type($ptr)));
    }' unless defined(&sk_POLICYINFO_find);
    eval 'sub sk_POLICYINFO_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_type($ptr)));
    }' unless defined(&sk_POLICYINFO_find_ex);
    eval 'sub sk_POLICYINFO_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_type($ptr), $pnum));
    }' unless defined(&sk_POLICYINFO_find_all);
    eval 'sub sk_POLICYINFO_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_POLICYINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYINFO_sort);
    eval 'sub sk_POLICYINFO_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_POLICYINFO_sk_type($sk)));
    }' unless defined(&sk_POLICYINFO_is_sorted);
    eval 'sub sk_POLICYINFO_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &POLICYINFO) *) &OPENSSL_sk_dup( &ossl_check_const_POLICYINFO_sk_type($sk))));
    }' unless defined(&sk_POLICYINFO_dup);
    eval 'sub sk_POLICYINFO_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &POLICYINFO) *) &OPENSSL_sk_deep_copy( &ossl_check_const_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_copyfunc_type($copyfunc),  &ossl_check_POLICYINFO_freefunc_type($freefunc))));
    }' unless defined(&sk_POLICYINFO_deep_copy);
    eval 'sub sk_POLICYINFO_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_POLICYINFO_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_POLICYINFO_sk_type($sk),  &ossl_check_POLICYINFO_compfunc_type($cmp))));
    }' unless defined(&sk_POLICYINFO_set_cmp_func);
    eval 'sub sk_POLICY_MAPPING_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_POLICY_MAPPING_sk_type($sk)));
    }' unless defined(&sk_POLICY_MAPPING_num);
    eval 'sub sk_POLICY_MAPPING_value {
        my($sk, $idx) = @_;
	    eval q((( &POLICY_MAPPING *) &OPENSSL_sk_value( &ossl_check_const_POLICY_MAPPING_sk_type($sk), ($idx))));
    }' unless defined(&sk_POLICY_MAPPING_value);
    eval 'sub sk_POLICY_MAPPING_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &POLICY_MAPPING) *) &OPENSSL_sk_new( &ossl_check_POLICY_MAPPING_compfunc_type($cmp))));
    }' unless defined(&sk_POLICY_MAPPING_new);
    eval 'sub sk_POLICY_MAPPING_new_null () {
        eval q((( &STACK_OF( &POLICY_MAPPING) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_POLICY_MAPPING_new_null);
    eval 'sub sk_POLICY_MAPPING_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &POLICY_MAPPING) *) &OPENSSL_sk_new_reserve( &ossl_check_POLICY_MAPPING_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_POLICY_MAPPING_new_reserve);
    eval 'sub sk_POLICY_MAPPING_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_POLICY_MAPPING_sk_type($sk), ($n)));
    }' unless defined(&sk_POLICY_MAPPING_reserve);
    eval 'sub sk_POLICY_MAPPING_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_POLICY_MAPPING_sk_type($sk)));
    }' unless defined(&sk_POLICY_MAPPING_free);
    eval 'sub sk_POLICY_MAPPING_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_POLICY_MAPPING_sk_type($sk)));
    }' unless defined(&sk_POLICY_MAPPING_zero);
    eval 'sub sk_POLICY_MAPPING_delete {
        my($sk, $i) = @_;
	    eval q((( &POLICY_MAPPING *) &OPENSSL_sk_delete( &ossl_check_POLICY_MAPPING_sk_type($sk), ($i))));
    }' unless defined(&sk_POLICY_MAPPING_delete);
    eval 'sub sk_POLICY_MAPPING_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &POLICY_MAPPING *) &OPENSSL_sk_delete_ptr( &ossl_check_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_type($ptr))));
    }' unless defined(&sk_POLICY_MAPPING_delete_ptr);
    eval 'sub sk_POLICY_MAPPING_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_type($ptr)));
    }' unless defined(&sk_POLICY_MAPPING_push);
    eval 'sub sk_POLICY_MAPPING_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_type($ptr)));
    }' unless defined(&sk_POLICY_MAPPING_unshift);
    eval 'sub sk_POLICY_MAPPING_pop {
        my($sk) = @_;
	    eval q((( &POLICY_MAPPING *) &OPENSSL_sk_pop( &ossl_check_POLICY_MAPPING_sk_type($sk))));
    }' unless defined(&sk_POLICY_MAPPING_pop);
    eval 'sub sk_POLICY_MAPPING_shift {
        my($sk) = @_;
	    eval q((( &POLICY_MAPPING *) &OPENSSL_sk_shift( &ossl_check_POLICY_MAPPING_sk_type($sk))));
    }' unless defined(&sk_POLICY_MAPPING_shift);
    eval 'sub sk_POLICY_MAPPING_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_POLICY_MAPPING_sk_type($sk), &ossl_check_POLICY_MAPPING_freefunc_type($freefunc)));
    }' unless defined(&sk_POLICY_MAPPING_pop_free);
    eval 'sub sk_POLICY_MAPPING_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_type($ptr), ($idx)));
    }' unless defined(&sk_POLICY_MAPPING_insert);
    eval 'sub sk_POLICY_MAPPING_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &POLICY_MAPPING *) &OPENSSL_sk_set( &ossl_check_POLICY_MAPPING_sk_type($sk), ($idx),  &ossl_check_POLICY_MAPPING_type($ptr))));
    }' unless defined(&sk_POLICY_MAPPING_set);
    eval 'sub sk_POLICY_MAPPING_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_type($ptr)));
    }' unless defined(&sk_POLICY_MAPPING_find);
    eval 'sub sk_POLICY_MAPPING_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_type($ptr)));
    }' unless defined(&sk_POLICY_MAPPING_find_ex);
    eval 'sub sk_POLICY_MAPPING_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_type($ptr), $pnum));
    }' unless defined(&sk_POLICY_MAPPING_find_all);
    eval 'sub sk_POLICY_MAPPING_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_POLICY_MAPPING_sk_type($sk)));
    }' unless defined(&sk_POLICY_MAPPING_sort);
    eval 'sub sk_POLICY_MAPPING_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_POLICY_MAPPING_sk_type($sk)));
    }' unless defined(&sk_POLICY_MAPPING_is_sorted);
    eval 'sub sk_POLICY_MAPPING_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &POLICY_MAPPING) *) &OPENSSL_sk_dup( &ossl_check_const_POLICY_MAPPING_sk_type($sk))));
    }' unless defined(&sk_POLICY_MAPPING_dup);
    eval 'sub sk_POLICY_MAPPING_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &POLICY_MAPPING) *) &OPENSSL_sk_deep_copy( &ossl_check_const_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_copyfunc_type($copyfunc),  &ossl_check_POLICY_MAPPING_freefunc_type($freefunc))));
    }' unless defined(&sk_POLICY_MAPPING_deep_copy);
    eval 'sub sk_POLICY_MAPPING_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_POLICY_MAPPING_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_POLICY_MAPPING_sk_type($sk),  &ossl_check_POLICY_MAPPING_compfunc_type($cmp))));
    }' unless defined(&sk_POLICY_MAPPING_set_cmp_func);
    eval 'sub sk_GENERAL_SUBTREE_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_GENERAL_SUBTREE_sk_type($sk)));
    }' unless defined(&sk_GENERAL_SUBTREE_num);
    eval 'sub sk_GENERAL_SUBTREE_value {
        my($sk, $idx) = @_;
	    eval q((( &GENERAL_SUBTREE *) &OPENSSL_sk_value( &ossl_check_const_GENERAL_SUBTREE_sk_type($sk), ($idx))));
    }' unless defined(&sk_GENERAL_SUBTREE_value);
    eval 'sub sk_GENERAL_SUBTREE_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &GENERAL_SUBTREE) *) &OPENSSL_sk_new( &ossl_check_GENERAL_SUBTREE_compfunc_type($cmp))));
    }' unless defined(&sk_GENERAL_SUBTREE_new);
    eval 'sub sk_GENERAL_SUBTREE_new_null () {
        eval q((( &STACK_OF( &GENERAL_SUBTREE) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_GENERAL_SUBTREE_new_null);
    eval 'sub sk_GENERAL_SUBTREE_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &GENERAL_SUBTREE) *) &OPENSSL_sk_new_reserve( &ossl_check_GENERAL_SUBTREE_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_GENERAL_SUBTREE_new_reserve);
    eval 'sub sk_GENERAL_SUBTREE_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_GENERAL_SUBTREE_sk_type($sk), ($n)));
    }' unless defined(&sk_GENERAL_SUBTREE_reserve);
    eval 'sub sk_GENERAL_SUBTREE_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_GENERAL_SUBTREE_sk_type($sk)));
    }' unless defined(&sk_GENERAL_SUBTREE_free);
    eval 'sub sk_GENERAL_SUBTREE_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_GENERAL_SUBTREE_sk_type($sk)));
    }' unless defined(&sk_GENERAL_SUBTREE_zero);
    eval 'sub sk_GENERAL_SUBTREE_delete {
        my($sk, $i) = @_;
	    eval q((( &GENERAL_SUBTREE *) &OPENSSL_sk_delete( &ossl_check_GENERAL_SUBTREE_sk_type($sk), ($i))));
    }' unless defined(&sk_GENERAL_SUBTREE_delete);
    eval 'sub sk_GENERAL_SUBTREE_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &GENERAL_SUBTREE *) &OPENSSL_sk_delete_ptr( &ossl_check_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_type($ptr))));
    }' unless defined(&sk_GENERAL_SUBTREE_delete_ptr);
    eval 'sub sk_GENERAL_SUBTREE_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_type($ptr)));
    }' unless defined(&sk_GENERAL_SUBTREE_push);
    eval 'sub sk_GENERAL_SUBTREE_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_type($ptr)));
    }' unless defined(&sk_GENERAL_SUBTREE_unshift);
    eval 'sub sk_GENERAL_SUBTREE_pop {
        my($sk) = @_;
	    eval q((( &GENERAL_SUBTREE *) &OPENSSL_sk_pop( &ossl_check_GENERAL_SUBTREE_sk_type($sk))));
    }' unless defined(&sk_GENERAL_SUBTREE_pop);
    eval 'sub sk_GENERAL_SUBTREE_shift {
        my($sk) = @_;
	    eval q((( &GENERAL_SUBTREE *) &OPENSSL_sk_shift( &ossl_check_GENERAL_SUBTREE_sk_type($sk))));
    }' unless defined(&sk_GENERAL_SUBTREE_shift);
    eval 'sub sk_GENERAL_SUBTREE_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_GENERAL_SUBTREE_sk_type($sk), &ossl_check_GENERAL_SUBTREE_freefunc_type($freefunc)));
    }' unless defined(&sk_GENERAL_SUBTREE_pop_free);
    eval 'sub sk_GENERAL_SUBTREE_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_type($ptr), ($idx)));
    }' unless defined(&sk_GENERAL_SUBTREE_insert);
    eval 'sub sk_GENERAL_SUBTREE_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &GENERAL_SUBTREE *) &OPENSSL_sk_set( &ossl_check_GENERAL_SUBTREE_sk_type($sk), ($idx),  &ossl_check_GENERAL_SUBTREE_type($ptr))));
    }' unless defined(&sk_GENERAL_SUBTREE_set);
    eval 'sub sk_GENERAL_SUBTREE_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_type($ptr)));
    }' unless defined(&sk_GENERAL_SUBTREE_find);
    eval 'sub sk_GENERAL_SUBTREE_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_type($ptr)));
    }' unless defined(&sk_GENERAL_SUBTREE_find_ex);
    eval 'sub sk_GENERAL_SUBTREE_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_type($ptr), $pnum));
    }' unless defined(&sk_GENERAL_SUBTREE_find_all);
    eval 'sub sk_GENERAL_SUBTREE_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_GENERAL_SUBTREE_sk_type($sk)));
    }' unless defined(&sk_GENERAL_SUBTREE_sort);
    eval 'sub sk_GENERAL_SUBTREE_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_GENERAL_SUBTREE_sk_type($sk)));
    }' unless defined(&sk_GENERAL_SUBTREE_is_sorted);
    eval 'sub sk_GENERAL_SUBTREE_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &GENERAL_SUBTREE) *) &OPENSSL_sk_dup( &ossl_check_const_GENERAL_SUBTREE_sk_type($sk))));
    }' unless defined(&sk_GENERAL_SUBTREE_dup);
    eval 'sub sk_GENERAL_SUBTREE_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &GENERAL_SUBTREE) *) &OPENSSL_sk_deep_copy( &ossl_check_const_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_copyfunc_type($copyfunc),  &ossl_check_GENERAL_SUBTREE_freefunc_type($freefunc))));
    }' unless defined(&sk_GENERAL_SUBTREE_deep_copy);
    eval 'sub sk_GENERAL_SUBTREE_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_GENERAL_SUBTREE_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_GENERAL_SUBTREE_sk_type($sk),  &ossl_check_GENERAL_SUBTREE_compfunc_type($cmp))));
    }' unless defined(&sk_GENERAL_SUBTREE_set_cmp_func);
    eval 'sub IDP_PRESENT () {0x1;}' unless defined(&IDP_PRESENT);
    eval 'sub IDP_INVALID () {0x2;}' unless defined(&IDP_INVALID);
    eval 'sub IDP_ONLYUSER () {0x4;}' unless defined(&IDP_ONLYUSER);
    eval 'sub IDP_ONLYCA () {0x8;}' unless defined(&IDP_ONLYCA);
    eval 'sub IDP_ONLYATTR () {0x10;}' unless defined(&IDP_ONLYATTR);
    eval 'sub IDP_INDIRECT () {0x20;}' unless defined(&IDP_INDIRECT);
    eval 'sub IDP_REASONS () {0x40;}' unless defined(&IDP_REASONS);
    eval 'sub X509V3_conf_err {
        my($val) = @_;
	    eval q( &ERR_add_error_data(6, \\"section:\\", ($val)-> &section, \\",name:\\", ($val)-> &name, \\",value:\\", ($val)-> &value));
    }' unless defined(&X509V3_conf_err);
    eval 'sub X509V3_set_ctx_test {
        my($ctx) = @_;
	    eval q( &X509V3_set_ctx($ctx,  &NULL,  &NULL,  &NULL,  &NULL,  &X509V3_CTX_TEST));
    }' unless defined(&X509V3_set_ctx_test);
    eval 'sub X509V3_set_ctx_nodb {
        my($ctx) = @_;
	    eval q(($ctx)-> &db =  &NULL;);
    }' unless defined(&X509V3_set_ctx_nodb);
    eval 'sub EXT_BITSTRING {
        my($nid, $table) = @_;
	    eval q({ $nid, 0,  &ASN1_ITEM_ref( &ASN1_BIT_STRING), 0,0,0,0, 0,0, ( &X509V3_EXT_I2V) &i2v_ASN1_BIT_STRING, ( &X509V3_EXT_V2I) &v2i_ASN1_BIT_STRING,  &NULL,  &NULL, $table});
    }' unless defined(&EXT_BITSTRING);
    eval 'sub EXT_IA5STRING {
        my($nid) = @_;
	    eval q({ $nid, 0,  &ASN1_ITEM_ref( &ASN1_IA5STRING), 0,0,0,0, ( &X509V3_EXT_I2S) &i2s_ASN1_IA5STRING, ( &X509V3_EXT_S2I) &s2i_ASN1_IA5STRING, 0,0,0,0,  &NULL});
    }' unless defined(&EXT_IA5STRING);
    eval 'sub EXT_UTF8STRING {
        my($nid) = @_;
	    eval q({ $nid, 0,  &ASN1_ITEM_ref( &ASN1_UTF8STRING), 0,0,0,0, ( &X509V3_EXT_I2S) &i2s_ASN1_UTF8STRING, ( &X509V3_EXT_S2I) &s2i_ASN1_UTF8STRING, 0,0,0,0,  &NULL});
    }' unless defined(&EXT_UTF8STRING);
    eval 'sub EXT_END () {{ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};}' unless defined(&EXT_END);
    eval 'sub EXFLAG_BCONS () {0x1;}' unless defined(&EXFLAG_BCONS);
    eval 'sub EXFLAG_KUSAGE () {0x2;}' unless defined(&EXFLAG_KUSAGE);
    eval 'sub EXFLAG_XKUSAGE () {0x4;}' unless defined(&EXFLAG_XKUSAGE);
    eval 'sub EXFLAG_NSCERT () {0x8;}' unless defined(&EXFLAG_NSCERT);
    eval 'sub EXFLAG_CA () {0x10;}' unless defined(&EXFLAG_CA);
    eval 'sub EXFLAG_SI () {0x20;}' unless defined(&EXFLAG_SI);
    eval 'sub EXFLAG_V1 () {0x40;}' unless defined(&EXFLAG_V1);
    eval 'sub EXFLAG_INVALID () {0x80;}' unless defined(&EXFLAG_INVALID);
    eval 'sub EXFLAG_SET () {0x100;}' unless defined(&EXFLAG_SET);
    eval 'sub EXFLAG_CRITICAL () {0x200;}' unless defined(&EXFLAG_CRITICAL);
    eval 'sub EXFLAG_PROXY () {0x400;}' unless defined(&EXFLAG_PROXY);
    eval 'sub EXFLAG_INVALID_POLICY () {0x800;}' unless defined(&EXFLAG_INVALID_POLICY);
    eval 'sub EXFLAG_FRESHEST () {0x1000;}' unless defined(&EXFLAG_FRESHEST);
    eval 'sub EXFLAG_SS () {0x2000;}' unless defined(&EXFLAG_SS);
    eval 'sub EXFLAG_BCONS_CRITICAL () {0x10000;}' unless defined(&EXFLAG_BCONS_CRITICAL);
    eval 'sub EXFLAG_AKID_CRITICAL () {0x20000;}' unless defined(&EXFLAG_AKID_CRITICAL);
    eval 'sub EXFLAG_SKID_CRITICAL () {0x40000;}' unless defined(&EXFLAG_SKID_CRITICAL);
    eval 'sub EXFLAG_SAN_CRITICAL () {0x80000;}' unless defined(&EXFLAG_SAN_CRITICAL);
    eval 'sub EXFLAG_NO_FINGERPRINT () {0x100000;}' unless defined(&EXFLAG_NO_FINGERPRINT);
    eval 'sub KU_DIGITAL_SIGNATURE () {0x80;}' unless defined(&KU_DIGITAL_SIGNATURE);
    eval 'sub KU_NON_REPUDIATION () {0x40;}' unless defined(&KU_NON_REPUDIATION);
    eval 'sub KU_KEY_ENCIPHERMENT () {0x20;}' unless defined(&KU_KEY_ENCIPHERMENT);
    eval 'sub KU_DATA_ENCIPHERMENT () {0x10;}' unless defined(&KU_DATA_ENCIPHERMENT);
    eval 'sub KU_KEY_AGREEMENT () {0x8;}' unless defined(&KU_KEY_AGREEMENT);
    eval 'sub KU_KEY_CERT_SIGN () {0x4;}' unless defined(&KU_KEY_CERT_SIGN);
    eval 'sub KU_CRL_SIGN () {0x2;}' unless defined(&KU_CRL_SIGN);
    eval 'sub KU_ENCIPHER_ONLY () {0x1;}' unless defined(&KU_ENCIPHER_ONLY);
    eval 'sub KU_DECIPHER_ONLY () {0x8000;}' unless defined(&KU_DECIPHER_ONLY);
    eval 'sub NS_SSL_CLIENT () {0x80;}' unless defined(&NS_SSL_CLIENT);
    eval 'sub NS_SSL_SERVER () {0x40;}' unless defined(&NS_SSL_SERVER);
    eval 'sub NS_SMIME () {0x20;}' unless defined(&NS_SMIME);
    eval 'sub NS_OBJSIGN () {0x10;}' unless defined(&NS_OBJSIGN);
    eval 'sub NS_SSL_CA () {0x4;}' unless defined(&NS_SSL_CA);
    eval 'sub NS_SMIME_CA () {0x2;}' unless defined(&NS_SMIME_CA);
    eval 'sub NS_OBJSIGN_CA () {0x1;}' unless defined(&NS_OBJSIGN_CA);
    eval 'sub NS_ANY_CA () {( &NS_SSL_CA| &NS_SMIME_CA| &NS_OBJSIGN_CA);}' unless defined(&NS_ANY_CA);
    eval 'sub XKU_SSL_SERVER () {0x1;}' unless defined(&XKU_SSL_SERVER);
    eval 'sub XKU_SSL_CLIENT () {0x2;}' unless defined(&XKU_SSL_CLIENT);
    eval 'sub XKU_SMIME () {0x4;}' unless defined(&XKU_SMIME);
    eval 'sub XKU_CODE_SIGN () {0x8;}' unless defined(&XKU_CODE_SIGN);
    eval 'sub XKU_SGC () {0x10;}' unless defined(&XKU_SGC);
    eval 'sub XKU_OCSP_SIGN () {0x20;}' unless defined(&XKU_OCSP_SIGN);
    eval 'sub XKU_TIMESTAMP () {0x40;}' unless defined(&XKU_TIMESTAMP);
    eval 'sub XKU_DVCS () {0x80;}' unless defined(&XKU_DVCS);
    eval 'sub XKU_ANYEKU () {0x100;}' unless defined(&XKU_ANYEKU);
    eval 'sub X509_PURPOSE_DYNAMIC () {0x1;}' unless defined(&X509_PURPOSE_DYNAMIC);
    eval 'sub X509_PURPOSE_DYNAMIC_NAME () {0x2;}' unless defined(&X509_PURPOSE_DYNAMIC_NAME);
    eval 'sub sk_X509_PURPOSE_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_PURPOSE_sk_type($sk)));
    }' unless defined(&sk_X509_PURPOSE_num);
    eval 'sub sk_X509_PURPOSE_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_PURPOSE *) &OPENSSL_sk_value( &ossl_check_const_X509_PURPOSE_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_PURPOSE_value);
    eval 'sub sk_X509_PURPOSE_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_PURPOSE) *) &OPENSSL_sk_new( &ossl_check_X509_PURPOSE_compfunc_type($cmp))));
    }' unless defined(&sk_X509_PURPOSE_new);
    eval 'sub sk_X509_PURPOSE_new_null () {
        eval q((( &STACK_OF( &X509_PURPOSE) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_PURPOSE_new_null);
    eval 'sub sk_X509_PURPOSE_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_PURPOSE) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_PURPOSE_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_PURPOSE_new_reserve);
    eval 'sub sk_X509_PURPOSE_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_PURPOSE_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_PURPOSE_reserve);
    eval 'sub sk_X509_PURPOSE_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_PURPOSE_sk_type($sk)));
    }' unless defined(&sk_X509_PURPOSE_free);
    eval 'sub sk_X509_PURPOSE_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_PURPOSE_sk_type($sk)));
    }' unless defined(&sk_X509_PURPOSE_zero);
    eval 'sub sk_X509_PURPOSE_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_PURPOSE *) &OPENSSL_sk_delete( &ossl_check_X509_PURPOSE_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_PURPOSE_delete);
    eval 'sub sk_X509_PURPOSE_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_PURPOSE *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_type($ptr))));
    }' unless defined(&sk_X509_PURPOSE_delete_ptr);
    eval 'sub sk_X509_PURPOSE_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_type($ptr)));
    }' unless defined(&sk_X509_PURPOSE_push);
    eval 'sub sk_X509_PURPOSE_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_type($ptr)));
    }' unless defined(&sk_X509_PURPOSE_unshift);
    eval 'sub sk_X509_PURPOSE_pop {
        my($sk) = @_;
	    eval q((( &X509_PURPOSE *) &OPENSSL_sk_pop( &ossl_check_X509_PURPOSE_sk_type($sk))));
    }' unless defined(&sk_X509_PURPOSE_pop);
    eval 'sub sk_X509_PURPOSE_shift {
        my($sk) = @_;
	    eval q((( &X509_PURPOSE *) &OPENSSL_sk_shift( &ossl_check_X509_PURPOSE_sk_type($sk))));
    }' unless defined(&sk_X509_PURPOSE_shift);
    eval 'sub sk_X509_PURPOSE_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_PURPOSE_sk_type($sk), &ossl_check_X509_PURPOSE_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_PURPOSE_pop_free);
    eval 'sub sk_X509_PURPOSE_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_type($ptr), ($idx)));
    }' unless defined(&sk_X509_PURPOSE_insert);
    eval 'sub sk_X509_PURPOSE_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_PURPOSE *) &OPENSSL_sk_set( &ossl_check_X509_PURPOSE_sk_type($sk), ($idx),  &ossl_check_X509_PURPOSE_type($ptr))));
    }' unless defined(&sk_X509_PURPOSE_set);
    eval 'sub sk_X509_PURPOSE_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_type($ptr)));
    }' unless defined(&sk_X509_PURPOSE_find);
    eval 'sub sk_X509_PURPOSE_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_type($ptr)));
    }' unless defined(&sk_X509_PURPOSE_find_ex);
    eval 'sub sk_X509_PURPOSE_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_type($ptr), $pnum));
    }' unless defined(&sk_X509_PURPOSE_find_all);
    eval 'sub sk_X509_PURPOSE_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_PURPOSE_sk_type($sk)));
    }' unless defined(&sk_X509_PURPOSE_sort);
    eval 'sub sk_X509_PURPOSE_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_PURPOSE_sk_type($sk)));
    }' unless defined(&sk_X509_PURPOSE_is_sorted);
    eval 'sub sk_X509_PURPOSE_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_PURPOSE) *) &OPENSSL_sk_dup( &ossl_check_const_X509_PURPOSE_sk_type($sk))));
    }' unless defined(&sk_X509_PURPOSE_dup);
    eval 'sub sk_X509_PURPOSE_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_PURPOSE) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_copyfunc_type($copyfunc),  &ossl_check_X509_PURPOSE_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_PURPOSE_deep_copy);
    eval 'sub sk_X509_PURPOSE_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_PURPOSE_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_PURPOSE_sk_type($sk),  &ossl_check_X509_PURPOSE_compfunc_type($cmp))));
    }' unless defined(&sk_X509_PURPOSE_set_cmp_func);
    eval 'sub X509_PURPOSE_SSL_CLIENT () {1;}' unless defined(&X509_PURPOSE_SSL_CLIENT);
    eval 'sub X509_PURPOSE_SSL_SERVER () {2;}' unless defined(&X509_PURPOSE_SSL_SERVER);
    eval 'sub X509_PURPOSE_NS_SSL_SERVER () {3;}' unless defined(&X509_PURPOSE_NS_SSL_SERVER);
    eval 'sub X509_PURPOSE_SMIME_SIGN () {4;}' unless defined(&X509_PURPOSE_SMIME_SIGN);
    eval 'sub X509_PURPOSE_SMIME_ENCRYPT () {5;}' unless defined(&X509_PURPOSE_SMIME_ENCRYPT);
    eval 'sub X509_PURPOSE_CRL_SIGN () {6;}' unless defined(&X509_PURPOSE_CRL_SIGN);
    eval 'sub X509_PURPOSE_ANY () {7;}' unless defined(&X509_PURPOSE_ANY);
    eval 'sub X509_PURPOSE_OCSP_HELPER () {8;}' unless defined(&X509_PURPOSE_OCSP_HELPER);
    eval 'sub X509_PURPOSE_TIMESTAMP_SIGN () {9;}' unless defined(&X509_PURPOSE_TIMESTAMP_SIGN);
    eval 'sub X509_PURPOSE_MIN () {1;}' unless defined(&X509_PURPOSE_MIN);
    eval 'sub X509_PURPOSE_MAX () {9;}' unless defined(&X509_PURPOSE_MAX);
    eval 'sub X509V3_EXT_UNKNOWN_MASK () {(0xf << 16);}' unless defined(&X509V3_EXT_UNKNOWN_MASK);
    eval 'sub X509V3_EXT_DEFAULT () {0;}' unless defined(&X509V3_EXT_DEFAULT);
    eval 'sub X509V3_EXT_ERROR_UNKNOWN () {(1 << 16);}' unless defined(&X509V3_EXT_ERROR_UNKNOWN);
    eval 'sub X509V3_EXT_PARSE_UNKNOWN () {(2 << 16);}' unless defined(&X509V3_EXT_PARSE_UNKNOWN);
    eval 'sub X509V3_EXT_DUMP_UNKNOWN () {(3 << 16);}' unless defined(&X509V3_EXT_DUMP_UNKNOWN);
    eval 'sub X509V3_ADD_OP_MASK () {0xf;}' unless defined(&X509V3_ADD_OP_MASK);
    eval 'sub X509V3_ADD_DEFAULT () {0;}' unless defined(&X509V3_ADD_DEFAULT);
    eval 'sub X509V3_ADD_APPEND () {1;}' unless defined(&X509V3_ADD_APPEND);
    eval 'sub X509V3_ADD_REPLACE () {2;}' unless defined(&X509V3_ADD_REPLACE);
    eval 'sub X509V3_ADD_REPLACE_EXISTING () {3;}' unless defined(&X509V3_ADD_REPLACE_EXISTING);
    eval 'sub X509V3_ADD_KEEP_EXISTING () {4;}' unless defined(&X509V3_ADD_KEEP_EXISTING);
    eval 'sub X509V3_ADD_DELETE () {5;}' unless defined(&X509V3_ADD_DELETE);
    eval 'sub X509V3_ADD_SILENT () {0x10;}' unless defined(&X509V3_ADD_SILENT);
    if(defined(&OPENSSL_CONF_H)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub hex_to_string () { &OPENSSL_buf2hexstr;}' unless defined(&hex_to_string);
	eval 'sub string_to_hex () { &OPENSSL_hexstr2buf;}' unless defined(&string_to_hex);
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    eval 'sub X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT () {0x1;}' unless defined(&X509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT);
    eval 'sub X509_CHECK_FLAG_NO_WILDCARDS () {0x2;}' unless defined(&X509_CHECK_FLAG_NO_WILDCARDS);
    eval 'sub X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS () {0x4;}' unless defined(&X509_CHECK_FLAG_NO_PARTIAL_WILDCARDS);
    eval 'sub X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS () {0x8;}' unless defined(&X509_CHECK_FLAG_MULTI_LABEL_WILDCARDS);
    eval 'sub X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS () {0x10;}' unless defined(&X509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS);
    eval 'sub X509_CHECK_FLAG_NEVER_CHECK_SUBJECT () {0x20;}' unless defined(&X509_CHECK_FLAG_NEVER_CHECK_SUBJECT);
    eval 'sub _X509_CHECK_FLAG_DOT_SUBDOMAINS () {0x8000;}' unless defined(&_X509_CHECK_FLAG_DOT_SUBDOMAINS);
    eval 'sub sk_X509_POLICY_NODE_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_X509_POLICY_NODE_sk_type($sk)));
    }' unless defined(&sk_X509_POLICY_NODE_num);
    eval 'sub sk_X509_POLICY_NODE_value {
        my($sk, $idx) = @_;
	    eval q((( &X509_POLICY_NODE *) &OPENSSL_sk_value( &ossl_check_const_X509_POLICY_NODE_sk_type($sk), ($idx))));
    }' unless defined(&sk_X509_POLICY_NODE_value);
    eval 'sub sk_X509_POLICY_NODE_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &X509_POLICY_NODE) *) &OPENSSL_sk_new( &ossl_check_X509_POLICY_NODE_compfunc_type($cmp))));
    }' unless defined(&sk_X509_POLICY_NODE_new);
    eval 'sub sk_X509_POLICY_NODE_new_null () {
        eval q((( &STACK_OF( &X509_POLICY_NODE) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_X509_POLICY_NODE_new_null);
    eval 'sub sk_X509_POLICY_NODE_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &X509_POLICY_NODE) *) &OPENSSL_sk_new_reserve( &ossl_check_X509_POLICY_NODE_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_X509_POLICY_NODE_new_reserve);
    eval 'sub sk_X509_POLICY_NODE_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_X509_POLICY_NODE_sk_type($sk), ($n)));
    }' unless defined(&sk_X509_POLICY_NODE_reserve);
    eval 'sub sk_X509_POLICY_NODE_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_X509_POLICY_NODE_sk_type($sk)));
    }' unless defined(&sk_X509_POLICY_NODE_free);
    eval 'sub sk_X509_POLICY_NODE_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_X509_POLICY_NODE_sk_type($sk)));
    }' unless defined(&sk_X509_POLICY_NODE_zero);
    eval 'sub sk_X509_POLICY_NODE_delete {
        my($sk, $i) = @_;
	    eval q((( &X509_POLICY_NODE *) &OPENSSL_sk_delete( &ossl_check_X509_POLICY_NODE_sk_type($sk), ($i))));
    }' unless defined(&sk_X509_POLICY_NODE_delete);
    eval 'sub sk_X509_POLICY_NODE_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &X509_POLICY_NODE *) &OPENSSL_sk_delete_ptr( &ossl_check_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_type($ptr))));
    }' unless defined(&sk_X509_POLICY_NODE_delete_ptr);
    eval 'sub sk_X509_POLICY_NODE_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_type($ptr)));
    }' unless defined(&sk_X509_POLICY_NODE_push);
    eval 'sub sk_X509_POLICY_NODE_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_type($ptr)));
    }' unless defined(&sk_X509_POLICY_NODE_unshift);
    eval 'sub sk_X509_POLICY_NODE_pop {
        my($sk) = @_;
	    eval q((( &X509_POLICY_NODE *) &OPENSSL_sk_pop( &ossl_check_X509_POLICY_NODE_sk_type($sk))));
    }' unless defined(&sk_X509_POLICY_NODE_pop);
    eval 'sub sk_X509_POLICY_NODE_shift {
        my($sk) = @_;
	    eval q((( &X509_POLICY_NODE *) &OPENSSL_sk_shift( &ossl_check_X509_POLICY_NODE_sk_type($sk))));
    }' unless defined(&sk_X509_POLICY_NODE_shift);
    eval 'sub sk_X509_POLICY_NODE_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_X509_POLICY_NODE_sk_type($sk), &ossl_check_X509_POLICY_NODE_freefunc_type($freefunc)));
    }' unless defined(&sk_X509_POLICY_NODE_pop_free);
    eval 'sub sk_X509_POLICY_NODE_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_type($ptr), ($idx)));
    }' unless defined(&sk_X509_POLICY_NODE_insert);
    eval 'sub sk_X509_POLICY_NODE_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &X509_POLICY_NODE *) &OPENSSL_sk_set( &ossl_check_X509_POLICY_NODE_sk_type($sk), ($idx),  &ossl_check_X509_POLICY_NODE_type($ptr))));
    }' unless defined(&sk_X509_POLICY_NODE_set);
    eval 'sub sk_X509_POLICY_NODE_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_type($ptr)));
    }' unless defined(&sk_X509_POLICY_NODE_find);
    eval 'sub sk_X509_POLICY_NODE_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_type($ptr)));
    }' unless defined(&sk_X509_POLICY_NODE_find_ex);
    eval 'sub sk_X509_POLICY_NODE_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_type($ptr), $pnum));
    }' unless defined(&sk_X509_POLICY_NODE_find_all);
    eval 'sub sk_X509_POLICY_NODE_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_X509_POLICY_NODE_sk_type($sk)));
    }' unless defined(&sk_X509_POLICY_NODE_sort);
    eval 'sub sk_X509_POLICY_NODE_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_X509_POLICY_NODE_sk_type($sk)));
    }' unless defined(&sk_X509_POLICY_NODE_is_sorted);
    eval 'sub sk_X509_POLICY_NODE_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &X509_POLICY_NODE) *) &OPENSSL_sk_dup( &ossl_check_const_X509_POLICY_NODE_sk_type($sk))));
    }' unless defined(&sk_X509_POLICY_NODE_dup);
    eval 'sub sk_X509_POLICY_NODE_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &X509_POLICY_NODE) *) &OPENSSL_sk_deep_copy( &ossl_check_const_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_copyfunc_type($copyfunc),  &ossl_check_X509_POLICY_NODE_freefunc_type($freefunc))));
    }' unless defined(&sk_X509_POLICY_NODE_deep_copy);
    eval 'sub sk_X509_POLICY_NODE_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_X509_POLICY_NODE_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_X509_POLICY_NODE_sk_type($sk),  &ossl_check_X509_POLICY_NODE_compfunc_type($cmp))));
    }' unless defined(&sk_X509_POLICY_NODE_set_cmp_func);
    unless(defined(&OPENSSL_NO_RFC3779)) {
	eval 'sub ASIdOrRange_id () {0;}' unless defined(&ASIdOrRange_id);
	eval 'sub ASIdOrRange_range () {1;}' unless defined(&ASIdOrRange_range);
	eval 'sub sk_ASIdOrRange_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_ASIdOrRange_sk_type($sk)));
	}' unless defined(&sk_ASIdOrRange_num);
	eval 'sub sk_ASIdOrRange_value {
	    my($sk, $idx) = @_;
    	    eval q((( &ASIdOrRange *) &OPENSSL_sk_value( &ossl_check_const_ASIdOrRange_sk_type($sk), ($idx))));
	}' unless defined(&sk_ASIdOrRange_value);
	eval 'sub sk_ASIdOrRange_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &ASIdOrRange) *) &OPENSSL_sk_new( &ossl_check_ASIdOrRange_compfunc_type($cmp))));
	}' unless defined(&sk_ASIdOrRange_new);
	eval 'sub sk_ASIdOrRange_new_null () {
	    eval q((( &STACK_OF( &ASIdOrRange) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_ASIdOrRange_new_null);
	eval 'sub sk_ASIdOrRange_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &ASIdOrRange) *) &OPENSSL_sk_new_reserve( &ossl_check_ASIdOrRange_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_ASIdOrRange_new_reserve);
	eval 'sub sk_ASIdOrRange_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_ASIdOrRange_sk_type($sk), ($n)));
	}' unless defined(&sk_ASIdOrRange_reserve);
	eval 'sub sk_ASIdOrRange_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_ASIdOrRange_sk_type($sk)));
	}' unless defined(&sk_ASIdOrRange_free);
	eval 'sub sk_ASIdOrRange_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_ASIdOrRange_sk_type($sk)));
	}' unless defined(&sk_ASIdOrRange_zero);
	eval 'sub sk_ASIdOrRange_delete {
	    my($sk, $i) = @_;
    	    eval q((( &ASIdOrRange *) &OPENSSL_sk_delete( &ossl_check_ASIdOrRange_sk_type($sk), ($i))));
	}' unless defined(&sk_ASIdOrRange_delete);
	eval 'sub sk_ASIdOrRange_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &ASIdOrRange *) &OPENSSL_sk_delete_ptr( &ossl_check_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_type($ptr))));
	}' unless defined(&sk_ASIdOrRange_delete_ptr);
	eval 'sub sk_ASIdOrRange_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_type($ptr)));
	}' unless defined(&sk_ASIdOrRange_push);
	eval 'sub sk_ASIdOrRange_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_type($ptr)));
	}' unless defined(&sk_ASIdOrRange_unshift);
	eval 'sub sk_ASIdOrRange_pop {
	    my($sk) = @_;
    	    eval q((( &ASIdOrRange *) &OPENSSL_sk_pop( &ossl_check_ASIdOrRange_sk_type($sk))));
	}' unless defined(&sk_ASIdOrRange_pop);
	eval 'sub sk_ASIdOrRange_shift {
	    my($sk) = @_;
    	    eval q((( &ASIdOrRange *) &OPENSSL_sk_shift( &ossl_check_ASIdOrRange_sk_type($sk))));
	}' unless defined(&sk_ASIdOrRange_shift);
	eval 'sub sk_ASIdOrRange_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_ASIdOrRange_sk_type($sk), &ossl_check_ASIdOrRange_freefunc_type($freefunc)));
	}' unless defined(&sk_ASIdOrRange_pop_free);
	eval 'sub sk_ASIdOrRange_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_type($ptr), ($idx)));
	}' unless defined(&sk_ASIdOrRange_insert);
	eval 'sub sk_ASIdOrRange_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &ASIdOrRange *) &OPENSSL_sk_set( &ossl_check_ASIdOrRange_sk_type($sk), ($idx),  &ossl_check_ASIdOrRange_type($ptr))));
	}' unless defined(&sk_ASIdOrRange_set);
	eval 'sub sk_ASIdOrRange_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_type($ptr)));
	}' unless defined(&sk_ASIdOrRange_find);
	eval 'sub sk_ASIdOrRange_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_type($ptr)));
	}' unless defined(&sk_ASIdOrRange_find_ex);
	eval 'sub sk_ASIdOrRange_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_type($ptr), $pnum));
	}' unless defined(&sk_ASIdOrRange_find_all);
	eval 'sub sk_ASIdOrRange_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_ASIdOrRange_sk_type($sk)));
	}' unless defined(&sk_ASIdOrRange_sort);
	eval 'sub sk_ASIdOrRange_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_ASIdOrRange_sk_type($sk)));
	}' unless defined(&sk_ASIdOrRange_is_sorted);
	eval 'sub sk_ASIdOrRange_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &ASIdOrRange) *) &OPENSSL_sk_dup( &ossl_check_const_ASIdOrRange_sk_type($sk))));
	}' unless defined(&sk_ASIdOrRange_dup);
	eval 'sub sk_ASIdOrRange_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &ASIdOrRange) *) &OPENSSL_sk_deep_copy( &ossl_check_const_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_copyfunc_type($copyfunc),  &ossl_check_ASIdOrRange_freefunc_type($freefunc))));
	}' unless defined(&sk_ASIdOrRange_deep_copy);
	eval 'sub sk_ASIdOrRange_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_ASIdOrRange_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_ASIdOrRange_sk_type($sk),  &ossl_check_ASIdOrRange_compfunc_type($cmp))));
	}' unless defined(&sk_ASIdOrRange_set_cmp_func);
	eval 'sub ASIdentifierChoice_inherit () {0;}' unless defined(&ASIdentifierChoice_inherit);
	eval 'sub ASIdentifierChoice_asIdsOrRanges () {1;}' unless defined(&ASIdentifierChoice_asIdsOrRanges);
	eval 'sub IPAddressOrRange_addressPrefix () {0;}' unless defined(&IPAddressOrRange_addressPrefix);
	eval 'sub IPAddressOrRange_addressRange () {1;}' unless defined(&IPAddressOrRange_addressRange);
	eval 'sub sk_IPAddressOrRange_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_IPAddressOrRange_sk_type($sk)));
	}' unless defined(&sk_IPAddressOrRange_num);
	eval 'sub sk_IPAddressOrRange_value {
	    my($sk, $idx) = @_;
    	    eval q((( &IPAddressOrRange *) &OPENSSL_sk_value( &ossl_check_const_IPAddressOrRange_sk_type($sk), ($idx))));
	}' unless defined(&sk_IPAddressOrRange_value);
	eval 'sub sk_IPAddressOrRange_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &IPAddressOrRange) *) &OPENSSL_sk_new( &ossl_check_IPAddressOrRange_compfunc_type($cmp))));
	}' unless defined(&sk_IPAddressOrRange_new);
	eval 'sub sk_IPAddressOrRange_new_null () {
	    eval q((( &STACK_OF( &IPAddressOrRange) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_IPAddressOrRange_new_null);
	eval 'sub sk_IPAddressOrRange_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &IPAddressOrRange) *) &OPENSSL_sk_new_reserve( &ossl_check_IPAddressOrRange_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_IPAddressOrRange_new_reserve);
	eval 'sub sk_IPAddressOrRange_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_IPAddressOrRange_sk_type($sk), ($n)));
	}' unless defined(&sk_IPAddressOrRange_reserve);
	eval 'sub sk_IPAddressOrRange_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_IPAddressOrRange_sk_type($sk)));
	}' unless defined(&sk_IPAddressOrRange_free);
	eval 'sub sk_IPAddressOrRange_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_IPAddressOrRange_sk_type($sk)));
	}' unless defined(&sk_IPAddressOrRange_zero);
	eval 'sub sk_IPAddressOrRange_delete {
	    my($sk, $i) = @_;
    	    eval q((( &IPAddressOrRange *) &OPENSSL_sk_delete( &ossl_check_IPAddressOrRange_sk_type($sk), ($i))));
	}' unless defined(&sk_IPAddressOrRange_delete);
	eval 'sub sk_IPAddressOrRange_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &IPAddressOrRange *) &OPENSSL_sk_delete_ptr( &ossl_check_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_type($ptr))));
	}' unless defined(&sk_IPAddressOrRange_delete_ptr);
	eval 'sub sk_IPAddressOrRange_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_type($ptr)));
	}' unless defined(&sk_IPAddressOrRange_push);
	eval 'sub sk_IPAddressOrRange_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_type($ptr)));
	}' unless defined(&sk_IPAddressOrRange_unshift);
	eval 'sub sk_IPAddressOrRange_pop {
	    my($sk) = @_;
    	    eval q((( &IPAddressOrRange *) &OPENSSL_sk_pop( &ossl_check_IPAddressOrRange_sk_type($sk))));
	}' unless defined(&sk_IPAddressOrRange_pop);
	eval 'sub sk_IPAddressOrRange_shift {
	    my($sk) = @_;
    	    eval q((( &IPAddressOrRange *) &OPENSSL_sk_shift( &ossl_check_IPAddressOrRange_sk_type($sk))));
	}' unless defined(&sk_IPAddressOrRange_shift);
	eval 'sub sk_IPAddressOrRange_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_IPAddressOrRange_sk_type($sk), &ossl_check_IPAddressOrRange_freefunc_type($freefunc)));
	}' unless defined(&sk_IPAddressOrRange_pop_free);
	eval 'sub sk_IPAddressOrRange_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_type($ptr), ($idx)));
	}' unless defined(&sk_IPAddressOrRange_insert);
	eval 'sub sk_IPAddressOrRange_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &IPAddressOrRange *) &OPENSSL_sk_set( &ossl_check_IPAddressOrRange_sk_type($sk), ($idx),  &ossl_check_IPAddressOrRange_type($ptr))));
	}' unless defined(&sk_IPAddressOrRange_set);
	eval 'sub sk_IPAddressOrRange_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_type($ptr)));
	}' unless defined(&sk_IPAddressOrRange_find);
	eval 'sub sk_IPAddressOrRange_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_type($ptr)));
	}' unless defined(&sk_IPAddressOrRange_find_ex);
	eval 'sub sk_IPAddressOrRange_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_type($ptr), $pnum));
	}' unless defined(&sk_IPAddressOrRange_find_all);
	eval 'sub sk_IPAddressOrRange_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_IPAddressOrRange_sk_type($sk)));
	}' unless defined(&sk_IPAddressOrRange_sort);
	eval 'sub sk_IPAddressOrRange_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_IPAddressOrRange_sk_type($sk)));
	}' unless defined(&sk_IPAddressOrRange_is_sorted);
	eval 'sub sk_IPAddressOrRange_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &IPAddressOrRange) *) &OPENSSL_sk_dup( &ossl_check_const_IPAddressOrRange_sk_type($sk))));
	}' unless defined(&sk_IPAddressOrRange_dup);
	eval 'sub sk_IPAddressOrRange_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &IPAddressOrRange) *) &OPENSSL_sk_deep_copy( &ossl_check_const_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_copyfunc_type($copyfunc),  &ossl_check_IPAddressOrRange_freefunc_type($freefunc))));
	}' unless defined(&sk_IPAddressOrRange_deep_copy);
	eval 'sub sk_IPAddressOrRange_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_IPAddressOrRange_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_IPAddressOrRange_sk_type($sk),  &ossl_check_IPAddressOrRange_compfunc_type($cmp))));
	}' unless defined(&sk_IPAddressOrRange_set_cmp_func);
	eval 'sub IPAddressChoice_inherit () {0;}' unless defined(&IPAddressChoice_inherit);
	eval 'sub IPAddressChoice_addressesOrRanges () {1;}' unless defined(&IPAddressChoice_addressesOrRanges);
	eval 'sub sk_IPAddressFamily_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_IPAddressFamily_sk_type($sk)));
	}' unless defined(&sk_IPAddressFamily_num);
	eval 'sub sk_IPAddressFamily_value {
	    my($sk, $idx) = @_;
    	    eval q((( &IPAddressFamily *) &OPENSSL_sk_value( &ossl_check_const_IPAddressFamily_sk_type($sk), ($idx))));
	}' unless defined(&sk_IPAddressFamily_value);
	eval 'sub sk_IPAddressFamily_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &IPAddressFamily) *) &OPENSSL_sk_new( &ossl_check_IPAddressFamily_compfunc_type($cmp))));
	}' unless defined(&sk_IPAddressFamily_new);
	eval 'sub sk_IPAddressFamily_new_null () {
	    eval q((( &STACK_OF( &IPAddressFamily) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_IPAddressFamily_new_null);
	eval 'sub sk_IPAddressFamily_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &IPAddressFamily) *) &OPENSSL_sk_new_reserve( &ossl_check_IPAddressFamily_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_IPAddressFamily_new_reserve);
	eval 'sub sk_IPAddressFamily_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_IPAddressFamily_sk_type($sk), ($n)));
	}' unless defined(&sk_IPAddressFamily_reserve);
	eval 'sub sk_IPAddressFamily_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_IPAddressFamily_sk_type($sk)));
	}' unless defined(&sk_IPAddressFamily_free);
	eval 'sub sk_IPAddressFamily_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_IPAddressFamily_sk_type($sk)));
	}' unless defined(&sk_IPAddressFamily_zero);
	eval 'sub sk_IPAddressFamily_delete {
	    my($sk, $i) = @_;
    	    eval q((( &IPAddressFamily *) &OPENSSL_sk_delete( &ossl_check_IPAddressFamily_sk_type($sk), ($i))));
	}' unless defined(&sk_IPAddressFamily_delete);
	eval 'sub sk_IPAddressFamily_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &IPAddressFamily *) &OPENSSL_sk_delete_ptr( &ossl_check_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_type($ptr))));
	}' unless defined(&sk_IPAddressFamily_delete_ptr);
	eval 'sub sk_IPAddressFamily_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_type($ptr)));
	}' unless defined(&sk_IPAddressFamily_push);
	eval 'sub sk_IPAddressFamily_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_type($ptr)));
	}' unless defined(&sk_IPAddressFamily_unshift);
	eval 'sub sk_IPAddressFamily_pop {
	    my($sk) = @_;
    	    eval q((( &IPAddressFamily *) &OPENSSL_sk_pop( &ossl_check_IPAddressFamily_sk_type($sk))));
	}' unless defined(&sk_IPAddressFamily_pop);
	eval 'sub sk_IPAddressFamily_shift {
	    my($sk) = @_;
    	    eval q((( &IPAddressFamily *) &OPENSSL_sk_shift( &ossl_check_IPAddressFamily_sk_type($sk))));
	}' unless defined(&sk_IPAddressFamily_shift);
	eval 'sub sk_IPAddressFamily_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_IPAddressFamily_sk_type($sk), &ossl_check_IPAddressFamily_freefunc_type($freefunc)));
	}' unless defined(&sk_IPAddressFamily_pop_free);
	eval 'sub sk_IPAddressFamily_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_type($ptr), ($idx)));
	}' unless defined(&sk_IPAddressFamily_insert);
	eval 'sub sk_IPAddressFamily_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &IPAddressFamily *) &OPENSSL_sk_set( &ossl_check_IPAddressFamily_sk_type($sk), ($idx),  &ossl_check_IPAddressFamily_type($ptr))));
	}' unless defined(&sk_IPAddressFamily_set);
	eval 'sub sk_IPAddressFamily_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_type($ptr)));
	}' unless defined(&sk_IPAddressFamily_find);
	eval 'sub sk_IPAddressFamily_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_type($ptr)));
	}' unless defined(&sk_IPAddressFamily_find_ex);
	eval 'sub sk_IPAddressFamily_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_type($ptr), $pnum));
	}' unless defined(&sk_IPAddressFamily_find_all);
	eval 'sub sk_IPAddressFamily_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_IPAddressFamily_sk_type($sk)));
	}' unless defined(&sk_IPAddressFamily_sort);
	eval 'sub sk_IPAddressFamily_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_IPAddressFamily_sk_type($sk)));
	}' unless defined(&sk_IPAddressFamily_is_sorted);
	eval 'sub sk_IPAddressFamily_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &IPAddressFamily) *) &OPENSSL_sk_dup( &ossl_check_const_IPAddressFamily_sk_type($sk))));
	}' unless defined(&sk_IPAddressFamily_dup);
	eval 'sub sk_IPAddressFamily_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &IPAddressFamily) *) &OPENSSL_sk_deep_copy( &ossl_check_const_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_copyfunc_type($copyfunc),  &ossl_check_IPAddressFamily_freefunc_type($freefunc))));
	}' unless defined(&sk_IPAddressFamily_deep_copy);
	eval 'sub sk_IPAddressFamily_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_IPAddressFamily_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_IPAddressFamily_sk_type($sk),  &ossl_check_IPAddressFamily_compfunc_type($cmp))));
	}' unless defined(&sk_IPAddressFamily_set_cmp_func);
	eval 'sub V3_ASID_ASNUM () {0;}' unless defined(&V3_ASID_ASNUM);
	eval 'sub V3_ASID_RDI () {1;}' unless defined(&V3_ASID_RDI);
	eval 'sub IANA_AFI_IPV4 () {1;}' unless defined(&IANA_AFI_IPV4);
	eval 'sub IANA_AFI_IPV6 () {2;}' unless defined(&IANA_AFI_IPV6);
    }
    eval 'sub sk_ASN1_STRING_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_ASN1_STRING_sk_type($sk)));
    }' unless defined(&sk_ASN1_STRING_num);
    eval 'sub sk_ASN1_STRING_value {
        my($sk, $idx) = @_;
	    eval q((( &ASN1_STRING *) &OPENSSL_sk_value( &ossl_check_const_ASN1_STRING_sk_type($sk), ($idx))));
    }' unless defined(&sk_ASN1_STRING_value);
    eval 'sub sk_ASN1_STRING_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &ASN1_STRING) *) &OPENSSL_sk_new( &ossl_check_ASN1_STRING_compfunc_type($cmp))));
    }' unless defined(&sk_ASN1_STRING_new);
    eval 'sub sk_ASN1_STRING_new_null () {
        eval q((( &STACK_OF( &ASN1_STRING) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_ASN1_STRING_new_null);
    eval 'sub sk_ASN1_STRING_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &ASN1_STRING) *) &OPENSSL_sk_new_reserve( &ossl_check_ASN1_STRING_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_ASN1_STRING_new_reserve);
    eval 'sub sk_ASN1_STRING_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_ASN1_STRING_sk_type($sk), ($n)));
    }' unless defined(&sk_ASN1_STRING_reserve);
    eval 'sub sk_ASN1_STRING_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_ASN1_STRING_sk_type($sk)));
    }' unless defined(&sk_ASN1_STRING_free);
    eval 'sub sk_ASN1_STRING_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_ASN1_STRING_sk_type($sk)));
    }' unless defined(&sk_ASN1_STRING_zero);
    eval 'sub sk_ASN1_STRING_delete {
        my($sk, $i) = @_;
	    eval q((( &ASN1_STRING *) &OPENSSL_sk_delete( &ossl_check_ASN1_STRING_sk_type($sk), ($i))));
    }' unless defined(&sk_ASN1_STRING_delete);
    eval 'sub sk_ASN1_STRING_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &ASN1_STRING *) &OPENSSL_sk_delete_ptr( &ossl_check_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_type($ptr))));
    }' unless defined(&sk_ASN1_STRING_delete_ptr);
    eval 'sub sk_ASN1_STRING_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_type($ptr)));
    }' unless defined(&sk_ASN1_STRING_push);
    eval 'sub sk_ASN1_STRING_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_type($ptr)));
    }' unless defined(&sk_ASN1_STRING_unshift);
    eval 'sub sk_ASN1_STRING_pop {
        my($sk) = @_;
	    eval q((( &ASN1_STRING *) &OPENSSL_sk_pop( &ossl_check_ASN1_STRING_sk_type($sk))));
    }' unless defined(&sk_ASN1_STRING_pop);
    eval 'sub sk_ASN1_STRING_shift {
        my($sk) = @_;
	    eval q((( &ASN1_STRING *) &OPENSSL_sk_shift( &ossl_check_ASN1_STRING_sk_type($sk))));
    }' unless defined(&sk_ASN1_STRING_shift);
    eval 'sub sk_ASN1_STRING_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_ASN1_STRING_sk_type($sk), &ossl_check_ASN1_STRING_freefunc_type($freefunc)));
    }' unless defined(&sk_ASN1_STRING_pop_free);
    eval 'sub sk_ASN1_STRING_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_type($ptr), ($idx)));
    }' unless defined(&sk_ASN1_STRING_insert);
    eval 'sub sk_ASN1_STRING_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &ASN1_STRING *) &OPENSSL_sk_set( &ossl_check_ASN1_STRING_sk_type($sk), ($idx),  &ossl_check_ASN1_STRING_type($ptr))));
    }' unless defined(&sk_ASN1_STRING_set);
    eval 'sub sk_ASN1_STRING_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_type($ptr)));
    }' unless defined(&sk_ASN1_STRING_find);
    eval 'sub sk_ASN1_STRING_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_type($ptr)));
    }' unless defined(&sk_ASN1_STRING_find_ex);
    eval 'sub sk_ASN1_STRING_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_type($ptr), $pnum));
    }' unless defined(&sk_ASN1_STRING_find_all);
    eval 'sub sk_ASN1_STRING_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_ASN1_STRING_sk_type($sk)));
    }' unless defined(&sk_ASN1_STRING_sort);
    eval 'sub sk_ASN1_STRING_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_ASN1_STRING_sk_type($sk)));
    }' unless defined(&sk_ASN1_STRING_is_sorted);
    eval 'sub sk_ASN1_STRING_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &ASN1_STRING) *) &OPENSSL_sk_dup( &ossl_check_const_ASN1_STRING_sk_type($sk))));
    }' unless defined(&sk_ASN1_STRING_dup);
    eval 'sub sk_ASN1_STRING_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &ASN1_STRING) *) &OPENSSL_sk_deep_copy( &ossl_check_const_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_copyfunc_type($copyfunc),  &ossl_check_ASN1_STRING_freefunc_type($freefunc))));
    }' unless defined(&sk_ASN1_STRING_deep_copy);
    eval 'sub sk_ASN1_STRING_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_ASN1_STRING_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_ASN1_STRING_sk_type($sk),  &ossl_check_ASN1_STRING_compfunc_type($cmp))));
    }' unless defined(&sk_ASN1_STRING_set_cmp_func);
    eval 'sub sk_PROFESSION_INFO_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_PROFESSION_INFO_sk_type($sk)));
    }' unless defined(&sk_PROFESSION_INFO_num);
    eval 'sub sk_PROFESSION_INFO_value {
        my($sk, $idx) = @_;
	    eval q((( &PROFESSION_INFO *) &OPENSSL_sk_value( &ossl_check_const_PROFESSION_INFO_sk_type($sk), ($idx))));
    }' unless defined(&sk_PROFESSION_INFO_value);
    eval 'sub sk_PROFESSION_INFO_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &PROFESSION_INFO) *) &OPENSSL_sk_new( &ossl_check_PROFESSION_INFO_compfunc_type($cmp))));
    }' unless defined(&sk_PROFESSION_INFO_new);
    eval 'sub sk_PROFESSION_INFO_new_null () {
        eval q((( &STACK_OF( &PROFESSION_INFO) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_PROFESSION_INFO_new_null);
    eval 'sub sk_PROFESSION_INFO_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &PROFESSION_INFO) *) &OPENSSL_sk_new_reserve( &ossl_check_PROFESSION_INFO_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_PROFESSION_INFO_new_reserve);
    eval 'sub sk_PROFESSION_INFO_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_PROFESSION_INFO_sk_type($sk), ($n)));
    }' unless defined(&sk_PROFESSION_INFO_reserve);
    eval 'sub sk_PROFESSION_INFO_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_PROFESSION_INFO_sk_type($sk)));
    }' unless defined(&sk_PROFESSION_INFO_free);
    eval 'sub sk_PROFESSION_INFO_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_PROFESSION_INFO_sk_type($sk)));
    }' unless defined(&sk_PROFESSION_INFO_zero);
    eval 'sub sk_PROFESSION_INFO_delete {
        my($sk, $i) = @_;
	    eval q((( &PROFESSION_INFO *) &OPENSSL_sk_delete( &ossl_check_PROFESSION_INFO_sk_type($sk), ($i))));
    }' unless defined(&sk_PROFESSION_INFO_delete);
    eval 'sub sk_PROFESSION_INFO_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &PROFESSION_INFO *) &OPENSSL_sk_delete_ptr( &ossl_check_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_type($ptr))));
    }' unless defined(&sk_PROFESSION_INFO_delete_ptr);
    eval 'sub sk_PROFESSION_INFO_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_type($ptr)));
    }' unless defined(&sk_PROFESSION_INFO_push);
    eval 'sub sk_PROFESSION_INFO_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_type($ptr)));
    }' unless defined(&sk_PROFESSION_INFO_unshift);
    eval 'sub sk_PROFESSION_INFO_pop {
        my($sk) = @_;
	    eval q((( &PROFESSION_INFO *) &OPENSSL_sk_pop( &ossl_check_PROFESSION_INFO_sk_type($sk))));
    }' unless defined(&sk_PROFESSION_INFO_pop);
    eval 'sub sk_PROFESSION_INFO_shift {
        my($sk) = @_;
	    eval q((( &PROFESSION_INFO *) &OPENSSL_sk_shift( &ossl_check_PROFESSION_INFO_sk_type($sk))));
    }' unless defined(&sk_PROFESSION_INFO_shift);
    eval 'sub sk_PROFESSION_INFO_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_PROFESSION_INFO_sk_type($sk), &ossl_check_PROFESSION_INFO_freefunc_type($freefunc)));
    }' unless defined(&sk_PROFESSION_INFO_pop_free);
    eval 'sub sk_PROFESSION_INFO_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_type($ptr), ($idx)));
    }' unless defined(&sk_PROFESSION_INFO_insert);
    eval 'sub sk_PROFESSION_INFO_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &PROFESSION_INFO *) &OPENSSL_sk_set( &ossl_check_PROFESSION_INFO_sk_type($sk), ($idx),  &ossl_check_PROFESSION_INFO_type($ptr))));
    }' unless defined(&sk_PROFESSION_INFO_set);
    eval 'sub sk_PROFESSION_INFO_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_type($ptr)));
    }' unless defined(&sk_PROFESSION_INFO_find);
    eval 'sub sk_PROFESSION_INFO_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_type($ptr)));
    }' unless defined(&sk_PROFESSION_INFO_find_ex);
    eval 'sub sk_PROFESSION_INFO_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_type($ptr), $pnum));
    }' unless defined(&sk_PROFESSION_INFO_find_all);
    eval 'sub sk_PROFESSION_INFO_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_PROFESSION_INFO_sk_type($sk)));
    }' unless defined(&sk_PROFESSION_INFO_sort);
    eval 'sub sk_PROFESSION_INFO_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_PROFESSION_INFO_sk_type($sk)));
    }' unless defined(&sk_PROFESSION_INFO_is_sorted);
    eval 'sub sk_PROFESSION_INFO_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &PROFESSION_INFO) *) &OPENSSL_sk_dup( &ossl_check_const_PROFESSION_INFO_sk_type($sk))));
    }' unless defined(&sk_PROFESSION_INFO_dup);
    eval 'sub sk_PROFESSION_INFO_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &PROFESSION_INFO) *) &OPENSSL_sk_deep_copy( &ossl_check_const_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_copyfunc_type($copyfunc),  &ossl_check_PROFESSION_INFO_freefunc_type($freefunc))));
    }' unless defined(&sk_PROFESSION_INFO_deep_copy);
    eval 'sub sk_PROFESSION_INFO_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_PROFESSION_INFO_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_PROFESSION_INFO_sk_type($sk),  &ossl_check_PROFESSION_INFO_compfunc_type($cmp))));
    }' unless defined(&sk_PROFESSION_INFO_set_cmp_func);
    eval 'sub sk_ADMISSIONS_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_ADMISSIONS_sk_type($sk)));
    }' unless defined(&sk_ADMISSIONS_num);
    eval 'sub sk_ADMISSIONS_value {
        my($sk, $idx) = @_;
	    eval q((( &ADMISSIONS *) &OPENSSL_sk_value( &ossl_check_const_ADMISSIONS_sk_type($sk), ($idx))));
    }' unless defined(&sk_ADMISSIONS_value);
    eval 'sub sk_ADMISSIONS_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &ADMISSIONS) *) &OPENSSL_sk_new( &ossl_check_ADMISSIONS_compfunc_type($cmp))));
    }' unless defined(&sk_ADMISSIONS_new);
    eval 'sub sk_ADMISSIONS_new_null () {
        eval q((( &STACK_OF( &ADMISSIONS) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_ADMISSIONS_new_null);
    eval 'sub sk_ADMISSIONS_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &ADMISSIONS) *) &OPENSSL_sk_new_reserve( &ossl_check_ADMISSIONS_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_ADMISSIONS_new_reserve);
    eval 'sub sk_ADMISSIONS_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_ADMISSIONS_sk_type($sk), ($n)));
    }' unless defined(&sk_ADMISSIONS_reserve);
    eval 'sub sk_ADMISSIONS_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_ADMISSIONS_sk_type($sk)));
    }' unless defined(&sk_ADMISSIONS_free);
    eval 'sub sk_ADMISSIONS_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_ADMISSIONS_sk_type($sk)));
    }' unless defined(&sk_ADMISSIONS_zero);
    eval 'sub sk_ADMISSIONS_delete {
        my($sk, $i) = @_;
	    eval q((( &ADMISSIONS *) &OPENSSL_sk_delete( &ossl_check_ADMISSIONS_sk_type($sk), ($i))));
    }' unless defined(&sk_ADMISSIONS_delete);
    eval 'sub sk_ADMISSIONS_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &ADMISSIONS *) &OPENSSL_sk_delete_ptr( &ossl_check_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_type($ptr))));
    }' unless defined(&sk_ADMISSIONS_delete_ptr);
    eval 'sub sk_ADMISSIONS_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_type($ptr)));
    }' unless defined(&sk_ADMISSIONS_push);
    eval 'sub sk_ADMISSIONS_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_type($ptr)));
    }' unless defined(&sk_ADMISSIONS_unshift);
    eval 'sub sk_ADMISSIONS_pop {
        my($sk) = @_;
	    eval q((( &ADMISSIONS *) &OPENSSL_sk_pop( &ossl_check_ADMISSIONS_sk_type($sk))));
    }' unless defined(&sk_ADMISSIONS_pop);
    eval 'sub sk_ADMISSIONS_shift {
        my($sk) = @_;
	    eval q((( &ADMISSIONS *) &OPENSSL_sk_shift( &ossl_check_ADMISSIONS_sk_type($sk))));
    }' unless defined(&sk_ADMISSIONS_shift);
    eval 'sub sk_ADMISSIONS_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_ADMISSIONS_sk_type($sk), &ossl_check_ADMISSIONS_freefunc_type($freefunc)));
    }' unless defined(&sk_ADMISSIONS_pop_free);
    eval 'sub sk_ADMISSIONS_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_type($ptr), ($idx)));
    }' unless defined(&sk_ADMISSIONS_insert);
    eval 'sub sk_ADMISSIONS_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &ADMISSIONS *) &OPENSSL_sk_set( &ossl_check_ADMISSIONS_sk_type($sk), ($idx),  &ossl_check_ADMISSIONS_type($ptr))));
    }' unless defined(&sk_ADMISSIONS_set);
    eval 'sub sk_ADMISSIONS_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_type($ptr)));
    }' unless defined(&sk_ADMISSIONS_find);
    eval 'sub sk_ADMISSIONS_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_type($ptr)));
    }' unless defined(&sk_ADMISSIONS_find_ex);
    eval 'sub sk_ADMISSIONS_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_type($ptr), $pnum));
    }' unless defined(&sk_ADMISSIONS_find_all);
    eval 'sub sk_ADMISSIONS_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_ADMISSIONS_sk_type($sk)));
    }' unless defined(&sk_ADMISSIONS_sort);
    eval 'sub sk_ADMISSIONS_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_ADMISSIONS_sk_type($sk)));
    }' unless defined(&sk_ADMISSIONS_is_sorted);
    eval 'sub sk_ADMISSIONS_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &ADMISSIONS) *) &OPENSSL_sk_dup( &ossl_check_const_ADMISSIONS_sk_type($sk))));
    }' unless defined(&sk_ADMISSIONS_dup);
    eval 'sub sk_ADMISSIONS_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &ADMISSIONS) *) &OPENSSL_sk_deep_copy( &ossl_check_const_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_copyfunc_type($copyfunc),  &ossl_check_ADMISSIONS_freefunc_type($freefunc))));
    }' unless defined(&sk_ADMISSIONS_deep_copy);
    eval 'sub sk_ADMISSIONS_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_ADMISSIONS_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_ADMISSIONS_sk_type($sk),  &ossl_check_ADMISSIONS_compfunc_type($cmp))));
    }' unless defined(&sk_ADMISSIONS_set_cmp_func);
    if(defined(&__cplusplus)) {
    }
}
1;
