/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;

public class InsertSizeFilter
implements SamRecordFilter {
    final int minInsertSize;
    final int maxInsertSize;

    public InsertSizeFilter(int minInsertSize, int maxInsertSize) {
        if (minInsertSize > maxInsertSize) {
            throw new SAMException("Cannot have minInsertSize > maxInsertSize");
        }
        this.minInsertSize = minInsertSize;
        this.maxInsertSize = maxInsertSize;
    }

    @Override
    public boolean filterOut(SAMRecord rec) {
        if (!rec.getReadPairedFlag()) {
            return true;
        }
        int ins = Math.abs(rec.getInferredInsertSize());
        return ins < this.minInsertSize || ins > this.maxInsertSize;
    }

    @Override
    public boolean filterOut(SAMRecord r1, SAMRecord r2) {
        return this.filterOut(r1) || this.filterOut(r2);
    }
}

