/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import htsjdk.samtools.SAMRecord;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.lang.MutableString;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.campagnelab.goby.reads.QualityEncoding;
import org.campagnelab.goby.util.LogIsConfigured;
import org.campagnelab.goby.util.SamSequenceVariation;
import org.campagnelab.goby.util.pool.Resettable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamHelper
implements Resettable {
    private static final Pattern CIGAR_REGEX = Pattern.compile("([0-9]+)([SMID])");
    private static final Pattern MD_REGEX = Pattern.compile("([0-9]+|[acgtnACGTN]|\\^[acgtnACGTN]+)");
    private static final Pattern NUMERIC_REGEX = Pattern.compile("^[0-9]+$");
    private static final Pattern FIRST_NUMBER_PATTERN = Pattern.compile("^(\\d+)");
    private static final Pattern LAST_NUMBER_PATTERN = Pattern.compile("(\\d+)$");
    public static final Pattern FIRST_CIGAR_PATTERN = Pattern.compile("^(\\d+)([MIDNSHP])");
    public static final Pattern LAST_CIGAR_PATTERN = Pattern.compile("(\\d+)([MIDNSHP])$");
    private static final Logger LOG = LoggerFactory.getLogger(SamHelper.class);
    private byte minQualValue;
    private final MutableString cigar = new MutableString();
    private final MutableString md = new MutableString();
    private final MutableString sourceQuery = new MutableString();
    private final MutableString sourceQual = new MutableString();
    private final MutableString query = new MutableString();
    private final MutableString qual = new MutableString();
    private final MutableString ref = new MutableString();
    private int alignedLength;
    private int queryAlignedLength;
    private int targetAlignedLength;
    private int numInsertions;
    private int numDeletions;
    private int numMisMatches;
    private int score;
    private int numLeftClipped;
    private int numRightClipped;
    private int position;
    private int queryIndex;
    private int queryPosition;
    private int queryLength;
    private boolean reverseStrand;
    private final IntList refPositions = new IntArrayList();
    private final IntList readIndexes = new IntArrayList();
    private final ObjectList<SamSequenceVariation> sequenceVariations = new ObjectArrayList();
    private final MutableString logval = new MutableString();
    private QualityEncoding qualityEncoding = QualityEncoding.SANGER;
    private static boolean debug = true;

    public SamHelper() {
        debug = debug && LogIsConfigured.isConfigured();
    }

    @Override
    public void reset() {
        this.cigar.setLength(0);
        this.md.setLength(0);
        this.sourceQuery.setLength(0);
        this.sourceQual.setLength(0);
        this.query.setLength(0);
        this.qual.setLength(0);
        this.ref.setLength(0);
        this.alignedLength = 0;
        this.numInsertions = 0;
        this.numDeletions = 0;
        this.numMisMatches = 0;
        this.score = 0;
        this.numLeftClipped = 0;
        this.numRightClipped = 0;
        this.position = 0;
        this.queryIndex = 0;
        this.queryPosition = 0;
        this.queryLength = 0;
        this.reverseStrand = false;
        this.refPositions.clear();
        this.readIndexes.clear();
        this.sequenceVariations.clear();
    }

    public void setSource(int queryIndex, CharSequence sourceQuery, CharSequence sourceQual, CharSequence cigar, CharSequence md, int position, boolean reverseStrand, int readLength) {
        this.queryLength = readLength;
        if (debug && LOG.isDebugEnabled()) {
            LOG.debug("------ new setSource --------------------------------");
            LOG.debug("position=" + (position - 1));
            LOG.debug("queryIndex=" + queryIndex);
        }
        this.reset();
        this.queryIndex = queryIndex;
        this.sourceQuery.setLength(0);
        if (sourceQuery != null) {
            this.sourceQuery.append(sourceQuery);
            this.queryLength = sourceQuery.length();
        }
        this.sourceQual.setLength(0);
        if (sourceQual != null) {
            this.sourceQual.append(sourceQual);
        }
        this.cigar.setLength(0);
        if (cigar != null) {
            this.cigar.append(cigar);
        }
        this.md.setLength(0);
        if (md != null) {
            this.md.append(md);
            this.md.toUpperCase();
        }
        this.position = position - 1;
        this.reverseStrand = reverseStrand;
        this.constructRefAndQuery();
        this.findSequenceVariations();
        SamSequenceVariation.merge(this.sequenceVariations);
    }

    public void setSourceWithReference(int queryIndex, SAMRecord samRecord, String sourceRef) {
        String sourceQuery = samRecord.getReadString();
        String sourceQual = samRecord.getBaseQualityString();
        int position = samRecord.getAlignmentStart();
        boolean reverseStrand = samRecord.getReadNegativeStrandFlag();
        this.setSourceWithReference(queryIndex, sourceRef, sourceQuery, sourceQual, position, reverseStrand);
    }

    public void setSourceWithReference(int queryIndex, CharSequence sourceRef, CharSequence sourceQuery, CharSequence sourceQual, int position, boolean reverseStrand) {
        if (debug && LOG.isDebugEnabled()) {
            LOG.debug("------ new setSourceWithReference --------------------------------");
            LOG.debug("position=" + (position - 1));
            LOG.debug("queryIndex=" + queryIndex);
        }
        this.reset();
        this.queryIndex = queryIndex;
        this.sourceQuery.setLength(0);
        if (sourceQuery != null) {
            this.sourceQuery.append(sourceQuery);
            this.queryLength = sourceQuery.length();
        }
        this.sourceQual.setLength(0);
        if (sourceQual != null) {
            this.sourceQual.append(sourceQual);
        }
        this.ref.setLength(0);
        if (sourceRef != null) {
            this.ref.append(sourceRef);
        }
        this.query.setLength(0);
        if (sourceQuery != null) {
            this.query.append(sourceQuery);
        }
        this.qual.setLength(0);
        if (sourceQual != null) {
            this.qual.append(sourceQual);
        }
        this.position = position - 1;
        this.queryPosition = 0;
        this.reverseStrand = reverseStrand;
        this.numInsertions = 0;
        this.numDeletions = 0;
        this.numLeftClipped = 0;
        this.numRightClipped = 0;
        this.alignedLength = this.query.length();
        this.queryAlignedLength = this.query.length();
        this.queryLength = this.query.length();
        this.targetAlignedLength = this.ref.length();
        int scanLength = Math.min(this.query.length(), this.ref.length());
        this.numMisMatches = 0;
        for (int i = 0; i < scanLength; ++i) {
            if (this.query.charAt(i) == this.ref.charAt(i)) continue;
            ++this.numMisMatches;
            this.ref.setCharAt(i, Character.toLowerCase(this.ref.charAt(i)));
        }
        this.score = this.alignedLength - this.numMisMatches;
        this.findSequenceVariations();
        SamSequenceVariation.merge(this.sequenceVariations);
        if (debug && LOG.isDebugEnabled()) {
            for (SamSequenceVariation seqvar : this.sequenceVariations) {
                LOG.debug("... Variation " + seqvar.toString());
            }
        }
    }

    public List<SamSequenceVariation> getSequenceVariations() {
        return this.sequenceVariations;
    }

    public MutableString getSourceQuery() {
        return this.sourceQuery;
    }

    public MutableString getQuery() {
        return this.query;
    }

    public MutableString getSourceQual() {
        return this.sourceQual;
    }

    public byte[] getSourceQualAsBytes() {
        int length = this.sourceQual.length();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.qualityEncoding.asciiEncodingToPhredQualityScore(this.sourceQual.charAt(i));
        }
        return result;
    }

    public MutableString getQual() {
        return this.qual;
    }

    public MutableString getRef() {
        return this.ref;
    }

    public MutableString getCigar() {
        return this.cigar;
    }

    public MutableString getMd() {
        return this.md;
    }

    public void setMinQualValue(byte minQualValue) {
        this.minQualValue = minQualValue;
    }

    public void setMinQualValue(char minQualValue) {
        this.minQualValue = (byte)minQualValue;
    }

    public byte getMinQualValue() {
        return this.minQualValue;
    }

    public int getAlignedLength() {
        return this.alignedLength;
    }

    public int getQueryAlignedLength() {
        return this.queryAlignedLength;
    }

    public int getQueryLength() {
        return this.queryLength;
    }

    public int getTargetAlignedLength() {
        return this.targetAlignedLength;
    }

    public int getNumInsertions() {
        return this.numInsertions;
    }

    public int getNumDeletions() {
        return this.numDeletions;
    }

    public int getNumMisMatches() {
        return this.numMisMatches;
    }

    public int getScore() {
        return this.score;
    }

    public int getNumLeftClipped() {
        return this.numLeftClipped;
    }

    public int getNumRightClipped() {
        return this.numRightClipped;
    }

    public int getPosition() {
        return this.position;
    }

    public int getQueryIndex() {
        return this.queryIndex;
    }

    public int getQueryPosition() {
        return this.queryPosition;
    }

    public boolean isReverseStrand() {
        return this.reverseStrand;
    }

    protected void constructRefAndQuery() {
        this.query.setLength(0);
        this.qual.setLength(0);
        this.ref.setLength(0);
        this.alignedLength = 0;
        this.queryAlignedLength = 0;
        this.targetAlignedLength = 0;
        this.numInsertions = 0;
        this.numDeletions = 0;
        this.numMisMatches = 0;
        this.numLeftClipped = 0;
        this.numRightClipped = 0;
        this.score = 0;
        if (debug && LOG.isDebugEnabled()) {
            LOG.debug(":: Reference and query before construction");
            LOG.debug(String.format(":: read=%s", this.sourceQuery));
        }
        this.applyCigar();
        this.applyMd();
        this.clipRefAndQuery();
        this.alignedLength = this.query.length();
        this.queryAlignedLength = this.alignedLength - this.numDeletions;
        this.targetAlignedLength = this.alignedLength - this.numInsertions;
        this.score = this.alignedLength - this.numDeletions - this.numInsertions - this.numMisMatches;
        if (this.query.length() != this.ref.length()) {
            LOG.error("ERROR! reconstructed reads and refs don't match in size!!");
        }
    }

    protected void applyCigar() {
        int i;
        if (debug && LOG.isDebugEnabled()) {
            LOG.debug(String.format(":: Applying cigar=%s", this.cigar));
        }
        int posInReads = 0;
        this.numInsertions = 0;
        this.numDeletions = 0;
        this.numMisMatches = 0;
        Matcher matcher = CIGAR_REGEX.matcher((CharSequence)this.cigar);
        block6: while (matcher.find()) {
            int length = Integer.parseInt(matcher.group(1));
            char op = matcher.group(2).charAt(0);
            switch (op) {
                case 'S': {
                    int i2;
                    for (i2 = 0; i2 < length; ++i2) {
                        this.ref.append('-');
                        this.query.append('-');
                        this.qual.append((char)this.minQualValue);
                    }
                    continue block6;
                }
                case 'M': {
                    this.query.append(this.sourceQuery.substring(posInReads, posInReads + length));
                    if (this.sourceQual.length() != 0) {
                        this.qual.append(this.sourceQual.substring(posInReads, posInReads + length));
                    }
                    this.ref.append(this.sourceQuery.substring(posInReads, posInReads + length));
                    posInReads += length;
                    break;
                }
                case 'I': {
                    int i2;
                    this.query.append(this.sourceQuery.substring(posInReads, posInReads + length));
                    if (this.sourceQual.length() != 0) {
                        this.qual.append(this.sourceQual.substring(posInReads, posInReads + length));
                    }
                    for (i2 = 0; i2 < length; ++i2) {
                        this.ref.append('-');
                    }
                    this.numInsertions += length;
                    posInReads += length;
                    break;
                }
                case 'D': {
                    int i2;
                    for (i2 = 0; i2 < length; ++i2) {
                        this.query.append('-');
                        if (this.sourceQual.length() != 0) {
                            this.qual.append((char)this.minQualValue);
                        }
                        this.ref.append('?');
                    }
                    this.numDeletions += length;
                }
            }
        }
        for (i = 0; i < this.query.length() && this.query.charAt(i) == '-' && this.ref.charAt(i) == '-'; ++i) {
            ++this.numLeftClipped;
        }
        for (i = this.query.length() - 1; i >= 0 && this.query.charAt(i) == '-' && this.ref.charAt(i) == '-'; --i) {
            ++this.numRightClipped;
        }
    }

    private void applyMd() {
        if (debug && LOG.isDebugEnabled()) {
            LOG.debug(String.format(":: Applying md=%s", this.md));
        }
        int position = this.numLeftClipped;
        Matcher matcher = MD_REGEX.matcher((CharSequence)this.md);
        while (matcher.find()) {
            int i;
            String mdPart = matcher.group();
            if (NUMERIC_REGEX.matcher(mdPart).matches()) {
                int length = Integer.parseInt(mdPart);
                position += length;
                continue;
            }
            if (mdPart.charAt(0) == '^') {
                if (this.ref.charAt(position) == '-') {
                    ++position;
                }
                for (i = 1; i < mdPart.length(); ++i) {
                    this.ref.setCharAt(position++, mdPart.charAt(i));
                }
                continue;
            }
            for (i = 0; i < mdPart.length(); ++i) {
                if (this.ref.charAt(position) == '-') {
                    // empty if block
                }
                int n = ++position;
                ++position;
                this.ref.setCharAt(n, Character.toLowerCase(mdPart.charAt(i)));
                ++this.numMisMatches;
            }
        }
    }

    private void clipRefAndQuery() {
        if (this.numLeftClipped > 0 || this.numRightClipped > 0) {
            LOG.debug(":: Reference and query pre-clipping");
            this.debugSequences(false);
            if (this.numRightClipped > 0) {
                this.query.setLength(this.query.length() - this.numRightClipped);
                this.ref.setLength(this.ref.length() - this.numRightClipped);
                if (this.qual.length() > 0) {
                    this.qual.setLength(this.qual.length() - this.numRightClipped);
                }
            }
            if (this.numLeftClipped > 0) {
                this.queryPosition += this.numLeftClipped;
                this.query.delete(0, this.numLeftClipped);
                this.ref.delete(0, this.numLeftClipped);
                if (this.qual.length() > 0) {
                    this.qual.delete(0, this.numLeftClipped);
                }
            }
        }
    }

    private void findSequenceVariations() {
        char queryChar;
        char refChar;
        int i;
        int genomicLength = this.ref.length();
        int paddedLength = this.numLeftClipped + genomicLength + this.numRightClipped;
        boolean tooBig = false;
        int tooBigReadIndex = 0;
        int tooBigRefPosition = 0;
        this.refPositions.size(10);
        this.readIndexes.size(paddedLength);
        this.refPositions.size(paddedLength);
        int refPosition = 0;
        int readIndex = 0;
        for (i = 0; i < paddedLength; ++i) {
            if (i < this.numLeftClipped) {
                ++readIndex;
            } else if (i >= genomicLength + this.numLeftClipped) {
                ++readIndex;
            } else {
                int index;
                refChar = Character.toUpperCase(this.ref.charAt(i - this.numLeftClipped));
                if (refChar != '-') {
                    ++refPosition;
                }
                if (this.reverseStrand) {
                    index = genomicLength - (i - this.numLeftClipped) - 1;
                    queryChar = Character.toUpperCase(this.query.charAt(index));
                } else {
                    index = i - this.numLeftClipped;
                    queryChar = Character.toUpperCase(this.query.charAt(index));
                }
                if (queryChar != '-') {
                    ++readIndex;
                }
            }
            this.refPositions.set(i, refPosition);
            if (this.reverseStrand) {
                this.readIndexes.set(paddedLength - i - 1, readIndex);
                continue;
            }
            this.readIndexes.set(i, readIndex);
        }
        if (debug && LOG.isDebugEnabled()) {
            this.debugSequences();
            this.logval.setLength(0);
            this.logval.append("::  pos=");
            for (i = 0; i < paddedLength; ++i) {
                this.logval.append(String.format("%d", (Integer)this.refPositions.get(i) % 10));
            }
            LOG.debug(this.logval.toString());
            this.logval.setLength(0);
            this.logval.append("::   ri=");
            for (i = 0; i < paddedLength; ++i) {
                this.logval.append(String.format("%d", (Integer)this.readIndexes.get(i) % 10));
            }
            LOG.debug(this.logval.toString());
            LOG.debug("ref with positions");
            this.logval.setLength(0);
            for (i = 0; i < paddedLength; ++i) {
                refChar = i < this.numLeftClipped ? (char)'_' : (i >= genomicLength + this.numLeftClipped ? (char)'_' : (char)this.ref.charAt(i - this.numLeftClipped));
                this.logval.append(String.format("%02d:%c:%02d  ", i, Character.valueOf(refChar), this.refPositions.get(i)));
            }
            LOG.debug(this.logval.toString());
            LOG.debug("read with positions");
            this.logval.setLength(0);
            for (i = 0; i < paddedLength; ++i) {
                queryChar = i < this.numLeftClipped ? (char)'_' : (i >= this.numLeftClipped + genomicLength ? (char)'_' : (char)this.query.charAt(i - this.numLeftClipped));
                this.logval.append(String.format("%02d:%c:%02d  ", i, Character.valueOf(queryChar), this.readIndexes.get(i)));
            }
            LOG.debug(this.logval.toString());
            LOG.debug(String.format("numLeftClipped=%d, numRightClipped=%d", this.numLeftClipped, this.numRightClipped));
        }
        for (int queryI = this.numLeftClipped; queryI < this.numLeftClipped + genomicLength; ++queryI) {
            byte qualChar;
            boolean hasQual;
            refPosition = (Integer)this.refPositions.get(queryI);
            readIndex = (Integer)this.readIndexes.get(queryI);
            int i2 = queryI - this.numLeftClipped;
            if (readIndex > this.queryLength && !tooBig) {
                tooBig = true;
                tooBigReadIndex = readIndex;
                tooBigRefPosition = refPosition;
            }
            refChar = Character.toUpperCase(this.ref.charAt(i2));
            queryChar = Character.toUpperCase(this.query.charAt(i2));
            if (this.qual.length() > 0 && queryChar != '-') {
                hasQual = true;
                qualChar = this.qualityEncoding.asciiEncodingToPhredQualityScore(this.qual.charAt(i2));
            } else {
                hasQual = false;
                qualChar = this.minQualValue;
            }
            if (refChar == queryChar) continue;
            this.sequenceVariations.add((Object)new SamSequenceVariation(refPosition, refChar, readIndex, queryChar, hasQual, qualChar));
        }
        if (tooBig && debug && LOG.isDebugEnabled()) {
            LOG.debug(String.format(" *** readIndex [%d] or refPosition [%d] is too large! ***", tooBigReadIndex, tooBigRefPosition));
            LOG.debug(String.format(">%d", this.queryIndex));
            if (this.sourceQuery.length() > 0) {
                LOG.debug(String.format("%s", this.sourceQuery));
            } else {
                LOG.debug("sourceQuery was NULL");
            }
        }
    }

    private void debugSequences() {
        this.debugSequences(true);
    }

    private void debugSequences(boolean printClipChars) {
        int i;
        if (!debug) {
            return;
        }
        LOG.debug(String.format(":: paddingLeft=%d, paddingRight=%d", this.numLeftClipped, this.numRightClipped));
        this.logval.setLength(0);
        if (this.qual.length() > 0) {
            this.logval.append(":: qual=");
            if (printClipChars) {
                for (i = 0; i < this.numLeftClipped; ++i) {
                    this.logval.append("_");
                }
            }
            for (i = 0; i < this.qual.length(); ++i) {
                if (i > 0) {
                    this.logval.append(":");
                }
                this.logval.append(String.format("%d", this.qual.charAt(i)));
            }
            if (printClipChars) {
                for (i = 0; i < this.numRightClipped; ++i) {
                    this.logval.append("_");
                }
            }
        } else {
            this.logval.append(":: qual=none");
        }
        LOG.debug(this.logval.toString());
        this.logval.setLength(0);
        this.logval.append(":: ref =");
        if (printClipChars) {
            for (i = 0; i < this.numLeftClipped; ++i) {
                this.logval.append("_");
            }
        }
        this.logval.append(this.ref.toString());
        if (printClipChars) {
            for (i = 0; i < this.numRightClipped; ++i) {
                this.logval.append("_");
            }
        }
        LOG.debug(this.logval.toString());
        this.logval.setLength(0);
        this.logval.append(":: read=");
        if (printClipChars) {
            for (i = 0; i < this.numLeftClipped; ++i) {
                this.logval.append("_");
            }
        }
        this.logval.append(this.query.toString());
        if (printClipChars) {
            for (i = 0; i < this.numRightClipped; ++i) {
                this.logval.append("_");
            }
        }
        LOG.debug(this.logval.toString());
    }

    public QualityEncoding getQualityEncoding() {
        return this.qualityEncoding;
    }

    public void setQualityEncoding(QualityEncoding qualityEncoding) {
        this.qualityEncoding = qualityEncoding;
    }

    public void setQueryPosition(int queryPosition) {
        this.queryPosition = queryPosition;
    }

    public static void appendCigar(MutableString appendTo, MutableString appendFrom) {
        if (appendFrom.length() == 0 || appendTo.length() == 0) {
            appendTo.append(appendFrom);
            return;
        }
        String appendToMatchNum = null;
        char appendToMatchCode = '\u0000';
        Matcher appendToMatcher = LAST_CIGAR_PATTERN.matcher((CharSequence)appendTo);
        if (appendToMatcher.find()) {
            appendToMatchNum = appendToMatcher.group(1);
            appendToMatchCode = appendToMatcher.group(2).charAt(0);
        }
        String appendFromMatchNum = null;
        char appendFromMatchCode = '\u0000';
        Matcher appendFromMatcher = FIRST_CIGAR_PATTERN.matcher((CharSequence)appendFrom);
        if (appendFromMatcher.find()) {
            appendFromMatchNum = appendFromMatcher.group(1);
            appendFromMatchCode = appendFromMatcher.group(2).charAt(0);
        }
        if (appendToMatchNum == null || appendFromMatchNum == null || appendToMatchCode != appendFromMatchCode) {
            appendTo.append(appendFrom);
        } else {
            int appendToVal = Integer.parseInt(appendToMatchNum);
            int appendFromVal = Integer.parseInt(appendFromMatchNum);
            appendTo.setLength(appendTo.length() - appendToMatchNum.length() - 1);
            appendTo.append(appendToVal + appendFromVal).append(appendFromMatchCode);
            appendTo.append(appendFrom.substring(appendFromMatchNum.length() + 1));
        }
    }

    public static void appendMismatches(MutableString appendTo, MutableString appendFrom) {
        if (appendFrom.length() == 0 || appendTo.length() == 0) {
            appendTo.append(appendFrom);
            return;
        }
        String appendToMatch = null;
        Matcher appendToMatcher = LAST_NUMBER_PATTERN.matcher((CharSequence)appendTo);
        if (appendToMatcher.find()) {
            appendToMatch = appendToMatcher.group(0);
        }
        String appendFromMatch = null;
        Matcher appendFromMatcher = FIRST_NUMBER_PATTERN.matcher((CharSequence)appendFrom);
        if (appendFromMatcher.find()) {
            appendFromMatch = appendFromMatcher.group(0);
        }
        if (appendToMatch == null || appendFromMatch == null) {
            appendTo.append(appendFrom);
        } else {
            int appendToVal = Integer.parseInt(appendToMatch);
            int appendFromVal = Integer.parseInt(appendFromMatch);
            appendTo.setLength(appendTo.length() - appendToMatch.length());
            appendTo.append(appendToVal + appendFromVal);
            appendTo.append(appendFrom.substring(appendFromMatch.length()));
        }
    }

    private static boolean mdzPartIsNumeric(CharSequence mdzPart) {
        return NUMERIC_REGEX.matcher(mdzPart).matches();
    }

    public static String canonicalMdz(List<CharSequence> mdzParts) {
        if (mdzParts == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean lastMdzPartWasNumeric = false;
        for (CharSequence mdzPart : mdzParts) {
            boolean mdzPartIsNumeric = SamHelper.mdzPartIsNumeric(mdzPart);
            if (mdzPartIsNumeric) {
                result.append(mdzPart);
            } else {
                if (!lastMdzPartWasNumeric) {
                    result.append("0");
                }
                result.append(mdzPart);
            }
            lastMdzPartWasNumeric = mdzPartIsNumeric;
        }
        if (!lastMdzPartWasNumeric) {
            result.append("0");
        }
        return result.toString().toUpperCase();
    }

    public static String canonicalMdz(String mdz) {
        if (mdz == null) {
            return mdz;
        }
        ArrayList<CharSequence> mdzParts = new ArrayList<CharSequence>();
        Matcher matcher = MD_REGEX.matcher(mdz);
        while (matcher.find()) {
            mdzParts.add(matcher.group());
        }
        return SamHelper.canonicalMdz(mdzParts);
    }
}

