/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.IterableOnceIterator;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import java.util.List;

public class SamLocusAndReferenceIterator
extends IterableOnceIterator<SAMLocusAndReference> {
    static final byte BASE_BEFORE_REFERENCE_START = 45;
    private final ReferenceSequenceFileWalker referenceSequenceFileWalker;
    private final SamLocusIterator locusIterator;

    public SamLocusAndReferenceIterator(ReferenceSequenceFileWalker referenceFile, SamLocusIterator locusIterator) throws IllegalArgumentException {
        if (!SequenceUtil.areSequenceDictionariesEqual(locusIterator.getHeader().getSequenceDictionary(), referenceFile.getSequenceDictionary())) {
            throw new IllegalArgumentException("reference and locus iterator have difference dictionaries." + locusIterator.getHeader().getSequenceDictionary().toString() + referenceFile.getSequenceDictionary().toString());
        }
        this.referenceSequenceFileWalker = referenceFile;
        this.locusIterator = locusIterator;
    }

    @Override
    public boolean hasNext() {
        return this.locusIterator.hasNext();
    }

    @Override
    public SAMLocusAndReference next() {
        SamLocusIterator.LocusInfo locus = (SamLocusIterator.LocusInfo)this.locusIterator.next();
        ReferenceSequence referenceSequence = this.referenceSequenceFileWalker.get(locus.getSequenceIndex(), locus.getSequenceName(), locus.getSequenceLength());
        if (locus.getPosition() == 0) {
            return new SAMLocusAndReference(locus, 45);
        }
        return new SAMLocusAndReference(locus, referenceSequence.getBases()[locus.getPosition() - 1]);
    }

    public static class SAMLocusAndReference {
        private final SamLocusIterator.LocusInfo locus;
        private final byte referenceBase;

        public SamLocusIterator.LocusInfo getLocus() {
            return this.locus;
        }

        public byte getReferenceBase() {
            return this.referenceBase;
        }

        public SAMLocusAndReference(SamLocusIterator.LocusInfo locus, byte referenceBase) {
            this.locus = locus;
            this.referenceBase = referenceBase;
        }

        public List<SamLocusIterator.RecordAndOffset> getRecordAndOffsets() {
            return this.locus.getRecordAndOffsets();
        }
    }
}

