require "color"

require "color/rgb/jp/base/encode"
require "color/rgb/jp/base/named_rgb"
require "color/rgb/jp/base/color_name"

module Color::RGB::JP::Base

  module Pallet
    include Encode
    include Enumerable

    def colors
      @colors
    end

    def each(&block)
      colors.each(&block)
    end

    def [](name, encoding = nil)
      with_internal_encoding(name, encoding) {|n|
        @index[normalize(n)]
      }
    end

    def define_color(const, hex, *names)
      @colors ||= []
      @index ||= {}

      name = ColorName.new(const, *names)
      rgb = ::Color::RGB.from_html(hex)
      color = NamedRGB.new(name, rgb)
      @colors << color

      [const, *names].compact.each {|e|
        @index[normalize(e)] ||= color
      }
      color
    end
    alias c define_color

    def normalize(v)
      v.gsub(/-/, "").downcase
    end
    private :normalize
  end

end
