/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.albatross;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KTypeProjection;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import org.islandoftex.albatross.Cache;
import org.islandoftex.albatross.FontConfig;
import org.islandoftex.albatross.FontData;
import org.islandoftex.albatross.KPSEWhich;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R!\u0010\f\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\b\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\f\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/islandoftex/albatross/Cache;", "", "()V", "cacheDirectoryPath", "Ljava/nio/file/Path;", "getCacheDirectoryPath", "()Ljava/nio/file/Path;", "cacheDirectoryPath$delegate", "Lkotlin/Lazy;", "cachePath", "getCachePath", "cachePath$delegate", "isAvailable", "", "isAvailable$annotations", "()Z", "isAvailable$delegate", "buildCacheAndGetFonts", "", "Lorg/islandoftex/albatross/FontData;", "clearCache", "", "compress", "", "bytes", "decompress", "getTeXFonts", "readCache", "albatross"})
public final class Cache {
    @NotNull
    public static final Cache INSTANCE = new Cache();
    @NotNull
    private static final Lazy cacheDirectoryPath$delegate = LazyKt.lazy(cacheDirectoryPath.2.INSTANCE);
    @NotNull
    private static final Lazy cachePath$delegate = LazyKt.lazy(cachePath.2.INSTANCE);
    @NotNull
    private static final Lazy isAvailable$delegate = LazyKt.lazy(isAvailable.2.INSTANCE);

    private Cache() {
    }

    private final Path getCacheDirectoryPath() {
        Lazy lazy = cacheDirectoryPath$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-cacheDirectoryPath>(...)");
        return (Path)t;
    }

    private final Path getCachePath() {
        Lazy lazy = cachePath$delegate;
        return (Path)lazy.getValue();
    }

    private static final boolean isAvailable() {
        Lazy lazy = isAvailable$delegate;
        return (Boolean)lazy.getValue();
    }

    @JvmStatic
    private static /* synthetic */ void isAvailable$annotations() {
    }

    private final List<FontData> buildCacheAndGetFonts() {
        List<FontData> list;
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(this.getCacheDirectoryPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue(Files.createDirectories(this.getCacheDirectoryPath(), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(this, *attributes)");
            }
            List fonts = CollectionsKt.plus((Collection)FontConfig.getFonts(KPSEWhich.INSTANCE.getSystemTeXFontsPath()), (Iterable)FontConfig.getFonts(KPSEWhich.INSTANCE.getLocalTeXFontsPath()));
            boolean $i$f$serializer = false;
            KSerializer<Object> $this$cast$iv$iv = SerializersKt.serializer(Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(FontData.class))));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull($this$cast$iv$iv, "null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            byte[] bytes = ProtoBuf.Default.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv, fonts);
            OpenOption[] openOptionArray = new OpenOption[]{};
            Files.write(this.getCachePath(), this.compress(bytes), Arrays.copyOf(openOptionArray, openOptionArray.length));
        }
        catch (IOException iOException) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<FontData> readCache() {
        List list;
        try {
            byte[] byArray = Files.readAllBytes(this.getCachePath());
            Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(this)");
            byte[] bytes = this.decompress(byArray);
            BinaryFormat $this$decodeFromByteArray$iv = ProtoBuf.Default;
            boolean $i$f$decodeFromByteArray = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromByteArray$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer<Object> $this$cast$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(FontData.class))));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull($this$cast$iv$iv$iv, "null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            list = (List)$this$decodeFromByteArray$iv.decodeFromByteArray($this$cast$iv$iv$iv, bytes);
        }
        catch (IOException iOException) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<FontData> getTeXFonts() {
        return Cache.isAvailable() ? this.readCache() : this.buildCacheAndGetFonts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] compress(byte[] bytes) {
        byte[] byArray;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new GZIPOutputStream(outputStream);
            Throwable throwable2 = null;
            try {
                GZIPOutputStream gzipStream = (GZIPOutputStream)closeable2;
                boolean bl2 = false;
                gzipStream.write(bytes);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(byArray, "ByteArrayOutputStream().\u2026m.toByteArray()\n        }");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] decompress(byte[] bytes) {
        byte[] byArray;
        Closeable closeable = new ByteArrayInputStream(bytes);
        Throwable throwable = null;
        try {
            byte[] byArray2;
            ByteArrayInputStream inputStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new GZIPInputStream(inputStream);
            Throwable throwable2 = null;
            try {
                GZIPInputStream gzipStream = (GZIPInputStream)closeable2;
                boolean bl2 = false;
                byArray2 = ByteStreamsKt.readBytes(gzipStream);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return byArray;
    }

    public final void clearCache() {
        try {
            Files.deleteIfExists(this.getCachePath());
            Files.deleteIfExists(this.getCacheDirectoryPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final /* synthetic */ Path access$getCacheDirectoryPath(Cache $this) {
        return $this.getCacheDirectoryPath();
    }

    public static final /* synthetic */ Path access$getCachePath(Cache $this) {
        return $this.getCachePath();
    }
}

