/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import java.io.Serializable;

public final class REMatch
implements Serializable,
Cloneable {
    private String matchedText;
    int eflags;
    int offset;
    int anchor;
    int index;
    int[] start;
    int[] end;
    REMatch next;

    /*
     * WARNING - void declaration
     */
    public final Object clone() {
        try {
            void e;
            REMatch copy = (REMatch)super.clone();
            copy.next = null;
            copy.start = (int[])this.start.clone();
            copy.end = (int[])this.end.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
    }

    final void assignFrom(REMatch other) {
        this.start = other.start;
        this.end = other.end;
        this.index = other.index;
        this.next = other.next;
    }

    final void finish(CharIndexed text) {
        this.start[0] = 0;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.end[0]) {
            sb.append(text.charAt(i));
            ++i;
        }
        this.matchedText = sb.toString();
        i = 0;
        while (i < this.start.length) {
            boolean bl = false;
            if (this.start[i] == -1) {
                bl = true;
            }
            boolean bl2 = false;
            if (this.end[i] == -1) {
                bl2 = true;
            }
            if (bl != bl2) {
                this.start[i] = -1;
                this.end[i] = -1;
            }
            ++i;
        }
        this.next = null;
    }

    final void clear(int index) {
        this.offset = index;
        this.index = 0;
        int i = 0;
        while (i < this.start.length) {
            this.end[i] = -1;
            this.start[i] = -1;
            ++i;
        }
        this.next = null;
    }

    public final String toString() {
        return this.matchedText;
    }

    public final int getStartIndex() {
        return this.offset + this.start[0];
    }

    public final int getEndIndex() {
        return this.offset + this.end[0];
    }

    public final String toString(int sub) {
        if (sub >= this.start.length || this.start[sub] == -1) {
            return "";
        }
        return this.matchedText.substring(this.start[sub], this.end[sub]);
    }

    public final int getSubStartIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.start[sub];
        return x == -1 ? x : this.offset + x;
    }

    public final int getStartIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.start[sub];
        return x == -1 ? x : this.offset + x;
    }

    public final int getSubEndIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.end[sub];
        return x == -1 ? x : this.offset + x;
    }

    public final int getEndIndex(int sub) {
        if (sub >= this.start.length) {
            return -1;
        }
        int x = this.end[sub];
        return x == -1 ? x : this.offset + x;
    }

    public final String substituteInto(String input) {
        StringBuffer output = new StringBuffer();
        int pos = 0;
        while (pos < input.length() - 1) {
            if (input.charAt(pos) == '$' && Character.isDigit(input.charAt(pos + 1))) {
                int val;
                if ((val = Character.digit(input.charAt(++pos), 10)) < this.start.length) {
                    output.append(this.toString(val));
                }
            } else {
                output.append(input.charAt(pos));
            }
            ++pos;
        }
        if (pos < input.length()) {
            output.append(input.charAt(pos));
        }
        return output.toString();
    }

    REMatch(int subs, int anchor, int eflags) {
        this.start = new int[subs + 1];
        this.end = new int[subs + 1];
        this.anchor = anchor;
        this.eflags = eflags;
        this.clear(anchor);
    }
}

