/* -*- Mode: C; c-file-style: "gnu" -*-
   gc.h -- plugable gc stuff.
   Created: Chris Toshok <toshok@hungry.com>, 1-Oct-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _gc_h
#define _gc_h

#include "jni.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct JGC {
    void  (*initCollector)(JavaVM *vm, jint initialHeapSize, jint segmentSize, jboolean verbose);
    void  (*shutdownCollector)(JavaVM *vm, jboolean finalizeOnExit);
    void* (*allocObject)(JavaVM *vm, size_t size);
    void* (*allocClazzFile)(JavaVM *vm, size_t size);
    void  (*runCollector)(JavaVM *vm);
    void  (*runFinalizers)(JavaVM *vm);
    void  (*addThread)(JavaVM *vm, JNIEnv *env);
    void  (*removeThread)(JavaVM *vm, JNIEnv *env);
    void	(*printStats)(JavaVM *vm, FILE *out);
  } JGC_struct;
  
  extern JGC_struct* JGC_getNamed(const char *name);

  extern void JGC_initCollector(JavaVM *vm, jint initialHeapSize, jint segmentSize, jboolean verbose);
  extern void JGC_shutdownCollector(JavaVM *vm, jboolean finalizeOnExit);
  extern void* JGC_allocObject(JavaVM *vm, jsize size);
  extern void* JGC_allocClazzFile(JavaVM *vm, jsize size);
  extern void JGC_runCollector(JavaVM *vm);
  extern void JGC_runFinalizers(JavaVM *vm);
  extern void JGC_addThread(JavaVM *vm, JNIEnv *env);
  extern void JGC_removeThread(JavaVM *vm, JNIEnv *env);
  extern void JGC_printStats(JavaVM *vm, FILE *out);


#ifdef __cplusplus
};
#endif

#endif /* _gc_h */
