/* -*- Mode: C; c-file-style: "gnu" -*-
   util.h -- misc functions/macros.
   Created: Chris Toshok <toshok@hungry.com>, 13-Aug-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _util_h
#define _util_h

#define slashes_to_dots(str) \
do { \
  int i; \
 \
  for (i = 0; i < strlen(str); i ++) \
    if (str[i] == '/') \
      str[i] = '.'; \
} while(0)

#define dots_to_slashes(str) \
do { \
  int i; \
 \
  for (i = 0; i < strlen(str); i ++) \
    if (str[i] == '.') \
      str[i] = '/'; \
} while(0)

#define slashes_to_underscores(str) \
do { \
  int i; \
 \
  for (i = 0; i < strlen(str); i ++) \
    if (str[i] == '/') \
      str[i] = '_'; \
} while(0) \

#define dots_to_underscores(str) \
do { \
  int i; \
 \
  for (i = 0; i < strlen(str); i ++) \
    if (str[i] == '.') \
      str[i] = '_'; \
} while(0)

#endif /* _util_h */
