/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.LinearGradient;
import org.jhotdraw.samples.svg.RadialGradient;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.io.SVGFigureFactory;

public class DefaultSVGFigureFactory
implements SVGFigureFactory {
    @Override
    public Figure createRect(double d, double d2, double d3, double d4, double d5, double d6, Map<AttributeKey, Object> map) {
        SVGRectFigure sVGRectFigure = new SVGRectFigure();
        sVGRectFigure.setBounds(new Point2D.Double(d, d2), new Point2D.Double(d + d3, d2 + d4));
        sVGRectFigure.setArc(d5, d6);
        sVGRectFigure.setAttributes(map);
        return sVGRectFigure;
    }

    @Override
    public Figure createCircle(double d, double d2, double d3, Map<AttributeKey, Object> map) {
        return this.createEllipse(d, d2, d3, d3, map);
    }

    @Override
    public Figure createEllipse(double d, double d2, double d3, double d4, Map<AttributeKey, Object> map) {
        SVGEllipseFigure sVGEllipseFigure = new SVGEllipseFigure(d - d3, d2 - d4, d3 * 2.0, d4 * 2.0);
        sVGEllipseFigure.setAttributes(map);
        return sVGEllipseFigure;
    }

    @Override
    public Figure createLine(double d, double d2, double d3, double d4, Map<AttributeKey, Object> map) {
        SVGPathFigure sVGPathFigure = new SVGPathFigure();
        sVGPathFigure.removeAllChildren();
        SVGBezierFigure sVGBezierFigure = new SVGBezierFigure();
        sVGBezierFigure.addNode(new BezierPath.Node(d, d2));
        sVGBezierFigure.addNode(new BezierPath.Node(d3, d4));
        sVGPathFigure.add(sVGBezierFigure);
        sVGPathFigure.setAttributes(map);
        return sVGPathFigure;
    }

    @Override
    public Figure createPolyline(Point2D.Double[] doubleArray, Map<AttributeKey, Object> map) {
        SVGPathFigure sVGPathFigure = new SVGPathFigure();
        sVGPathFigure.removeAllChildren();
        SVGBezierFigure sVGBezierFigure = new SVGBezierFigure();
        for (int i = 0; i < doubleArray.length; ++i) {
            sVGBezierFigure.addNode(new BezierPath.Node(doubleArray[i].x, doubleArray[i].y));
        }
        sVGPathFigure.add(sVGBezierFigure);
        sVGPathFigure.setAttributes(map);
        return sVGPathFigure;
    }

    @Override
    public Figure createPolygon(Point2D.Double[] doubleArray, Map<AttributeKey, Object> map) {
        SVGPathFigure sVGPathFigure = new SVGPathFigure();
        sVGPathFigure.removeAllChildren();
        SVGBezierFigure sVGBezierFigure = new SVGBezierFigure();
        for (int i = 0; i < doubleArray.length; ++i) {
            sVGBezierFigure.addNode(new BezierPath.Node(doubleArray[i].x, doubleArray[i].y));
        }
        sVGBezierFigure.setClosed(true);
        sVGPathFigure.add(sVGBezierFigure);
        sVGPathFigure.setAttributes(map);
        return sVGPathFigure;
    }

    @Override
    public Figure createPath(BezierPath[] bezierPathArray, Map<AttributeKey, Object> map) {
        SVGPathFigure sVGPathFigure = new SVGPathFigure();
        sVGPathFigure.removeAllChildren();
        for (int i = 0; i < bezierPathArray.length; ++i) {
            SVGBezierFigure sVGBezierFigure = new SVGBezierFigure();
            sVGBezierFigure.setBezierPath(bezierPathArray[i]);
            sVGPathFigure.add(sVGBezierFigure);
        }
        sVGPathFigure.setAttributes(map);
        return sVGPathFigure;
    }

    @Override
    public CompositeFigure createG(Map<AttributeKey, Object> map) {
        SVGGroupFigure sVGGroupFigure = new SVGGroupFigure();
        sVGGroupFigure.setAttributes(map);
        return sVGGroupFigure;
    }

    @Override
    public Figure createImage(double d, double d2, double d3, double d4, byte[] byArray, BufferedImage bufferedImage, Map<AttributeKey, Object> map) {
        SVGImageFigure sVGImageFigure = new SVGImageFigure();
        sVGImageFigure.setBounds(new Point2D.Double(d, d2), new Point2D.Double(d + d3, d2 + d4));
        sVGImageFigure.setImage(byArray, bufferedImage);
        sVGImageFigure.setAttributes(map);
        return sVGImageFigure;
    }

    @Override
    public Figure createTextArea(double d, double d2, double d3, double d4, StyledDocument styledDocument, Map<AttributeKey, Object> map) {
        SVGTextAreaFigure sVGTextAreaFigure = new SVGTextAreaFigure();
        sVGTextAreaFigure.setBounds(new Point2D.Double(d, d2), new Point2D.Double(d + d3, d2 + d4));
        try {
            sVGTextAreaFigure.setText(styledDocument.getText(0, styledDocument.getLength()));
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
        sVGTextAreaFigure.setAttributes(map);
        return sVGTextAreaFigure;
    }

    @Override
    public Figure createText(Point2D.Double[] doubleArray, double[] dArray, StyledDocument styledDocument, Map<AttributeKey, Object> map) {
        SVGTextFigure sVGTextFigure = new SVGTextFigure();
        sVGTextFigure.setCoordinates(doubleArray);
        sVGTextFigure.setRotates(dArray);
        try {
            sVGTextFigure.setText(styledDocument.getText(0, styledDocument.getLength()));
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
        sVGTextFigure.setAttributes(map);
        return sVGTextFigure;
    }

    @Override
    public Gradient createRadialGradient(double d, double d2, double d3, double d4, double d5, double[] dArray, Color[] colorArray, double[] dArray2, boolean bl, AffineTransform affineTransform) {
        return new RadialGradient(d, d2, d3, d4, d5, dArray, colorArray, dArray2, bl, affineTransform);
    }

    @Override
    public Gradient createLinearGradient(double d, double d2, double d3, double d4, double[] dArray, Color[] colorArray, double[] dArray2, boolean bl, AffineTransform affineTransform) {
        return new LinearGradient(d, d2, d3, d4, dArray, colorArray, dArray2, bl, affineTransform);
    }
}

