/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SHA1PRNG
extends SecureRandomSpi
implements Serializable {
    private static final int SEED_SIZE = 20;
    private static final int DATA_SIZE = 40;
    MessageDigest digest;
    byte[] seed;
    byte[] data;
    int seedpos;
    int datapos;
    private boolean seeded;

    public void engineSetSeed(byte[] seed) {
        int i = 0;
        while (i < seed.length) {
            int n = this.seedpos++ % 20;
            this.seed[n] = (byte)(this.seed[n] ^ seed[i]);
            ++i;
        }
        this.seedpos %= 20;
    }

    public void engineNextBytes(byte[] bytes) {
        this.ensureIsSeeded();
        int loc = 0;
        while (loc < bytes.length) {
            int copy = Math.min(bytes.length - loc, 20 - this.datapos);
            if (copy > 0) {
                System.arraycopy(this.data, this.datapos, bytes, loc, copy);
                this.datapos += copy;
                loc += copy;
                continue;
            }
            System.arraycopy(this.seed, 0, this.data, 20, 20);
            byte[] digestdata = this.digest.digest(this.data);
            System.arraycopy(digestdata, 0, this.data, 0, 20);
            this.datapos = 0;
        }
    }

    public byte[] engineGenerateSeed(int numBytes) {
        byte[] tmp = new byte[numBytes];
        this.engineNextBytes(tmp);
        return tmp;
    }

    private final void ensureIsSeeded() {
        if (!this.seeded) {
            new Random(0L).nextBytes(this.seed);
            byte[] digestdata = this.digest.digest(this.data);
            System.arraycopy(digestdata, 0, this.data, 0, 20);
            this.seeded = true;
        }
    }

    private final /* synthetic */ void this() {
        this.seeded = false;
    }

    public SHA1PRNG() {
        this.this();
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("no SHA implementation found");
        }
        this.seed = new byte[20];
        this.seedpos = 0;
        this.data = new byte[40];
        this.datapos = 20;
    }
}

