/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNSResolverContext;
import gnu.xml.dom.DomXPathResult;
import gnu.xml.xpath.DocumentOrderComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathNSResolver;

class DomXPathExpression
implements org.w3c.dom.xpath.XPathExpression {
    final DomDocument doc;
    final XPathExpression expression;
    final XPathNSResolver resolver;

    public Object evaluate(Node contextNode, short type, Object result) throws XPathException, DOMException {
        try {
            QName typeName = null;
            switch (type) {
                case 3: {
                    typeName = XPathConstants.BOOLEAN;
                    break;
                }
                case 1: {
                    typeName = XPathConstants.NUMBER;
                    break;
                }
                case 2: {
                    typeName = XPathConstants.STRING;
                    break;
                }
                case 8: 
                case 9: {
                    typeName = XPathConstants.NODE;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    typeName = XPathConstants.NODESET;
                    break;
                }
                default: {
                    throw new XPathException(52, null);
                }
            }
            Object val = this.expression.evaluate(contextNode, typeName);
            switch (type) {
                case 5: 
                case 7: {
                    ArrayList ns = new ArrayList((Collection)val);
                    Collections.sort(ns, new DocumentOrderComparator());
                    val = ns;
                }
            }
            return new DomXPathResult(val, type);
        }
        catch (javax.xml.xpath.XPathException e) {
            throw new XPathException(52, e.getMessage());
        }
    }

    public String toString() {
        return this.getClass().getName() + "[expression=" + this.expression + ']';
    }

    DomXPathExpression(DomDocument doc, String expression, XPathNSResolver resolver) throws XPathException {
        this.doc = doc;
        this.resolver = resolver;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (resolver != null) {
            xpath.setNamespaceContext(new DomNSResolverContext(resolver));
        }
        try {
            this.expression = xpath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new XPathException(51, e.getMessage());
        }
    }
}

