# Changelog

## [Unreleased](https://github.com/gjtorikian/html-pipeline/tree/HEAD)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.14.2...HEAD)

**Closed issues:**

- Allow vertical-align [\#366](https://github.com/gjtorikian/html-pipeline/issues/366)
- Since bump 2.14.2 builds are failing [\#363](https://github.com/gjtorikian/html-pipeline/issues/363)

**Merged pull requests:**

- Replace EscapeUtils.escape\_html with CGI.escape\_html [\#365](https://github.com/gjtorikian/html-pipeline/pull/365) ([ramhoj](https://github.com/ramhoj))

## [v2.14.2](https://github.com/gjtorikian/html-pipeline/tree/v2.14.2) (2022-06-12)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.14.1...v2.14.2)

**Merged pull requests:**

- handle invalid data urls in absolute source filter [\#361](https://github.com/gjtorikian/html-pipeline/pull/361) ([glaszig](https://github.com/glaszig))

## [v2.14.1](https://github.com/gjtorikian/html-pipeline/tree/v2.14.1) (2022-03-31)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.13.2...v2.14.1)

**Closed issues:**

- 2.14.0 is disconnected [\#358](https://github.com/gjtorikian/html-pipeline/issues/358)
- I would love to use the vscode codicon.ttf in my readme.md [\#356](https://github.com/gjtorikian/html-pipeline/issues/356)
- Html-pipeline [\#355](https://github.com/gjtorikian/html-pipeline/issues/355)
- Canalizacion de HTML [\#354](https://github.com/gjtorikian/html-pipeline/issues/354)
- Change branch name off of `master` [\#340](https://github.com/gjtorikian/html-pipeline/issues/340)
- New feature request: team mention filter [\#311](https://github.com/gjtorikian/html-pipeline/issues/311)
- code in header produce invalid anchor [\#308](https://github.com/gjtorikian/html-pipeline/issues/308)
- Stop "camo"ing "github.io" [\#305](https://github.com/gjtorikian/html-pipeline/issues/305)
- A filter to produce diffs with syntax highlighting in html, maybe. [\#270](https://github.com/gjtorikian/html-pipeline/issues/270)
- Require pygments.rb or remove Pygments references [\#235](https://github.com/gjtorikian/html-pipeline/issues/235)
- Allow ᴀʀɪᴀ attributes for blind people. [\#219](https://github.com/gjtorikian/html-pipeline/issues/219)
- 'lexer' is removed from github-linguist [\#217](https://github.com/gjtorikian/html-pipeline/issues/217)
- Please document how to use the html-pipeline binary without command‐line arguments! [\#213](https://github.com/gjtorikian/html-pipeline/issues/213)
- PHP syntax highlight [\#212](https://github.com/gjtorikian/html-pipeline/issues/212)

## [v2.13.2](https://github.com/gjtorikian/html-pipeline/tree/v2.13.2) (2020-12-04)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.13.1...v2.13.2)

**Merged pull requests:**

- Fix custom renderer with unsafe option missing pre lang [\#341](https://github.com/gjtorikian/html-pipeline/pull/341) ([kazk](https://github.com/kazk))

## [v2.13.1](https://github.com/gjtorikian/html-pipeline/tree/v2.13.1) (2020-12-02)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.14.0...v2.13.1)

**Merged pull requests:**

- Replace whitelist with more neutral language [\#339](https://github.com/gjtorikian/html-pipeline/pull/339) ([tancnle](https://github.com/tancnle))
- allows progress tags to be used [\#338](https://github.com/gjtorikian/html-pipeline/pull/338) ([pedrozath](https://github.com/pedrozath))
- Updated English [\#337](https://github.com/gjtorikian/html-pipeline/pull/337) ([BhuvnendraPratapSingh](https://github.com/BhuvnendraPratapSingh))
- Make AutolinkFilter configurable [\#335](https://github.com/gjtorikian/html-pipeline/pull/335) ([mnishiguchi](https://github.com/mnishiguchi))

## [v2.14.0](https://github.com/gjtorikian/html-pipeline/tree/v2.14.0) (2020-08-11)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.13.0...v2.14.0)

## [v2.13.0](https://github.com/gjtorikian/html-pipeline/tree/v2.13.0) (2020-05-28)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.12.3...v2.13.0)

**Closed issues:**

- Jch html-pipeline [\#330](https://github.com/gjtorikian/html-pipeline/issues/330)
- console rendering of slash continued multi-line commands [\#328](https://github.com/gjtorikian/html-pipeline/issues/328)
- Allow backslash-escape for @mention and emoji [\#232](https://github.com/gjtorikian/html-pipeline/issues/232)

**Merged pull requests:**

- Allow `role` attributes in html tags [\#332](https://github.com/gjtorikian/html-pipeline/pull/332) ([eric-wieser](https://github.com/eric-wieser))
- Update README.md [\#329](https://github.com/gjtorikian/html-pipeline/pull/329) ([Mihail354](https://github.com/Mihail354))
- Update CHANGELOG from 2.12.1 to 2.12.3 [\#326](https://github.com/gjtorikian/html-pipeline/pull/326) ([JuanitoFatas](https://github.com/JuanitoFatas))

## [v2.12.3](https://github.com/gjtorikian/html-pipeline/tree/v2.12.3) (2019-12-19)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.12.2...v2.12.3)

**Merged pull requests:**

- Improves syntax highlight filter [\#325](https://github.com/gjtorikian/html-pipeline/pull/325) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Reuse found lexer in SyntaxHighlightFilter [\#324](https://github.com/gjtorikian/html-pipeline/pull/324) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Fix link of Rouge CSS Theme [\#323](https://github.com/gjtorikian/html-pipeline/pull/323) ([JuanitoFatas](https://github.com/JuanitoFatas))

## [v2.12.2](https://github.com/gjtorikian/html-pipeline/tree/v2.12.2) (2019-11-14)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.12.1...v2.12.2)

**Closed issues:**

- Changing the list of commonmarker extensions with custom renderer is broken [\#321](https://github.com/gjtorikian/html-pipeline/issues/321)

**Merged pull requests:**

- Allow bad tags [\#322](https://github.com/gjtorikian/html-pipeline/pull/322) ([gjtorikian](https://github.com/gjtorikian))

## [v2.12.1](https://github.com/gjtorikian/html-pipeline/tree/v2.12.1) (2019-11-13)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.12.0...v2.12.1)

**Closed issues:**

- Where is this inserting the p tag? [\#317](https://github.com/gjtorikian/html-pipeline/issues/317)
- Update CHANGELOG [\#315](https://github.com/gjtorikian/html-pipeline/issues/315)

**Merged pull requests:**

- Make this list a const [\#320](https://github.com/gjtorikian/html-pipeline/pull/320) ([gjtorikian](https://github.com/gjtorikian))
- Add Rails 6.0 to appraisals [\#319](https://github.com/gjtorikian/html-pipeline/pull/319) ([smudge](https://github.com/smudge))
- Add ability to pass custom renderer to MarkdownFilter [\#318](https://github.com/gjtorikian/html-pipeline/pull/318) ([gjtorikian](https://github.com/gjtorikian))
- Update changelog [\#316](https://github.com/gjtorikian/html-pipeline/pull/316) ([sj26](https://github.com/sj26))

## [v2.12.0](https://github.com/gjtorikian/html-pipeline/tree/v2.12.0) (2019-08-12)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.11.1...v2.12.0)

**Merged pull requests:**

- Team mention filter [\#314](https://github.com/gjtorikian/html-pipeline/pull/314) ([indigok](https://github.com/indigok))

## [v2.11.1](https://github.com/gjtorikian/html-pipeline/tree/v2.11.1) (2019-07-18)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.11.0...v2.11.1)

**Merged pull requests:**

- Freeze string literals in Ruby 2.3 and beyond [\#313](https://github.com/gjtorikian/html-pipeline/pull/313) ([ashmaroli](https://github.com/ashmaroli))
- Avoid YARD warning: Unknown tag @mention [\#309](https://github.com/gjtorikian/html-pipeline/pull/309) ([olleolleolle](https://github.com/olleolleolle))

## [v2.11.0](https://github.com/gjtorikian/html-pipeline/tree/v2.11.0) (2019-04-06)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.10.0...v2.11.0)

**Merged pull requests:**

- CI: Use latest 2.4 [\#310](https://github.com/gjtorikian/html-pipeline/pull/310) ([olleolleolle](https://github.com/olleolleolle))
- CamoFilter: use String\#unpack to hexencode URLs [\#256](https://github.com/gjtorikian/html-pipeline/pull/256) ([glaszig](https://github.com/glaszig))

## [v2.10.0](https://github.com/gjtorikian/html-pipeline/tree/v2.10.0) (2019-01-06)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.9.2...v2.10.0)

**Closed issues:**

- RFC5122: XMPP URI [\#289](https://github.com/gjtorikian/html-pipeline/issues/289)

**Merged pull requests:**

- Add XMPP URI \#289 [\#307](https://github.com/gjtorikian/html-pipeline/pull/307) ([Neustradamus](https://github.com/Neustradamus))

## [v2.9.2](https://github.com/gjtorikian/html-pipeline/tree/v2.9.2) (2019-01-04)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.9.1...v2.9.2)

**Closed issues:**

- Why isn't \<span\> whitelisted by default? [\#183](https://github.com/gjtorikian/html-pipeline/issues/183)

**Merged pull requests:**

- Whitelist various inline semantic/formatting tags [\#306](https://github.com/gjtorikian/html-pipeline/pull/306) ([chris-morgan](https://github.com/chris-morgan))

## [v2.9.1](https://github.com/gjtorikian/html-pipeline/tree/v2.9.1) (2018-11-13)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.9.0...v2.9.1)

**Merged pull requests:**

- Render irc and ircs URLs [\#191](https://github.com/gjtorikian/html-pipeline/pull/191) ([frozencemetery](https://github.com/frozencemetery))

## [v2.9.0](https://github.com/gjtorikian/html-pipeline/tree/v2.9.0) (2018-11-08)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.8.4...v2.9.0)

**Closed issues:**

- New feature request for hashtags \# filter  [\#301](https://github.com/gjtorikian/html-pipeline/issues/301)
- Whitelist srcset for responsive images [\#233](https://github.com/gjtorikian/html-pipeline/issues/233)

**Merged pull requests:**

- Adds `UNSAFE` option to CommonMarker usage where needed [\#304](https://github.com/gjtorikian/html-pipeline/pull/304) ([diachini](https://github.com/diachini))
- Fix one more missing freeze [\#300](https://github.com/gjtorikian/html-pipeline/pull/300) ([stanhu](https://github.com/stanhu))

## [v2.8.4](https://github.com/gjtorikian/html-pipeline/tree/v2.8.4) (2018-07-24)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.8.3...v2.8.4)

**Merged pull requests:**

- Freeze all elements in HTML::Pipeline::SanitizationFilter [\#299](https://github.com/gjtorikian/html-pipeline/pull/299) ([stanhu](https://github.com/stanhu))

## [v2.8.3](https://github.com/gjtorikian/html-pipeline/tree/v2.8.3) (2018-06-29)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.8.2...v2.8.3)

**Closed issues:**

- Accessibility-related HTML isn't whitelisted [\#215](https://github.com/gjtorikian/html-pipeline/issues/215)

**Merged pull requests:**

- Whitelist some accessibility properties [\#298](https://github.com/gjtorikian/html-pipeline/pull/298) ([gjtorikian](https://github.com/gjtorikian))

## [v2.8.2](https://github.com/gjtorikian/html-pipeline/tree/v2.8.2) (2018-06-27)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.8.1...v2.8.2)

## [v2.8.1](https://github.com/gjtorikian/html-pipeline/tree/v2.8.1) (2018-06-26)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.8.0...v2.8.1)

**Merged pull requests:**

- \[PATCH\] Fix XSS vulnerability on table of content generation [\#296](https://github.com/gjtorikian/html-pipeline/pull/296) ([gjtorikian](https://github.com/gjtorikian))

## [v2.8.0](https://github.com/gjtorikian/html-pipeline/tree/v2.8.0) (2018-05-04)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.7.2...v2.8.0)

**Merged pull requests:**

- Ensure \<pre\> nodes are not removed after syntax highlighting [\#295](https://github.com/gjtorikian/html-pipeline/pull/295) ([ianks](https://github.com/ianks))

## [v2.7.2](https://github.com/gjtorikian/html-pipeline/tree/v2.7.2) (2018-04-25)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.7.1...v2.7.2)

**Closed issues:**

- emoji autocomplet/suggestion [\#294](https://github.com/gjtorikian/html-pipeline/issues/294)
- Bug in allowed attributes [\#287](https://github.com/gjtorikian/html-pipeline/issues/287)
- Github Flavoured Markdown table support [\#269](https://github.com/gjtorikian/html-pipeline/issues/269)
- Allow embedding of JSON-LD [\#250](https://github.com/gjtorikian/html-pipeline/issues/250)

**Merged pull requests:**

- Update README.md \[ci skip\] [\#293](https://github.com/gjtorikian/html-pipeline/pull/293) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Disable processing @mentions in \<script\> tag [\#292](https://github.com/gjtorikian/html-pipeline/pull/292) ([ashmaroli](https://github.com/ashmaroli))
- Update dependencies [\#291](https://github.com/gjtorikian/html-pipeline/pull/291) ([gjtorikian](https://github.com/gjtorikian))
- Apply mention filter & emoji filter on node text [\#290](https://github.com/gjtorikian/html-pipeline/pull/290) ([ashmaroli](https://github.com/ashmaroli))

## [v2.7.1](https://github.com/gjtorikian/html-pipeline/tree/v2.7.1) (2017-09-21)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.7.0...v2.7.1)

**Closed issues:**

- Eating LoadErrors can mask different problems [\#282](https://github.com/gjtorikian/html-pipeline/issues/282)

**Merged pull requests:**

- Reduce travis errors and move to trusty [\#285](https://github.com/gjtorikian/html-pipeline/pull/285) ([timdiggins](https://github.com/timdiggins))
- Output underlying load error when wrapping [\#284](https://github.com/gjtorikian/html-pipeline/pull/284) ([timdiggins](https://github.com/timdiggins))
- correct spelling mistake [\#281](https://github.com/gjtorikian/html-pipeline/pull/281) ([EdwardBetts](https://github.com/EdwardBetts))

## [v2.7.0](https://github.com/gjtorikian/html-pipeline/tree/v2.7.0) (2017-08-16)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.6.0...v2.7.0)

**Closed issues:**

- github-markdown is abandonware. Lose it or resurrect+support it? [\#246](https://github.com/gjtorikian/html-pipeline/issues/246)

**Merged pull requests:**

- Fix CI~ [\#280](https://github.com/gjtorikian/html-pipeline/pull/280) ([kivikakk](https://github.com/kivikakk))
- Let users set the common marker extensions [\#279](https://github.com/gjtorikian/html-pipeline/pull/279) ([gwincr11](https://github.com/gwincr11))
- Update CHANGELOG for 2.6.0 [\#277](https://github.com/gjtorikian/html-pipeline/pull/277) ([carpodaster](https://github.com/carpodaster))
- Fix hyperlink in README [\#276](https://github.com/gjtorikian/html-pipeline/pull/276) ([jwilk](https://github.com/jwilk))

## [v2.6.0](https://github.com/gjtorikian/html-pipeline/tree/v2.6.0) (2017-05-23)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.5.0...v2.6.0)

**Merged pull requests:**

- Set instrumentation name [\#275](https://github.com/gjtorikian/html-pipeline/pull/275) ([gjtorikian](https://github.com/gjtorikian))
- Switch to CommonMark [\#274](https://github.com/gjtorikian/html-pipeline/pull/274) ([kivikakk](https://github.com/kivikakk))
-   add korgi to 3rd party extensions \[ci skip\] [\#271](https://github.com/gjtorikian/html-pipeline/pull/271) ([jodeci](https://github.com/jodeci))

## [v2.5.0](https://github.com/gjtorikian/html-pipeline/tree/v2.5.0) (2017-01-13)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.4.2...v2.5.0)

**Closed issues:**

- Add `<wbr>` to whitelist [\#265](https://github.com/gjtorikian/html-pipeline/issues/265)
- Missing context keys for HTML::Pipeline::EmojiFilter: :asset\_root [\#262](https://github.com/gjtorikian/html-pipeline/issues/262)
- Emoji \<img\> tags does not pass W3C validationg [\#234](https://github.com/gjtorikian/html-pipeline/issues/234)
- Incompatible character encodings: ASCII-8BIT and UTF-8 in EmailReplyFilter [\#229](https://github.com/gjtorikian/html-pipeline/issues/229)

**Merged pull requests:**

- Ruby 2.4 [\#268](https://github.com/gjtorikian/html-pipeline/pull/268) ([haileys](https://github.com/haileys))

## [v2.4.2](https://github.com/gjtorikian/html-pipeline/tree/v2.4.2) (2016-07-11)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.4.1...v2.4.2)

**Closed issues:**

- Rails 5 support [\#252](https://github.com/gjtorikian/html-pipeline/issues/252)

**Merged pull requests:**

- Release v2.4.2 [\#260](https://github.com/gjtorikian/html-pipeline/pull/260) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Bump Active Support dependency to version \>= 2 [\#257](https://github.com/gjtorikian/html-pipeline/pull/257) ([JuanitoFatas](https://github.com/JuanitoFatas))

## [v2.4.1](https://github.com/gjtorikian/html-pipeline/tree/v2.4.1) (2016-05-11)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.4.0...v2.4.1)

**Merged pull requests:**

- Bump gem to 2.4.1 [\#255](https://github.com/gjtorikian/html-pipeline/pull/255) ([jch](https://github.com/jch))
- Regression in EmailReplyPipeline: unfiltered content is being ommitted [\#253](https://github.com/gjtorikian/html-pipeline/pull/253) ([oreoshake](https://github.com/oreoshake))

## [v2.4.0](https://github.com/gjtorikian/html-pipeline/tree/v2.4.0) (2016-04-11)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.3.0...v2.4.0)

**Merged pull requests:**

- Release 2.4.0 [\#248](https://github.com/gjtorikian/html-pipeline/pull/248) ([jch](https://github.com/jch))
- Optionally filter email addresses [\#247](https://github.com/gjtorikian/html-pipeline/pull/247) ([oreoshake](https://github.com/oreoshake))

## [v2.3.0](https://github.com/gjtorikian/html-pipeline/tree/v2.3.0) (2016-01-20)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.2.4...v2.3.0)

**Merged pull requests:**

- Release 2.3.0 [\#245](https://github.com/gjtorikian/html-pipeline/pull/245) ([jch](https://github.com/jch))
- Creating the option to pass in an anchor icon, instead of using octicons [\#244](https://github.com/gjtorikian/html-pipeline/pull/244) ([jonrohan](https://github.com/jonrohan))

## [v2.2.4](https://github.com/gjtorikian/html-pipeline/tree/v2.2.4) (2016-01-17)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.2.3...v2.2.4)

**Merged pull requests:**

- Use entire namespace so exception constant is resolved [\#243](https://github.com/gjtorikian/html-pipeline/pull/243) ([simeonwillbanks](https://github.com/simeonwillbanks))

## [v2.2.3](https://github.com/gjtorikian/html-pipeline/tree/v2.2.3) (2016-01-14)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.2.2...v2.2.3)

**Closed issues:**

- `rescue LoadError; abort` flow for missing dependencies breaks client applications [\#240](https://github.com/gjtorikian/html-pipeline/issues/240)

**Merged pull requests:**

- Release 2.2.3 [\#242](https://github.com/gjtorikian/html-pipeline/pull/242) ([jch](https://github.com/jch))
- raise MissingDependencyError instead of aborting on missing dependency [\#241](https://github.com/gjtorikian/html-pipeline/pull/241) ([parkr](https://github.com/parkr))
- Fix typo [\#239](https://github.com/gjtorikian/html-pipeline/pull/239) ([rimenes](https://github.com/rimenes))
- Test against Ruby 2.3.0 on Travis CI [\#238](https://github.com/gjtorikian/html-pipeline/pull/238) ([tricknotes](https://github.com/tricknotes))
- use travis containers [\#237](https://github.com/gjtorikian/html-pipeline/pull/237) ([kbrock](https://github.com/kbrock))

## [v2.2.2](https://github.com/gjtorikian/html-pipeline/tree/v2.2.2) (2015-10-27)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.2.1...v2.2.2)

**Closed issues:**

- 2.2.1 release [\#225](https://github.com/gjtorikian/html-pipeline/issues/225)

**Merged pull requests:**

- Release 2.2.2 [\#231](https://github.com/gjtorikian/html-pipeline/pull/231) ([jch](https://github.com/jch))
- Fix for calling mention\_link\_filter with only one argument [\#230](https://github.com/gjtorikian/html-pipeline/pull/230) ([benbalter](https://github.com/benbalter))
- Add html-pipeline-linkify\_github to 3rd Party Extensions \[ci skip\] [\#228](https://github.com/gjtorikian/html-pipeline/pull/228) ([JuanitoFatas](https://github.com/JuanitoFatas))

## [v2.2.1](https://github.com/gjtorikian/html-pipeline/tree/v2.2.1) (2015-10-01)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.2.0...v2.2.1)

**Merged pull requests:**

- Soften Nokogiri dependency to versions "\>= 1.4" [\#208](https://github.com/gjtorikian/html-pipeline/pull/208) ([JuanitoFatas](https://github.com/JuanitoFatas))

## [v2.2.0](https://github.com/gjtorikian/html-pipeline/tree/v2.2.0) (2015-09-28)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.1.0...v2.2.0)

**Merged pull requests:**

- Release 2.2.0 [\#224](https://github.com/gjtorikian/html-pipeline/pull/224) ([jch](https://github.com/jch))
- Only allow cite attribute on blockquote and restrict schemes [\#223](https://github.com/gjtorikian/html-pipeline/pull/223) ([btoews](https://github.com/btoews))

## [v2.1.0](https://github.com/gjtorikian/html-pipeline/tree/v2.1.0) (2015-09-22)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v2.0...v2.1.0)

**Closed issues:**

- Add SmartQuotes filter [\#220](https://github.com/gjtorikian/html-pipeline/issues/220)
- Need help fixing a non-security issue… [\#214](https://github.com/gjtorikian/html-pipeline/issues/214)
- List GitHub-deployed versions somewhere? [\#201](https://github.com/gjtorikian/html-pipeline/issues/201)
- Support limited use of the HTML 'style' attribute [\#192](https://github.com/gjtorikian/html-pipeline/issues/192)
- Separate gems for versioning external dependencies [\#182](https://github.com/gjtorikian/html-pipeline/issues/182)

**Merged pull requests:**

- Release 2.1.0 [\#222](https://github.com/gjtorikian/html-pipeline/pull/222) ([jch](https://github.com/jch))
- Whitelist schemes for longdesc [\#221](https://github.com/gjtorikian/html-pipeline/pull/221) ([btoews](https://github.com/btoews))
- Update README.md [\#211](https://github.com/gjtorikian/html-pipeline/pull/211) ([st0012](https://github.com/st0012))
- Add ImageFilter for image url to img tag conversion [\#207](https://github.com/gjtorikian/html-pipeline/pull/207) ([st0012](https://github.com/st0012))
- Extract emoji image tag generation to own method [\#195](https://github.com/gjtorikian/html-pipeline/pull/195) ([kbrock](https://github.com/kbrock))

## [v2.0](https://github.com/gjtorikian/html-pipeline/tree/v2.0) (2015-07-20)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.11.0...v2.0)

**Closed issues:**

- Feature request: Strikethrough if issue is closed [\#202](https://github.com/gjtorikian/html-pipeline/issues/202)
- how can i read this code? [\#198](https://github.com/gjtorikian/html-pipeline/issues/198)
- how can i read this code? [\#197](https://github.com/gjtorikian/html-pipeline/issues/197)
- Change github-markdown dependency to a free licensed parser [\#196](https://github.com/gjtorikian/html-pipeline/issues/196)
- possible bug? [\#193](https://github.com/gjtorikian/html-pipeline/issues/193)
- Support ftp scheme for markdown URLs [\#187](https://github.com/gjtorikian/html-pipeline/issues/187)
- Syntax highlighting example in Readme not working [\#186](https://github.com/gjtorikian/html-pipeline/issues/186)
- OSX HTML::Pipeline::MarkdownFilter Fails on Right Double Quotation Mark around email address [\#173](https://github.com/gjtorikian/html-pipeline/issues/173)
- Question - Can this work with Rouge? [\#166](https://github.com/gjtorikian/html-pipeline/issues/166)
- Question about github markdown filter \(low priority!\) [\#165](https://github.com/gjtorikian/html-pipeline/issues/165)
- Do not mention or emojify in a codeblock [\#163](https://github.com/gjtorikian/html-pipeline/issues/163)
- MentionFilter base\_url config question [\#161](https://github.com/gjtorikian/html-pipeline/issues/161)
- Feature Request: Add "details" tag to whitelist [\#138](https://github.com/gjtorikian/html-pipeline/issues/138)

**Merged pull requests:**

- Add three 3rd party filters. \[ci skip\] [\#185](https://github.com/gjtorikian/html-pipeline/pull/185) ([JuanitoFatas](https://github.com/JuanitoFatas))
- \[MentionFilter\] Dup string before modifying [\#181](https://github.com/gjtorikian/html-pipeline/pull/181) ([jch](https://github.com/jch))
- Constrain active support \>= 2, \< 5 [\#180](https://github.com/gjtorikian/html-pipeline/pull/180) ([jch](https://github.com/jch))
- Release 2.0 [\#179](https://github.com/gjtorikian/html-pipeline/pull/179) ([jch](https://github.com/jch))
- \[ci skip\] Fix CHANGELOG.md rendering. [\#177](https://github.com/gjtorikian/html-pipeline/pull/177) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Restrict nokogiri to specific versions [\#176](https://github.com/gjtorikian/html-pipeline/pull/176) ([simeonwillbanks](https://github.com/simeonwillbanks))
- Use svg build badge. \[ci skip\] [\#175](https://github.com/gjtorikian/html-pipeline/pull/175) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Add 3rd party gem: html-pipeline-rouge\_filter. [\#174](https://github.com/gjtorikian/html-pipeline/pull/174) ([JuanitoFatas](https://github.com/JuanitoFatas))
- MentionFilter\#link\_to\_mentioned\_user: Replace String introspection with Regexp match [\#172](https://github.com/gjtorikian/html-pipeline/pull/172) ([simeonwillbanks](https://github.com/simeonwillbanks))
- Whitelist summary and details element. [\#171](https://github.com/gjtorikian/html-pipeline/pull/171) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Implement new context option: ignored\_ancestor\_tags to accept more ignored tags. [\#170](https://github.com/gjtorikian/html-pipeline/pull/170) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Support ~login for MentionFilter. [\#167](https://github.com/gjtorikian/html-pipeline/pull/167) ([JuanitoFatas](https://github.com/JuanitoFatas))
- Add GitHub flavor Markdown Task List extension [\#162](https://github.com/gjtorikian/html-pipeline/pull/162) ([simeonwillbanks](https://github.com/simeonwillbanks))
- Drop support for gemoji ~\> 1.0 [\#159](https://github.com/gjtorikian/html-pipeline/pull/159) ([jch](https://github.com/jch))
- Revert "Search for text nodes on DocumentFragments without root tags" [\#158](https://github.com/gjtorikian/html-pipeline/pull/158) ([jch](https://github.com/jch))
- @mention allow for custom regex to identify usernames. [\#157](https://github.com/gjtorikian/html-pipeline/pull/157) ([brittballard](https://github.com/brittballard))
- Drop support for ruby ree, 1.9.2 [\#156](https://github.com/gjtorikian/html-pipeline/pull/156) ([jch](https://github.com/jch))
- Use Linguist lexers [\#153](https://github.com/gjtorikian/html-pipeline/pull/153) ([pchaigno](https://github.com/pchaigno))
- Readme tweaks: add FAQ section, refresh 3rd party extensions [\#150](https://github.com/gjtorikian/html-pipeline/pull/150) ([jch](https://github.com/jch))
- \<tt\> tags are not skipped by EmojiFilter [\#147](https://github.com/gjtorikian/html-pipeline/pull/147) ([moskvax](https://github.com/moskvax))

## [v1.11.0](https://github.com/gjtorikian/html-pipeline/tree/v1.11.0) (2014-09-15)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.10.0...v1.11.0)

**Closed issues:**

- @mention\_filter should not replace mentions in style blocks. [\#143](https://github.com/gjtorikian/html-pipeline/issues/143)
- EmojiFilter doesn't work on strings that don't contain HTML [\#133](https://github.com/gjtorikian/html-pipeline/issues/133)

**Merged pull requests:**

- Search for text nodes on DocumentFragments without root tags [\#146](https://github.com/gjtorikian/html-pipeline/pull/146) ([Razer6](https://github.com/Razer6))
- Don't filter @mentions in \<style\> tags [\#145](https://github.com/gjtorikian/html-pipeline/pull/145) ([jch](https://github.com/jch))
- Prefer http\_url in HttpsFilter [\#142](https://github.com/gjtorikian/html-pipeline/pull/142) ([bkeepers](https://github.com/bkeepers))
- Don't check twice if there is a ':' in content \(EmojiFilter\) [\#141](https://github.com/gjtorikian/html-pipeline/pull/141) ([Razer6](https://github.com/Razer6))

## [v1.10.0](https://github.com/gjtorikian/html-pipeline/tree/v1.10.0) (2014-09-05)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.9.0...v1.10.0)

**Closed issues:**

- header tags are html-rendered with name="" instead of id="" [\#135](https://github.com/gjtorikian/html-pipeline/issues/135)
- Enable syntax highlighting for inline code [\#134](https://github.com/gjtorikian/html-pipeline/issues/134)

**Merged pull requests:**

- Use id instead of name for TableOfContentsFilter [\#140](https://github.com/gjtorikian/html-pipeline/pull/140) ([bkeepers](https://github.com/bkeepers))
- adding "details" to tag whitelist [\#139](https://github.com/gjtorikian/html-pipeline/pull/139) ([tansaku](https://github.com/tansaku))
- Fix spelling in readme [\#137](https://github.com/gjtorikian/html-pipeline/pull/137) ([Razer6](https://github.com/Razer6))
- Remove ActiveSupport try\(\) dependency [\#132](https://github.com/gjtorikian/html-pipeline/pull/132) ([simeonwillbanks](https://github.com/simeonwillbanks))

## [v1.9.0](https://github.com/gjtorikian/html-pipeline/tree/v1.9.0) (2014-07-07)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.8.0...v1.9.0)

**Closed issues:**

- Medico [\#128](https://github.com/gjtorikian/html-pipeline/issues/128)
- Support ActiveSupport 4.1 [\#125](https://github.com/gjtorikian/html-pipeline/issues/125)
- De-github https filter [\#123](https://github.com/gjtorikian/html-pipeline/issues/123)

**Merged pull requests:**

- Generalize https filter take 2 [\#131](https://github.com/gjtorikian/html-pipeline/pull/131) ([simeonwillbanks](https://github.com/simeonwillbanks))
- Remove RUBY\_VERSION conditionals from gemspec [\#130](https://github.com/gjtorikian/html-pipeline/pull/130) ([mislav](https://github.com/mislav))
- Add compatibility with gemoji v2 [\#129](https://github.com/gjtorikian/html-pipeline/pull/129) ([mislav](https://github.com/mislav))

## [v1.8.0](https://github.com/gjtorikian/html-pipeline/tree/v1.8.0) (2014-04-04)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.7.0...v1.8.0)

**Implemented enhancements:**

- Getting Started Guide [\#112](https://github.com/gjtorikian/html-pipeline/issues/112)

**Merged pull requests:**

- Adding support to supply the path to the emoji sprite in the emoji pipeline [\#122](https://github.com/gjtorikian/html-pipeline/pull/122) ([bradly](https://github.com/bradly))
- Initial Better README [\#118](https://github.com/gjtorikian/html-pipeline/pull/118) ([simeonwillbanks](https://github.com/simeonwillbanks))

## [v1.7.0](https://github.com/gjtorikian/html-pipeline/tree/v1.7.0) (2014-03-11)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.6.0...v1.7.0)

**Implemented enhancements:**

- Contributing Guidelines [\#113](https://github.com/gjtorikian/html-pipeline/issues/113)

**Closed issues:**

- cut a 1.6.0 release [\#116](https://github.com/gjtorikian/html-pipeline/issues/116)
- AutolinkFilter link\_attr doesn't seem to work [\#114](https://github.com/gjtorikian/html-pipeline/issues/114)
- Spaces inserted into code [\#109](https://github.com/gjtorikian/html-pipeline/issues/109)

**Merged pull requests:**

- Allow \<s\> and \<strike\> [\#120](https://github.com/gjtorikian/html-pipeline/pull/120) ([haileys](https://github.com/haileys))
- Ruby 2.1.1 [\#119](https://github.com/gjtorikian/html-pipeline/pull/119) ([simeonwillbanks](https://github.com/simeonwillbanks))
- Notes on how to release a new gem version [\#117](https://github.com/gjtorikian/html-pipeline/pull/117) ([jch](https://github.com/jch))
- Initial Contributing Guidelines [\#115](https://github.com/gjtorikian/html-pipeline/pull/115) ([simeonwillbanks](https://github.com/simeonwillbanks))

## [v1.6.0](https://github.com/gjtorikian/html-pipeline/tree/v1.6.0) (2014-02-14)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.5.0...v1.6.0)

**Closed issues:**

- EmailReplyParser is undefined [\#107](https://github.com/gjtorikian/html-pipeline/issues/107)
- No stylesheets for SyntaxHighlightFilter [\#106](https://github.com/gjtorikian/html-pipeline/issues/106)
- Camo Filter doesn't return doc when disabled [\#102](https://github.com/gjtorikian/html-pipeline/issues/102)
- Passed content must be valid XML to be filtered [\#100](https://github.com/gjtorikian/html-pipeline/issues/100)
- Emoji syntax gravatars [\#56](https://github.com/gjtorikian/html-pipeline/issues/56)

**Merged pull requests:**

- EmailReplyFilter depends on EmailReplyParser [\#110](https://github.com/gjtorikian/html-pipeline/pull/110) ([foca](https://github.com/foca))
- Document generating CSS for HTML formatted code [\#108](https://github.com/gjtorikian/html-pipeline/pull/108) ([simeonwillbanks](https://github.com/simeonwillbanks))
- Stop using deprecated OpenSSL::Digest::Digest [\#103](https://github.com/gjtorikian/html-pipeline/pull/103) ([chrishunt](https://github.com/chrishunt))

## [v1.5.0](https://github.com/gjtorikian/html-pipeline/tree/v1.5.0) (2014-01-22)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.4.0...v1.5.0)

**Merged pull requests:**

- Allow customization of allowed \<a href\> URL schemes [\#98](https://github.com/gjtorikian/html-pipeline/pull/98) ([aroben](https://github.com/aroben))

## [v1.4.0](https://github.com/gjtorikian/html-pipeline/tree/v1.4.0) (2014-01-21)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.3.0...v1.4.0)

**Merged pull requests:**

- Don't URI parse src before passing to camo [\#101](https://github.com/gjtorikian/html-pipeline/pull/101) ([josh](https://github.com/josh))

## [v1.3.0](https://github.com/gjtorikian/html-pipeline/tree/v1.3.0) (2014-01-14)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.2.0...v1.3.0)

**Merged pull requests:**

- Remove 1.8 from Travis build [\#99](https://github.com/gjtorikian/html-pipeline/pull/99) ([josh](https://github.com/josh))

## [v1.2.0](https://github.com/gjtorikian/html-pipeline/tree/v1.2.0) (2014-01-09)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.1.0...v1.2.0)

**Closed issues:**

- Allow SSH protocol links [\#95](https://github.com/gjtorikian/html-pipeline/issues/95)
- Straight quote → unicode curly quotes filter [\#94](https://github.com/gjtorikian/html-pipeline/issues/94)

**Merged pull requests:**

- Bump version 1.2.0 [\#97](https://github.com/gjtorikian/html-pipeline/pull/97) ([jch](https://github.com/jch))
- Camo Everything [\#96](https://github.com/gjtorikian/html-pipeline/pull/96) ([josh](https://github.com/josh))

## [v1.1.0](https://github.com/gjtorikian/html-pipeline/tree/v1.1.0) (2013-11-20)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v1.0.0...v1.1.0)

**Merged pull requests:**

- Bump version 1.1.0 [\#93](https://github.com/gjtorikian/html-pipeline/pull/93) ([jch](https://github.com/jch))
- CGI.escape emoji name [\#92](https://github.com/gjtorikian/html-pipeline/pull/92) ([jayroh](https://github.com/jayroh))

## [v1.0.0](https://github.com/gjtorikian/html-pipeline/tree/v1.0.0) (2013-10-29)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.3.1...v1.0.0)

**Closed issues:**

- Tagged releases for 0.3.0 and 0.3.1 [\#91](https://github.com/gjtorikian/html-pipeline/issues/91)
- Potential class loading conflict with add-on filters [\#88](https://github.com/gjtorikian/html-pipeline/issues/88)
- Place Dependency Management On Filters [\#77](https://github.com/gjtorikian/html-pipeline/issues/77)
- Decrease number of dependencies [\#48](https://github.com/gjtorikian/html-pipeline/issues/48)

**Merged pull requests:**

- Add link\_attr option to Autolink filter [\#89](https://github.com/gjtorikian/html-pipeline/pull/89) ([excid3](https://github.com/excid3))
- Update readme with link to asciidoc filter [\#87](https://github.com/gjtorikian/html-pipeline/pull/87) ([jch](https://github.com/jch))
- use xml\_mini extracted from activesupport [\#85](https://github.com/gjtorikian/html-pipeline/pull/85) ([mojavelinux](https://github.com/mojavelinux))
- Filters Manage Dependencies [\#80](https://github.com/gjtorikian/html-pipeline/pull/80) ([simeonwillbanks](https://github.com/simeonwillbanks))

## [v0.3.1](https://github.com/gjtorikian/html-pipeline/tree/v0.3.1) (2013-09-16)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.3.0...v0.3.1)

**Closed issues:**

- Tweaks to the email reply filter [\#82](https://github.com/gjtorikian/html-pipeline/issues/82)

**Merged pull requests:**

- Guard against nil node replacement results [\#84](https://github.com/gjtorikian/html-pipeline/pull/84) ([jbarnette](https://github.com/jbarnette))

## [v0.3.0](https://github.com/gjtorikian/html-pipeline/tree/v0.3.0) (2013-08-30)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.2.1...v0.3.0)

**Closed issues:**

- Support for ActiveSupport 4 [\#76](https://github.com/gjtorikian/html-pipeline/issues/76)

**Merged pull requests:**

- Teach SyntaxHighlightFilter about default highlights [\#81](https://github.com/gjtorikian/html-pipeline/pull/81) ([jbarnette](https://github.com/jbarnette))

## [v0.2.1](https://github.com/gjtorikian/html-pipeline/tree/v0.2.1) (2013-08-20)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.2.0...v0.2.1)

**Closed issues:**

- Implement an AsciiDoc filter based on Asciidoctor [\#59](https://github.com/gjtorikian/html-pipeline/issues/59)

**Merged pull requests:**

- Move activesupport to a development dependency [\#79](https://github.com/gjtorikian/html-pipeline/pull/79) ([jch](https://github.com/jch))

## [v0.2.0](https://github.com/gjtorikian/html-pipeline/tree/v0.2.0) (2013-07-31)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.1.0...v0.2.0)

**Merged pull requests:**

- Generate Table of Contents [\#75](https://github.com/gjtorikian/html-pipeline/pull/75) ([simeonwillbanks](https://github.com/simeonwillbanks))
- Fix wrong class name at README.md [\#74](https://github.com/gjtorikian/html-pipeline/pull/74) ([tricknotes](https://github.com/tricknotes))

## [v0.1.0](https://github.com/gjtorikian/html-pipeline/tree/v0.1.0) (2013-07-16)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.14...v0.1.0)

**Closed issues:**

- Fix travis-ci build [\#63](https://github.com/gjtorikian/html-pipeline/issues/63)
- Loosen Markdown Dependency. [\#62](https://github.com/gjtorikian/html-pipeline/issues/62)
- TocFilter: non-English characters in headers don't get proper anchor names [\#58](https://github.com/gjtorikian/html-pipeline/issues/58)
- Whitelist table sections \(thead, tbody, tfoot\) [\#54](https://github.com/gjtorikian/html-pipeline/issues/54)
- Warn if "pipelines" are out of order. [\#47](https://github.com/gjtorikian/html-pipeline/issues/47)

**Merged pull requests:**

- TocFilter: keep using the old punctuation stripping on 1.8.7 [\#73](https://github.com/gjtorikian/html-pipeline/pull/73) ([jakedouglas](https://github.com/jakedouglas))
- Add ruby 2.0.0 to .travis.yml [\#72](https://github.com/gjtorikian/html-pipeline/pull/72) ([tricknotes](https://github.com/tricknotes))
- Fix ignored test [\#71](https://github.com/gjtorikian/html-pipeline/pull/71) ([tricknotes](https://github.com/tricknotes))
- Improve to describe gem 'github-linguist' [\#69](https://github.com/gjtorikian/html-pipeline/pull/69) ([tricknotes](https://github.com/tricknotes))
- Bump version to 0.1.0. Follow semver. [\#68](https://github.com/gjtorikian/html-pipeline/pull/68) ([jch](https://github.com/jch))
- Scope gem versions for Travis CI [\#67](https://github.com/gjtorikian/html-pipeline/pull/67) ([jch](https://github.com/jch))
- Allow passing skip\_tags in autolink filter context [\#65](https://github.com/gjtorikian/html-pipeline/pull/65) ([pengwynn](https://github.com/pengwynn))
- Support non-English characters in anchor names [\#64](https://github.com/gjtorikian/html-pipeline/pull/64) ([jakedouglas](https://github.com/jakedouglas))
- Fix the `AutolinkFilter` constant name. [\#57](https://github.com/gjtorikian/html-pipeline/pull/57) ([envygeeks](https://github.com/envygeeks))
- resolves \#54 allow table section elements \(thead, tfoot, tbody\) [\#55](https://github.com/gjtorikian/html-pipeline/pull/55) ([mojavelinux](https://github.com/mojavelinux))

## [v0.0.14](https://github.com/gjtorikian/html-pipeline/tree/v0.0.14) (2013-05-22)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.13...v0.0.14)

**Closed issues:**

- Give rsanheim rights to pushing gems [\#53](https://github.com/gjtorikian/html-pipeline/issues/53)

## [v0.0.13](https://github.com/gjtorikian/html-pipeline/tree/v0.0.13) (2013-05-13)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.12...v0.0.13)

**Closed issues:**

- Can I use MentionFilter without MarkdownFilter [\#51](https://github.com/gjtorikian/html-pipeline/issues/51)

**Merged pull requests:**

- New octicon class names [\#52](https://github.com/gjtorikian/html-pipeline/pull/52) ([cameronmcefee](https://github.com/cameronmcefee))
- Strip contents of \<script\> tags. [\#50](https://github.com/gjtorikian/html-pipeline/pull/50) ([benubois](https://github.com/benubois))

## [v0.0.12](https://github.com/gjtorikian/html-pipeline/tree/v0.0.12) (2013-04-01)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.11...v0.0.12)

**Merged pull requests:**

- Include output and results to filter, pipeline event payload [\#46](https://github.com/gjtorikian/html-pipeline/pull/46) ([mtodd](https://github.com/mtodd))

## [v0.0.11](https://github.com/gjtorikian/html-pipeline/tree/v0.0.11) (2013-03-29)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.10...v0.0.11)

**Merged pull requests:**

- Instrument filters in the pipeline [\#45](https://github.com/gjtorikian/html-pipeline/pull/45) ([mtodd](https://github.com/mtodd))

## [v0.0.10](https://github.com/gjtorikian/html-pipeline/tree/v0.0.10) (2013-03-21)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.8.1...v0.0.10)

**Closed issues:**

- Executable for previewing [\#43](https://github.com/gjtorikian/html-pipeline/issues/43)

**Merged pull requests:**

- Add an html-pipeline executable to the gem [\#44](https://github.com/gjtorikian/html-pipeline/pull/44) ([indirect](https://github.com/indirect))
- add result\[:mentioned\_usernames\] for MentionFilter [\#42](https://github.com/gjtorikian/html-pipeline/pull/42) ([fahchen](https://github.com/fahchen))

## [v0.0.8.1](https://github.com/gjtorikian/html-pipeline/tree/v0.0.8.1) (2013-03-03)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.9...v0.0.8.1)

## [v0.0.9](https://github.com/gjtorikian/html-pipeline/tree/v0.0.9) (2013-02-27)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.8...v0.0.9)

**Closed issues:**

- Better error notification on missing linguist dependency? [\#36](https://github.com/gjtorikian/html-pipeline/issues/36)

**Merged pull requests:**

- Bump escape\_utils [\#41](https://github.com/gjtorikian/html-pipeline/pull/41) ([brianmario](https://github.com/brianmario))
- Don't monkeypatch Nokogiri in 1.9 [\#40](https://github.com/gjtorikian/html-pipeline/pull/40) ([defunkt](https://github.com/defunkt))

## [v0.0.8](https://github.com/gjtorikian/html-pipeline/tree/v0.0.8) (2013-02-07)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.7...v0.0.8)

**Closed issues:**

- Optionally require github-linguist [\#33](https://github.com/gjtorikian/html-pipeline/issues/33)

**Merged pull requests:**

- Raise the roof---I mean, error [\#37](https://github.com/gjtorikian/html-pipeline/pull/37) ([gjtorikian](https://github.com/gjtorikian))

## [v0.0.7](https://github.com/gjtorikian/html-pipeline/tree/v0.0.7) (2013-01-30)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.6...v0.0.7)

**Closed issues:**

- Where to report custom filters? [\#30](https://github.com/gjtorikian/html-pipeline/issues/30)

**Merged pull requests:**

- Remove github-linguist dependency [\#35](https://github.com/gjtorikian/html-pipeline/pull/35) ([jch](https://github.com/jch))
- Delete erroneous trailing {}s from README [\#34](https://github.com/gjtorikian/html-pipeline/pull/34) ([mrb](https://github.com/mrb))

## [v0.0.6](https://github.com/gjtorikian/html-pipeline/tree/v0.0.6) (2012-12-11)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.5...v0.0.6)

**Merged pull requests:**

- use \#gsub instead of \#gsub! in MarkdownFilter\#initialize [\#32](https://github.com/gjtorikian/html-pipeline/pull/32) ([jakedouglas](https://github.com/jakedouglas))

## [v0.0.5](https://github.com/gjtorikian/html-pipeline/tree/v0.0.5) (2012-12-10)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.4...v0.0.5)

**Merged pull requests:**

- Fix XSS vulnerability in sanitization filter [\#31](https://github.com/gjtorikian/html-pipeline/pull/31) ([jch](https://github.com/jch))
- Fix typo on readme in "AutolinkFilter" doc [\#29](https://github.com/gjtorikian/html-pipeline/pull/29) ([dmarcotte](https://github.com/dmarcotte))
- fix syntax highlighting example in Readme [\#27](https://github.com/gjtorikian/html-pipeline/pull/27) ([mislav](https://github.com/mislav))
- remove github-linguist dependency [\#26](https://github.com/gjtorikian/html-pipeline/pull/26) ([mislav](https://github.com/mislav))
- Retrigger Travis build for debugging [\#25](https://github.com/gjtorikian/html-pipeline/pull/25) ([jch](https://github.com/jch))
- Use consistent quotes in gemspec [\#24](https://github.com/gjtorikian/html-pipeline/pull/24) ([jbarnette](https://github.com/jbarnette))
- Add MIT license indicator to the gemspec. [\#23](https://github.com/gjtorikian/html-pipeline/pull/23) ([nbibler](https://github.com/nbibler))
- Context validation [\#22](https://github.com/gjtorikian/html-pipeline/pull/22) ([benubois](https://github.com/benubois))
- Corrected a little typo [\#21](https://github.com/gjtorikian/html-pipeline/pull/21) ([blackerby](https://github.com/blackerby))
- Added an example of a custom filter. [\#19](https://github.com/gjtorikian/html-pipeline/pull/19) ([benubois](https://github.com/benubois))
- Use correct OSS Manifesto link. [\#18](https://github.com/gjtorikian/html-pipeline/pull/18) ([wickedshimmy](https://github.com/wickedshimmy))
- Fixed typos [\#17](https://github.com/gjtorikian/html-pipeline/pull/17) ([pborreli](https://github.com/pborreli))
- What is the github filter chain? [\#16](https://github.com/gjtorikian/html-pipeline/pull/16) ([geemus](https://github.com/geemus))
- Loosen Gemoji restriction [\#15](https://github.com/gjtorikian/html-pipeline/pull/15) ([josh](https://github.com/josh))

## [v0.0.4](https://github.com/gjtorikian/html-pipeline/tree/v0.0.4) (2012-11-06)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/v0.0.3...v0.0.4)

**Implemented enhancements:**

- Detect asset pipeline availability [\#1](https://github.com/gjtorikian/html-pipeline/issues/1)

**Fixed bugs:**

- @mention at end of parenthetical sentence doesn't get linked [\#11](https://github.com/gjtorikian/html-pipeline/issues/11)

**Closed issues:**

- Open source, transferring repo ownership [\#12](https://github.com/gjtorikian/html-pipeline/issues/12)
- Ensure we get the latest from github/github [\#10](https://github.com/gjtorikian/html-pipeline/issues/10)
- Rename repository to html-pipeline [\#7](https://github.com/gjtorikian/html-pipeline/issues/7)

**Merged pull requests:**

- HTML::Pipeline::Pipeline [\#13](https://github.com/gjtorikian/html-pipeline/pull/13) ([jbarnette](https://github.com/jbarnette))

## [v0.0.3](https://github.com/gjtorikian/html-pipeline/tree/v0.0.3) (2012-10-03)

[Full Changelog](https://github.com/gjtorikian/html-pipeline/compare/a08f65df81dba0004c2de429848cd9a202917d04...v0.0.3)

**Closed issues:**

- History [\#3](https://github.com/gjtorikian/html-pipeline/issues/3)

**Merged pull requests:**

- Ensure required context values are present [\#9](https://github.com/gjtorikian/html-pipeline/pull/9) ([juliamae](https://github.com/juliamae))
- emoji filter requires the emoji gem [\#8](https://github.com/gjtorikian/html-pipeline/pull/8) ([atmos](https://github.com/atmos))
- De-Github and opensource [\#6](https://github.com/gjtorikian/html-pipeline/pull/6) ([jch](https://github.com/jch))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
