/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.processors;

import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Random;
import java.util.Set;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.processors.ObservedIndel;
import org.campagnelab.goby.util.UnboundedFifoPool;

public class InfoForTarget {
    int targetIndex;
    public IntSet positionsWithSpanningIndel = new IntAVLTreeSet();
    UnboundedFifoPool<Alignments.AlignmentEntry> entriesInWindow = new UnboundedFifoPool();
    public ObjectAVLTreeSet<ObservedIndel> potentialIndels = new ObjectAVLTreeSet();
    public int windowStartPosition = Integer.MAX_VALUE;
    public int maxEntryPosition;
    protected int pastMaxCount;
    private static final int MAX_ENTRIES_IN_WINDOW = 250000;
    private static final long SPECIAL_SEED = 238927383682638267L;
    private Random random = new Random(238927383682638267L);

    public void addIndel(int startPosition, int endPosition, String from, String to) {
        for (int p = startPosition; p < endPosition; ++p) {
            this.positionsWithSpanningIndel.add(p);
        }
        ObservedIndel candidate = new ObservedIndel(startPosition, endPosition, from, to);
        this.potentialIndels.add((Object)candidate);
    }

    public InfoForTarget(int targetIndex) {
        this.targetIndex = targetIndex;
    }

    public InfoForTarget(int targetIndex, Set<ObservedIndel> targetKnownIndels) {
        this.targetIndex = targetIndex;
        this.potentialIndels.addAll(targetKnownIndels);
    }

    public void removeIndels(int firstPosition, int lastPosition) {
        IntIterator intIterator = this.positionsWithSpanningIndel.iterator();
        while (intIterator.hasNext()) {
            int pos = (Integer)intIterator.next();
            if (pos >= lastPosition || pos >= firstPosition) continue;
            this.positionsWithSpanningIndel.remove(pos);
        }
        for (ObservedIndel indel : this.potentialIndels) {
            if (indel.getEnd() > lastPosition) continue;
            this.potentialIndels.remove((Object)indel);
        }
    }

    public void clear() {
        this.potentialIndels.clear();
        this.positionsWithSpanningIndel.clear();
        this.entriesInWindow.clear();
        this.pastMaxCount = 0;
    }

    public Alignments.AlignmentEntry remove() {
        Alignments.AlignmentEntry tmp = this.entriesInWindow.remove();
        if (this.entriesInWindow.size() < 250000) {
            this.pastMaxCount = 0;
        }
        return tmp;
    }

    public boolean add(Alignments.AlignmentEntry entry) {
        boolean add = true;
        if (this.entriesInWindow.size() > 250000) {
            double threshold;
            ++this.pastMaxCount;
            double randomChoice = this.random.nextDouble();
            if (randomChoice > (threshold = 1.0 / (double)this.pastMaxCount)) {
                add = false;
            }
        }
        if (add) {
            this.entriesInWindow.add(entry);
        }
        return add;
    }
}

