/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.util.RuntimeIOException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.util.OptionalLong;

public abstract class SeekableStream
extends InputStream {
    protected OptionalLong mark = OptionalLong.empty();

    public abstract long length();

    public abstract long position() throws IOException;

    public abstract void seek(long var1) throws IOException;

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract boolean eof() throws IOException;

    public abstract String getSource();

    public void readFully(byte[] b) throws IOException {
        int count;
        int len = b.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.eof()) {
            return 0;
        }
        long remaining = this.length() - this.position();
        if (remaining < 0L) {
            return 0;
        }
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    @Override
    public final synchronized void mark(int readlimit) {
        try {
            this.mark = OptionalLong.of(this.position());
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark.isPresent()) {
            this.seek(this.mark.getAsLong());
        } else {
            this.seek(0L);
        }
    }

    @Override
    public final boolean markSupported() {
        return true;
    }
}

