# NOTE: Derived from web_diary_dir/lib/TDS/Collection.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package TDS::Collection;

#line 446 "web_diary_dir/lib/TDS/Collection.pm (autosplit into web_diary_dir/lib/auto/TDS/Collection/read_files.al)"
################################################################
# read specified files.
# return number of read files.
sub read_files($@)
{
    my ($self, @files) = @_;

    require TDS::Cache;
    # clear caches if tdf files is updated
    my $total;
    my $reverse = $ReverseInRecent && $TDS::Status->mode =~ /RECENT/;
    # for all files

    for (@files){
	last unless ref $_;
	my ($filename, $year, $month, $day) = @$_;
	next unless $filename;
	my $cache_unused;

#	warn times, " collect: $filename";
#	print "<br>$year/$month/$day:";
	
	# read from cache if possile
	if ($TDS::Cache::EnableCache){
	    require TDS::Cache::Daily;
	    #warn "read cache: $year/$month/$day";
	    my $cache = new TDS::Cache::Daily(reverse=>$reverse);

	    $cache->year($year);
	    $cache->month($month);
	    $cache->day($day);
	    if ($cache->IsFresh){
#		warn times, " use daily cache: ", $cache->GetCacheFilename;
		push(@{$self->diarys}, $cache);
		$TDS::Status->has_secret(1)
		    if $cache->has_secret;
		$cache_unused = 0;
	    } else {
		$cache_unused = 1;
	    }
	} else {
	    $cache_unused = 1;
	}
#	warn "$year/$month/$day: cache unused $cache_unused";
	# if impossible, read tdf file and parse it
	if ($cache_unused){
#	    warn times, " cannot use daily cache, so parse it";
	    my $date_line = "DIARY $year $month $day\n";
	
#	    my $start = (times)[0];
	    require TDS::Tdf::Parser;
	    my $parser = new TDS::Tdf::Parser;
	    $parser->Parse($date_line);

	    $self->parse_file($filename, $parser);
	    $parser->end('DIARY');

	    push(@{$self->diarys}, $parser);
	}
    }
#    return $_ = @files;                # ActivePerl 613  modification of a read-only value ܤ
#    warn times, "done";
    return scalar(@files);
    
#    push(@{$self->diarys}, $parser);
#    print "<br>read done: ", time() - $TDS::Status->start_time->time;    
}

# end of TDS::Collection::read_files
1;
