/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.Arrays;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.util.CharUtilities;

public class TextArea
extends AbstractTextArea {
    private static final long serialVersionUID = 7315900267242540809L;

    public TextArea() {
    }

    public TextArea(int stretch, int shrink, int adj) {
        super(stretch, shrink, adj);
    }

    public void removeText() {
        this.inlines.clear();
    }

    public void addWord(String word, int offset) {
        this.addWord(word, 0, null, null, null, offset);
    }

    public void addWord(String word, int offset, int level) {
        this.addWord(word, 0, null, this.makeLevels(level, word.length()), null, offset);
    }

    public void addWord(String word, int ipd, int[] letterAdjust, int[] levels, int[][] gposAdjustments, int blockProgressionOffset) {
        int minWordLevel = TextArea.findMinLevel(levels);
        WordArea wordArea = new WordArea(blockProgressionOffset, minWordLevel, word, letterAdjust, levels, gposAdjustments);
        wordArea.setIPD(ipd);
        this.addChildArea(wordArea);
        wordArea.setParentArea(this);
        this.updateLevel(minWordLevel);
    }

    public void addSpace(char space, int ipd, boolean adjustable, int blockProgressionOffset, int level) {
        SpaceArea spaceArea = new SpaceArea(blockProgressionOffset, level, space, adjustable);
        spaceArea.setIPD(ipd);
        this.addChildArea(spaceArea);
        spaceArea.setParentArea(this);
        this.updateLevel(level);
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        for (InlineArea inline : this.inlines) {
            if (inline instanceof WordArea) {
                text.append(((WordArea)inline).getWord());
                continue;
            }
            text.append(((SpaceArea)inline).getSpace());
        }
        return text.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" {text=\"");
        sb.append(CharUtilities.toNCRefs(this.getText()));
        sb.append("\"");
        sb.append("}");
        return sb.toString();
    }

    private void updateLevel(int newLevel) {
        if (newLevel >= 0) {
            int curLevel = this.getBidiLevel();
            if (curLevel >= 0) {
                if (newLevel < curLevel) {
                    this.setBidiLevel(newLevel);
                }
            } else {
                this.setBidiLevel(newLevel);
            }
        }
    }

    private static int findMinLevel(int[] levels) {
        if (levels != null) {
            int lMin = Integer.MAX_VALUE;
            for (int l : levels) {
                if (l < 0 || l >= lMin) continue;
                lMin = l;
            }
            if (lMin == Integer.MAX_VALUE) {
                return -1;
            }
            return lMin;
        }
        return -1;
    }

    private int[] makeLevels(int level, int count) {
        if (level >= 0) {
            int[] levels = new int[count];
            Arrays.fill(levels, level);
            return levels;
        }
        return null;
    }
}

